/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelExtensionHandler;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelExtensionAdvice<T> {
    private static final Log _log = LogFactoryUtil.getLog(ModelExtensionAdvice.class);
    private List<String> _extensionMethodNames;
    private ModelExtensionHandler<T> _modelExtensionHandler;

    public ModelExtensionHandler<T> getModelExtensionHandler() {
        return this._modelExtensionHandler;
    }

    public Object invoke(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object result = proceedingJoinPoint.proceed();
        Signature signature = proceedingJoinPoint.getSignature();
        if (this._extensionMethodNames.isEmpty() || this._extensionMethodNames.contains(signature.getName())) {
            if (_log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Extending method ");
                sb.append(signature.getDeclaringTypeName());
                sb.append(".");
                sb.append(signature.getName());
                sb.append("(");
                Object[] args = proceedingJoinPoint.getArgs();
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(args[i].getClass().getSimpleName());
                }
                sb.append(")");
                _log.debug((Object)sb.toString());
            }
            if (result instanceof BaseModel) {
                result = this._modelExtensionHandler.extendSingle((BaseModel)result);
            } else if (result instanceof List) {
                result = this._modelExtensionHandler.extendList((List)result);
            }
        }
        return result;
    }

    public void setModelExtensionHandler(ModelExtensionHandler<T> modelExtensionHandler) {
        this._modelExtensionHandler = modelExtensionHandler;
        this._extensionMethodNames = this._modelExtensionHandler.getExtensionMethodNames() != null ? this._modelExtensionHandler.getExtensionMethodNames() : new ArrayList<String>();
    }
}

