/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InitialThreadLocal;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class ServiceHookAdvice {
    private static Log _log = LogFactoryUtil.getLog(ServiceHookAdvice.class);
    private static ThreadLocal<Boolean> _immediatelyProceed = new InitialThreadLocal((Object)false);
    private static Map<String, Object> _services = new ConcurrentHashMap<String, Object>();

    public static Object getService(String className) {
        return _services.get(className);
    }

    public static void setService(String className, Object service) {
        if (_log.isDebugEnabled()) {
            if (service == null) {
                _log.debug((Object)("Remove service hook " + className));
            } else {
                _log.debug((Object)("Add service hook " + className + " " + service.getClass().getName()));
            }
        }
        if (service == null) {
            _services.remove(className);
        } else {
            _services.put(className, service);
        }
    }

    public Object invoke(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        if (_immediatelyProceed.get().booleanValue()) {
            _immediatelyProceed.set(Boolean.FALSE);
            return proceedingJoinPoint.proceed();
        }
        MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
        String className = methodSignature.getDeclaringTypeName();
        Object service = _services.get(className);
        if (service == null) {
            return proceedingJoinPoint.proceed();
        }
        _immediatelyProceed.set(Boolean.TRUE);
        try {
            Method method = methodSignature.getMethod();
            Object object = method.invoke(service, proceedingJoinPoint.getArgs());
            return object;
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        finally {
            _immediatelyProceed.remove();
        }
    }
}

