/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.portal.spring.hibernate.SessionInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

public class SessionFactoryInvocationHandler
implements InvocationHandler {
    private static final String _EQUALS = "equals";
    private static final String _GET_CURRENT_SESSION = "getCurrentSession";
    private static final String _HASHCODE = "hashCode";
    private static final String _OPEN_SESSION = "openSession";
    private final SessionFactory _sessionFactory;

    public SessionFactoryInvocationHandler(SessionFactory sessionFactory) {
        this._sessionFactory = sessionFactory;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals(_GET_CURRENT_SESSION)) {
            try {
                Session session = (Session)SessionFactoryUtils.doGetSession((SessionFactory)((SessionFactory)proxy), (boolean)false);
                return this.wrapSession(session);
            }
            catch (IllegalStateException ise) {
                throw new HibernateException(ise.getMessage());
            }
        }
        if (methodName.equals(_OPEN_SESSION)) {
            Session session = (Session)method.invoke((Object)this._sessionFactory, args);
            return this.wrapSession(session);
        }
        if (methodName.equals(_EQUALS)) {
            if (proxy == args[0]) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (methodName.equals(_HASHCODE)) {
            return new Integer(this.hashCode());
        }
        try {
            return method.invoke((Object)this._sessionFactory, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    protected Session wrapSession(Session session) {
        if (Proxy.isProxyClass(session.getClass())) {
            return session;
        }
        return (Session)Proxy.newProxyInstance(Session.class.getClassLoader(), new Class[]{Session.class}, (InvocationHandler)new SessionInvocationHandler(session));
    }
}

