/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import org.hibernate.classic.Session;

public class SessionInvocationHandler
implements InvocationHandler {
    private static final String _CONNECTION = "connection";
    private static final String _EQUALS = "equals";
    private static final String _HASHCODE = "hashCode";
    private final Session _session;

    public SessionInvocationHandler(Session session) {
        this._session = session;
    }

    public Session getSession() {
        return this._session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals(_CONNECTION)) {
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            try {
                ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
                currentThread.setContextClassLoader(portalClassLoader);
                Connection connection = this._session.connection();
                return connection;
            }
            finally {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
        if (methodName.equals(_EQUALS)) {
            if (proxy == args[0]) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (methodName.equals(_HASHCODE)) {
            return new Integer(this.hashCode());
        }
        try {
            return method.invoke((Object)this._session, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }
}

