/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.ServletContext;
import org.apache.struts.util.MessageResourcesFactory;
import org.apache.struts.util.PropertyMessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMessageResources
extends PropertyMessageResources {
    private static Log _log = LogFactoryUtil.getLog(MultiMessageResources.class);
    private Lock _localeReadLock;
    private ReadWriteLock _localeReadWriteLock = new ReentrantReadWriteLock();
    private Lock _localeWriteLock;
    private Lock _messagesReadLock;
    private ReadWriteLock _messagesReadWriteLock;
    private Lock _messagesWriteLock;
    private transient ServletContext _servletContext;

    public MultiMessageResources(MessageResourcesFactory factory, String config) {
        this(factory, config, true);
    }

    public MultiMessageResources(MessageResourcesFactory factory, String config, boolean returnNull) {
        super(factory, config, returnNull);
        this._localeReadLock = this._localeReadWriteLock.readLock();
        this._localeWriteLock = this._localeReadWriteLock.writeLock();
        this._messagesReadWriteLock = new ReentrantReadWriteLock();
        this._messagesReadLock = this._messagesReadWriteLock.readLock();
        this._messagesWriteLock = this._messagesReadWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getMessages() {
        this._messagesReadLock.lock();
        try {
            HashMap hashMap = this.messages;
            return hashMap;
        }
        finally {
            this._messagesReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLocale(String localeKey) {
        this._localeWriteLock.lock();
        try {
            this.locales.put(localeKey, localeKey);
        }
        finally {
            this._localeWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties putMessages(Properties properties, String localeKey) {
        Properties oldProperties = new Properties();
        if (properties.size() < 1) {
            return oldProperties;
        }
        this._messagesWriteLock.lock();
        try {
            Enumeration<Object> names = properties.keys();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                String message = this.getMessage(LocaleUtil.fromLanguageId((String)localeKey), key);
                if (message != null) {
                    oldProperties.put(key, message);
                }
                this.messages.put(this.messageKey(localeKey, key), properties.getProperty(key));
            }
        }
        finally {
            this._messagesWriteLock.unlock();
        }
        return oldProperties;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLocale(String localeKey) {
        String name;
        int i;
        this._localeReadLock.lock();
        try {
            if (this.locales.containsKey(localeKey)) {
                return;
            }
        }
        finally {
            this._localeReadLock.unlock();
        }
        this._localeWriteLock.lock();
        try {
            if (this.locales.containsKey(localeKey)) {
                return;
            }
            this.locales.put(localeKey, localeKey);
        }
        finally {
            this._localeWriteLock.unlock();
        }
        String[] names = StringUtil.split((String)this.config.replace(".", "/"));
        for (i = 0; i < names.length; ++i) {
            name = names[i];
            if (localeKey.length() > 0) {
                name = name + "_" + localeKey;
            }
            name = name + ".properties";
            this._loadProperties(name, localeKey, false);
        }
        for (i = 0; i < names.length; ++i) {
            name = names[i];
            if (localeKey.length() > 0) {
                name = name + "_" + localeKey;
            }
            name = name + ".properties";
            this._loadProperties(name, localeKey, true);
        }
    }

    private void _loadProperties(String name, String localeKey, boolean useServletContext) {
        Properties properties = new Properties();
        try {
            URL url = null;
            if (useServletContext) {
                url = this._servletContext.getResource("/WEB-INF/" + name);
            } else {
                ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                url = classLoader.getResource(name);
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Attempting to load " + name + " " + localeKey + " " + useServletContext));
            }
            if (url != null) {
                InputStream is = url.openStream();
                properties.load(is);
                is.close();
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Loading " + url + " with " + properties.size() + " values"));
                }
            }
        }
        catch (Exception e) {
            _log.warn((Throwable)e);
        }
        this.putMessages(properties, localeKey);
    }
}

