/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.LayoutPermissionException;
import com.liferay.portal.PortletActiveException;
import com.liferay.portal.SystemException;
import com.liferay.portal.UserActiveException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletPreferencesIds;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserTracker;
import com.liferay.portal.model.UserTrackerPath;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.service.persistence.UserTrackerPathUtil;
import com.liferay.portal.struts.LastPath;
import com.liferay.portal.struts.StrutsUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.InvokerPortlet;
import com.liferay.portlet.PortletConfigFactory;
import com.liferay.portlet.PortletInstanceFactoryUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.RenderRequestFactory;
import com.liferay.portlet.RenderRequestImpl;
import com.liferay.portlet.RenderResponseFactory;
import com.liferay.portlet.RenderResponseImpl;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.tiles.TilesRequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalRequestProcessor
extends TilesRequestProcessor {
    private static String _PATH_C = "/c";
    private static String _PATH_COMMON = "/common";
    private static String _PATH_COMMON_ERROR = "/common/error";
    private static String _PATH_J_SECURITY_CHECK = "/j_security_check";
    private static String _PATH_PORTAL = "/portal";
    private static String _PATH_PORTAL_ERROR = "/portal/error";
    private static String _PATH_PORTAL_EXPIRE_SESSION = "/portal/expire_session";
    private static String _PATH_PORTAL_EXTEND_SESSION = "/portal/extend_session";
    private static String _PATH_PORTAL_FLASH = "/portal/flash";
    private static String _PATH_PORTAL_J_LOGIN = "/portal/j_login";
    private static String _PATH_PORTAL_LAYOUT = "/portal/layout";
    private static String _PATH_PORTAL_LOGIN = "/portal/login";
    private static String _PATH_PORTAL_LOGOUT = "/portal/logout";
    private static String _PATH_PORTAL_PROTECTED = "/portal/protected";
    private static String _PATH_PORTAL_RENDER_PORTLET = "/portal/render_portlet";
    private static String _PATH_PORTAL_TCK = "/portal/tck";
    private static String _PATH_PORTAL_TERMS_OF_USE = "/portal/terms_of_use";
    private static String _PATH_PORTAL_UPDATE_EMAIL_ADDRESS = "/portal/update_email_address";
    private static String _PATH_PORTAL_UPDATE_PASSWORD = "/portal/update_password";
    private static String _PATH_PORTAL_UPDATE_REMINDER_QUERY = "/portal/update_reminder_query";
    private static String _PATH_PORTAL_UPDATE_TERMS_OF_USE = "/portal/update_terms_of_use";
    private static Log _log = LogFactoryUtil.getLog(PortalRequestProcessor.class);
    private Set<String> _lastPaths = new HashSet<String>();
    private Set<String> _publicPaths;
    private Set<String> _trackerIgnorePaths;

    public PortalRequestProcessor() {
        this._lastPaths.add(_PATH_PORTAL_LAYOUT);
        this.addPaths(this._lastPaths, "auth.forward.last.paths");
        this._publicPaths = new HashSet<String>();
        this._publicPaths.add(_PATH_C);
        this._publicPaths.add(_PATH_PORTAL_FLASH);
        this._publicPaths.add(_PATH_PORTAL_J_LOGIN);
        this._publicPaths.add(_PATH_PORTAL_LAYOUT);
        this._publicPaths.add(_PATH_PORTAL_LOGIN);
        this._publicPaths.add(_PATH_PORTAL_RENDER_PORTLET);
        this._publicPaths.add(_PATH_PORTAL_TCK);
        this.addPaths(this._publicPaths, "auth.public.paths");
        this._trackerIgnorePaths = new HashSet<String>();
        this.addPaths(this._trackerIgnorePaths, "session.tracker.ignore.paths");
    }

    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String path = super.processPath(request, response);
        ActionMapping mapping = (ActionMapping)this.moduleConfig.findActionConfig(path);
        if (mapping == null) {
            String lastPath = this.getLastPath(request);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Last path " + lastPath));
            }
            response.sendRedirect(lastPath);
            return;
        }
        super.process(request, response);
        try {
            if (this.isPortletPath(path)) {
                this.cleanUp(request);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void addPaths(Set<String> paths, String propsKey) {
        String[] pathsArray;
        for (String path : pathsArray = PropsUtil.getArray(propsKey)) {
            paths.add(path);
        }
    }

    protected void callParentDoForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        super.doForward(uri, request, response);
    }

    protected HttpServletRequest callParentProcessMultipart(HttpServletRequest request) {
        return super.processMultipart(request);
    }

    protected String callParentProcessPath(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return super.processPath(request, response);
    }

    protected boolean callParentProcessRoles(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        return super.processRoles(request, response, mapping);
    }

    protected void cleanUp(HttpServletRequest request) throws Exception {
        RenderRequestImpl renderRequestImpl = (RenderRequestImpl)request.getAttribute("javax.portlet.request");
        if (renderRequestImpl != null) {
            renderRequestImpl.cleanUp();
        }
    }

    protected void defineObjects(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws Exception {
        String portletId = portlet.getPortletId();
        ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletPreferencesIds portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds((HttpServletRequest)request, (String)portletId);
        PortletPreferences portletPreferences = PortletPreferencesLocalServiceUtil.getPreferences((PortletPreferencesIds)portletPreferencesIds);
        PortletConfig portletConfig = PortletConfigFactory.create(portlet, servletContext);
        PortletContext portletContext = portletConfig.getPortletContext();
        RenderRequestImpl renderRequestImpl = RenderRequestFactory.create(request, portlet, invokerPortlet, portletContext, WindowState.MAXIMIZED, PortletMode.VIEW, portletPreferences);
        RenderResponseImpl renderResponseImpl = RenderResponseFactory.create(renderRequestImpl, response, portletId, portlet.getCompanyId());
        renderRequestImpl.defineObjects(portletConfig, (PortletResponse)renderResponseImpl);
        request.setAttribute("PORTLET_STRUTS_EXECUTE", (Object)Boolean.TRUE);
    }

    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        StrutsUtil.forward(uri, this.getServletContext(), request, response);
    }

    protected void doInclude(String uri, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        StrutsUtil.include(uri, this.getServletContext(), request, response);
    }

    protected StringBuilder getFriendlyTrackerPath(String path, ThemeDisplay themeDisplay, HttpServletRequest request) throws Exception {
        if (!path.equals(_PATH_PORTAL_LAYOUT)) {
            return null;
        }
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
        if (plid == 0L) {
            return null;
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        String layoutFriendlyURL = PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay);
        StringBuilder sb = new StringBuilder();
        sb.append(layoutFriendlyURL);
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        if (Validator.isNull((String)portletId)) {
            return sb;
        }
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
        if (portlet == null) {
            String strutsPath = path.substring(1, path.lastIndexOf("/"));
            portlet = PortletLocalServiceUtil.getPortletByStrutsPath((long)companyId, (String)strutsPath);
        }
        if (portlet == null || !portlet.isActive()) {
            sb.append("?");
            sb.append(request.getQueryString());
            return sb;
        }
        String namespace = PortalUtil.getPortletNamespace((String)portletId);
        FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
        if (friendlyURLMapper == null) {
            sb.append("?");
            sb.append(request.getQueryString());
            return sb;
        }
        PortletURLImpl portletURL = new PortletURLImpl(request, portletId, plid, "RENDER_PHASE");
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(namespace)) continue;
            key = key.substring(namespace.length());
            portletURL.setParameter(key, (String[])entry.getValue());
        }
        String portletFriendlyURL = friendlyURLMapper.buildPath((LiferayPortletURL)portletURL);
        if (portletFriendlyURL != null) {
            sb.append(portletFriendlyURL);
        } else {
            sb.append("?");
            sb.append(request.getQueryString());
        }
        return sb;
    }

    protected String getLastPath(HttpServletRequest request) {
        ActionMapping mapping;
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        Boolean httpsInitial = (Boolean)session.getAttribute("HTTPS_INITIAL");
        String portalURL = null;
        portalURL = PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS && httpsInitial != null && httpsInitial == false ? PortalUtil.getPortalURL((HttpServletRequest)request, (boolean)false) : PortalUtil.getPortalURL((HttpServletRequest)request);
        StringBuilder sb = new StringBuilder();
        sb.append(portalURL);
        sb.append(themeDisplay.getPathMain());
        sb.append(_PATH_PORTAL_LAYOUT);
        if (!PropsValues.AUTH_FORWARD_BY_LAST_PATH) {
            if (request.getRemoteUser() != null) {
                sb.append("?");
                sb.append("p_l_id");
                sb.append("=");
                sb.append(0L);
            }
            return sb.toString();
        }
        LastPath lastPath = (LastPath)session.getAttribute("LAST_PATH");
        if (lastPath == null) {
            return sb.toString();
        }
        Map<String, String[]> parameterMap = lastPath.getParameterMap();
        if (lastPath.getContextPath().equals(themeDisplay.getPathMain()) && ((mapping = (ActionMapping)this.moduleConfig.findActionConfig(lastPath.getPath())) == null || parameterMap == null)) {
            return sb.toString();
        }
        StringBuilder lastPathSB = new StringBuilder();
        lastPathSB.append(portalURL);
        lastPathSB.append(lastPath.getContextPath());
        lastPathSB.append(lastPath.getPath());
        lastPathSB.append(HttpUtil.parameterMapToString(parameterMap));
        return lastPathSB.toString();
    }

    protected boolean isPortletPath(String path) {
        return path != null && !path.equals(_PATH_C) && !path.startsWith(_PATH_COMMON) && path.indexOf(_PATH_J_SECURITY_CHECK) == -1 && !path.startsWith(_PATH_PORTAL);
    }

    protected boolean isPublicPath(String path) {
        return path != null && this._publicPaths.contains(path) || path.startsWith(_PATH_COMMON);
    }

    protected ActionMapping processMapping(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        if (path == null) {
            return null;
        }
        ActionMapping mapping = super.processMapping(request, response, path);
        if (mapping == null) {
            String msg = this.getInternal().getMessage("processInvalid");
            _log.error((Object)("User ID " + request.getRemoteUser()));
            _log.error((Object)("Current URL " + PortalUtil.getCurrentURL((HttpServletRequest)request)));
            _log.error((Object)("Referer " + request.getHeader("Referer")));
            _log.error((Object)("Remote address " + request.getRemoteAddr()));
            _log.error((Object)(msg + " " + path));
        }
        return mapping;
    }

    protected HttpServletRequest processMultipart(HttpServletRequest request) {
        return request;
    }

    protected String processPath(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = GetterUtil.getString((String)super.processPath(request, response));
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        UserTracker userTracker = LiveUsers.getUserTracker(themeDisplay.getCompanyId(), session.getId());
        if (userTracker != null && !path.equals(_PATH_C) && path.indexOf(_PATH_J_SECURITY_CHECK) == -1 && path.indexOf(_PATH_PORTAL_PROTECTED) == -1 && !this._trackerIgnorePaths.contains(path)) {
            StringBuilder sb = null;
            try {
                if (PropsValues.SESSION_TRACKER_FRIENDLY_PATHS_ENABLED) {
                    sb = this.getFriendlyTrackerPath(path, themeDisplay, request);
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(path);
                sb.append("?");
                sb.append(request.getQueryString());
            }
            UserTrackerPath userTrackerPath = UserTrackerPathUtil.create((long)0L);
            userTrackerPath.setUserTrackerId(userTracker.getUserTrackerId());
            userTrackerPath.setPath(sb.toString());
            userTrackerPath.setPathDate(new Date());
            userTracker.addPath(userTrackerPath);
        }
        String remoteUser = request.getRemoteUser();
        User user = null;
        try {
            user = PortalUtil.getUser((HttpServletRequest)request);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this._lastPaths.contains(path) && !this._trackerIgnorePaths.contains(path)) {
            boolean saveLastPath = ParamUtil.getBoolean((HttpServletRequest)request, (String)"saveLastPath", (boolean)true);
            if (themeDisplay.isLifecycleResource() || themeDisplay.isStateExclusive() || themeDisplay.isStatePopUp() || !request.getMethod().equalsIgnoreCase("GET")) {
                saveLastPath = false;
            }
            if (saveLastPath) {
                LastPath lastPath = (LastPath)request.getAttribute("LAST_PATH");
                if (lastPath == null) {
                    lastPath = new LastPath(themeDisplay.getPathMain(), path, request.getParameterMap());
                }
                session.setAttribute("LAST_PATH", (Object)lastPath);
            }
        }
        if ((remoteUser != null || user != null) && path.equals(_PATH_PORTAL_LOGOUT)) {
            return path;
        }
        if ((remoteUser != null || user != null) && (path.equals(_PATH_PORTAL_EXPIRE_SESSION) || path.equals(_PATH_PORTAL_EXTEND_SESSION))) {
            return path;
        }
        if ((remoteUser != null || user != null) && path.equals(_PATH_PORTAL_UPDATE_TERMS_OF_USE)) {
            return path;
        }
        if (remoteUser != null && user == null) {
            return _PATH_PORTAL_LOGOUT;
        }
        if (user != null && !user.isActive()) {
            SessionErrors.add((HttpServletRequest)request, (String)UserActiveException.class.getName());
            return _PATH_PORTAL_ERROR;
        }
        if (!path.equals(_PATH_PORTAL_RENDER_PORTLET) && !ParamUtil.getBoolean((HttpServletRequest)request, (String)"wsrp")) {
            if (user != null && !user.isAgreedToTermsOfUse()) {
                boolean termsOfUseRequired = false;
                try {
                    termsOfUseRequired = PrefsPropsUtil.getBoolean(user.getCompanyId(), "terms.of.use.required");
                }
                catch (SystemException se) {
                    termsOfUseRequired = PropsValues.TERMS_OF_USE_REQUIRED;
                }
                if (termsOfUseRequired) {
                    return _PATH_PORTAL_TERMS_OF_USE;
                }
            }
            if (user != null && user.isPasswordReset()) {
                return _PATH_PORTAL_UPDATE_PASSWORD;
            }
            if (user != null && Validator.isNull((String)user.getDisplayEmailAddress())) {
                return _PATH_PORTAL_UPDATE_EMAIL_ADDRESS;
            }
            if (user != null && (Validator.isNull((String)user.getReminderQueryQuestion()) || Validator.isNull((String)user.getReminderQueryAnswer())) && PropsValues.USERS_REMINDER_QUERIES_ENABLED) {
                return _PATH_PORTAL_UPDATE_REMINDER_QUERY;
            }
        }
        if (!this.isPublicPath(path) && user == null) {
            SessionErrors.add((HttpServletRequest)request, (String)PrincipalException.class.getName());
            return _PATH_PORTAL_LOGIN;
        }
        ActionMapping mapping = (ActionMapping)this.moduleConfig.findActionConfig(path);
        path = mapping.getPath();
        if (user != null) {
            // empty if block
        }
        if (this.isPortletPath(path)) {
            try {
                Portlet portlet = null;
                long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
                String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
                if (Validator.isNotNull((String)portletId)) {
                    portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
                }
                if (portlet == null) {
                    String strutsPath = path.substring(1, path.lastIndexOf("/"));
                    portlet = PortletLocalServiceUtil.getPortletByStrutsPath((long)companyId, (String)strutsPath);
                }
                if (portlet != null && portlet.isActive()) {
                    this.defineObjects(request, response, portlet);
                }
            }
            catch (Exception e) {
                request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
                path = _PATH_COMMON_ERROR;
            }
        }
        if (SessionErrors.contains((HttpServletRequest)request, (String)LayoutPermissionException.class.getName())) {
            return _PATH_PORTAL_ERROR;
        }
        return path;
    }

    protected boolean processRoles(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        String path = mapping.getPath();
        if (this.isPublicPath(path)) {
            return true;
        }
        boolean authorized = true;
        User user = null;
        try {
            user = PortalUtil.getUser((HttpServletRequest)request);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (user != null && this.isPortletPath(path)) {
            try {
                if (path.equals(_PATH_PORTAL_LOGOUT)) {
                    return true;
                }
                Portlet portlet = null;
                String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
                if (Validator.isNotNull((String)portletId)) {
                    portlet = PortletLocalServiceUtil.getPortletById((long)user.getCompanyId(), (String)portletId);
                }
                String strutsPath = path.substring(1, path.lastIndexOf("/"));
                if (portlet != null) {
                    if (!strutsPath.equals(portlet.getStrutsPath())) {
                        throw new PrincipalException();
                    }
                } else {
                    portlet = PortletLocalServiceUtil.getPortletByStrutsPath((long)user.getCompanyId(), (String)strutsPath);
                }
                if (portlet != null && portlet.isActive()) {
                    ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
                    Layout layout = themeDisplay.getLayout();
                    PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
                    if (!PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)layout.getPlid(), (Portlet)portlet, (String)"VIEW")) {
                        throw new PrincipalException();
                    }
                } else if (portlet != null && !portlet.isActive()) {
                    SessionErrors.add((HttpServletRequest)request, (String)PortletActiveException.class.getName());
                    authorized = false;
                }
            }
            catch (Exception e) {
                SessionErrors.add((HttpServletRequest)request, (String)PrincipalException.class.getName());
                authorized = false;
            }
        }
        if (!authorized) {
            ActionForward forwardConfig = mapping.findForward(_PATH_PORTAL_ERROR);
            this.processForwardConfig(request, response, (ForwardConfig)forwardConfig);
            return false;
        }
        return true;
    }
}

