/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrutsUtil {
    public static final String STRUTS_PACKAGE = "org.apache.struts.";
    public static final String TEXT_HTML_DIR = "/html";
    public static final String TEXT_WAP_DIR = "/wap";
    private static Log _log = LogFactoryUtil.getLog(StrutsUtil.class);

    public static void forward(String uri, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Forward URI " + uri));
        }
        if (uri.equals("/common/null.jsp")) {
            return;
        }
        if (!response.isCommitted()) {
            String path = TEXT_HTML_DIR + uri;
            if (BrowserSnifferUtil.isWap((HttpServletRequest)request)) {
                path = TEXT_WAP_DIR + uri;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Forward path " + path));
            }
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
            try {
                requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (IOException ioe1) {
                _log.warn((Object)ioe1, (Throwable)ioe1);
            }
            catch (ServletException se1) {
                request.setAttribute("javax.servlet.jsp.jspException", (Object)se1.getRootCause());
                String errorPath = "/html/common/error.jsp";
                if (BrowserSnifferUtil.isWap((HttpServletRequest)request)) {
                    path = "/wap/common/error.jsp";
                }
                requestDispatcher = servletContext.getRequestDispatcher(errorPath);
                try {
                    requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
                }
                catch (IOException ioe2) {
                    _log.warn((Object)ioe2, (Throwable)ioe2);
                }
                catch (ServletException se2) {
                    throw se2;
                }
            }
        } else {
            _log.warn((Object)(uri + " is already committed"));
        }
    }

    public static void include(String uri, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Include URI " + uri));
        }
        String path = TEXT_HTML_DIR + uri;
        if (BrowserSnifferUtil.isWap((HttpServletRequest)request)) {
            path = TEXT_WAP_DIR + uri;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Include path " + path));
        }
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
        try {
            requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException ioe) {
            _log.warn((Object)ioe, (Throwable)ioe);
        }
    }

    public static Map<String, Object> removeStrutsAttributes(PortletContext portletContext, PortletRequest portletRequest) {
        HashMap<String, Object> strutsAttributes = new HashMap<String, Object>();
        Enumeration enu = portletRequest.getAttributeNames();
        while (enu.hasMoreElements()) {
            String attributeName = (String)enu.nextElement();
            if (!attributeName.startsWith(STRUTS_PACKAGE)) continue;
            strutsAttributes.put(attributeName, portletRequest.getAttribute(attributeName));
        }
        for (String attributeName : strutsAttributes.keySet()) {
            portletRequest.setAttribute(attributeName, null);
        }
        Object moduleConfig = portletContext.getAttribute("org.apache.struts.action.MODULE");
        portletRequest.setAttribute("org.apache.struts.action.MODULE", moduleConfig);
        return strutsAttributes;
    }

    public static void setStrutsAttributes(PortletRequest portletRequest, Map<String, Object> strutsAttributes) {
        for (Map.Entry<String, Object> entry : strutsAttributes.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            portletRequest.setAttribute(key, value);
        }
    }
}

