/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.theme;

import com.liferay.portal.theme.ThemeLoader;
import com.liferay.portal.velocity.VelocityContextPool;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;

public class ThemeLoaderFactory {
    private static Map<String, ThemeLoader> _themeLoaders = new HashMap<String, ThemeLoader>();

    public static void init(String servletContextName, ServletContext servletContext, String[] xmls) {
        VelocityContextPool.put(servletContextName, servletContext);
        ThemeLoader themeLoader = new ThemeLoader(servletContextName, servletContext, xmls);
        _themeLoaders.put(servletContextName, themeLoader);
    }

    public static boolean destroy(String servletContextName) {
        ThemeLoader themeLoader = _themeLoaders.remove(servletContextName);
        if (themeLoader == null) {
            return false;
        }
        VelocityContextPool.remove(servletContextName);
        themeLoader.destroy();
        return true;
    }

    public static ThemeLoader getDefaultThemeLoader() {
        ThemeLoader themeLoader;
        block0: {
            themeLoader = null;
            Iterator<Map.Entry<String, ThemeLoader>> i$ = _themeLoaders.entrySet().iterator();
            if (!i$.hasNext()) break block0;
            Map.Entry<String, ThemeLoader> entry = i$.next();
            themeLoader = entry.getValue();
        }
        return themeLoader;
    }

    public static ThemeLoader getThemeLoader(String servletContextName) {
        return _themeLoaders.get(servletContextName);
    }

    public static void loadThemes() {
        for (Map.Entry<String, ThemeLoader> entry : _themeLoaders.entrySet()) {
            ThemeLoader themeLoader = entry.getValue();
            themeLoader.loadThemes();
        }
    }
}

