/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.InitUtil;
import java.io.IOException;

public class DBBuilder {
    private String _databaseName;
    private String[] _databaseTypes;

    public static void main(String[] args) {
        InitUtil.initWithSpring();
        if (args.length == 1) {
            new DBBuilder(args[0], DB.TYPE_ALL);
        } else if (args.length == 2) {
            new DBBuilder(args[0], StringUtil.split((String)args[1]));
        } else {
            throw new IllegalArgumentException();
        }
    }

    public DBBuilder(String databaseName, String[] databaseTypes) {
        try {
            this._databaseName = databaseName;
            this._databaseTypes = databaseTypes;
            this._buildSQLFile("portal");
            this._buildSQLFile("portal-minimal");
            this._buildSQLFile("indexes");
            this._buildSQLFile("sequences");
            this._buildSQLFile("update-4.2.0-4.3.0");
            this._buildSQLFile("update-4.3.0-4.3.1");
            this._buildSQLFile("update-4.3.1-4.3.2");
            this._buildSQLFile("update-4.3.2-4.3.3");
            this._buildSQLFile("update-4.3.3-4.3.4");
            this._buildSQLFile("update-4.3.6-4.4.0");
            this._buildSQLFile("update-4.4.0-5.0.0");
            this._buildSQLFile("update-5.0.1-5.1.0");
            this._buildSQLFile("update-5.1.1-5.1.2");
            this._buildSQLFile("update-5.1.2-5.2.0");
            this._buildSQLFile("update-5.2.0-5.2.1");
            this._buildSQLFile("update-5.2.2-5.2.3");
            this._buildSQLFile("update-5.2.4-5.2.5");
            this._buildSQLFile("update-5.2.5-5.2.6");
            this._buildSQLFile("update-5.2.6-5.2.7");
            this._buildCreateFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _buildCreateFile() throws IOException {
        for (int i = 0; i < this._databaseTypes.length; ++i) {
            DB db;
            String databaseType = this._databaseTypes[i];
            if (databaseType.equals("hypersonic") || databaseType.equals("interbase") || databaseType.equals("jdatastore") || databaseType.equals("sap") || (db = DBFactoryUtil.getDB((String)this._databaseTypes[i])) == null) continue;
            db.buildCreateFile(this._databaseName);
        }
    }

    private void _buildSQLFile(String fileName) throws IOException {
        if (!FileUtil.exists((String)("../sql/" + fileName + ".sql"))) {
            return;
        }
        for (int i = 0; i < this._databaseTypes.length; ++i) {
            DB db = DBFactoryUtil.getDB((String)this._databaseTypes[i]);
            if (db == null) continue;
            db.buildSQLFile(fileName);
        }
    }
}

