/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.FileImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.apache.derby.tools.ij;

public class DBLoader {
    private static FileImpl _fileUtil = FileImpl.getInstance();
    private String _databaseType;
    private String _databaseName;
    private String _fileName;

    public static void main(String[] args) {
        if (args.length == 2) {
            new DBLoader(args[0], args[1], "");
        } else if (args.length == 3) {
            new DBLoader(args[0], args[1], args[2]);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public DBLoader(String databaseType, String databaseName, String fileName) {
        try {
            this._databaseType = databaseType;
            this._databaseName = databaseName;
            this._fileName = fileName;
            if (this._databaseType.equals("derby")) {
                this._loadDerby();
            } else if (this._databaseType.equals("hypersonic")) {
                this._loadHypersonic();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _loadDerby() throws Exception {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        Connection con = DriverManager.getConnection("jdbc:derby:" + this._databaseName + ";create=true", "", "");
        if (Validator.isNull((String)this._fileName)) {
            this._loadDerby(con, "../sql/portal/portal-derby.sql");
            this._loadDerby(con, "../sql/indexes.sql");
        } else {
            this._loadDerby(con, this._fileName);
        }
    }

    private void _loadDerby(Connection con, String fileName) throws Exception {
        StringBuilder sb = new StringBuilder();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(_fileUtil.read(fileName)));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith("--")) continue;
            sb.append(line);
            if (!line.endsWith(";")) continue;
            String sql = sb.toString();
            sql = StringUtil.replace((String)sql, (String[])new String[]{"\\'", "\\\"", "\\\\", "\\n", "\\r"}, (String[])new String[]{"''", "\"", "\\", "\n", "\r"});
            sql = sql.substring(0, sql.length() - 1);
            sb = new StringBuilder();
            if (sql.startsWith("commit")) continue;
            ij.runScript((Connection)con, (InputStream)new UnsyncByteArrayInputStream(sql.getBytes("UTF-8")), (String)"UTF-8", (OutputStream)new UnsyncByteArrayOutputStream(), (String)"UTF-8");
        }
        unsyncBufferedReader.close();
    }

    private void _loadHypersonic() throws Exception {
        Class.forName("org.hsqldb.jdbcDriver");
        Connection con = DriverManager.getConnection("jdbc:hsqldb:" + this._databaseName + ";shutdown=true", "sa", "");
        if (Validator.isNull((String)this._fileName)) {
            this._loadHypersonic(con, "../sql/portal/portal-hypersonic.sql");
            this._loadHypersonic(con, "../sql/indexes.sql");
        } else {
            this._loadHypersonic(con, this._fileName);
        }
        Statement statement = con.createStatement();
        statement.execute("SHUTDOWN COMPACT");
        statement.close();
        con.close();
        String content = _fileUtil.read(this._databaseName + ".script");
        content = StringUtil.replace((String)content, (String)"\\u005cu", (String)"\\u");
        _fileUtil.write(this._databaseName + ".script", content);
    }

    private void _loadHypersonic(Connection con, String fileName) throws Exception {
        StringBuilder sb = new StringBuilder();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(_fileUtil.read(fileName)));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith("//")) continue;
            sb.append(line);
            if (!line.endsWith(";")) continue;
            String sql = sb.toString();
            sql = StringUtil.replace((String)sql, (String[])new String[]{"\\\"", "\\\\", "\\n", "\\r"}, (String[])new String[]{"\"", "\\", "\\u000a", "\\u000a"});
            sb = new StringBuilder();
            PreparedStatement ps = con.prepareStatement(sql);
            ps.executeUpdate();
            ps.close();
        }
        unsyncBufferedReader.close();
    }
}

