/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.tools.servicebuilder.ServiceBuilder;
import com.liferay.portal.util.InitUtil;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class InstanceWrapperBuilder {
    public static void main(String[] args) {
        InitUtil.initWithSpring();
        if (args.length != 1) {
            throw new IllegalArgumentException();
        }
        new InstanceWrapperBuilder(args[0]);
    }

    public InstanceWrapperBuilder(String xml) {
        try {
            File file = new File(xml);
            Document doc = null;
            try {
                doc = SAXReaderUtil.read((File)file);
            }
            catch (DocumentException de) {
                de.printStackTrace();
            }
            Element root = doc.getRootElement();
            for (Element instanceWrapper : root.elements("instance-wrapper")) {
                String parentDir = instanceWrapper.attributeValue("parent-dir");
                String srcFile = instanceWrapper.attributeValue("src-file");
                this._createIW(parentDir, srcFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _createIW(String parentDir, String srcFile) throws IOException {
        JavaClass javaClass = this._getJavaClass(parentDir, srcFile);
        JavaMethod[] methods = javaClass.getMethods();
        StringBuilder sb = new StringBuilder();
        sb.append("package " + javaClass.getPackage().getName() + ";");
        sb.append("public class " + javaClass.getName() + "_IW {");
        sb.append("public static " + javaClass.getName() + "_IW getInstance() {");
        sb.append("return _instance;");
        sb.append("}\n");
        for (int i = 0; i < methods.length; ++i) {
            int j;
            DocletTag[] docletTags;
            JavaMethod javaMethod = methods[i];
            String methodName = javaMethod.getName();
            if (!javaMethod.isPublic() || !javaMethod.isStatic()) continue;
            if (methodName.equals("getInstance")) {
                methodName = "getWrappedInstance";
            }
            if ((docletTags = javaMethod.getTagsByName("deprecated")) != null && docletTags.length > 0) {
                sb.append("\t/**\n");
                sb.append("\t * @deprecated\n");
                sb.append("\t */\n");
            }
            sb.append("public " + javaMethod.getReturns().getValue() + this._getDimensions(javaMethod.getReturns()) + " " + methodName + "(");
            JavaParameter[] parameters = javaMethod.getParameters();
            for (int j2 = 0; j2 < parameters.length; ++j2) {
                JavaParameter javaParameter = parameters[j2];
                sb.append(javaParameter.getType().getValue() + javaParameter.getGenericsName() + this._getDimensions(javaParameter.getType()) + " " + javaParameter.getName());
                if (j2 + 1 == parameters.length) continue;
                sb.append(", ");
            }
            sb.append(")");
            Type[] thrownExceptions = javaMethod.getExceptions();
            LinkedHashSet<String> newExceptions = new LinkedHashSet<String>();
            for (j = 0; j < thrownExceptions.length; ++j) {
                Type thrownException = thrownExceptions[j];
                newExceptions.add(thrownException.getValue());
            }
            if (newExceptions.size() > 0) {
                sb.append(" throws ");
                Iterator itr = newExceptions.iterator();
                while (itr.hasNext()) {
                    sb.append((String)itr.next());
                    if (!itr.hasNext()) continue;
                    sb.append(", ");
                }
            }
            sb.append("{\n");
            if (!javaMethod.getReturns().getValue().equals("void")) {
                sb.append("return ");
            }
            sb.append(javaClass.getName() + "." + javaMethod.getName() + "(");
            for (j = 0; j < parameters.length; ++j) {
                JavaParameter javaParameter = parameters[j];
                sb.append(javaParameter.getName());
                if (j + 1 == parameters.length) continue;
                sb.append(", ");
            }
            sb.append(");");
            sb.append("}\n");
        }
        sb.append("private " + javaClass.getName() + "_IW() {");
        sb.append("}");
        sb.append("private static " + javaClass.getName() + "_IW _instance = new " + javaClass.getName() + "_IW();");
        sb.append("}");
        File file = new File(parentDir + "/" + StringUtil.replace((String)javaClass.getPackage().getName(), (String)".", (String)"/") + "/" + javaClass.getName() + "_IW.java");
        ServiceBuilder.writeFile(file, sb.toString());
    }

    private String _getDimensions(Type type) {
        String dimensions = "";
        for (int i = 0; i < type.getDimensions(); ++i) {
            dimensions = dimensions + "[]";
        }
        return dimensions;
    }

    private JavaClass _getJavaClass(String parentDir, String srcFile) throws IOException {
        String className = StringUtil.replace((String)srcFile.substring(0, srcFile.length() - 5), (String)"/", (String)".");
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.addSource(new File(parentDir + "/" + srcFile));
        return builder.getClassByName(className);
    }
}

