/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import com.liferay.util.xml.DocUtil;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocFormatter {
    private static FileImpl _fileUtil = FileImpl.getInstance();
    private static SAXReaderImpl _saxReaderUtil = SAXReaderImpl.getInstance();
    private String _basedir = "./";
    private boolean _initializeMissingJavadocs;

    public static void main(String[] args) {
        try {
            new JavadocFormatter(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JavadocFormatter(String[] args) throws Exception {
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option limitOption = cmdLineParser.addStringOption("limit");
        CmdLineParser.Option initOption = cmdLineParser.addStringOption("init");
        cmdLineParser.parse(args);
        String limit = (String)cmdLineParser.getOptionValue(limitOption);
        String init = (String)cmdLineParser.getOptionValue(initOption);
        if (!init.startsWith("$")) {
            this._initializeMissingJavadocs = GetterUtil.getBoolean((String)init);
        }
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this._basedir);
        ds.setExcludes(new String[]{"**\\classes\\**", "**\\portal-client\\**"});
        ArrayList<String> includes = new ArrayList<String>();
        if (Validator.isNotNull((String)limit) && !limit.startsWith("$")) {
            String[] limitArray;
            for (String curLimit : limitArray = StringUtil.split((String)limit, (String)"/")) {
                includes.add("**\\" + StringUtil.replace((String)curLimit, (String)".", (String)"\\") + "\\**\\*.java");
                includes.add("**\\" + curLimit + ".java");
            }
        } else {
            includes.add("**\\*.java");
        }
        ds.setIncludes(includes.toArray(new String[includes.size()]));
        ds.scan();
        String[] fileNames = ds.getIncludedFiles();
        for (String fileName : fileNames) {
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            this._format(fileName);
        }
    }

    private void _addClassCommentElement(Element rootElement, JavaClass javaClass) {
        Element commentElement = rootElement.addElement("comment");
        String comment = this._getCDATA((AbstractJavaEntity)javaClass);
        if (comment.startsWith("Copyright (c) 2000-2009 Liferay, Inc.")) {
            comment = "";
        }
        if (comment.startsWith("<a href=\"" + javaClass.getName() + ".java.html\">")) {
            int pos = comment.indexOf("</a>");
            comment = comment.substring(pos + 4).trim();
        }
        commentElement.addCDATA(comment);
    }

    private void _addDocletElements(Element parentElement, AbstractJavaEntity abstractJavaEntity, String name) throws Exception {
        DocletTag[] docletTags;
        for (DocletTag docletTag : docletTags = abstractJavaEntity.getTagsByName(name)) {
            String value = docletTag.getValue();
            value = StringUtil.replace((String)value, (String)"\n", (String)" ");
            if (name.equals("author") || name.equals("see") || name.equals("since") || name.equals("version")) {
                // empty if block
            }
            Element element = parentElement.addElement(name);
            element.addCDATA(value);
        }
        if (docletTags.length == 0 && name.equals("author")) {
            Element element = parentElement.addElement(name);
            element.addCDATA("Brian Wing Shun Chan");
        }
    }

    private String _addDocletTags(Element parentElement, String[] names, String indent) {
        StringBuilder sb = new StringBuilder();
        int maxNameLength = 0;
        block0: for (String name : names) {
            if (name.length() < maxNameLength) continue;
            List elements = parentElement.elements(name);
            for (Element element : elements) {
                Element commentElement = element.element("comment");
                String comment = null;
                comment = commentElement != null ? commentElement.getText() : element.getText();
                if (!name.equals("deprecated") && !this._initializeMissingJavadocs && Validator.isNull((String)comment)) continue;
                maxNameLength = name.length();
                continue block0;
            }
        }
        int indentLength = this._getIndentLength(indent) + maxNameLength;
        String maxNameIndent = "\t ";
        for (int i = 0; i < maxNameLength; ++i) {
            maxNameIndent = maxNameIndent + " ";
        }
        maxNameIndent = StringUtil.replace((String)maxNameIndent, (String)"    ", (String)"\t");
        for (String name : names) {
            String curNameIndent = " ";
            if (name.length() < maxNameLength) {
                int firstTab = 4 - name.length() % 4;
                int delta = maxNameLength + 1 - (name.length() + firstTab);
                if (delta == 0) {
                    curNameIndent = "\t";
                } else if (delta < 0) {
                    for (int i = 0; i < maxNameLength - name.length(); ++i) {
                        curNameIndent = curNameIndent + " ";
                    }
                } else if (delta > 0) {
                    int numberOfSpaces;
                    curNameIndent = "\t";
                    int numberOfTabs = delta / 4;
                    if (numberOfTabs > 0) {
                        for (int i = 0; i < numberOfTabs; ++i) {
                            curNameIndent = curNameIndent + "\t";
                        }
                    }
                    if ((numberOfSpaces = delta % 4) > 0) {
                        for (int i = 0; i < numberOfSpaces; ++i) {
                            curNameIndent = curNameIndent + " ";
                        }
                    }
                }
            }
            List elements = parentElement.elements(name);
            for (Element element : elements) {
                Element commentElement = element.element("comment");
                String comment = null;
                comment = commentElement != null ? commentElement.getText() : element.getText();
                if (!name.equals("deprecated") && !this._initializeMissingJavadocs && Validator.isNull((String)comment)) continue;
                sb.append(indent);
                sb.append(" * @");
                sb.append(name);
                if (Validator.isNotNull((String)comment) || commentElement != null) {
                    sb.append(curNameIndent);
                }
                if (commentElement != null) {
                    comment = element.elementText("name") + " " + comment;
                }
                comment = StringUtil.wrap((String)comment, (int)(80 - indentLength - 5), (String)"\n");
                comment = comment.trim();
                comment = StringUtil.replace((String)comment, (String)"\n", (String)("\n" + indent + " *" + maxNameIndent));
                while (comment.contains(" \n")) {
                    comment = StringUtil.replace((String)comment, (String)" \n", (String)"\n");
                }
                while (comment.startsWith("\n")) {
                    comment = comment.substring(1, comment.length());
                }
                sb.append(comment);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private void _addFieldElement(Element rootElement, JavaField javaField) throws Exception {
        Element fieldElement = rootElement.addElement("field");
        DocUtil.add((Element)fieldElement, (String)"name", (String)javaField.getName());
        Element commentElement = fieldElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA((AbstractJavaEntity)javaField));
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "version");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "see");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "since");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "deprecated");
    }

    private void _addMethodElement(Element rootElement, JavaMethod javaMethod) throws Exception {
        Element methodElement = rootElement.addElement("method");
        DocUtil.add((Element)methodElement, (String)"name", (String)javaMethod.getName());
        Element commentElement = methodElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA((AbstractJavaEntity)javaMethod));
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "version");
        this._addParamElements(methodElement, javaMethod);
        this._addReturnElement(methodElement, javaMethod);
        this._addThrowsElements(methodElement, javaMethod);
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "see");
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "since");
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "deprecated");
    }

    private void _addParamElement(Element methodElement, JavaParameter javaParameter, DocletTag[] paramDocletTags) {
        String name = javaParameter.getName();
        String type = javaParameter.getType().getValue();
        String value = null;
        for (DocletTag paramDocletTag : paramDocletTags) {
            String curValue = paramDocletTag.getValue();
            if (!curValue.startsWith(name)) continue;
            value = curValue;
            break;
        }
        Element paramElement = methodElement.addElement("param");
        DocUtil.add((Element)paramElement, (String)"name", (String)name);
        DocUtil.add((Element)paramElement, (String)"type", (String)type);
        if (value != null) {
            value = value.substring(name.length());
        }
        Element commentElement = paramElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA(value));
    }

    private void _addParamElements(Element methodElement, JavaMethod javaMethod) {
        JavaParameter[] javaParameters = javaMethod.getParameters();
        DocletTag[] paramDocletTags = javaMethod.getTagsByName("param");
        for (JavaParameter javaParameter : javaParameters) {
            this._addParamElement(methodElement, javaParameter, paramDocletTags);
        }
    }

    private void _addReturnElement(Element methodElement, JavaMethod javaMethod) throws Exception {
        Type returns = javaMethod.getReturns();
        if (returns == null || returns.getValue().equals("void")) {
            return;
        }
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "return");
    }

    private void _addThrowsElement(Element methodElement, Type exception, DocletTag[] throwsDocletTags) {
        String name = exception.getJavaClass().getName();
        String value = null;
        for (DocletTag throwsDocletTag : throwsDocletTags) {
            String curValue = throwsDocletTag.getValue();
            if (!curValue.startsWith(name)) continue;
            value = curValue;
            break;
        }
        Element throwsElement = methodElement.addElement("throws");
        DocUtil.add((Element)throwsElement, (String)"name", (String)name);
        DocUtil.add((Element)throwsElement, (String)"type", (String)exception.getValue());
        if (value != null) {
            value = value.substring(name.length());
        }
        Element commentElement = throwsElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA(value));
    }

    private void _addThrowsElements(Element methodElement, JavaMethod javaMethod) {
        Type[] exceptions = javaMethod.getExceptions();
        DocletTag[] throwsDocletTags = javaMethod.getTagsByName("throws");
        for (Type exception : exceptions) {
            this._addThrowsElement(methodElement, exception, throwsDocletTags);
        }
    }

    private String _getCDATA(AbstractJavaEntity abstractJavaEntity) {
        return this._getCDATA(abstractJavaEntity.getComment());
    }

    private String _getCDATA(String cdata) {
        if (cdata == null) {
            return "";
        }
        cdata = StringUtil.replace((String)cdata, (String[])new String[]{"\n", "<p>", "</p>", "<li>", "</li>"}, (String[])new String[]{" ", " \n<p>\n", "\n</p>\n", " \n<li>\n", "\n</li>\n"});
        while (cdata.contains("\n ")) {
            cdata = StringUtil.replace((String)cdata, (String)"\n ", (String)"\n");
        }
        while (cdata.contains("  ")) {
            cdata = StringUtil.replace((String)cdata, (String)"  ", (String)" ");
        }
        cdata = StringUtil.replace((String)cdata, (String)"</p>\n<p>", (String)"</p>\n\n<p>");
        cdata = StringUtil.replace((String)cdata, (String)"</li>\n<li>", (String)"</li>\n\n<li>");
        return cdata.trim();
    }

    private String _getFieldKey(Element fieldElement) {
        return fieldElement.elementText("name");
    }

    private String _getFieldKey(JavaField javaField) {
        return javaField.getName();
    }

    private int _getIndentLength(String indent) {
        int indentLength = 0;
        for (char c : indent.toCharArray()) {
            if (c == '\t') {
                indentLength += 4;
                continue;
            }
            ++indentLength;
        }
        return indentLength;
    }

    private JavaClass _getJavaClass(String fileName, Reader reader) throws Exception {
        int pos = fileName.indexOf("src/");
        if (pos == -1) {
            pos = fileName.indexOf("test/");
        }
        if (pos == -1) {
            throw new RuntimeException(fileName);
        }
        pos = fileName.indexOf("/", pos);
        String srcFile = fileName.substring(pos + 1, fileName.length());
        String className = StringUtil.replace((String)srcFile.substring(0, srcFile.length() - 5), (String)"/", (String)".");
        JavaDocBuilder builder = new JavaDocBuilder();
        if (reader == null) {
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
            builder.addSource(file);
        } else {
            builder.addSource(reader);
        }
        return builder.getClassByName(className);
    }

    private String _getJavaClassComment(Element rootElement, JavaClass javaClass) {
        String docletTags;
        StringBuilder sb = new StringBuilder();
        String indent = "";
        sb.append("/**\n");
        String viewSourceHREF = " * <a href=\"" + javaClass.getName() + ".java.html\"><b><i>View Source</i></b></a>";
        if (viewSourceHREF.length() > 80) {
            int x = viewSourceHREF.lastIndexOf("<", 80);
            int y = viewSourceHREF.lastIndexOf(" ", 80);
            int start = x;
            int end = x;
            if (x < y) {
                start = y;
                end = y + 1;
            }
            viewSourceHREF = viewSourceHREF.substring(0, start) + "\n * " + viewSourceHREF.substring(end);
        }
        sb.append(viewSourceHREF);
        sb.append("\n");
        String comment = rootElement.elementText("comment");
        if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
            sb.append(" *\n");
            sb.append(this._wrapText(comment, indent));
            sb.append("\n");
        }
        if ((docletTags = this._addDocletTags(rootElement, new String[]{"author", "version", "see", "since", "serial", "deprecated"}, indent)).length() > 0) {
            sb.append(" *\n");
            sb.append(docletTags);
        }
        sb.append(" */\n");
        return sb.toString();
    }

    private Document _getJavadocDocument(JavaClass javaClass) throws Exception {
        JavaField[] javaFields;
        JavaMethod[] javaMethods;
        Element rootElement = _saxReaderUtil.createElement("javadoc");
        Document document = _saxReaderUtil.createDocument(rootElement);
        DocUtil.add((Element)rootElement, (String)"name", (String)javaClass.getName());
        DocUtil.add((Element)rootElement, (String)"type", (String)javaClass.getFullyQualifiedName());
        this._addClassCommentElement(rootElement, javaClass);
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "author");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "version");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "see");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "since");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "serial");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "deprecated");
        for (JavaMethod javaMethod : javaMethods = javaClass.getMethods()) {
            this._addMethodElement(rootElement, javaMethod);
        }
        for (JavaField javaField : javaFields = javaClass.getFields()) {
            this._addFieldElement(rootElement, javaField);
        }
        return document;
    }

    private String _getJavaFieldComment(String[] lines, Map<String, Element> fieldElementsMap, JavaField javaField) {
        String docletTags;
        String fieldKey = this._getFieldKey(javaField);
        Element fieldElement = fieldElementsMap.get(fieldKey);
        if (fieldElement == null) {
            return null;
        }
        String line = lines[javaField.getLineNumber() - 1];
        String indent = "";
        for (char c : line.toCharArray()) {
            if (!Character.isWhitespace(c)) break;
            indent = indent + c;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("/**\n");
        String comment = fieldElement.elementText("comment");
        if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
            sb.append(this._wrapText(comment, indent));
            sb.append("\n");
        }
        if ((docletTags = this._addDocletTags(fieldElement, new String[]{"version", "see", "since", "deprecated"}, indent)).length() > 0) {
            if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
                sb.append(indent);
                sb.append(" *\n");
            }
            sb.append(docletTags);
        }
        sb.append(indent);
        sb.append(" */\n");
        if (!this._initializeMissingJavadocs && Validator.isNull((String)comment) && Validator.isNull((String)docletTags)) {
            return null;
        }
        return sb.toString();
    }

    private String _getJavaMethodComment(String[] lines, Map<String, Element> methodElementsMap, JavaMethod javaMethod) {
        String docletTags;
        String methodKey = this._getMethodKey(javaMethod);
        Element methodElement = methodElementsMap.get(methodKey);
        if (methodElement == null) {
            return null;
        }
        String line = lines[javaMethod.getLineNumber() - 1];
        String indent = "";
        for (char c : line.toCharArray()) {
            if (!Character.isWhitespace(c)) break;
            indent = indent + c;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("/**\n");
        String comment = methodElement.elementText("comment");
        if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
            sb.append(this._wrapText(comment, indent));
            sb.append("\n");
        }
        if ((docletTags = this._addDocletTags(methodElement, new String[]{"version", "param", "return", "throws", "see", "since", "deprecated"}, indent)).length() > 0) {
            if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
                sb.append(indent);
                sb.append(" *\n");
            }
            sb.append(docletTags);
        }
        sb.append(indent);
        sb.append(" */\n");
        if (!this._initializeMissingJavadocs && Validator.isNull((String)comment) && Validator.isNull((String)docletTags)) {
            return null;
        }
        return sb.toString();
    }

    private String _getMethodKey(Element methodElement) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodElement.elementText("name"));
        sb.append("(");
        List paramElements = methodElement.elements("param");
        for (Element paramElement : paramElements) {
            sb.append(paramElement.elementText("name"));
            sb.append("|");
            sb.append(paramElement.elementText("type"));
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private String _getMethodKey(JavaMethod javaMethod) {
        JavaParameter[] javaParameters;
        StringBuilder sb = new StringBuilder();
        sb.append(javaMethod.getName());
        sb.append("(");
        for (JavaParameter javaParameter : javaParameters = javaMethod.getParameters()) {
            sb.append(javaParameter.getName());
            sb.append("|");
            sb.append(javaParameter.getType().getValue());
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private boolean _isGenerated(String content) {
        return content.contains("* @generated");
    }

    private String _removeJavadocFromJava(JavaClass javaClass, String content) {
        JavaField[] javaFields;
        JavaMethod[] javaMethods;
        HashSet<Integer> lineNumbers = new HashSet<Integer>();
        lineNumbers.add(javaClass.getLineNumber());
        for (JavaMethod javaMethod : javaMethods = javaClass.getMethods()) {
            lineNumbers.add(javaMethod.getLineNumber());
        }
        for (JavaField javaField : javaFields = javaClass.getFields()) {
            lineNumbers.add(javaField.getLineNumber());
        }
        String[] lines = StringUtil.split((String)content, (String)"\n");
        Iterator i$ = lineNumbers.iterator();
        block2: while (i$.hasNext()) {
            int lineNumber = (Integer)i$.next();
            int pos = lineNumber - 2;
            String line = lines[pos].trim();
            if (!line.endsWith("*/")) continue;
            while (true) {
                lines[pos] = null;
                if (line.startsWith("/**")) continue block2;
                line = lines[--pos].trim();
            }
        }
        StringBuilder sb = new StringBuilder(content.length());
        for (String line : lines) {
            if (line == null) continue;
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString().trim();
    }

    private void _format(String fileName) throws Exception {
        FileInputStream fis = new FileInputStream(new File(this._basedir + fileName));
        byte[] bytes = new byte[fis.available()];
        fis.read(bytes);
        fis.close();
        String originalContent = new String(bytes);
        if (!fileName.endsWith("JavadocFormatter.java") && this._isGenerated(originalContent)) {
            return;
        }
        JavaClass javaClass = this._getJavaClass(fileName, (Reader)new UnsyncStringReader(originalContent));
        String javadocLessContent = this._removeJavadocFromJava(javaClass, originalContent);
        Document document = this._getJavadocDocument(javaClass);
        this._updateJavaFromDocument(fileName, originalContent, javadocLessContent, document);
    }

    private void _updateJavaFromDocument(String fileName, String originalContent, String javadocLessContent, Document document) throws Exception {
        JavaField[] javaFields;
        JavaMethod[] javaMethods;
        String[] lines = StringUtil.split((String)javadocLessContent, (String)"\n");
        JavaClass javaClass = this._getJavaClass(fileName, (Reader)new UnsyncStringReader(javadocLessContent));
        Element rootElement = document.getRootElement();
        TreeMap<Integer, String> commentsMap = new TreeMap<Integer, String>();
        commentsMap.put(javaClass.getLineNumber(), this._getJavaClassComment(rootElement, javaClass));
        HashMap<String, Element> methodElementsMap = new HashMap<String, Element>();
        List methodElements = rootElement.elements("method");
        for (Element methodElement : methodElements) {
            String methodKey = this._getMethodKey(methodElement);
            methodElementsMap.put(methodKey, methodElement);
        }
        for (JavaMethod javaMethod : javaMethods = javaClass.getMethods()) {
            if (commentsMap.containsKey(javaMethod.getLineNumber())) continue;
            commentsMap.put(javaMethod.getLineNumber(), this._getJavaMethodComment(lines, methodElementsMap, javaMethod));
        }
        HashMap<String, Element> fieldElementsMap = new HashMap<String, Element>();
        List fieldElements = rootElement.elements("field");
        for (Element fieldElement : fieldElements) {
            String fieldKey = this._getFieldKey(fieldElement);
            fieldElementsMap.put(fieldKey, fieldElement);
        }
        for (JavaField javaField : javaFields = javaClass.getFields()) {
            if (commentsMap.containsKey(javaField.getLineNumber())) continue;
            commentsMap.put(javaField.getLineNumber(), this._getJavaFieldComment(lines, fieldElementsMap, javaField));
        }
        StringBuilder sb = new StringBuilder(javadocLessContent.length());
        for (int lineNumber = 1; lineNumber <= lines.length; ++lineNumber) {
            String line = lines[lineNumber - 1];
            String comments = (String)commentsMap.get(lineNumber);
            if (comments != null) {
                sb.append(comments);
            }
            sb.append(line);
            sb.append("\n");
        }
        String formattedContent = sb.toString().trim();
        if (!originalContent.equals(formattedContent)) {
            File file = new File(this._basedir + fileName);
            _fileUtil.write(file, formattedContent.getBytes());
            System.out.println("Writing " + file);
        }
    }

    private String _wrapText(String text, String indent) {
        int indentLength = this._getIndentLength(indent);
        text = StringUtil.wrap((String)text, (int)(80 - indentLength - 3), (String)"\n");
        text = "\n" + text.trim();
        text = StringUtil.replace((String)text, (String)"\n", (String)("\n" + indent + " * "));
        while (text.contains(" \n")) {
            text = StringUtil.replace((String)text, (String)" \n", (String)"\n");
        }
        while (text.startsWith("\n")) {
            text = text.substring(1, text.length());
        }
        return text;
    }
}

