/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.InitUtil;
import com.liferay.portlet.translator.model.Translation;
import com.liferay.portlet.translator.util.TranslationWebCacheItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LangBuilder {
    private String _langDir;
    private String _langFile;
    private Properties _renameKeys;

    public static void main(String[] args) {
        InitUtil.initWithSpring();
        if (args.length == 2) {
            new LangBuilder(args[0], args[1], null);
        } else if (args.length == 3) {
            new LangBuilder(args[0], args[1], args[2]);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public LangBuilder(String langDir, String langFile, String langCode) {
        try {
            this._langDir = langDir;
            this._langFile = langFile;
            File renameKeysFile = new File(this._langDir + "/rename.properties");
            if (renameKeysFile.exists()) {
                this._renameKeys = PropertiesUtil.load((String)FileUtil.read((File)renameKeysFile));
            }
            String content = this._orderProps(new File(this._langDir + "/" + this._langFile + ".properties"));
            if (Validator.isNotNull((String)langCode) && !langCode.startsWith("$")) {
                this._createProps(content, langCode);
            } else {
                this._createProps(content, "ar");
                this._createProps(content, "eu");
                this._createProps(content, "ca");
                this._createProps(content, "zh_CN");
                this._createProps(content, "zh_TW");
                this._createProps(content, "cs");
                this._createProps(content, "nl");
                this._createProps(content, "fi");
                this._createProps(content, "fr");
                this._createProps(content, "de");
                this._createProps(content, "el");
                this._createProps(content, "hu");
                this._createProps(content, "it");
                this._createProps(content, "ja");
                this._createProps(content, "ko");
                this._createProps(content, "nb");
                this._createProps(content, "fa");
                this._createProps(content, "pl");
                this._createProps(content, "pt_BR");
                this._createProps(content, "pt_PT");
                this._createProps(content, "ru");
                this._createProps(content, "sk");
                this._createProps(content, "es");
                this._createProps(content, "sv");
                this._createProps(content, "tr");
                this._createProps(content, "vi");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _createProps(String content, String languageId) throws IOException {
        String translationId;
        File propsFile = new File(this._langDir + "/" + this._langFile + "_" + languageId + ".properties");
        Properties props = new Properties();
        if (propsFile.exists()) {
            props.load(new FileInputStream(propsFile));
        }
        File nativePropsFile = new File(this._langDir + "/" + this._langFile + "_" + languageId + ".properties.native");
        Properties nativeProps = new Properties();
        if (nativePropsFile.exists()) {
            nativeProps.load(new FileInputStream(nativePropsFile));
        }
        if ((translationId = "en_" + languageId).equals("en_pt_BR")) {
            translationId = "en_pt";
        } else if (translationId.equals("en_pt_PT")) {
            translationId = "en_pt";
        } else if (translationId.equals("en_zh_CN")) {
            translationId = "en_zh";
        } else if (translationId.equals("en_zh_TW")) {
            translationId = "en_zt";
        }
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        UnsyncBufferedWriter unsyncBufferedWriter = new UnsyncBufferedWriter((Writer)new FileWriter(nativePropsFile));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            int pos = (line = line.trim()).indexOf("=");
            if (pos != -1) {
                String renameKey;
                String key = line.substring(0, pos);
                String value = line.substring(pos + 1, line.length());
                String translatedText = props.getProperty(key);
                if (translatedText == null && this._renameKeys != null && (renameKey = this._renameKeys.getProperty(key)) != null) {
                    translatedText = props.getProperty(renameKey);
                }
                if (translatedText != null && (translatedText.indexOf("Babel Fish") != -1 || translatedText.indexOf("Yahoo! - 999") != -1)) {
                    translatedText = "";
                }
                if (translatedText == null || translatedText.equals("")) {
                    translatedText = line.indexOf("{") != -1 || line.indexOf("<") != -1 ? value : (key.equals("lang.dir") ? "ltr" : (key.equals("lang.line.begin") ? "left" : (key.equals("lang.line.end") ? "right" : (translationId.equals("en_el") && (key.equals("enabled") || key.equals("on") || key.equals("on-date")) ? "" : (translationId.equals("en_es") && key.equals("am") ? "" : (translationId.equals("en_it") && key.equals("am") ? "" : (translationId.equals("en_ja") && (key.equals("any") || key.equals("anytime") || key.equals("down") || key.equals("on") || key.equals("the")) ? "" : (translationId.equals("en_ko") && key.equals("the") ? "" : this._translate(translationId, value, 0)))))))));
                }
                if (Validator.isNotNull((String)translatedText)) {
                    if (translatedText.indexOf("Babel Fish") != -1 || translatedText.indexOf("Yahoo! - 999") != -1) {
                        throw new IOException("IP was blocked because of over usage. Please use another IP.");
                    }
                    if (translatedText.indexOf("&#39;") != -1) {
                        translatedText = StringUtil.replace((String)translatedText, (String)"&#39;", (String)"'");
                    }
                    unsyncBufferedWriter.write(key + "=" + translatedText);
                    unsyncBufferedWriter.newLine();
                    unsyncBufferedWriter.flush();
                    continue;
                }
                if (!nativeProps.containsKey(key)) continue;
                unsyncBufferedWriter.write(key + "=");
                unsyncBufferedWriter.newLine();
                unsyncBufferedWriter.flush();
                continue;
            }
            unsyncBufferedWriter.write(line);
            unsyncBufferedWriter.newLine();
            unsyncBufferedWriter.flush();
        }
        unsyncBufferedReader.close();
        unsyncBufferedWriter.close();
    }

    private String _orderProps(File propsFile) throws IOException {
        String content = FileUtil.read((File)propsFile);
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        UnsyncBufferedWriter unsyncBufferedWriter = new UnsyncBufferedWriter((Writer)new FileWriter(propsFile));
        TreeSet<String> messages = new TreeSet<String>();
        boolean begin = false;
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            int pos = line.indexOf("=");
            if (pos != -1) {
                String key = line.substring(0, pos);
                String value = line.substring(pos + 1, line.length());
                messages.add(key + "=" + value);
            } else {
                if (begin && line.equals("")) {
                    this._sortAndWrite(unsyncBufferedWriter, messages);
                }
                if (line.equals("")) {
                    begin = !begin;
                }
                unsyncBufferedWriter.write(line);
                unsyncBufferedWriter.newLine();
            }
            unsyncBufferedWriter.flush();
        }
        if (messages.size() > 0) {
            this._sortAndWrite(unsyncBufferedWriter, messages);
        }
        unsyncBufferedReader.close();
        unsyncBufferedWriter.close();
        return FileUtil.read((File)propsFile);
    }

    private void _sortAndWrite(UnsyncBufferedWriter unsyncBufferedWriter, Set<String> messages) throws IOException {
        String[] messagesArray = messages.toArray(new String[messages.size()]);
        for (int i = 0; i < messagesArray.length; ++i) {
            unsyncBufferedWriter.write(messagesArray[i]);
            unsyncBufferedWriter.newLine();
        }
        messages.clear();
    }

    private String _translate(String translationId, String fromText, int limit) {
        if (translationId.equals("en_ar") || translationId.equals("en_eu") || translationId.equals("en_ca") || translationId.equals("en_cs") || translationId.equals("en_fi") || translationId.equals("en_hu") || translationId.equals("en_nb") || translationId.equals("en_fa") || translationId.equals("en_pl") || translationId.equals("en_ru") || translationId.equals("en_sk") || translationId.equals("en_sv") || translationId.equals("en_tr") || translationId.equals("en_vi")) {
            return null;
        }
        if (limit == 3) {
            return null;
        }
        String toText = null;
        try {
            System.out.println("Translating " + translationId + " " + fromText);
            TranslationWebCacheItem wci = new TranslationWebCacheItem(translationId, fromText);
            Translation translation = (Translation)wci.convert("");
            toText = translation.getToText();
            if (toText != null && toText.indexOf("Babel Fish") != -1) {
                toText = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (toText == null) {
            return this._translate(translationId, fromText, ++limit);
        }
        return toText;
    }
}

