/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.InitUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.oro.io.GlobFilenameFilter;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsEnvironmentBuilder {
    private static final String _SVN_ADD = "svn add ";
    private static final String _SVN_DEL_IGNORES = "svn propdel svn:ignore ";
    private static final String _SVN_GET_IGNORES = "svn propget svn:ignore ";
    private static final String _SVN_INFO = "svn info ";
    private static final String _SVN_SET_IGNORES = "svn propset svn:ignore ";
    private boolean _svn;

    public static void main(String[] args) throws Exception {
        InitUtil.initWithSpring();
        File dir = new File(System.getProperty("plugins.env.dir"));
        boolean svn = GetterUtil.getBoolean((String)System.getProperty("plugins.env.svn"));
        boolean eclipse = GetterUtil.getBoolean((String)System.getProperty("plugins.env.eclipse"));
        new PluginsEnvironmentBuilder(dir, svn, eclipse);
    }

    public PluginsEnvironmentBuilder(File dir, boolean svn, boolean eclipse) {
        try {
            String[] fileNames;
            this._svn = svn;
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(dir);
            ds.setIncludes(new String[]{"**\\liferay-plugin-package.properties"});
            ds.scan();
            String dirName = dir.getCanonicalPath();
            for (String fileName : fileNames = ds.getIncludedFiles()) {
                File propertiesFile = new File(dirName + "/" + fileName);
                File libDir = new File(propertiesFile.getParent() + "/lib");
                File projectDir = new File(propertiesFile.getParent() + "/../..");
                Properties properties = new Properties();
                properties.load(new FileInputStream(propertiesFile));
                List dependencyJars = ListUtil.toList((Object[])StringUtil.split((String)properties.getProperty("portal-dependency-jars", properties.getProperty("portal.dependency.jars"))));
                if (svn) {
                    List jars = new ArrayList<String>(dependencyJars);
                    jars.add("commons-logging.jar");
                    jars.add("log4j.jar");
                    jars.add("util-bridges.jar");
                    jars.add("util-java.jar");
                    jars.add("util-taglib.jar");
                    jars = ListUtil.sort(jars);
                    this.updateLibIgnores(libDir, jars.toArray(new String[jars.size()]));
                }
                if (!eclipse) continue;
                this.updateEclipseFiles(libDir, projectDir, dependencyJars);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEclipseFiles(File libDir, File projectDir, List<String> dependencyJars) throws Exception {
        String libDirPath = libDir.getPath();
        libDirPath = StringUtil.replace((String)libDirPath, (String)"\\", (String)"/");
        String projectDirName = projectDir.getCanonicalPath();
        String projectName = StringUtil.extractLast((String)projectDirName, (String)File.separator);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        sb.append("<projectDescription>\n");
        sb.append("\t<name>" + projectName + "</name>\n");
        sb.append("\t<comment></comment>\n");
        sb.append("\t<projects></projects>\n");
        sb.append("\t<buildSpec>\n");
        sb.append("\t\t<buildCommand>\n");
        sb.append("\t\t\t<name>org.eclipse.jdt.core.javabuilder</name>\n");
        sb.append("\t\t\t<arguments></arguments>\n");
        sb.append("\t\t</buildCommand>\n");
        sb.append("\t</buildSpec>\n");
        sb.append("\t<natures>\n");
        sb.append("\t\t<nature>org.eclipse.jdt.core.javanature</nature>\n");
        sb.append("\t</natures>\n");
        sb.append("</projectDescription>");
        File projectFile = new File(projectDirName + "/.project");
        System.out.println("Updating " + projectFile);
        FileUtil.write((File)projectFile, (String)sb.toString());
        List<String> portalJars = new ArrayList<String>(dependencyJars);
        portalJars.add("commons-logging.jar");
        portalJars.add("log4j.jar");
        portalJars = ListUtil.sort(portalJars);
        Object[] customJarsArray = libDir.list((FilenameFilter)new GlobFilenameFilter("*.jar"));
        List customJars = null;
        if (customJarsArray != null) {
            customJars = ListUtil.toList((Object[])customJarsArray);
            customJars = ListUtil.sort(customJars);
            for (String jar : portalJars) {
                customJars.remove(jar);
            }
            customJars.remove(projectName + "-service.jar");
            customJars.remove("util-bridges.jar");
            customJars.remove("util-java.jar");
            customJars.remove("util-taglib.jar");
        } else {
            customJars = new ArrayList();
        }
        sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        sb.append("<classpath>\n");
        if (FileUtil.exists((String)(projectDirName + "/docroot/WEB-INF/service"))) {
            sb.append("\t<classpathentry excluding=\"**/.svn/**|.svn/\" ");
            sb.append("kind=\"src\" path=\"docroot/WEB-INF/service\" />\n");
        }
        sb.append("\t<classpathentry excluding=\"**/.svn/**|.svn/\" ");
        sb.append("kind=\"src\" path=\"docroot/WEB-INF/src\" />\n");
        sb.append("\t<classpathentry kind=\"src\" path=\"/portal\" />\n");
        sb.append("\t<classpathentry kind=\"con\" ");
        sb.append("path=\"org.eclipse.jdt.launching.JRE_CONTAINER\" />\n");
        if (FileUtil.exists((String)(projectDirName + "/docroot/WEB-INF/test"))) {
            sb.append("\t<classpathentry excluding=\"**/.svn/**|.svn/\" ");
            sb.append("kind=\"src\" path=\"docroot/WEB-INF/test\" />\n");
        }
        this._addClasspathEntry(sb, "/portal/lib/development/activation.jar");
        this._addClasspathEntry(sb, "/portal/lib/development/jsp-api.jar");
        this._addClasspathEntry(sb, "/portal/lib/development/mail.jar");
        this._addClasspathEntry(sb, "/portal/lib/development/servlet-api.jar");
        this._addClasspathEntry(sb, "/portal/lib/global/annotations.jar");
        this._addClasspathEntry(sb, "/portal/lib/global/portlet.jar");
        for (String jar : portalJars) {
            this._addClasspathEntry(sb, "/portal/lib/portal/" + jar);
        }
        this._addClasspathEntry(sb, "/portal/portal-kernel/portal-kernel.jar");
        this._addClasspathEntry(sb, "/portal/portal-service/portal-service.jar");
        this._addClasspathEntry(sb, "/portal/util-bridges/util-bridges.jar");
        this._addClasspathEntry(sb, "/portal/util-java/util-java.jar");
        this._addClasspathEntry(sb, "/portal/util-taglib/util-taglib.jar");
        for (String jar : customJars) {
            if (libDirPath.contains("/tmp/WEB-INF/lib")) {
                this._addClasspathEntry(sb, "tmp/WEB-INF/lib/" + jar);
                continue;
            }
            this._addClasspathEntry(sb, "docroot/WEB-INF/lib/" + jar);
        }
        sb.append("\t<classpathentry kind=\"output\" path=\"bin\" />\n");
        sb.append("</classpath>");
        File classpathFile = new File(projectDirName + "/.classpath");
        System.out.println("Updating " + classpathFile);
        FileUtil.write((File)classpathFile, (String)sb.toString());
        if (this._svn) {
            String projectFileName = "\"" + projectFile + "\"";
            try {
                this._exec(_SVN_INFO + projectFileName);
            }
            catch (Exception e) {
                this._exec(_SVN_ADD + projectFileName);
            }
            String classpathFileName = "\"" + classpathFile + "\"";
            try {
                this._exec(_SVN_INFO + classpathFileName);
            }
            catch (Exception e) {
                this._exec(_SVN_ADD + classpathFileName);
            }
            File tempFile = File.createTempFile("svn-ignores-", null, null);
            try {
                FileUtil.write((File)tempFile, (String)"bin\ntmp");
                this._exec("svn propset svn:ignore -F \"" + tempFile.getCanonicalPath() + "\" \"" + projectDirName + "\"");
            }
            finally {
                FileUtil.delete((File)tempFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateLibIgnores(File libDir, String[] jars) throws Exception {
        String libDirName;
        File tempFile;
        block6: {
            if (!this._isSVNDir(libDir)) {
                return;
            }
            tempFile = null;
            libDirName = "\"" + libDir.getCanonicalPath() + "\"";
            Object[] oldIgnores = this._exec(_SVN_GET_IGNORES + libDirName);
            Arrays.sort(oldIgnores);
            if (!Arrays.equals(oldIgnores, jars)) break block6;
            if (tempFile == null) return;
            FileUtil.delete(tempFile);
            return;
        }
        try {
            tempFile = File.createTempFile("svn-ignores-", null, null);
            this._exec(_SVN_DEL_IGNORES + libDirName);
            StringBuilder sb = new StringBuilder();
            for (String jar : jars) {
                sb.append(jar + "\n");
            }
            FileUtil.write((File)tempFile, (String)sb.toString());
            this._exec("svn propset svn:ignore -F \"" + tempFile.getCanonicalPath() + "\" \"" + libDirName + "\"");
            Object[] newIgnores = this._exec("svn propget svn:ignore \"" + libDirName + "\"");
            if (newIgnores.length > 0) {
                Arrays.sort(newIgnores);
            }
            if (tempFile == null) return;
        }
        catch (Throwable throwable) {
            if (tempFile == null) throw throwable;
            FileUtil.delete(tempFile);
            throw throwable;
        }
        FileUtil.delete((File)tempFile);
    }

    private void _addClasspathEntry(StringBuilder sb, String jar) throws Exception {
        sb.append("\t<classpathentry kind=\"lib\" path=\"");
        sb.append(jar);
        sb.append("\" />\n");
    }

    private String[] _exec(String cmd) throws Exception {
        Process process = Runtime.getRuntime().exec(cmd);
        String[] stdout = this._getExecOutput(process.getInputStream());
        String[] stderr = this._getExecOutput(process.getErrorStream());
        if (stderr.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Received errors in executing '" + cmd + "'\n");
            for (String err : stderr) {
                sb.append("\t" + err + "\n");
            }
            throw new Exception(sb.toString());
        }
        return stdout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] _getExecOutput(InputStream is) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = null;
        try {
            unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(is));
            String line = unsyncBufferedReader.readLine();
            while (line != null) {
                if (Validator.isNotNull((String)(line = line.trim()))) {
                    list.add(line);
                }
                line = unsyncBufferedReader.readLine();
            }
        }
        finally {
            if (unsyncBufferedReader != null) {
                try {
                    unsyncBufferedReader.close();
                }
                catch (Exception e) {}
            }
        }
        return list.toArray(new String[0]);
    }

    private boolean _isSVNDir(File libDir) {
        if (!libDir.exists()) {
            return false;
        }
        try {
            this._exec("svn info \"" + libDir + "\"");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

