/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.InitUtil;
import com.liferay.util.ant.Wsdl2JavaTask;
import java.io.File;

public class PortalClientBuilder {
    public static void main(String[] args) {
        InitUtil.initWithSpring();
        if (args.length != 4) {
            throw new IllegalArgumentException();
        }
        new PortalClientBuilder(args[0], args[1], args[2], args[3]);
    }

    public PortalClientBuilder(String fileName, String outputDir, String mappingFile, String url) {
        try {
            Document doc = SAXReaderUtil.read((File)new File(fileName));
            Element root = doc.getRootElement();
            for (Element service : root.elements("service")) {
                String name = service.attributeValue("name");
                if (!name.startsWith("Portal_") && !name.startsWith("Portlet_")) continue;
                Wsdl2JavaTask.generateJava((String)(url + "/" + name + "?wsdl"), (String)outputDir, (String)mappingFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File testNamespace = new File(outputDir + "/com/liferay/portal");
        if (testNamespace.exists()) {
            throw new RuntimeException("Please update " + mappingFile + " to namespace " + "com.liferay.portal to com.liferay.client.soap.portal");
        }
    }
}

