/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;

public class SourceFormatter {
    private static final String[] _TAG_LIBRARIES = new String[]{"c", "html", "jsp", "liferay-portlet", "liferay-security", "liferay-theme", "liferay-ui", "liferay-util", "portlet", "struts", "tiles"};
    private static FileImpl _fileUtil = FileImpl.getInstance();
    private static Properties _exclusions;
    private static Pattern _xssPattern;

    public static void main(String[] args) {
        try {
            SourceFormatter._readExclusions();
            Thread thread1 = new Thread(){

                public void run() {
                    try {
                        SourceFormatter._checkPersistenceTestSuite();
                        SourceFormatter._checkWebXML();
                        SourceFormatter._formatJSP();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            Thread thread2 = new Thread(){

                public void run() {
                    try {
                        SourceFormatter._formatJava();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            thread1.start();
            thread2.start();
            thread1.join();
            thread2.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String stripImports(String content, String packageDir, String className) throws IOException {
        int x = content.indexOf("import ");
        if (x == -1) {
            return content;
        }
        int y = content.indexOf("{", x);
        y = content.substring(0, y).lastIndexOf(";") + 1;
        String imports = SourceFormatter._formatImports(content.substring(x, y));
        content = content.substring(0, x) + imports + content.substring(y + 1, content.length());
        Set classes = ClassUtil.getClasses((Reader)new UnsyncStringReader(content), (String)className);
        x = content.indexOf("import ");
        y = content.indexOf("{", x);
        y = content.substring(0, y).lastIndexOf(";") + 1;
        imports = content.substring(x, y);
        StringBuilder sb = new StringBuilder();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.indexOf("import ") == -1) continue;
            int importX = line.indexOf(" ");
            int importY = line.lastIndexOf(".");
            String importPackage = line.substring(importX + 1, importY);
            String importClass = line.substring(importY + 1, line.length() - 1);
            if (packageDir.equals(importPackage)) continue;
            if (!importClass.equals("*")) {
                if (!classes.contains(importClass)) continue;
                sb.append(line);
                sb.append("\n");
                continue;
            }
            sb.append(line);
            sb.append("\n");
        }
        imports = SourceFormatter._formatImports(sb.toString());
        content = content.substring(0, x) + imports + content.substring(y + 1, content.length());
        return content;
    }

    public static void _checkPersistenceTestSuite() throws IOException {
        String basedir = "./portal-impl/test";
        if (!_fileUtil.exists(basedir)) {
            return;
        }
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(basedir);
        ds.setIncludes(new String[]{"**\\*PersistenceTest.java"});
        ds.scan();
        String[] files = ds.getIncludedFiles();
        HashSet<String> persistenceTests = new HashSet<String>();
        for (String file : files) {
            String persistenceTest = file.substring(0, file.length() - 5);
            persistenceTest = persistenceTest.substring(persistenceTest.lastIndexOf(File.separator) + 1, persistenceTest.length());
            persistenceTests.add(persistenceTest);
        }
        String persistenceTestSuite = _fileUtil.read(basedir + "/com/liferay/portal/service/persistence/" + "PersistenceTestSuite.java");
        for (String persistenceTest : persistenceTests) {
            if (persistenceTestSuite.indexOf(persistenceTest) != -1) continue;
            System.out.println("PersistenceTestSuite: " + persistenceTest);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void _checkWebXML() throws IOException {
        String basedir = "./";
        if (_fileUtil.exists(basedir + "portal-impl")) {
            void var5_11;
            Object[] locales = (String[])PropsValues.LOCALES.clone();
            Arrays.sort(locales);
            TreeSet<Object> urlPatterns = new TreeSet<Object>();
            Object[] arr$ = locales;
            int len$ = arr$.length;
            boolean bl = false;
            while (var5_11 < len$) {
                Object locale = arr$[var5_11];
                int pos = ((String)locale).indexOf("_");
                String languageCode = ((String)locale).substring(0, pos);
                urlPatterns.add(languageCode);
                urlPatterns.add(locale);
                ++var5_11;
            }
            StringBuilder sb = new StringBuilder();
            for (String string : urlPatterns) {
                sb.append("\t<servlet-mapping>\n");
                sb.append("\t\t<servlet-name>I18n Servlet</servlet-name>\n");
                sb.append("\t\t<url-pattern>/" + string + "/*</url-pattern>\n");
                sb.append("\t</servlet-mapping>\n");
            }
            File file = new File(basedir + "portal-web/docroot/WEB-INF/web.xml");
            String string = _fileUtil.read(file);
            int x = string.indexOf("<servlet-mapping>");
            x = string.indexOf("<servlet-name>I18n Servlet</servlet-name>", x);
            x = string.lastIndexOf("<servlet-mapping>", x) - 1;
            int y = string.lastIndexOf("<servlet-name>I18n Servlet</servlet-name>");
            y = string.indexOf("</servlet-mapping>", y) + 19;
            String newContent = string.substring(0, x) + sb.toString() + string.substring(y);
            if (newContent != null && !string.equals(newContent)) {
                _fileUtil.write(file, newContent);
                System.out.println(file);
            }
        } else {
            String[] files;
            String webXML = ContentUtil.get("com/liferay/portal/deploy/dependencies/web.xml");
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(basedir);
            ds.setIncludes(new String[]{"**\\web.xml"});
            ds.scan();
            for (String file : files = ds.getIncludedFiles()) {
                String content = _fileUtil.read(basedir + file);
                if (!content.equals(webXML)) continue;
                System.out.println(file);
            }
        }
    }

    private static void _checkXSS(String fileName, String jspContent) {
        Matcher matcher = _xssPattern.matcher(jspContent);
        while (matcher.find()) {
            String documentIdVulnerability;
            String inlineStringVulnerability3;
            String inlineStringVulnerability2;
            String inlineStringVulnerability1;
            String anchorVulnerability;
            boolean xssVulnerable = false;
            String jspVariable = matcher.group(1);
            String inputVulnerability = "<input[^>]* value=\"<%= " + jspVariable + " %>";
            Pattern inputVulnerabilityPattern = Pattern.compile(inputVulnerability, 2);
            Matcher inputVulnerabilityMatcher = inputVulnerabilityPattern.matcher(jspContent);
            if (inputVulnerabilityMatcher.find()) {
                xssVulnerable = true;
            }
            if (jspContent.indexOf(anchorVulnerability = " href=\"<%= " + jspVariable + " %>") != -1) {
                xssVulnerable = true;
            }
            if (jspContent.indexOf(inlineStringVulnerability1 = "'<%= " + jspVariable + " %>") != -1) {
                xssVulnerable = true;
            }
            if (jspContent.indexOf(inlineStringVulnerability2 = "(\"<%= " + jspVariable + " %>") != -1) {
                xssVulnerable = true;
            }
            if (jspContent.indexOf(inlineStringVulnerability3 = " \"<%= " + jspVariable + " %>") != -1) {
                xssVulnerable = true;
            }
            if (jspContent.indexOf(documentIdVulnerability = ".<%= " + jspVariable + " %>") != -1) {
                xssVulnerable = true;
            }
            if (!xssVulnerable) continue;
            System.out.println("(xss): " + fileName + " (" + jspVariable + ")");
        }
    }

    public static String _formatImports(String imports) throws IOException {
        if (imports.indexOf("/*") != -1 || imports.indexOf("*/") != -1 || imports.indexOf("//") != -1) {
            return imports + "\n";
        }
        List<String> importsList = new ArrayList();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.indexOf("import ") == -1 || importsList.contains(line)) continue;
            importsList.add(line);
        }
        importsList = ListUtil.sort(importsList);
        StringBuilder sb = new StringBuilder();
        String temp = null;
        for (int i = 0; i < importsList.size(); ++i) {
            String s = (String)importsList.get(i);
            int pos = s.indexOf(".");
            if ((pos = s.indexOf(".", pos + 1)) == -1) {
                pos = s.indexOf(".");
            }
            String packageLevel = s.substring(7, pos);
            if (i != 0 && !packageLevel.equals(temp)) {
                sb.append("\n");
            }
            temp = packageLevel;
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static void _formatJava() throws IOException {
        String basedir = "./";
        String copyright = SourceFormatter._getCopyright();
        boolean portalJavaFiles = true;
        String[] files = null;
        if (_fileUtil.exists(basedir + "portal-impl")) {
            files = SourceFormatter._getPortalJavaFiles();
        } else {
            portalJavaFiles = false;
            files = SourceFormatter._getPluginJavaFiles();
        }
        for (int i = 0; i < files.length; ++i) {
            int packagePathY;
            File file = new File(basedir + files[i]);
            String content = _fileUtil.read(file);
            String className = file.getName();
            className = className.substring(0, className.length() - 5);
            String packagePath = files[i];
            int packagePathX = packagePath.indexOf(File.separator + "src" + File.separator);
            packagePath = packagePathX + 5 >= (packagePathY = packagePath.lastIndexOf(File.separator)) ? "" : packagePath.substring(packagePathX + 5, packagePathY);
            if ((packagePath = StringUtil.replace((String)packagePath, (String)File.separator, (String)".")).endsWith(".model") && content.indexOf("extends " + className + "Model {") != -1) continue;
            String newContent = SourceFormatter._formatJavaContent(files[i], content);
            if (newContent.indexOf("$\n */") != -1) {
                System.out.println("*: " + files[i]);
                newContent = StringUtil.replace((String)newContent, (String)"$\n */", (String)"$\n *\n */");
            }
            if (newContent.indexOf(copyright) == -1) {
                System.out.println("(c): " + files[i]);
            }
            if (newContent.indexOf(className + ".java.html") == -1) {
                System.out.println("Java2HTML: " + files[i]);
            }
            if (newContent.contains(" * @author Raymond Aug") && !newContent.contains(" * @author Raymond Aug\u00e9")) {
                newContent = newContent.replaceFirst("Raymond Aug.++", "Raymond Aug\u00e9");
                System.out.println("UTF-8: " + files[i]);
            }
            if ((newContent = SourceFormatter.stripImports(newContent, packagePath, className)).indexOf(";\n/**") != -1) {
                newContent = StringUtil.replace((String)newContent, (String)";\n/**", (String)";\n\n/**");
            }
            if (newContent.indexOf("\t/*\n\t *") != -1) {
                newContent = StringUtil.replace((String)newContent, (String)"\t/*\n\t *", (String)"\t/**\n\t *");
            }
            if (newContent.indexOf("if(") != -1) {
                newContent = StringUtil.replace((String)newContent, (String)"if(", (String)"if (");
            }
            if (newContent.indexOf("while(") != -1) {
                newContent = StringUtil.replace((String)newContent, (String)"while(", (String)"while (");
            }
            if (newContent.indexOf("\n\n\n") != -1) {
                newContent = StringUtil.replace((String)newContent, (String)"\n\n\n", (String)"\n\n");
            }
            if (newContent.indexOf("*/\npackage ") != -1) {
                System.out.println("package: " + files[i]);
            }
            if (newContent.indexOf("    ") != -1 && !files[i].endsWith("StringPool.java")) {
                System.out.println("tab: " + files[i]);
            }
            if (newContent.indexOf("  {") != -1) {
                System.out.println("{:" + files[i]);
            }
            if (!newContent.endsWith("\n\n}") && !newContent.endsWith("{\n}")) {
                System.out.println("}: " + files[i]);
            }
            if (portalJavaFiles && className.endsWith("ServiceImpl") && newContent.indexOf("ServiceUtil.") != -1) {
                System.out.println("ServiceUtil: " + files[i]);
            }
            if (newContent == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            System.out.println(file);
        }
    }

    private static String _formatJavaContent(String fileName, String content) throws IOException {
        boolean longLogFactoryUtil = false;
        StringBuilder sb = new StringBuilder();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        int lineCount = 0;
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            ++lineCount;
            if (line.trim().length() == 0) {
                line = "";
            }
            line = StringUtil.trimTrailing((String)line);
            line = StringUtil.replace((String)line, (String[])new String[]{"* Copyright (c) 2000-2008 Liferay, Inc.", "* Copyright 2008 Sun Microsystems Inc."}, (String[])new String[]{"* Copyright (c) 2000-2009 Liferay, Inc.", "* Copyright 2009 Sun Microsystems Inc."});
            sb.append(line);
            sb.append("\n");
            StringBuilder lineSB = new StringBuilder();
            int spacesPerTab = 4;
            for (char c : line.toCharArray()) {
                if (c == '\t') {
                    for (int i = 0; i < spacesPerTab; ++i) {
                        lineSB.append(' ');
                    }
                    spacesPerTab = 4;
                    continue;
                }
                lineSB.append(c);
                if (--spacesPerTab > 0) continue;
                spacesPerTab = 4;
            }
            line = lineSB.toString();
            String excluded = _exclusions.getProperty(StringUtil.replace((String)fileName, (String)"\\", (String)"/") + "@" + lineCount);
            if (excluded == null) {
                excluded = _exclusions.getProperty(StringUtil.replace((String)fileName, (String)"\\", (String)"/"));
            }
            if (excluded != null || line.length() <= 80 || line.startsWith("import ") || line.startsWith("package ")) continue;
            if (line.contains("private static Log _log = LogFactoryUtil.getLog(")) {
                longLogFactoryUtil = true;
            }
            if (fileName.endsWith("Table.java") && line.contains("String TABLE_SQL_CREATE = ")) continue;
            System.out.println("> 80: " + fileName + " " + lineCount);
        }
        unsyncBufferedReader.close();
        String newContent = sb.toString();
        if (newContent.endsWith("\n")) {
            newContent = newContent.substring(0, newContent.length() - 1);
        }
        if (longLogFactoryUtil) {
            newContent = StringUtil.replace((String)newContent, (String)"private static Log _log = ", (String)"private static Log _log =\n\t\t");
        }
        return newContent;
    }

    private static void _formatJSP() throws IOException {
        String basedir = "./";
        ArrayList list = new ArrayList();
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(basedir);
        ds.setExcludes(new String[]{"**\\bin\\**", "**\\null.jsp", "**\\tmp\\**", "**\\tools\\tck\\**"});
        ds.setIncludes(new String[]{"**\\*.jsp", "**\\*.jspf", "**\\*.vm"});
        ds.scan();
        list.addAll(ListUtil.fromArray((Object[])ds.getIncludedFiles()));
        String copyright = SourceFormatter._getCopyright();
        String[] files = list.toArray(new String[list.size()]);
        for (int i = 0; i < files.length; ++i) {
            File file = new File(basedir + files[i]);
            String content = _fileUtil.read(file);
            String newContent = SourceFormatter._formatJSPContent(files[i], content);
            newContent = StringUtil.replace((String)newContent, (String[])new String[]{"<br/>", "\"/>", "\" >", "@page import", "\"%>", ")%>", "javascript: "}, (String[])new String[]{"<br />", "\" />", "\">", "@ page import", "\" %>", ") %>", "javascript:"});
            newContent = StringUtil.replace((String)newContent, (String[])new String[]{"* Copyright (c) 2000-2008 Liferay, Inc.", "* Copyright 2008 Sun Microsystems Inc."}, (String[])new String[]{"* Copyright (c) 2000-2009 Liferay, Inc.", "* Copyright 2009 Sun Microsystems Inc."});
            if (files[i].endsWith(".jsp") && newContent.indexOf(copyright) == -1) {
                System.out.println("(c): " + files[i]);
            }
            if (newContent.indexOf("alert('<%= LanguageUtil.") != -1) {
                newContent = StringUtil.replace((String)newContent, (String)"alert('<%= LanguageUtil.", (String)"alert('<%= UnicodeLanguageUtil.");
            }
            if (newContent.indexOf("alert(\"<%= LanguageUtil.") != -1) {
                newContent = StringUtil.replace((String)newContent, (String)"alert(\"<%= LanguageUtil.", (String)"alert(\"<%= UnicodeLanguageUtil.");
            }
            if (newContent.indexOf("confirm('<%= LanguageUtil.") != -1) {
                newContent = StringUtil.replace((String)newContent, (String)"confirm('<%= LanguageUtil.", (String)"confirm('<%= UnicodeLanguageUtil.");
            }
            if (newContent.indexOf("confirm(\"<%= LanguageUtil.") != -1) {
                newContent = StringUtil.replace((String)newContent, (String)"confirm(\"<%= LanguageUtil.", (String)"confirm(\"<%= UnicodeLanguageUtil.");
            }
            if (newContent.indexOf("    ") != -1 && !files[i].endsWith("template.vm")) {
                System.out.println("tab: " + files[i]);
            }
            SourceFormatter._checkXSS(files[i], content);
            if (newContent == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            System.out.println(file);
        }
    }

    private static String _formatJSPContent(String fileName, String content) throws IOException {
        StringBuilder sb = new StringBuilder();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.trim().length() == 0) {
                line = "";
            }
            line = StringUtil.trimTrailing((String)line);
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        content = SourceFormatter._formatTaglibQuotes(fileName, content, "\"");
        content = SourceFormatter._formatTaglibQuotes(fileName, content, "'");
        return content;
    }

    private static String _formatTaglibQuotes(String fileName, String content, String quoteType) {
        String quoteFix = "'";
        if (quoteFix.equals(quoteType)) {
            quoteFix = "\"";
        }
        Pattern pattern = Pattern.compile(SourceFormatter._getTaglibRegex(quoteType));
        Matcher matcher = pattern.matcher(content);
        block0: while (matcher.find()) {
            int x = content.indexOf(quoteType + "<%=", matcher.start());
            int y = content.indexOf("%>" + quoteType, x);
            while (x != -1 && y != -1) {
                String result = content.substring(x + 1, y + 2);
                if (result.indexOf(quoteType) != -1) {
                    int lineCount = 1;
                    char[] contentCharArray = content.toCharArray();
                    for (int i = 0; i < x; ++i) {
                        if (contentCharArray[i] != '\n') continue;
                        ++lineCount;
                    }
                    if (result.indexOf(quoteFix) == -1) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(content.substring(0, x));
                        sb.append(quoteFix);
                        sb.append(result);
                        sb.append(quoteFix);
                        sb.append(content.substring(y + 3, content.length()));
                        content = sb.toString();
                    } else {
                        System.out.println("taglib: " + fileName + " " + lineCount);
                    }
                }
                if ((x = content.indexOf(quoteType + "<%=", y)) > matcher.end()) continue block0;
                y = content.indexOf("%>" + quoteType, x);
            }
        }
        return content;
    }

    private static String _getCopyright() throws IOException {
        try {
            return _fileUtil.read("copyright.txt");
        }
        catch (Exception e1) {
            try {
                return _fileUtil.read("../copyright.txt");
            }
            catch (Exception e2) {
                return _fileUtil.read("../../copyright.txt");
            }
        }
    }

    private static String[] _getPluginJavaFiles() {
        String basedir = "./";
        ArrayList list = new ArrayList();
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(basedir);
        ds.setExcludes(new String[]{"**\\bin\\**", "**\\model\\*Clp.java", "**\\model\\*Model.java", "**\\model\\*Soap.java", "**\\model\\*Wrapper.java", "**\\model\\impl\\*ModelImpl.java", "**\\service\\*Service.java", "**\\service\\*ServiceClp.java", "**\\service\\*ServiceFactory.java", "**\\service\\*ServiceUtil.java", "**\\service\\*ServiceWrapper.java", "**\\service\\ClpSerializer.java", "**\\service\\base\\*ServiceBaseImpl.java", "**\\service\\http\\*JSONSerializer.java", "**\\service\\http\\*ServiceHttp.java", "**\\service\\http\\*ServiceJSON.java", "**\\service\\http\\*ServiceSoap.java", "**\\service\\messaging\\*ClpMessageListener.java", "**\\service\\persistence\\*Finder.java", "**\\service\\persistence\\*Persistence.java", "**\\service\\persistence\\*PersistenceImpl.java", "**\\service\\persistence\\*Util.java", "**\\tmp\\**"});
        ds.setIncludes(new String[]{"**\\*.java"});
        ds.scan();
        list.addAll(ListUtil.fromArray((Object[])ds.getIncludedFiles()));
        return list.toArray(new String[list.size()]);
    }

    private static String[] _getPortalJavaFiles() {
        String basedir = "./";
        ArrayList list = new ArrayList();
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(basedir);
        ds.setExcludes(new String[]{"**\\bin\\**", "**\\classes\\*", "**\\jsp\\*", "**\\tmp\\**", "**\\EARXMLBuilder.java", "**\\EJBXMLBuilder.java", "**\\PropsKeys.java", "**\\InstanceWrapperBuilder.java", "**\\ServiceBuilder.java", "**\\SourceFormatter.java", "**\\UserAttributes.java", "**\\WebKeys.java", "**\\*_IW.java", "**\\XHTMLComplianceFormatter.java", "**\\portal-service\\**\\model\\*Model.java", "**\\portal-service\\**\\model\\*Soap.java", "**\\portal-service\\**\\model\\*Wrapper.java", "**\\model\\impl\\*ModelImpl.java", "**\\portal\\service\\**", "**\\portal-client\\**", "**\\portal-web\\classes\\**\\*.java", "**\\portal-web\\test\\**\\*Test.java", "**\\portlet\\**\\service\\**", "**\\tools\\ext_tmpl\\**", "**\\tools\\tck\\**"});
        ds.setIncludes(new String[]{"**\\*.java"});
        ds.scan();
        list.addAll(ListUtil.fromArray((Object[])ds.getIncludedFiles()));
        ds = new DirectoryScanner();
        ds.setBasedir(basedir);
        ds.setExcludes(new String[]{"**\\bin\\**", "**\\portal-client\\**", "**\\tools\\ext_tmpl\\**", "**\\*_IW.java", "**\\test\\**\\*PersistenceTest.java"});
        ds.setIncludes(new String[]{"**\\com\\liferay\\portal\\service\\ServiceContext*.java", "**\\model\\BaseModel.java", "**\\model\\impl\\BaseModelImpl.java", "**\\service\\base\\PrincipalBean.java", "**\\service\\http\\*HttpTest.java", "**\\service\\http\\*SoapTest.java", "**\\service\\http\\TunnelUtil.java", "**\\service\\impl\\*.java", "**\\service\\jms\\*.java", "**\\service\\permission\\*.java", "**\\service\\persistence\\BasePersistence.java", "**\\service\\persistence\\BatchSession*.java", "**\\service\\persistence\\*FinderImpl.java", "**\\service\\persistence\\*Query.java", "**\\service\\persistence\\impl\\BasePersistenceImpl.java", "**\\portal-impl\\test\\**\\*.java", "**\\portal-service\\**\\liferay\\counter\\**.java", "**\\portal-service\\**\\liferay\\documentlibrary\\**.java", "**\\portal-service\\**\\liferay\\lock\\**.java", "**\\portal-service\\**\\liferay\\mail\\**.java", "**\\util-bridges\\**\\*.java"});
        ds.scan();
        list.addAll(ListUtil.fromArray((Object[])ds.getIncludedFiles()));
        return list.toArray(new String[list.size()]);
    }

    private static String _getTaglibRegex(String quoteType) {
        StringBuilder sb = new StringBuilder();
        sb.append("<(");
        for (int i = 0; i < _TAG_LIBRARIES.length; ++i) {
            sb.append(_TAG_LIBRARIES[i]);
            sb.append("|");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("):([^>]|%>)*");
        sb.append(quoteType);
        sb.append("<%=.*");
        sb.append(quoteType);
        sb.append(".*%>");
        sb.append(quoteType);
        sb.append("([^>]|%>)*>");
        return sb.toString();
    }

    private static void _readExclusions() throws IOException {
        String sourceFormatterExclusions;
        _exclusions = new Properties();
        ClassLoader classLoader = SourceFormatter.class.getClassLoader();
        URL url = classLoader.getResource(sourceFormatterExclusions = System.getProperty("source-formatter-exclusions", "com/liferay/portal/tools/dependencies/source_formatter_exclusions.properties"));
        if (url == null) {
            return;
        }
        InputStream is = url.openStream();
        _exclusions.load(is);
        is.close();
    }

    static {
        _xssPattern = Pattern.compile("String\\s+([^\\s]+)\\s*=\\s*ParamUtil\\.getString\\(");
    }
}

