/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.FileImpl;
import org.apache.tools.ant.DirectoryScanner;

public class UpgradeTableBuilder {
    private static FileImpl _fileUtil = FileImpl.getInstance();

    public static void main(String[] args) {
        try {
            new UpgradeTableBuilder(args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UpgradeTableBuilder(String upgradeTableDir) throws Exception {
        String[] fileNames;
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(".");
        ds.setIncludes(new String[]{"**\\upgrade\\v**\\util\\*Table.java"});
        ds.scan();
        for (String fileName : fileNames = ds.getIncludedFiles()) {
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            int x = fileName.indexOf("upgrade/v");
            int y = fileName.indexOf("/util", x);
            String version = StringUtil.replace((String)fileName.substring(x + 9, y), (String)"_", (String)".");
            x = fileName.indexOf("/", y + 1);
            y = fileName.indexOf("Table.java", x);
            String upgradeFileName = upgradeTableDir + "/" + version + "/" + fileName.substring(x, y) + "ModelImpl.java";
            if (!_fileUtil.exists(upgradeFileName)) continue;
            String content = _fileUtil.read(upgradeFileName);
            String packagePath = "com.liferay.portal.upgrade.v" + StringUtil.replace((String)version, (String)".", (String)"_") + ".util";
            String className = fileName.substring(x + 1, y) + "Table";
            content = this._getContent(packagePath, className, content);
            _fileUtil.write(fileName, content);
        }
    }

    private String _getContent(String packagePath, String className, String content) throws Exception {
        String[] lines;
        int y;
        int x = content.indexOf("public static final String TABLE_NAME =");
        if (x == -1) {
            x = content.indexOf("public static String TABLE_NAME =");
        }
        if ((y = content.indexOf("public static final String TABLE_SQL_DROP =")) == -1) {
            y = content.indexOf("public static String TABLE_SQL_DROP =");
        }
        y = content.indexOf(";", y);
        content = content.substring(x, y + 1);
        content = StringUtil.replace((String)content, (String[])new String[]{"\t", "{ \"", ") }"}, (String[])new String[]{"", "{\"", ")}"});
        while (content.contains("\n\n")) {
            content = StringUtil.replace((String)content, (String)"\n\n", (String)"\n");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(_fileUtil.read("../copyright.txt"));
        sb.append("\n\npackage " + packagePath + ";\n\n");
        sb.append("import java.sql.Types;\n\n");
        sb.append("/**\n");
        sb.append(" * <a href=\"" + className + ".java.html\"><b><i>View Source</i></b></a>\n");
        sb.append(" *\n");
        sb.append(" * @author Brian Wing Shun Chan\n");
        sb.append(" */\n");
        sb.append("public class " + className + " {\n\n");
        for (String line : lines = StringUtil.split((String)content, (String)"\n")) {
            if (line.startsWith("public static") || line.startsWith("};")) {
                sb.append("\t");
            } else if (line.startsWith("{\"")) {
                sb.append("\t\t");
            }
            sb.append(line);
            sb.append("\n");
            if (!line.endsWith(";")) continue;
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }
}

