/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.deploy;

import com.liferay.portal.deploy.DeployUtil;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.License;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.plugin.PluginPackageUtil;
import com.liferay.portal.tools.WebXMLBuilder;
import com.liferay.portal.tools.deploy.DeploymentHandler;
import com.liferay.portal.util.ExtRegistry;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.SystemProperties;
import com.liferay.util.ant.CopyTask;
import com.liferay.util.ant.DeleteTask;
import com.liferay.util.ant.ExpandTask;
import com.liferay.util.ant.UpToDateTask;
import com.liferay.util.ant.WarTask;
import com.liferay.util.xml.XMLFormatter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.oro.io.GlobFilenameFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDeployer {
    public static final String DEPLOY_TO_PREFIX = "DEPLOY_TO__";
    protected String baseDir;
    protected String destDir;
    protected String appServerType;
    protected String portletTaglibDTD;
    protected String portletExtTaglibDTD;
    protected String securityTaglibDTD;
    protected String themeTaglibDTD;
    protected String uiTaglibDTD;
    protected String utilTaglibDTD;
    protected boolean unpackWar;
    protected String filePattern;
    protected String jbossPrefix;
    protected String tomcatLibDir;
    protected List<String> wars;
    protected List<String> jars;
    private static final String _PORTAL_CLASS_LOADER = "com.liferay.support.tomcat.loader.PortalClassLoader";
    private static Log _log = LogFactoryUtil.getLog(BaseDeployer.class);

    public static void main(String[] args) {
        InitUtil.initWithSpring();
        ArrayList<String> wars = new ArrayList<String>();
        ArrayList<String> jars = new ArrayList<String>();
        for (String arg : args) {
            String fileName = arg.toLowerCase();
            if (fileName.endsWith(".war")) {
                wars.add(arg);
                continue;
            }
            if (!fileName.endsWith(".jar")) continue;
            jars.add(arg);
        }
        new BaseDeployer(wars, jars);
    }

    protected BaseDeployer() {
    }

    protected BaseDeployer(List<String> wars, List<String> jars) {
        this.baseDir = System.getProperty("deployer.base.dir");
        this.destDir = System.getProperty("deployer.dest.dir");
        this.appServerType = System.getProperty("deployer.app.server.type");
        this.portletTaglibDTD = System.getProperty("deployer.portlet.taglib.dtd");
        this.portletExtTaglibDTD = System.getProperty("deployer.portlet.ext.taglib.dtd");
        this.securityTaglibDTD = System.getProperty("deployer.security.taglib.dtd");
        this.themeTaglibDTD = System.getProperty("deployer.theme.taglib.dtd");
        this.uiTaglibDTD = System.getProperty("deployer.ui.taglib.dtd");
        this.utilTaglibDTD = System.getProperty("deployer.util.taglib.dtd");
        this.unpackWar = GetterUtil.getBoolean((String)System.getProperty("deployer.unpack.war"), (boolean)true);
        this.filePattern = System.getProperty("deployer.file.pattern");
        this.jbossPrefix = GetterUtil.getString((String)System.getProperty("deployer.jboss.prefix"));
        this.tomcatLibDir = System.getProperty("deployer.tomcat.lib.dir");
        this.wars = wars;
        this.jars = jars;
        this.checkArguments();
        try {
            this.deploy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addExtJar(List<String> jars, String resource) throws Exception {
        Set<String> servletContextNames = ExtRegistry.getServletContextNames();
        for (String servletContextName : servletContextNames) {
            String extResource = "ext-" + servletContextName + resource.substring(3);
            String path = DeployUtil.getResourcePath(extResource);
            if (_log.isDebugEnabled()) {
                if (path == null) {
                    _log.debug((Object)("Resource " + extResource + " is not available"));
                } else {
                    _log.debug((Object)("Resource " + extResource + " is available at " + path));
                }
            }
            if (path == null) continue;
            jars.add(path);
        }
    }

    protected void addRequiredJar(List<String> jars, String resource) throws Exception {
        String path = DeployUtil.getResourcePath(resource);
        if (path == null) {
            throw new RuntimeException("Resource " + resource + " does not exist");
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Resource " + resource + " is available at " + path));
        }
        jars.add(path);
    }

    protected void checkArguments() {
        if (Validator.isNull((String)this.baseDir)) {
            throw new IllegalArgumentException("The system property deployer.base.dir is not set");
        }
        if (Validator.isNull((String)this.destDir)) {
            throw new IllegalArgumentException("The system property deployer.dest.dir is not set");
        }
        if (Validator.isNull((String)this.appServerType)) {
            throw new IllegalArgumentException("The system property deployer.app.server.type is not set");
        }
        if (!(this.appServerType.startsWith("geronimo") || this.appServerType.startsWith("glassfish") || this.appServerType.startsWith("jboss") || this.appServerType.startsWith("jonas") || this.appServerType.equals("jetty") || this.appServerType.equals("oc4j") || this.appServerType.equals("resin") || this.appServerType.equals("tomcat") || this.appServerType.equals("weblogic") || this.appServerType.equals("websphere"))) {
            throw new IllegalArgumentException(this.appServerType + " is not a valid application server type");
        }
        if (this.appServerType.startsWith("glassfish") || this.appServerType.equals("weblogic")) {
            this.unpackWar = false;
        }
        if (Validator.isNotNull((String)this.jbossPrefix) && !Validator.isNumber((String)this.jbossPrefix)) {
            this.jbossPrefix = "1";
        }
    }

    protected void copyDependencyXml(String fileName, String targetDir) throws Exception {
        this.copyDependencyXml(fileName, targetDir, null);
    }

    protected void copyDependencyXml(String fileName, String targetDir, Map<String, String> filterMap) throws Exception {
        this.copyDependencyXml(fileName, targetDir, filterMap, false);
    }

    protected void copyDependencyXml(String fileName, String targetDir, Map<String, String> filterMap, boolean overwrite) throws Exception {
        File file = new File(DeployUtil.getResourcePath(fileName));
        File targetFile = new File(targetDir + "/" + fileName);
        if (!targetFile.exists()) {
            CopyTask.copyFile((File)file, (File)new File(targetDir), filterMap, (boolean)overwrite, (boolean)true);
        }
    }

    protected void copyJars(File srcFile, PluginPackage pluginPackage) throws Exception {
        for (int i = 0; i < this.jars.size(); ++i) {
            String jarFullName = this.jars.get(i);
            String jarName = jarFullName.substring(jarFullName.lastIndexOf("/") + 1, jarFullName.length());
            if (this.appServerType.equals("tomcat") && (!this.appServerType.equals("tomcat") || jarFullName.equals("util-java.jar"))) continue;
            FileUtil.copyFile((String)jarFullName, (String)(srcFile + "/WEB-INF/lib/" + jarName), (boolean)true);
        }
        FileUtil.delete((String)(srcFile + "/WEB-INF/lib/util-jsf.jar"));
    }

    protected void copyPortalDependencies(File srcFile) throws Exception {
        String[] log4jJars;
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties == null) {
            return;
        }
        String[] portalJars = StringUtil.split((String)properties.getProperty("portal-dependency-jars", properties.getProperty("portal.dependency.jars")));
        for (int i = 0; i < portalJars.length; ++i) {
            String portalJar = portalJars[i].trim();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Copy portal JAR " + portalJar));
            }
            try {
                String portalJarPath = PortalUtil.getPortalLibDir() + portalJar;
                FileUtil.copyFile((String)portalJarPath, (String)(srcFile + "/WEB-INF/lib/" + portalJar), (boolean)true);
                continue;
            }
            catch (Exception e) {
                _log.error((Object)("Unable to copy portal JAR " + portalJar), (Throwable)e);
            }
        }
        String[] portalTlds = StringUtil.split((String)properties.getProperty("portal-dependency-tlds", properties.getProperty("portal.dependency.tlds")));
        for (int i = 0; i < portalTlds.length; ++i) {
            String portalTld = portalTlds[i].trim();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Copy portal TLD " + portalTld));
            }
            try {
                String portalTldPath = DeployUtil.getResourcePath(portalTld);
                FileUtil.copyFile((String)portalTldPath, (String)(srcFile + "/WEB-INF/tld/" + portalTld), (boolean)true);
                continue;
            }
            catch (Exception e) {
                _log.error((Object)("Unable to copy portal TLD " + portalTld), (Throwable)e);
            }
        }
        File pluginLibDir = new File(srcFile + "/WEB-INF/lib/");
        String[] commonsLoggingJars = pluginLibDir.list((FilenameFilter)new GlobFilenameFilter("commons-logging*.jar"));
        if (commonsLoggingJars == null || commonsLoggingJars.length == 0) {
            String portalJarPath = PortalUtil.getPortalLibDir() + "commons-logging.jar";
            FileUtil.copyFile((String)portalJarPath, (String)(srcFile + "/WEB-INF/lib/commons-logging.jar"), (boolean)true);
        }
        if ((log4jJars = pluginLibDir.list((FilenameFilter)new GlobFilenameFilter("log4j*.jar"))) == null || log4jJars.length == 0) {
            String portalJarPath = PortalUtil.getPortalLibDir() + "log4j.jar";
            FileUtil.copyFile((String)portalJarPath, (String)(srcFile + "/WEB-INF/lib/log4j.jar"), (boolean)true);
        }
    }

    protected void copyProperties(File srcFile, PluginPackage pluginPackage) throws Exception {
        this.copyDependencyXml("log4j.properties", srcFile + "/WEB-INF/classes");
        this.copyDependencyXml("logging.properties", srcFile + "/WEB-INF/classes");
    }

    protected void copyTlds(File srcFile, PluginPackage pluginPackage) throws Exception {
        if (Validator.isNotNull((String)this.portletTaglibDTD)) {
            FileUtil.copyFile((String)this.portletTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-portlet.tld"), (boolean)true);
        }
        if (Validator.isNotNull((String)this.portletExtTaglibDTD)) {
            FileUtil.copyFile((String)this.portletExtTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-portlet-ext.tld"), (boolean)true);
        }
        if (Validator.isNotNull((String)this.securityTaglibDTD)) {
            FileUtil.copyFile((String)this.securityTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-security.tld"), (boolean)true);
        }
        if (Validator.isNotNull((String)this.themeTaglibDTD)) {
            FileUtil.copyFile((String)this.themeTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-theme.tld"), (boolean)true);
        }
        if (Validator.isNotNull((String)this.uiTaglibDTD)) {
            FileUtil.copyFile((String)this.uiTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-ui.tld"), (boolean)true);
        }
        if (Validator.isNotNull((String)this.utilTaglibDTD)) {
            FileUtil.copyFile((String)this.utilTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-util.tld"), (boolean)true);
        }
    }

    protected void copyXmls(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        if (this.appServerType.startsWith("geronimo")) {
            this.copyDependencyXml("geronimo-web.xml", srcFile + "/WEB-INF");
        } else if (this.appServerType.equals("weblogic")) {
            this.copyDependencyXml("weblogic.xml", srcFile + "/WEB-INF");
        } else if (this.appServerType.equals("websphere")) {
            this.copyDependencyXml("ibm-web-ext.xmi", srcFile + "/WEB-INF");
        }
        this.copyDependencyXml("web.xml", srcFile + "/WEB-INF");
    }

    protected void deploy() throws Exception {
        try {
            File baseDirFile = new File(this.baseDir);
            File[] files = baseDirFile.listFiles();
            if (files == null) {
                return;
            }
            files = FileUtil.sortFiles((File[])files);
            for (int i = 0; i < files.length; ++i) {
                File srcFile = files[i];
                String fileName = srcFile.getName().toLowerCase();
                boolean deploy = false;
                if (fileName.endsWith(".war") || fileName.endsWith(".zip")) {
                    deploy = true;
                    if (this.wars.size() > 0) {
                        if (!this.wars.contains(srcFile.getName())) {
                            deploy = false;
                        }
                    } else if (Validator.isNotNull((String)this.filePattern) && !StringUtil.matches((String)fileName, (String)this.filePattern)) {
                        deploy = false;
                    }
                }
                if (!deploy) continue;
                this.deployFile(srcFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void deployDirectory(File srcFile, String displayName, boolean override, PluginPackage pluginPackage) throws Exception {
        this.deployDirectory(srcFile, null, null, displayName, override, pluginPackage);
    }

    protected void deployDirectory(File srcFile, File mergeDir, File deployDir, String displayName, boolean overwrite, PluginPackage pluginPackage) throws Exception {
        this.rewriteFiles(srcFile);
        this.mergeDirectory(mergeDir, srcFile);
        this.processPluginPackageProperties(srcFile, displayName, pluginPackage);
        this.copyJars(srcFile, pluginPackage);
        this.copyProperties(srcFile, pluginPackage);
        this.copyTlds(srcFile, pluginPackage);
        this.copyXmls(srcFile, displayName, pluginPackage);
        this.copyPortalDependencies(srcFile);
        this.updateGeronimoWebXml(srcFile, displayName, pluginPackage);
        File webXml = new File(srcFile + "/WEB-INF/web.xml");
        this.updateWebXml(webXml, srcFile, displayName, pluginPackage);
        if (deployDir == null || this.baseDir.equals(this.destDir)) {
            return;
        }
        this.updateDeployDirectory(srcFile);
        String excludes = "";
        if (this.appServerType.startsWith("jboss")) {
            excludes = excludes + "**/WEB-INF/lib/log4j.jar,";
        } else if (this.appServerType.equals("tomcat")) {
            String content;
            String[] libs = FileUtil.listFiles((String)this.tomcatLibDir);
            for (int i = 0; i < libs.length; ++i) {
                excludes = excludes + "**/WEB-INF/lib/" + libs[i] + ",";
            }
            File contextXml = new File(srcFile + "/META-INF/context.xml");
            if (contextXml.exists() && (content = FileUtil.read((File)contextXml)).indexOf(_PORTAL_CLASS_LOADER) != -1) {
                excludes = excludes + "**/WEB-INF/lib/util-bridges.jar,";
                excludes = excludes + "**/WEB-INF/lib/util-java.jar,";
                excludes = excludes + "**/WEB-INF/lib/util-taglib.jar,";
            }
            try {
                Class.forName("javax.el.ELContext");
                excludes = excludes + "**/WEB-INF/lib/el-api.jar,";
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if (!this.unpackWar || this.appServerType.equals("websphere")) {
            File tempDir = new File(SystemProperties.get((String)"java.io.tmpdir") + File.separator + Time.getTimestamp());
            WarTask.war((File)srcFile, (File)tempDir, (String)"WEB-INF/web.xml", (File)webXml);
            if (this.isJEEDeploymentEnabled()) {
                File tempWarDir = new File(tempDir.getParent(), deployDir.getName());
                if (tempWarDir.exists()) {
                    tempWarDir.delete();
                }
                if (!tempDir.renameTo(tempWarDir)) {
                    tempWarDir = tempDir;
                }
                DeploymentHandler deploymentHandler = this.getDeploymentHandler();
                deploymentHandler.deploy(tempWarDir, displayName);
                deploymentHandler.releaseDeploymentManager();
                DeleteTask.deleteDirectory((File)tempWarDir);
            } else {
                if (!tempDir.renameTo(deployDir)) {
                    WarTask.war((File)srcFile, (File)deployDir, (String)"WEB-INF/web.xml", (File)webXml);
                }
                DeleteTask.deleteDirectory((File)tempDir);
            }
        } else {
            excludes = excludes + "**/WEB-INF/web.xml";
            CopyTask.copyDirectory((File)srcFile, (File)deployDir, (String)"", (String)excludes, (boolean)overwrite, (boolean)true);
            CopyTask.copyDirectory((File)srcFile, (File)deployDir, (String)"**/WEB-INF/web.xml", (String)"", (boolean)true, (boolean)false);
            if (this.appServerType.equals("tomcat")) {
                File deployWebXml = new File(deployDir + "/WEB-INF/web.xml");
                deployWebXml.setLastModified(System.currentTimeMillis() + 6000L);
            }
        }
    }

    protected void deployFile(File srcFile) throws Exception {
        PluginPackage pluginPackage = this.readPluginPackage(srcFile);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Deploying " + srcFile.getName()));
        }
        String deployDir = null;
        String displayName = null;
        boolean overwrite = false;
        String preliminaryContext = null;
        if (srcFile.getName().startsWith(DEPLOY_TO_PREFIX)) {
            displayName = srcFile.getName().substring(DEPLOY_TO_PREFIX.length(), srcFile.getName().length() - 4);
            overwrite = true;
            preliminaryContext = displayName;
        }
        if (preliminaryContext == null) {
            preliminaryContext = this.getDisplayName(srcFile);
        }
        if (pluginPackage != null) {
            if (!PluginPackageUtil.isCurrentVersionSupported(pluginPackage.getLiferayVersions())) {
                throw new AutoDeployException(srcFile.getName() + " does not support this version of Liferay");
            }
            if (displayName == null) {
                displayName = pluginPackage.getRecommendedDeploymentContext();
            }
            if (Validator.isNull((String)displayName)) {
                displayName = this.getDisplayName(srcFile);
            }
            pluginPackage.setContext(displayName);
            PluginPackageUtil.updateInstallingPluginPackage(preliminaryContext, pluginPackage);
        }
        if (Validator.isNotNull(displayName)) {
            deployDir = displayName + ".war";
        } else {
            deployDir = srcFile.getName();
            displayName = this.getDisplayName(srcFile);
        }
        if (this.appServerType.startsWith("jboss")) {
            deployDir = this.jbossPrefix + deployDir;
        } else if ((this.appServerType.equals("jetty") || this.appServerType.equals("oc4j") || this.appServerType.equals("resin") || this.appServerType.equals("tomcat")) && this.unpackWar) {
            deployDir = deployDir.substring(0, deployDir.length() - 4);
        }
        deployDir = this.destDir + "/" + deployDir;
        File deployDirFile = new File(deployDir);
        try {
            PluginPackage previousPluginPackage = this.readPluginPackage(deployDirFile);
            if (pluginPackage != null && previousPluginPackage != null) {
                if (_log.isInfoEnabled()) {
                    String name = pluginPackage.getName();
                    String previousVersion = previousPluginPackage.getVersion();
                    String version = pluginPackage.getVersion();
                    _log.info((Object)("Updating " + name + " from version " + previousVersion + " to version " + version));
                }
                if (pluginPackage.isLaterVersionThan(previousPluginPackage)) {
                    overwrite = true;
                }
            }
            File mergeDirFile = new File(srcFile.getParent() + "/merge/" + srcFile.getName());
            if (srcFile.isDirectory()) {
                this.deployDirectory(srcFile, mergeDirFile, deployDirFile, displayName, overwrite, pluginPackage);
            } else {
                boolean deployed = this.deployFile(srcFile, mergeDirFile, deployDirFile, displayName, overwrite, pluginPackage);
                if (!deployed) {
                    String context = preliminaryContext;
                    if (pluginPackage != null) {
                        context = pluginPackage.getContext();
                    }
                    PluginPackageUtil.endPluginPackageInstallation(context);
                }
            }
        }
        catch (Exception e) {
            if (pluginPackage != null) {
                PluginPackageUtil.endPluginPackageInstallation(pluginPackage.getContext());
            }
            throw e;
        }
    }

    protected boolean deployFile(File srcFile, File mergeDir, File deployDir, String displayName, boolean overwrite, PluginPackage pluginPackage) throws Exception {
        boolean undeployOnRedeploy = false;
        try {
            undeployOnRedeploy = PrefsPropsUtil.getBoolean("hot.undeploy.on.redeploy", PropsValues.HOT_UNDEPLOY_ON_REDEPLOY);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (undeployOnRedeploy) {
            DeployUtil.undeploy(this.appServerType, deployDir);
        }
        if (!overwrite && UpToDateTask.isUpToDate((File)srcFile, (File)deployDir)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)(deployDir + " is already up to date"));
            }
            return false;
        }
        File tempDir = new File(SystemProperties.get((String)"java.io.tmpdir") + File.separator + Time.getTimestamp());
        ExpandTask.expand((File)srcFile, (File)tempDir);
        this.deployDirectory(tempDir, mergeDir, deployDir, displayName, overwrite, pluginPackage);
        DeleteTask.deleteDirectory((File)tempDir);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String downloadJar(String jar) throws Exception {
        String tmpDir = SystemProperties.get((String)"java.io.tmpdir");
        File file = new File(tmpDir + "/liferay/com/liferay/portal/deploy/dependencies/" + jar);
        if (!file.exists()) {
            BaseDeployer baseDeployer = this;
            synchronized (baseDeployer) {
                String url = PropsUtil.get("library.download.url." + jar);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Downloading library from " + url));
                }
                byte[] bytes = HttpUtil.URLtoByteArray((String)url);
                FileUtil.write((File)file, (byte[])bytes);
            }
        }
        return FileUtil.getAbsolutePath((File)file);
    }

    protected String getDisplayName(File srcFile) {
        String displayName = srcFile.getName();
        if (StringUtil.endsWith((String)displayName, (String)".war") || StringUtil.endsWith((String)displayName, (String)".xml")) {
            displayName = displayName.substring(0, displayName.length() - 4);
        }
        if (this.appServerType.startsWith("jboss") && Validator.isNotNull((String)this.jbossPrefix) && displayName.startsWith(this.jbossPrefix)) {
            displayName = displayName.substring(1, displayName.length());
        }
        return displayName;
    }

    protected DeploymentHandler getDeploymentHandler() {
        String prefix = "auto.deploy." + ServerDetector.getServerId() + ".jee.";
        String dmId = PropsUtil.get(prefix + "dm.id");
        String dmUser = PropsUtil.get(prefix + "dm.user");
        String dmPassword = PropsUtil.get(prefix + "dm.passwd");
        String dfClassName = PropsUtil.get(prefix + "df.classname");
        return new DeploymentHandler(dmId, dmUser, dmPassword, dfClassName);
    }

    protected String getExtraContent(double webXmlVersion, File srcFile, String displayName) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<display-name>");
        sb.append(displayName);
        sb.append("</display-name>");
        sb.append("<listener>");
        sb.append("<listener-class>");
        sb.append("com.liferay.portal.kernel.servlet.");
        sb.append("SerializableSessionAttributeListener");
        sb.append("</listener-class>");
        sb.append("</listener>");
        File serviceXml = new File(srcFile + "/WEB-INF/service.xml");
        if (serviceXml.exists()) {
            sb.append("<listener>");
            sb.append("<listener-class>");
            sb.append("com.liferay.portal.kernel.spring.context.");
            sb.append("PortletContextLoaderListener");
            sb.append("</listener-class>");
            sb.append("</listener>");
        }
        boolean hasTaglib = false;
        if (Validator.isNotNull((String)this.portletTaglibDTD) || Validator.isNotNull((String)this.portletExtTaglibDTD) || Validator.isNotNull((String)this.securityTaglibDTD) || Validator.isNotNull((String)this.themeTaglibDTD) || Validator.isNotNull((String)this.uiTaglibDTD) || Validator.isNotNull((String)this.utilTaglibDTD)) {
            hasTaglib = true;
        }
        if (hasTaglib && webXmlVersion > 2.3) {
            sb.append("<jsp-config>");
        }
        if (Validator.isNotNull((String)this.portletTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://java.sun.com/portlet_2_0</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-portlet.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull((String)this.portletExtTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>");
            sb.append("http://liferay.com/tld/portlet");
            sb.append("</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-portlet-ext.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull((String)this.securityTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>");
            sb.append("http://liferay.com/tld/security");
            sb.append("</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-security.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull((String)this.themeTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://liferay.com/tld/theme</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-theme.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull((String)this.uiTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://liferay.com/tld/ui</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-ui.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull((String)this.utilTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://liferay.com/tld/util</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-util.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (hasTaglib && webXmlVersion > 2.3) {
            sb.append("</jsp-config>");
        }
        return sb.toString();
    }

    protected String getPluginPackageLicensesXml(List<License> licenses) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < licenses.size(); ++i) {
            License license = licenses.get(i);
            if (i == 0) {
                sb.append("\r\n");
            }
            sb.append("\t\t<license osi-approved=\"");
            sb.append(license.isOsiApproved());
            sb.append("\">");
            sb.append(license.getName());
            sb.append("</license>\r\n");
            if (i + 1 != licenses.size()) continue;
            sb.append("\t");
        }
        return sb.toString();
    }

    protected String getPluginPackageLiferayVersionsXml(List<String> liferayVersions) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < liferayVersions.size(); ++i) {
            String liferayVersion = liferayVersions.get(i);
            if (i == 0) {
                sb.append("\r\n");
            }
            sb.append("\t\t<liferay-version>");
            sb.append(liferayVersion);
            sb.append("</liferay-version>\r\n");
            if (i + 1 != liferayVersions.size()) continue;
            sb.append("\t");
        }
        return sb.toString();
    }

    protected Properties getPluginPackageProperties(File srcFile) throws Exception {
        File propertiesFile = new File(srcFile + "/WEB-INF/liferay-plugin-package.properties");
        if (!propertiesFile.exists()) {
            return null;
        }
        String propertiesString = FileUtil.read((File)propertiesFile);
        return PropertiesUtil.load((String)propertiesString);
    }

    protected String getPluginPackageTagsXml(List<String> tags) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tags.size(); ++i) {
            String tag = tags.get(i);
            if (i == 0) {
                sb.append("\r\n");
            }
            sb.append("\t\t<tag>");
            sb.append(tag);
            sb.append("</tag>\r\n");
            if (i + 1 != tags.size()) continue;
            sb.append("\t");
        }
        return sb.toString();
    }

    protected String getSpeedFiltersContent(File srcFile) throws Exception {
        boolean speedFiltersEnabled = true;
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties != null) {
            speedFiltersEnabled = GetterUtil.getBoolean((String)properties.getProperty("speed-filters-enabled"), (boolean)true);
        }
        if (speedFiltersEnabled) {
            String speedFiltersContent = FileUtil.read((String)DeployUtil.getResourcePath("speed_filters.xml"));
            return speedFiltersContent;
        }
        return "";
    }

    protected boolean isJEEDeploymentEnabled() {
        return GetterUtil.getBoolean((String)PropsUtil.get("auto.deploy." + ServerDetector.getServerId() + ".jee.deployment.enabled"));
    }

    protected void mergeDirectory(File mergeDir, File targetDir) {
        if (mergeDir == null || !mergeDir.exists()) {
            return;
        }
        CopyTask.copyDirectory((File)mergeDir, (File)targetDir, null, null, (boolean)true, (boolean)false);
    }

    protected void processPluginPackageProperties(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PluginPackage readPluginPackage(File file) {
        if (!file.exists()) {
            return null;
        }
        InputStream is = null;
        ZipFile zipFile = null;
        try {
            File pluginPackageXmlFile;
            boolean parseProps;
            block46: {
                block45: {
                    parseProps = false;
                    if (!file.isDirectory()) break block45;
                    String path = file.getPath();
                    File pluginPackageXmlFile2 = new File(file.getParent() + "/merge/" + file.getName() + "/WEB-INF/liferay-plugin-package.xml");
                    if (pluginPackageXmlFile2.exists()) {
                        is = new FileInputStream(pluginPackageXmlFile2);
                    } else {
                        pluginPackageXmlFile2 = new File(path + "/WEB-INF/liferay-plugin-package.xml");
                        if (pluginPackageXmlFile2.exists()) {
                            is = new FileInputStream(pluginPackageXmlFile2);
                        }
                    }
                    File pluginPackagePropsFile = new File(file.getParent() + "/merge/" + file.getName() + "/WEB-INF/liferay-plugin-package.properties");
                    if (is == null && pluginPackagePropsFile.exists()) {
                        is = new FileInputStream(pluginPackagePropsFile);
                        parseProps = true;
                        break block46;
                    } else {
                        pluginPackagePropsFile = new File(path + "/WEB-INF/liferay-plugin-package.properties");
                        if (is == null && pluginPackagePropsFile.exists()) {
                            is = new FileInputStream(pluginPackagePropsFile);
                            parseProps = true;
                        }
                    }
                    break block46;
                }
                zipFile = new ZipFile(file);
                pluginPackageXmlFile = new File(file.getParent() + "/merge/" + file.getName() + "/WEB-INF/liferay-plugin-package.xml");
                if (pluginPackageXmlFile.exists()) {
                    is = new FileInputStream(pluginPackageXmlFile);
                } else {
                    ZipEntry zipEntry = zipFile.getEntry("WEB-INF/liferay-plugin-package.xml");
                    if (zipEntry != null) {
                        is = zipFile.getInputStream(zipEntry);
                    }
                }
                File pluginPackagePropsFile = new File(file.getParent() + "/merge/" + file.getName() + "/WEB-INF/liferay-plugin-package.properties");
                if (is == null && pluginPackagePropsFile.exists()) {
                    is = new FileInputStream(pluginPackagePropsFile);
                    parseProps = true;
                } else {
                    ZipEntry zipEntry = zipFile.getEntry("WEB-INF/liferay-plugin-package.properties");
                    if (is == null && zipEntry != null) {
                        is = zipFile.getInputStream(zipEntry);
                        parseProps = true;
                    }
                }
            }
            if (is == null) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)(file.getPath() + " does not have a " + "WEB-INF/liferay-plugin-package.xml or " + "WEB-INF/liferay-plugin-package.properties"));
                }
                pluginPackageXmlFile = null;
                return pluginPackageXmlFile;
            }
            if (parseProps) {
                String displayName = this.getDisplayName(file);
                String propertiesString = StringUtil.read((InputStream)is);
                Properties properties = PropertiesUtil.load((String)propertiesString);
                PluginPackage pluginPackage = PluginPackageUtil.readPluginPackageProperties(displayName, properties);
                return pluginPackage;
            }
            String xml = StringUtil.read((InputStream)is);
            xml = XMLFormatter.fixProlog((String)xml);
            PluginPackage pluginPackage = PluginPackageUtil.readPluginPackageXml(xml);
            return pluginPackage;
        }
        catch (Exception e) {
            _log.error((Object)(file.getPath() + ": " + e.toString()));
            return null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    protected void rewriteFiles(File srcDir) throws Exception {
        String[] files = FileUtil.listFiles((String)(srcDir + "/WEB-INF/"));
        for (int i = 0; i < files.length; ++i) {
            String ext;
            String fileName = GetterUtil.getString((String)FileUtil.getShortFileName((String)files[i]));
            if (fileName.equalsIgnoreCase("mule-config.xml") || !(ext = GetterUtil.getString((String)FileUtil.getExtension((String)files[i]))).equalsIgnoreCase("xml")) continue;
            File file = new File(srcDir + "/WEB-INF/" + files[i]);
            try {
                Document doc = SAXReaderUtil.read((File)file);
                String content = doc.formattedString("\t", true);
                FileUtil.write((File)file, (String)content);
                continue;
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to format " + file + ": " + e.getMessage()));
            }
        }
    }

    protected void updateDeployDirectory(File srcFile) throws Exception {
    }

    protected void updateGeronimoWebXml(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        if (!this.appServerType.startsWith("geronimo")) {
            return;
        }
        File geronimoWebXml = new File(srcFile + "/WEB-INF/geronimo-web.xml");
        Document doc = SAXReaderUtil.read((File)geronimoWebXml);
        Element root = doc.getRootElement();
        Element environmentEl = root.element("environment");
        Element moduleIdEl = environmentEl.element("moduleId");
        Element artifactIdEl = moduleIdEl.element("artifactId");
        String artifactIdText = GetterUtil.getString((String)artifactIdEl.getText());
        if (!artifactIdText.equals(displayName)) {
            artifactIdEl.setText(displayName);
            String content = doc.formattedString();
            FileUtil.write((File)geronimoWebXml, (String)content);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Modifying Geronimo " + geronimoWebXml));
            }
        }
    }

    protected void updateWebXml(File webXml, File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        int pos;
        String content = FileUtil.read((File)webXml);
        int x = content.indexOf("<display-name>");
        if (x != -1) {
            int y = content.indexOf("</display-name>", x);
            y = content.indexOf(">", y) + 1;
            content = content.substring(0, x) + content.substring(y);
        }
        double webXmlVersion = 2.3;
        Document webXmlDoc = SAXReaderUtil.read((String)content);
        Element webXmlRoot = webXmlDoc.getRootElement();
        webXmlVersion = GetterUtil.getDouble((String)webXmlRoot.attributeValue("version"), (double)webXmlVersion);
        String extraContent = this.getExtraContent(webXmlVersion, srcFile, displayName);
        if (webXmlVersion > 2.3) {
            while ((pos = extraContent.indexOf("<param-name>servlet-2.4-dispatcher</param-name>")) != -1) {
                x = extraContent.lastIndexOf("<init-param>", pos);
                int y = extraContent.indexOf("</init-param>", pos);
                extraContent = extraContent.substring(0, x) + extraContent.substring(y + 13);
            }
        }
        pos = content.indexOf("</web-app>");
        String newContent = content.substring(0, pos) + extraContent + content.substring(pos, content.length());
        newContent = StringUtil.replace((String)newContent, (String)"com.liferay.portal.shared.", (String)"com.liferay.portal.kernel.");
        newContent = WebXMLBuilder.organizeWebXML(newContent);
        FileUtil.write((File)webXml, (String)newContent, (boolean)true);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Modifying Servlet " + webXmlVersion + " " + webXml));
        }
    }
}

