/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.deploy;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.tools.deploy.DeploymentProgressListener;
import java.io.File;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;

public class DeploymentHandler {
    private static Log _log = LogFactoryUtil.getLog(DeploymentHandler.class);
    private DeploymentManager _deploymentManager;
    private boolean _error;
    private boolean _started;

    public DeploymentHandler(String dmId, String dmUser, String dmPassword, String dfClassName) {
        try {
            ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
            DeploymentFactoryManager deploymentFactoryManager = DeploymentFactoryManager.getInstance();
            DeploymentFactory deploymentFactory = (DeploymentFactory)classLoader.loadClass(dfClassName).newInstance();
            deploymentFactoryManager.registerDeploymentFactory(deploymentFactory);
            this._deploymentManager = deploymentFactoryManager.getDeploymentManager(dmId, dmUser, dmPassword);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public DeploymentManager getDeploymentManager() {
        return this._deploymentManager;
    }

    public void deploy(File warDir, String warContext) throws Exception {
        TargetModuleID[] targetModuleIDs;
        this.setStarted(false);
        ProgressObject deployProgress = null;
        for (TargetModuleID targetModuleID : targetModuleIDs = this._deploymentManager.getAvailableModules(ModuleType.WAR, this._deploymentManager.getTargets())) {
            if (!targetModuleID.getModuleID().equals(warContext)) continue;
            deployProgress = this._deploymentManager.redeploy(new TargetModuleID[]{targetModuleID}, warDir, null);
            break;
        }
        if (deployProgress == null) {
            deployProgress = this._deploymentManager.distribute(this._deploymentManager.getTargets(), warDir, null);
        }
        deployProgress.addProgressListener((ProgressListener)new DeploymentProgressListener(this, warContext));
        this.waitForStart(warContext);
        if (this._error) {
            throw new Exception("Failed to deploy " + warDir);
        }
    }

    public void releaseDeploymentManager() {
        this._deploymentManager.release();
    }

    public synchronized void setError(boolean error) {
        this._error = error;
    }

    public synchronized void setStarted(boolean started) {
        this._started = started;
        this.notifyAll();
    }

    protected synchronized void waitForStart(String warContext) throws Exception {
        while (!this._error && !this._started) {
            this.wait();
        }
        if (this._error) {
            return;
        }
    }
}

