/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.deploy;

import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.tools.deploy.BaseDeployer;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.xml.DocumentImpl;
import com.liferay.util.TextFormatter;
import com.liferay.util.bridges.mvc.MVCPortlet;
import com.liferay.util.xml.XMLMerger;
import com.liferay.util.xml.descriptor.FacesXMLDescriptor;
import com.liferay.util.xml.descriptor.XMLDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletDeployer
extends BaseDeployer {
    public static final String JSF_MYFACES = "org.apache.myfaces.portlet.MyFacesGenericPortlet";
    public static final String JSF_STANDARD = "javax.portlet.faces.GenericFacesPortlet";
    public static final String JSF_SUN = "com.sun.faces.portlet.FacesPortlet";
    public static final String LIFERAY_RENDER_KIT_FACTORY = "com.liferay.util.jsf.sun.faces.renderkit.LiferayRenderKitFactoryImpl";
    public static final String MYFACES_CONTEXT_FACTORY = "com.liferay.util.bridges.jsf.myfaces.MyFacesContextFactoryImpl";
    private boolean _myFacesPortlet;
    private boolean _sunFacesPortlet;

    public static void main(String[] args) {
        InitUtil.initWithSpring();
        ArrayList<String> wars = new ArrayList<String>();
        ArrayList<String> jars = new ArrayList<String>();
        for (String arg : args) {
            if (arg.endsWith(".war")) {
                wars.add(arg);
                continue;
            }
            if (!arg.endsWith(".jar")) continue;
            jars.add(arg);
        }
        new PortletDeployer(wars, jars);
    }

    protected PortletDeployer() {
    }

    protected PortletDeployer(List<String> wars, List<String> jars) {
        super(wars, jars);
    }

    @Override
    protected void checkArguments() {
        super.checkArguments();
        if (Validator.isNull((String)this.portletTaglibDTD)) {
            throw new IllegalArgumentException("The system property deployer.portlet.taglib.dtd is not set");
        }
    }

    @Override
    protected void copyXmls(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        super.copyXmls(srcFile, displayName, pluginPackage);
        if (this.appServerType.equals("tomcat")) {
            this.copyDependencyXml("context.xml", srcFile + "/META-INF");
        }
    }

    @Override
    protected String getExtraContent(double webXmlVersion, File srcFile, String displayName) throws Exception {
        StringBuilder sb = new StringBuilder();
        String extraContent = super.getExtraContent(webXmlVersion, srcFile, displayName);
        sb.append(extraContent);
        if (ServerDetector.isWebSphere()) {
            sb.append("<context-param>");
            sb.append("<param-name>");
            sb.append("com.ibm.websphere.portletcontainer.");
            sb.append("PortletDeploymentEnabled");
            sb.append("</param-name>");
            sb.append("<param-value>false</param-value>");
            sb.append("</context-param>");
        }
        File facesXML = new File(srcFile + "/WEB-INF/faces-config.xml");
        File portletXML = new File(srcFile + "/WEB-INF/" + "portlet.xml");
        File webXML = new File(srcFile + "/WEB-INF/web.xml");
        this.updatePortletXML(portletXML);
        sb.append(this.getServletContent(portletXML, webXML));
        this.setupJSF(facesXML, portletXML);
        if (this._sunFacesPortlet) {
            sb.append("<listener>");
            sb.append("<listener-class>");
            sb.append("com.liferay.util.bridges.jsf.sun.");
            sb.append("LiferayConfigureListener");
            sb.append("</listener-class>");
            sb.append("</listener>");
        }
        sb.append("<listener>");
        sb.append("<listener-class>");
        sb.append("com.liferay.portal.kernel.servlet.PortletContextListener");
        sb.append("</listener-class>");
        sb.append("</listener>");
        sb.append(this.getSpeedFiltersContent(srcFile));
        return sb.toString();
    }

    protected String getServletContent(File portletXML, File webXML) throws Exception {
        StringBuilder sb = new StringBuilder();
        Document doc = SAXReaderUtil.read((File)portletXML);
        Element root = doc.getRootElement();
        for (Element portlet : root.elements("portlet")) {
            String portletName = PortalUtil.getJsSafePortletId((String)portlet.elementText("portlet-name"));
            String portletClass = portlet.elementText("portlet-class");
            sb.append("<servlet>");
            sb.append("<servlet-name>");
            sb.append(portletName);
            sb.append("</servlet-name>");
            sb.append("<servlet-class>");
            sb.append("com.liferay.portal.kernel.servlet.PortletServlet");
            sb.append("</servlet-class>");
            sb.append("<init-param>");
            sb.append("<param-name>portlet-class</param-name>");
            sb.append("<param-value>");
            sb.append(portletClass);
            sb.append("</param-value>");
            sb.append("</init-param>");
            sb.append("<load-on-startup>0</load-on-startup>");
            sb.append("</servlet>");
            sb.append("<servlet-mapping>");
            sb.append("<servlet-name>");
            sb.append(portletName);
            sb.append("</servlet-name>");
            sb.append("<url-pattern>/");
            sb.append(portletName);
            sb.append("/*</url-pattern>");
            sb.append("</servlet-mapping>");
        }
        doc = SAXReaderUtil.read((File)webXML);
        root = doc.getRootElement();
        for (Element servlet : root.elements("servlet")) {
            String paramValue;
            String paramName;
            String icon = servlet.elementText("icon");
            String servletName = servlet.elementText("servlet-name");
            String displayName = servlet.elementText("display-name");
            String description = servlet.elementText("description");
            String servletClass = servlet.elementText("servlet-class");
            List initParams = servlet.elements("init-param");
            String loadOnStartup = servlet.elementText("load-on-startup");
            String runAs = servlet.elementText("run-as");
            List securityRoleRefs = servlet.elements("security-role-ref");
            if (servletClass == null || !servletClass.equals("com.liferay.portal.servlet.SharedServletWrapper")) continue;
            sb.append("<servlet>");
            if (icon != null) {
                sb.append("<icon>");
                sb.append(icon);
                sb.append("</icon>");
            }
            if (servletName != null) {
                sb.append("<servlet-name>");
                sb.append(servletName);
                sb.append("</servlet-name>");
            }
            if (displayName != null) {
                sb.append("<display-name>");
                sb.append(displayName);
                sb.append("</display-name>");
            }
            if (description != null) {
                sb.append("<description>");
                sb.append(description);
                sb.append("</description>");
            }
            for (Element initParam : initParams) {
                paramName = initParam.elementText("param-name");
                paramValue = initParam.elementText("param-value");
                if (paramName == null || !paramName.equals("servlet-class")) continue;
                sb.append("<servlet-class>");
                sb.append(paramValue);
                sb.append("</servlet-class>");
            }
            for (Element initParam : initParams) {
                paramName = initParam.elementText("param-name");
                paramValue = initParam.elementText("param-value");
                String paramDesc = initParam.elementText("description");
                if (paramName == null || paramName.equals("servlet-class")) continue;
                sb.append("<init-param>");
                sb.append("<param-name>");
                sb.append(paramName);
                sb.append("</param-name>");
                if (paramValue != null) {
                    sb.append("<param-value>");
                    sb.append(paramValue);
                    sb.append("</param-value>");
                }
                if (paramDesc != null) {
                    sb.append("<description>");
                    sb.append(paramDesc);
                    sb.append("</description>");
                }
                sb.append("</init-param>");
            }
            if (loadOnStartup != null) {
                sb.append("<load-on-startup>");
                sb.append(loadOnStartup);
                sb.append("</load-on-startup>");
            }
            if (runAs != null) {
                sb.append("<run-as>");
                sb.append(runAs);
                sb.append("</run-as>");
            }
            for (Element roleRef : securityRoleRefs) {
                String roleDesc = roleRef.elementText("description");
                String roleName = roleRef.elementText("role-name");
                String roleLink = roleRef.elementText("role-link");
                sb.append("<security-role-ref>");
                if (roleDesc != null) {
                    sb.append("<description>");
                    sb.append(roleDesc);
                    sb.append("</description>");
                }
                if (roleName != null) {
                    sb.append("<role-name>");
                    sb.append(roleName);
                    sb.append("</role-name>");
                }
                if (roleLink != null) {
                    sb.append("<role-link>");
                    sb.append(roleLink);
                    sb.append("</role-link>");
                }
                sb.append("</security-role-ref>");
            }
            sb.append("</servlet>");
        }
        return sb.toString();
    }

    @Override
    protected void processPluginPackageProperties(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        if (pluginPackage == null) {
            return;
        }
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties == null || properties.size() == 0) {
            return;
        }
        String moduleGroupId = pluginPackage.getGroupId();
        String moduleArtifactId = pluginPackage.getArtifactId();
        String moduleVersion = pluginPackage.getVersion();
        String pluginName = pluginPackage.getName();
        String pluginType = (String)pluginPackage.getTypes().get(0);
        String pluginTypeName = TextFormatter.format((String)pluginType, (int)9);
        if (!pluginType.equals("portlet")) {
            return;
        }
        String tags = this.getPluginPackageTagsXml(pluginPackage.getTags());
        String shortDescription = pluginPackage.getShortDescription();
        String longDescription = pluginPackage.getLongDescription();
        String changeLog = pluginPackage.getChangeLog();
        String pageURL = pluginPackage.getPageURL();
        String author = pluginPackage.getAuthor();
        String licenses = this.getPluginPackageLicensesXml(pluginPackage.getLicenses());
        String liferayVersions = this.getPluginPackageLiferayVersionsXml(pluginPackage.getLiferayVersions());
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("module_group_id", moduleGroupId);
        filterMap.put("module_artifact_id", moduleArtifactId);
        filterMap.put("module_version", moduleVersion);
        filterMap.put("plugin_name", pluginName);
        filterMap.put("plugin_type", pluginType);
        filterMap.put("plugin_type_name", pluginTypeName);
        filterMap.put("tags", tags);
        filterMap.put("short_description", shortDescription);
        filterMap.put("long_description", longDescription);
        filterMap.put("change_log", changeLog);
        filterMap.put("page_url", pageURL);
        filterMap.put("author", author);
        filterMap.put("licenses", licenses);
        filterMap.put("liferay_versions", liferayVersions);
        this.copyDependencyXml("liferay-plugin-package.xml", srcFile + "/WEB-INF", filterMap, true);
    }

    protected void setupJSF(File facesXML, File portletXML) throws Exception {
        this._myFacesPortlet = false;
        this._sunFacesPortlet = false;
        if (!facesXML.exists()) {
            return;
        }
        Document doc = SAXReaderUtil.read((File)portletXML, (boolean)true);
        Element root = doc.getRootElement();
        List elements = root.elements("portlet");
        for (Element portlet : elements) {
            String portletClass = portlet.elementText("portlet-class");
            if (portletClass.equals(JSF_MYFACES)) {
                this._myFacesPortlet = true;
                break;
            }
            if (!portletClass.equals(JSF_SUN)) continue;
            this._sunFacesPortlet = true;
            break;
        }
        doc = SAXReaderUtil.read((File)facesXML, (boolean)true);
        root = doc.getRootElement();
        Element factoryEl = root.element("factory");
        Element renderKitFactoryEl = null;
        Element facesContextFactoryEl = null;
        if (factoryEl == null) {
            factoryEl = root.addElement("factory");
        }
        renderKitFactoryEl = factoryEl.element("render-kit-factory");
        facesContextFactoryEl = factoryEl.element("faces-context-factory");
        if (this.appServerType.equals("orion") && this._sunFacesPortlet && renderKitFactoryEl == null) {
            renderKitFactoryEl = factoryEl.addElement("render-kit-factory");
            renderKitFactoryEl.addText(LIFERAY_RENDER_KIT_FACTORY);
        } else if (this._myFacesPortlet && facesContextFactoryEl == null) {
            facesContextFactoryEl = factoryEl.addElement("faces-context-factory");
            facesContextFactoryEl.addText(MYFACES_CONTEXT_FACTORY);
        }
        if (!this.appServerType.equals("orion") && this._sunFacesPortlet) {
            factoryEl.detach();
        }
        XMLMerger merger = new XMLMerger((XMLDescriptor)new FacesXMLDescriptor());
        DocumentImpl docImpl = (DocumentImpl)doc;
        merger.organizeXML(docImpl.getWrappedDocument());
        FileUtil.write((File)facesXML, (String)doc.formattedString(), (boolean)true);
    }

    @Override
    protected void updateDeployDirectory(File srcFile) throws Exception {
        File portletXML;
        block5: {
            try {
                if (!PrefsPropsUtil.getBoolean("auto.deploy.custom.portlet.xml", PropsValues.AUTO_DEPLOY_CUSTOM_PORTLET_XML)) {
                    return;
                }
            }
            catch (Exception e) {
                if (PropsValues.AUTO_DEPLOY_CUSTOM_PORTLET_XML) break block5;
                return;
            }
        }
        if ((portletXML = new File(srcFile + "/WEB-INF/" + "portlet.xml")).exists()) {
            File portletCustomXML = new File(srcFile + "/WEB-INF/" + "portlet-custom.xml");
            if (portletCustomXML.exists()) {
                portletCustomXML.delete();
            }
            portletXML.renameTo(portletCustomXML);
        }
    }

    protected void updatePortletXML(File portletXML) throws Exception {
        if (!portletXML.exists()) {
            return;
        }
        String content = FileUtil.read((File)portletXML);
        content = StringUtil.replace((String)content, (String)"com.liferay.util.bridges.jsp.JSPPortlet", (String)MVCPortlet.class.getName());
        FileUtil.write((File)portletXML, (String)content);
    }
}

