/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.jspc.resin;

import com.liferay.portal.kernel.util.MethodInvoker;
import com.liferay.portal.kernel.util.MethodWrapper;
import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.portal.util.FileImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchJspCompiler {
    private static FileImpl _fileUtil = FileImpl.getInstance();
    private String _appDir;
    private String _classDir;

    public static void main(String[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException();
        }
        new BatchJspCompiler(args[0], args[1]);
    }

    public BatchJspCompiler(String appDir, String classDir) {
        try {
            this._appDir = appDir;
            this._classDir = classDir;
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(appDir);
            ds.setIncludes(new String[]{"**\\*.jsp"});
            ds.scan();
            Object[] files = ds.getIncludedFiles();
            Arrays.sort(files);
            ArrayList<String> fileNames = new ArrayList<String>();
            for (int i = 0; i < files.length; ++i) {
                Object fileName = files[i];
                fileNames.add((String)fileName);
                if ((i <= 0 || i % 200 != 0) && i + 1 != files.length) continue;
                this._compile(fileNames);
                fileNames.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _compile(List<String> fileNames) throws Exception {
        if (fileNames.size() == 0) {
            return;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("-app-dir");
        args.add(this._appDir);
        args.add("-class-dir");
        args.add(this._classDir);
        args.addAll(fileNames);
        MethodWrapper methodWrapper = new MethodWrapper("com.caucho.jsp.JspCompiler", "main", new Object[]{args.toArray(new String[args.size()])});
        try {
            MethodInvoker.invoke((MethodWrapper)methodWrapper);
        }
        catch (Exception e) {
            _fileUtil.write(this._appDir + "/../jspc_error", StackTraceUtil.getStackTrace((Throwable)e));
        }
    }
}

