/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.servicebuilder;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.servicebuilder.EntityColumn;
import com.liferay.portal.tools.servicebuilder.EntityFinder;
import com.liferay.portal.tools.servicebuilder.EntityOrder;
import com.liferay.util.TextFormatter;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entity {
    public static final String DEFAULT_DATA_SOURCE = "liferayDataSource";
    public static final String DEFAULT_SESSION_FACTORY = "liferaySessionFactory";
    public static final String DEFAULT_TX_MANAGER = "liferayTransactionManager";
    private String _alias;
    private boolean _cacheEnabled;
    private List<EntityColumn> _collectionList;
    private List<EntityColumn> _columnList;
    private String _dataSource;
    private String _finderClass;
    private List<EntityFinder> _finderList;
    private boolean _localService;
    private String _name;
    private EntityOrder _order;
    private String _packagePath;
    private String _persistenceClass;
    private List<EntityColumn> _pkList;
    private boolean _portalReference;
    private String _portletName;
    private String _portletShortName;
    private List<Entity> _referenceList;
    private List<EntityColumn> _regularColList;
    private boolean _remoteService;
    private String _sessionFactory;
    private String _table;
    private String _txManager;
    private List<String> _txRequiredList;
    private boolean _uuid;

    public static EntityColumn getColumn(String name, List<EntityColumn> columnList) {
        int pos = columnList.indexOf(new EntityColumn(name));
        if (pos != -1) {
            return columnList.get(pos);
        }
        throw new RuntimeException("Column " + name + " not found");
    }

    public static boolean hasColumn(String name, List<EntityColumn> columnList) {
        int pos = columnList.indexOf(new EntityColumn(name));
        return pos != -1;
    }

    public Entity(String name) {
        this(null, null, null, name, null, null, false, false, true, null, null, null, null, null, true, null, null, null, null, null, null, null, null);
    }

    public Entity(String packagePath, String portletName, String portletShortName, String name, String table, String alias, boolean uuid, boolean localService, boolean remoteService, String persistenceClass, String finderClass, String dataSource, String sessionFactory, String txManager, boolean cacheEnabled, List<EntityColumn> pkList, List<EntityColumn> regularColList, List<EntityColumn> collectionList, List<EntityColumn> columnList, EntityOrder order, List<EntityFinder> finderList, List<Entity> referenceList, List<String> txRequiredList) {
        this._packagePath = packagePath;
        this._portletName = portletName;
        this._portletShortName = portletShortName;
        this._name = name;
        this._table = table;
        this._alias = alias;
        this._uuid = uuid;
        this._localService = localService;
        this._remoteService = remoteService;
        this._persistenceClass = persistenceClass;
        this._finderClass = finderClass;
        this._dataSource = GetterUtil.getString((String)dataSource, (String)DEFAULT_DATA_SOURCE);
        this._sessionFactory = GetterUtil.getString((String)sessionFactory, (String)DEFAULT_SESSION_FACTORY);
        this._txManager = GetterUtil.getString((String)txManager, (String)DEFAULT_TX_MANAGER);
        this._cacheEnabled = cacheEnabled;
        this._pkList = pkList;
        this._regularColList = regularColList;
        this._collectionList = collectionList;
        this._columnList = columnList;
        this._order = order;
        this._finderList = finderList;
        this._referenceList = referenceList;
        this._txRequiredList = txRequiredList;
    }

    public boolean equals(Object obj) {
        Entity entity = (Entity)obj;
        String name = entity.getName();
        return this._name.equals(name);
    }

    public String getAlias() {
        return this._alias;
    }

    public List<EntityFinder> getCollectionFinderList() {
        List finderList = ListUtil.copy(this._finderList);
        Iterator itr = finderList.iterator();
        while (itr.hasNext()) {
            EntityFinder finder = (EntityFinder)itr.next();
            if (finder.isCollection()) continue;
            itr.remove();
        }
        return finderList;
    }

    public List<EntityColumn> getCollectionList() {
        return this._collectionList;
    }

    public EntityColumn getColumn(String name) {
        return Entity.getColumn(name, this._columnList);
    }

    public EntityColumn getColumnByMappingTable(String mappingTable) {
        for (int i = 0; i < this._columnList.size(); ++i) {
            EntityColumn col = this._columnList.get(i);
            if (col.getMappingTable() == null || !col.getMappingTable().equals(mappingTable)) continue;
            return col;
        }
        return null;
    }

    public List<EntityColumn> getColumnList() {
        return this._columnList;
    }

    public String getDataSource() {
        return this._dataSource;
    }

    public String getFinderClass() {
        return this._finderClass;
    }

    public List<EntityFinder> getFinderList() {
        return this._finderList;
    }

    public String getName() {
        return this._name;
    }

    public String getNames() {
        return TextFormatter.formatPlural((String)new String(this._name));
    }

    public EntityOrder getOrder() {
        return this._order;
    }

    public String getPackagePath() {
        return this._packagePath;
    }

    public String getPersistenceClass() {
        return this._persistenceClass;
    }

    public String getPKClassName() {
        if (this.hasCompoundPK()) {
            return this._name + "PK";
        }
        EntityColumn col = this._pkList.get(0);
        return col.getType();
    }

    public List<EntityColumn> getPKList() {
        return this._pkList;
    }

    public String getPKVarName() {
        if (this.hasCompoundPK()) {
            return this.getVarName() + "PK";
        }
        EntityColumn col = this._pkList.get(0);
        return col.getName();
    }

    public String getPortletName() {
        return this._portletName;
    }

    public String getPortletShortName() {
        return this._portletShortName;
    }

    public List<Entity> getReferenceList() {
        return this._referenceList;
    }

    public List<EntityColumn> getRegularColList() {
        return this._regularColList;
    }

    public String getSessionFactory() {
        return this._sessionFactory;
    }

    public String getShortName() {
        if (this._name.startsWith(this._portletShortName)) {
            return this._name.substring(this._portletShortName.length());
        }
        return this._name;
    }

    public String getSpringPropertyName() {
        return TextFormatter.format((String)this._name, (int)11);
    }

    public String getTable() {
        return this._table;
    }

    public String getTXManager() {
        return this._txManager;
    }

    public List<String> getTxRequiredList() {
        return this._txRequiredList;
    }

    public List<EntityFinder> getUniqueFinderList() {
        List finderList = ListUtil.copy(this._finderList);
        Iterator itr = finderList.iterator();
        while (itr.hasNext()) {
            EntityFinder finder = (EntityFinder)itr.next();
            if (!finder.isCollection()) continue;
            itr.remove();
        }
        return finderList;
    }

    public String getVarName() {
        return TextFormatter.format((String)this._name, (int)8);
    }

    public String getVarNames() {
        return TextFormatter.formatPlural((String)new String(this.getVarName()));
    }

    public boolean hasColumn(String name) {
        return Entity.hasColumn(name, this._columnList);
    }

    public boolean hasColumns() {
        return this._columnList != null && this._columnList.size() != 0;
    }

    public boolean hasCompoundPK() {
        return this._pkList.size() > 1;
    }

    public boolean hasFinderClass() {
        return !Validator.isNull((String)this._finderClass);
    }

    public boolean hasLocalizedColumn() {
        for (EntityColumn col : this._columnList) {
            if (!col.isLocalized()) continue;
            return true;
        }
        return false;
    }

    public boolean hasLocalService() {
        return this._localService;
    }

    public boolean hasPrimitivePK() {
        if (this.hasCompoundPK()) {
            return false;
        }
        EntityColumn col = this._pkList.get(0);
        return col.isPrimitiveType();
    }

    public boolean hasRemoteService() {
        return this._remoteService;
    }

    public boolean hasUuid() {
        return this._uuid;
    }

    public boolean isCacheEnabled() {
        return this._cacheEnabled;
    }

    public boolean isDefaultDataSource() {
        return this._dataSource.equals(DEFAULT_DATA_SOURCE);
    }

    public boolean isDefaultSessionFactory() {
        return this._sessionFactory.equals(DEFAULT_SESSION_FACTORY);
    }

    public boolean isDefaultTXManager() {
        return this._txManager.equals(DEFAULT_TX_MANAGER);
    }

    public boolean isHierarchicalTree() {
        if (!this.hasPrimitivePK()) {
            return false;
        }
        EntityColumn col = this._pkList.get(0);
        return this._columnList.indexOf(new EntityColumn("parent" + col.getMethodName())) != -1 && this._columnList.indexOf(new EntityColumn("left" + col.getMethodName())) != -1 && this._columnList.indexOf(new EntityColumn("right" + col.getMethodName())) != -1;
    }

    public boolean isOrdered() {
        return this._order != null;
    }

    public boolean isPortalReference() {
        return this._portalReference;
    }

    public void setPortalReference(boolean portalReference) {
        this._portalReference = portalReference;
    }
}

