/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.servicebuilder;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.TextFormatter;

public class EntityColumn
implements Cloneable {
    private boolean _caseSensitive;
    private String _comparator;
    private boolean _convertNull;
    private String _dbName;
    private String _ejbName;
    private boolean _fetchFinderPath;
    private String _idParam;
    private String _idType;
    private boolean _localized;
    private String _mappingKey;
    private String _mappingTable;
    private String _methodName;
    private String _name;
    private boolean _orderByAscending;
    private boolean _primary;
    private String _type;

    public EntityColumn(String name) {
        this(name, null, null, false, null, null, null, true, true, null, null, null, true, false);
    }

    public EntityColumn(String name, String dbName, String type, boolean primary, String ejbName, String mappingKey, String mappingTable, boolean caseSensitive, boolean orderByAscending, String comparator, String idType, String idParam, boolean convertNull, boolean localized) {
        this._name = name;
        this._dbName = dbName;
        this._type = type;
        this._primary = primary;
        this._methodName = TextFormatter.format((String)name, (int)6);
        this._ejbName = ejbName;
        this._mappingKey = mappingKey;
        this._mappingTable = mappingTable;
        this._caseSensitive = caseSensitive;
        this._orderByAscending = orderByAscending;
        this._comparator = comparator;
        this._idType = idType;
        this._idParam = idParam;
        this._convertNull = convertNull;
        this._localized = localized;
    }

    public EntityColumn(String name, String dbName, String type, boolean primary, String ejbName, String mappingKey, String mappingTable, String idType, String idParam, boolean convertNull, boolean localized) {
        this(name, dbName, type, primary, ejbName, mappingKey, mappingTable, true, true, null, idType, idParam, convertNull, localized);
    }

    public Object clone() {
        return new EntityColumn(this.getName(), this.getDBName(), this.getType(), this.isPrimary(), this.getEJBName(), this.getMappingKey(), this.getMappingTable(), this.isCaseSensitive(), this.isOrderByAscending(), this.getComparator(), this.getIdType(), this.getIdParam(), this.isConvertNull(), this.isLocalized());
    }

    public boolean equals(Object obj) {
        EntityColumn col = (EntityColumn)obj;
        String name = col.getName();
        return this._name.equals(name);
    }

    public String getComparator() {
        return this._comparator;
    }

    public String getDBName() {
        return this._dbName;
    }

    public String getEJBName() {
        return this._ejbName;
    }

    public String getIdParam() {
        return this._idParam;
    }

    public String getIdType() {
        return this._idType;
    }

    public String getMappingKey() {
        return this._mappingKey;
    }

    public String getMappingTable() {
        return this._mappingTable;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public String getMethodNames() {
        return TextFormatter.formatPlural((String)new String(this._methodName));
    }

    public String getMethodUserUuidName() {
        return this._methodName.substring(0, this._methodName.length() - 2) + "Uuid";
    }

    public String getName() {
        return this._name;
    }

    public String getNames() {
        return TextFormatter.formatPlural((String)new String(this._name));
    }

    public String getType() {
        return this._type;
    }

    public String getUserUuidName() {
        return this._name.substring(0, this._name.length() - 2) + "Uuid";
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public boolean isCollection() {
        return this._type.equals("Collection");
    }

    public boolean isConvertNull() {
        return this._convertNull;
    }

    public boolean isFetchFinderPath() {
        return this._fetchFinderPath;
    }

    public boolean isLocalized() {
        return this._localized;
    }

    public boolean isMappingManyToMany() {
        return Validator.isNotNull((String)this._mappingTable);
    }

    public boolean isMappingOneToMany() {
        return Validator.isNotNull((String)this._mappingKey);
    }

    public boolean isOrderByAscending() {
        return this._orderByAscending;
    }

    public boolean isPrimary() {
        return this._primary;
    }

    public boolean isPrimitiveType() {
        return Character.isLowerCase(this._type.charAt(0));
    }

    public boolean isUserUuid() {
        return this._type.equals("long") && this._methodName.endsWith("UserId");
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }

    public void setComparator(String comparator) {
        this._comparator = comparator;
    }

    public void setConvertNull(boolean convertNull) {
        this._convertNull = convertNull;
    }

    public void setDBName(String dbName) {
        this._dbName = dbName;
    }

    public void setFetchFinderPath(boolean fetchFinderPath) {
        this._fetchFinderPath = fetchFinderPath;
    }

    public void setIdParam(String idParam) {
        this._idParam = idParam;
    }

    public void setIdType(String idType) {
        this._idType = idType;
    }

    public void setLocalized(boolean localized) {
        this._localized = localized;
    }

    public void setOrderByAscending(boolean orderByAscending) {
        this._orderByAscending = orderByAscending;
    }
}

