/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.servicebuilder;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.freemarker.FreeMarkerUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ArrayUtil_IW;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.StringUtil_IW;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.tools.SourceFormatter;
import com.liferay.portal.tools.servicebuilder.Entity;
import com.liferay.portal.tools.servicebuilder.EntityColumn;
import com.liferay.portal.tools.servicebuilder.EntityFinder;
import com.liferay.portal.tools.servicebuilder.EntityMapping;
import com.liferay.portal.tools.servicebuilder.EntityOrder;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.TextFormatter;
import com.liferay.util.xml.XMLFormatter;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import de.hunsicker.io.FileFormat;
import de.hunsicker.jalopy.Jalopy;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Environment;
import freemarker.ext.beans.BeansWrapper;
import freemarker.log.Logger;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBuilder {
    public static final String AUTHOR = "Brian Wing Shun Chan";
    private static final int _SESSION_TYPE_REMOTE = 0;
    private static final int _SESSION_TYPE_LOCAL = 1;
    private static final String _SQL_CREATE_TABLE = "create table ";
    private static final String _TPL_ROOT = "com/liferay/portal/tools/servicebuilder/dependencies/";
    private String _tplBadAliasNames = "com/liferay/portal/tools/servicebuilder/dependencies/bad_alias_names.txt";
    private String _tplBadColumnNames = "com/liferay/portal/tools/servicebuilder/dependencies/bad_column_names.txt";
    private String _tplBadJsonTypes = "com/liferay/portal/tools/servicebuilder/dependencies/bad_json_types.txt";
    private String _tplBadTableNames = "com/liferay/portal/tools/servicebuilder/dependencies/bad_table_names.txt";
    private String _tplEjbPk = "com/liferay/portal/tools/servicebuilder/dependencies/ejb_pk.ftl";
    private String _tplException = "com/liferay/portal/tools/servicebuilder/dependencies/exception.ftl";
    private String _tplExtendedModel = "com/liferay/portal/tools/servicebuilder/dependencies/extended_model.ftl";
    private String _tplExtendedModelImpl = "com/liferay/portal/tools/servicebuilder/dependencies/extended_model_impl.ftl";
    private String _tplFinder = "com/liferay/portal/tools/servicebuilder/dependencies/finder.ftl";
    private String _tplFinderUtil = "com/liferay/portal/tools/servicebuilder/dependencies/finder_util.ftl";
    private String _tplHbmXml = "com/liferay/portal/tools/servicebuilder/dependencies/hbm_xml.ftl";
    private String _tplJsonJs = "com/liferay/portal/tools/servicebuilder/dependencies/json_js.ftl";
    private String _tplJsonJsMethod = "com/liferay/portal/tools/servicebuilder/dependencies/json_js_method.ftl";
    private String _tplModel = "com/liferay/portal/tools/servicebuilder/dependencies/model.ftl";
    private String _tplModelClp = "com/liferay/portal/tools/servicebuilder/dependencies/model_clp.ftl";
    private String _tplModelHintsXml = "com/liferay/portal/tools/servicebuilder/dependencies/model_hints_xml.ftl";
    private String _tplModelImpl = "com/liferay/portal/tools/servicebuilder/dependencies/model_impl.ftl";
    private String _tplModelSoap = "com/liferay/portal/tools/servicebuilder/dependencies/model_soap.ftl";
    private String _tplModelWrapper = "com/liferay/portal/tools/servicebuilder/dependencies/model_wrapper.ftl";
    private String _tplPersistence = "com/liferay/portal/tools/servicebuilder/dependencies/persistence.ftl";
    private String _tplPersistenceImpl = "com/liferay/portal/tools/servicebuilder/dependencies/persistence_impl.ftl";
    private String _tplPersistenceTest = "com/liferay/portal/tools/servicebuilder/dependencies/persistence_test.ftl";
    private String _tplPersistenceUtil = "com/liferay/portal/tools/servicebuilder/dependencies/persistence_util.ftl";
    private String _tplProps = "com/liferay/portal/tools/servicebuilder/dependencies/props.ftl";
    private String _tplRemotingXml = "com/liferay/portal/tools/servicebuilder/dependencies/remoting_xml.ftl";
    private String _tplService = "com/liferay/portal/tools/servicebuilder/dependencies/service.ftl";
    private String _tplServiceBaseImpl = "com/liferay/portal/tools/servicebuilder/dependencies/service_base_impl.ftl";
    private String _tplServiceClp = "com/liferay/portal/tools/servicebuilder/dependencies/service_clp.ftl";
    private String _tplServiceClpMessageListener = "com/liferay/portal/tools/servicebuilder/dependencies/service_clp_message_listener.ftl";
    private String _tplServiceClpSerializer = "com/liferay/portal/tools/servicebuilder/dependencies/service_clp_serializer.ftl";
    private String _tplServiceHttp = "com/liferay/portal/tools/servicebuilder/dependencies/service_http.ftl";
    private String _tplServiceImpl = "com/liferay/portal/tools/servicebuilder/dependencies/service_impl.ftl";
    private String _tplServiceJsonSerializer = "com/liferay/portal/tools/servicebuilder/dependencies/service_json_serializer.ftl";
    private String _tplServiceSoap = "com/liferay/portal/tools/servicebuilder/dependencies/service_soap.ftl";
    private String _tplServiceUtil = "com/liferay/portal/tools/servicebuilder/dependencies/service_util.ftl";
    private String _tplServiceWrapper = "com/liferay/portal/tools/servicebuilder/dependencies/service_wrapper.ftl";
    private String _tplSpringBaseXml = "com/liferay/portal/tools/servicebuilder/dependencies/spring_base_xml.ftl";
    private String _tplSpringDynamicDataSourceXml = "com/liferay/portal/tools/servicebuilder/dependencies/spring_dynamic_data_source_xml.ftl";
    private String _tplSpringHibernateXml = "com/liferay/portal/tools/servicebuilder/dependencies/spring_hibernate_xml.ftl";
    private String _tplSpringInfrastructureXml = "com/liferay/portal/tools/servicebuilder/dependencies/spring_infrastructure_xml.ftl";
    private String _tplSpringXml = "com/liferay/portal/tools/servicebuilder/dependencies/spring_xml.ftl";
    private Set<String> _badTableNames;
    private Set<String> _badAliasNames;
    private Set<String> _badColumnNames;
    private Set<String> _badJsonTypes;
    private String _hbmFileName;
    private String _modelHintsFileName;
    private String _springFileName;
    private String _springBaseFileName;
    private String _springDynamicDataSourceFileName;
    private String _springHibernateFileName;
    private String _springInfrastructureFileName;
    private String _apiDir;
    private String _implDir;
    private String _jsonFileName;
    private String _remotingFileName;
    private String _sqlDir;
    private String _sqlFileName;
    private String _sqlIndexesFileName;
    private String _sqlIndexesPropertiesFileName;
    private String _sqlSequencesFileName;
    private boolean _autoNamespaceTables;
    private String _beanLocatorUtil;
    private String _beanLocatorUtilShortName;
    private String _propsUtil;
    private String _pluginName;
    private String _testDir;
    private String _author;
    private String _portletName = "";
    private String _portletShortName = "";
    private String _portletPackageName = "";
    private String _outputPath;
    private String _serviceOutputPath;
    private String _testOutputPath;
    private String _packagePath;
    private List<Entity> _ejbList;
    private Map<String, EntityMapping> _entityMappings;
    private Map<String, Entity> _entityPool = new HashMap<String, Entity>();

    public static void main(String[] args) {
        InitUtil.initWithSpring();
        ServiceBuilder serviceBuilder = null;
        if (args.length == 7) {
            String fileName = args[0];
            String hbmFileName = args[1];
            String modelHintsFileName = args[2];
            String springFileName = args[3];
            String springBaseFileName = "";
            String springDynamicDataSourceFileName = "";
            String springHibernateFileName = "";
            String springInfrastructureFileName = "";
            String apiDir = args[5];
            String implDir = "src";
            String jsonFileName = args[6];
            String remotingFileName = "../tunnel-web/docroot/WEB-INF/remoting-servlet.xml";
            String sqlDir = "../sql";
            String sqlFileName = "portal-tables.sql";
            String sqlIndexesFileName = "indexes.sql";
            String sqlIndexesPropertiesFileName = "indexes.properties";
            String sqlSequencesFileName = "sequences.sql";
            boolean autoNamespaceTables = false;
            String beanLocatorUtil = "com.liferay.portal.kernel.bean.BeanLocatorUtil";
            String propsUtil = "com.liferay.portal.util.PropsUtil";
            String pluginName = "";
            String testDir = "";
            serviceBuilder = new ServiceBuilder(fileName, hbmFileName, modelHintsFileName, springFileName, springBaseFileName, springDynamicDataSourceFileName, springHibernateFileName, springInfrastructureFileName, apiDir, implDir, jsonFileName, remotingFileName, sqlDir, sqlFileName, sqlIndexesFileName, sqlIndexesPropertiesFileName, sqlSequencesFileName, autoNamespaceTables, beanLocatorUtil, propsUtil, pluginName, testDir);
        } else if (args.length == 0) {
            String fileName = System.getProperty("service.input.file");
            String hbmFileName = System.getProperty("service.hbm.file");
            String modelHintsFileName = System.getProperty("service.model.hints.file");
            String springFileName = System.getProperty("service.spring.file");
            String springBaseFileName = System.getProperty("service.spring.base.file");
            String springDynamicDataSourceFileName = System.getProperty("service.spring.dynamic.data.source.file");
            String springHibernateFileName = System.getProperty("service.spring.hibernate.file");
            String springInfrastructureFileName = System.getProperty("service.spring.infrastructure.file");
            String apiDir = System.getProperty("service.api.dir");
            String implDir = System.getProperty("service.impl.dir");
            String jsonFileName = System.getProperty("service.json.file");
            String remotingFileName = System.getProperty("service.remoting.file");
            String sqlDir = System.getProperty("service.sql.dir");
            String sqlFileName = System.getProperty("service.sql.file");
            String sqlIndexesFileName = System.getProperty("service.sql.indexes.file");
            String sqlIndexesPropertiesFileName = System.getProperty("service.sql.indexes.properties.file");
            String sqlSequencesFileName = System.getProperty("service.sql.sequences.file");
            boolean autoNamespaceTables = GetterUtil.getBoolean((String)System.getProperty("service.auto.namespace.tables"));
            String beanLocatorUtil = System.getProperty("service.bean.locator.util");
            String propsUtil = System.getProperty("service.props.util");
            String pluginName = System.getProperty("service.plugin.name");
            String testDir = System.getProperty("service.test.dir");
            serviceBuilder = new ServiceBuilder(fileName, hbmFileName, modelHintsFileName, springFileName, springBaseFileName, springDynamicDataSourceFileName, springHibernateFileName, springInfrastructureFileName, apiDir, implDir, jsonFileName, remotingFileName, sqlDir, sqlFileName, sqlIndexesFileName, sqlIndexesPropertiesFileName, sqlSequencesFileName, autoNamespaceTables, beanLocatorUtil, propsUtil, pluginName, testDir);
        }
        if (serviceBuilder == null) {
            System.out.println("Please set these required system properties. Sample values are:\n\n\t-Dservice.input.file=${service.file}\n\t-Dservice.hbm.file=src/META-INF/portal-hbm.xml\n\t-Dservice.model.hints.file=src/META-INF/portal-model-hints.xml\n\t-Dservice.spring.file=src/META-INF/portal-spring.xml\n\t-Dservice.api.dir=${project.dir}/portal-service/src\n\t-Dservice.impl.dir=src\n\t-Dservice.json.file=${project.dir}/portal-web/docroot/html/js/liferay/service_unpacked.js\n\t-Dservice.remoting.file=${project.dir}/tunnel-web/docroot/WEB-INF/remoting-servlet.xml\n\t-Dservice.sql.dir=../sql\n\t-Dservice.sql.file=portal-tables.sql\n\t-Dservice.sql.indexes.file=indexes.sql\n\t-Dservice.sql.indexes.properties.file=indexes.properties\n\t-Dservice.sql.sequences.file=sequences.sql\n\t-Dservice.bean.locator.util.package=com.liferay.portal.kernel.bean\n\t-Dservice.props.util.package=com.liferay.portal.util\n\nYou can also customize the generated code by overriding the default templates with these optional properties:\n\n\t-Dservice.tpl.bad_alias_names=com/liferay/portal/tools/servicebuilder/dependencies/bad_alias_names.txt\n\t-Dservice.tpl.bad_column_names=com/liferay/portal/tools/servicebuilder/dependencies/bad_column_names.txt\n\t-Dservice.tpl.bad_json_types=com/liferay/portal/tools/servicebuilder/dependencies/bad_json_types.txt\n\t-Dservice.tpl.bad_table_names=com/liferay/portal/tools/servicebuilder/dependencies/bad_table_names.txt\n\t-Dservice.tpl.base_mode_impl=com/liferay/portal/tools/servicebuilder/dependencies/base_mode_impl.ftl\n\t-Dservice.tpl.copyright.txt=copyright.txt\n\t-Dservice.tpl.ejb_pk=com/liferay/portal/tools/servicebuilder/dependencies/ejb_pk.ftl\n\t-Dservice.tpl.exception=com/liferay/portal/tools/servicebuilder/dependencies/exception.ftl\n\t-Dservice.tpl.extended_model=com/liferay/portal/tools/servicebuilder/dependencies/extended_model.ftl\n\t-Dservice.tpl.extended_model_impl=com/liferay/portal/tools/servicebuilder/dependencies/extended_model_impl.ftl\n\t-Dservice.tpl.finder=com/liferay/portal/tools/servicebuilder/dependencies/finder.ftl\n\t-Dservice.tpl.finder_util=com/liferay/portal/tools/servicebuilder/dependencies/finder_util.ftl\n\t-Dservice.tpl.hbm_xml=com/liferay/portal/tools/servicebuilder/dependencies/hbm_xml.ftl\n\t-Dservice.tpl.json_js=com/liferay/portal/tools/servicebuilder/dependencies/json_js.ftl\n\t-Dservice.tpl.json_js_method=com/liferay/portal/tools/servicebuilder/dependencies/json_js_method.ftl\n\t-Dservice.tpl.model=com/liferay/portal/tools/servicebuilder/dependencies/model.ftl\n\t-Dservice.tpl.model_hints_xml=com/liferay/portal/tools/servicebuilder/dependencies/model_hints_xml.ftl\n\t-Dservice.tpl.model_impl=com/liferay/portal/tools/servicebuilder/dependencies/model_impl.ftl\n\t-Dservice.tpl.model_soap=com/liferay/portal/tools/servicebuilder/dependencies/model_soap.ftl\n\t-Dservice.tpl.model_wrapper=com/liferay/portal/tools/servicebuilder/dependencies/model_wrapper.ftl\n\t-Dservice.tpl.persistence=com/liferay/portal/tools/servicebuilder/dependencies/persistence.ftl\n\t-Dservice.tpl.persistence_impl=com/liferay/portal/tools/servicebuilder/dependencies/persistence_impl.ftl\n\t-Dservice.tpl.persistence_util=com/liferay/portal/tools/servicebuilder/dependencies/persistence_util.ftl\n\t-Dservice.tpl.props=com/liferay/portal/tools/servicebuilder/dependencies/props.ftl\n\t-Dservice.tpl.remoting_xml=com/liferay/portal/tools/servicebuilder/dependencies/remoting_xml.ftl\n\t-Dservice.tpl.service=com/liferay/portal/tools/servicebuilder/dependencies/service.ftl\n\t-Dservice.tpl.service_base_impl=com/liferay/portal/tools/servicebuilder/dependencies/service_base_impl.ftl\n\t-Dservice.tpl.service_clp=com/liferay/portal/tools/servicebuilder/dependencies/service_clp.ftl\n\t-Dservice.tpl.service_clp_message_listener=com/liferay/portal/tools/servicebuilder/dependencies/service_clp_message_listener.ftl\n\t-Dservice.tpl.service_clp_serializer=com/liferay/portal/tools/servicebuilder/dependencies/service_clp_serializer.ftl\n\t-Dservice.tpl.service_http=com/liferay/portal/tools/servicebuilder/dependencies/service_http.ftl\n\t-Dservice.tpl.service_impl=com/liferay/portal/tools/servicebuilder/dependencies/service_impl.ftl\n\t-Dservice.tpl.service_json_serializer=com/liferay/portal/tools/servicebuilder/dependencies/service_json_serializer.ftl\n\t-Dservice.tpl.service_soap=com/liferay/portal/tools/servicebuilder/dependencies/service_soap.ftl\n\t-Dservice.tpl.service_util=com/liferay/portal/tools/servicebuilder/dependencies/service_util.ftl\n\t-Dservice.tpl.service_wrapper=com/liferay/portal/tools/servicebuilder/dependencies/service_wrapper.ftl\n\t-Dservice.tpl.spring_base_xml=com/liferay/portal/tools/servicebuilder/dependencies/spring_base_xml.ftl\n\t-Dservice.tpl.spring_dynamic_data_source_xml=com/liferay/portal/tools/servicebuilder/dependencies/spring_dynamic_data_source_xml.ftl\n\t-Dservice.tpl.spring_hibernate_xml=com/liferay/portal/tools/servicebuilder/dependencies/spring_hibernate_xml.ftl\n\t-Dservice.tpl.spring_infrastructure_xml=com/liferay/portal/tools/servicebuilder/dependencies/spring_infrastructure_xml.ftl\n\t-Dservice.tpl.spring_xml=com/liferay/portal/tools/servicebuilder/dependencies/spring_xml.ftl\n\t-Dservice.tpl.spring_xml_session=com/liferay/portal/tools/servicebuilder/dependencies/spring_xml_session.ftl");
        }
    }

    public static void writeFile(File file, String content) throws IOException {
        ServiceBuilder.writeFile(file, content, AUTHOR);
    }

    public static void writeFile(File file, String content, String author) throws IOException {
        ServiceBuilder.writeFile(file, content, author, null);
    }

    public static void writeFile(File file, String content, String author, Map<String, Object> jalopySettings) throws IOException {
        String packagePath = ServiceBuilder._getPackagePath(file);
        String className = file.getName();
        className = className.substring(0, className.length() - 5);
        content = SourceFormatter.stripImports(content, packagePath, className);
        File tempFile = new File("ServiceBuilder.temp");
        FileUtil.write((File)tempFile, (String)content);
        StringBuffer sb = new StringBuffer();
        Jalopy jalopy = new Jalopy();
        jalopy.setFileFormat(FileFormat.UNIX);
        jalopy.setInput(tempFile);
        jalopy.setOutput(sb);
        try {
            Jalopy.setConvention((String)"../tools/jalopy.xml");
        }
        catch (FileNotFoundException fnne) {
            // empty catch block
        }
        try {
            Jalopy.setConvention((String)"../../misc/jalopy.xml");
        }
        catch (FileNotFoundException fnne) {
            // empty catch block
        }
        if (jalopySettings == null) {
            jalopySettings = new HashMap<String, Object>();
        }
        Environment env = Environment.getInstance();
        author = GetterUtil.getString((String)((String)jalopySettings.get("author")), (String)author);
        env.set("author", (Object)author);
        env.set("fileName", (Object)file.getName());
        Convention convention = Convention.getInstance();
        String classMask = "/**\n";
        String viewSourceHREF = " * <a href=\"" + file.getName() + ".html\"><b><i>View Source</i></b></a>";
        if (viewSourceHREF.length() > 80) {
            int x = viewSourceHREF.lastIndexOf("<", 80);
            int y = viewSourceHREF.lastIndexOf(" ", 80);
            int start = x;
            int end = x;
            if (x < y) {
                start = y;
                end = y + 1;
            }
            viewSourceHREF = viewSourceHREF.substring(0, start) + "\n * " + viewSourceHREF.substring(end);
        }
        classMask = classMask + viewSourceHREF + "\n";
        classMask = classMask + " *\n * @author $author$\n*/";
        convention.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CLASS, env.interpolate(classMask));
        convention.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_INTERFACE, env.interpolate(classMask));
        jalopy.format();
        String newContent = sb.toString();
        String oldContent = null;
        if (file.exists()) {
            oldContent = FileUtil.read((File)file);
        }
        if (oldContent == null || !oldContent.equals(newContent)) {
            FileUtil.write((File)file, (String)newContent);
            System.out.println("Writing " + file);
        }
        tempFile.deleteOnExit();
    }

    public ServiceBuilder(String fileName, String hbmFileName, String modelHintsFileName, String springFileName, String springBaseFileName, String springDynamicDataSourceFileName, String springHibernateFileName, String springInfrastructureFileName, String apiDir, String implDir, String jsonFileName, String remotingFileName, String sqlDir, String sqlFileName, String sqlIndexesFileName, String sqlIndexesPropertiesFileName, String sqlSequencesFileName, boolean autoNamespaceTables, String beanLocatorUtil, String propsUtil, String pluginName, String testDir) {
        new ServiceBuilder(fileName, hbmFileName, modelHintsFileName, springFileName, springBaseFileName, springDynamicDataSourceFileName, springHibernateFileName, springInfrastructureFileName, apiDir, implDir, jsonFileName, remotingFileName, sqlDir, sqlFileName, sqlIndexesFileName, sqlIndexesPropertiesFileName, sqlSequencesFileName, autoNamespaceTables, beanLocatorUtil, propsUtil, pluginName, testDir, true);
    }

    public ServiceBuilder(String fileName, String hbmFileName, String modelHintsFileName, String springFileName, String springBaseFileName, String springDynamicDataSourceFileName, String springHibernateFileName, String springInfrastructureFileName, String apiDir, String implDir, String jsonFileName, String remotingFileName, String sqlDir, String sqlFileName, String sqlIndexesFileName, String sqlIndexesPropertiesFileName, String sqlSequencesFileName, boolean autoNamespaceTables, String beanLocatorUtil, String propsUtil, String pluginName, String testDir, boolean build) {
        this._tplBadAliasNames = this._getTplProperty("bad_alias_names", this._tplBadAliasNames);
        this._tplBadColumnNames = this._getTplProperty("bad_column_names", this._tplBadColumnNames);
        this._tplBadJsonTypes = this._getTplProperty("bad_json_types", this._tplBadJsonTypes);
        this._tplBadTableNames = this._getTplProperty("bad_table_names", this._tplBadTableNames);
        this._tplEjbPk = this._getTplProperty("ejb_pk", this._tplEjbPk);
        this._tplException = this._getTplProperty("exception", this._tplException);
        this._tplExtendedModel = this._getTplProperty("extended_model", this._tplExtendedModel);
        this._tplExtendedModelImpl = this._getTplProperty("extended_model_impl", this._tplExtendedModelImpl);
        this._tplFinder = this._getTplProperty("finder", this._tplFinder);
        this._tplFinderUtil = this._getTplProperty("finder_util", this._tplFinderUtil);
        this._tplHbmXml = this._getTplProperty("hbm_xml", this._tplHbmXml);
        this._tplJsonJs = this._getTplProperty("json_js", this._tplJsonJs);
        this._tplJsonJsMethod = this._getTplProperty("json_js_method", this._tplJsonJsMethod);
        this._tplModel = this._getTplProperty("model", this._tplModel);
        this._tplModelClp = this._getTplProperty("model", this._tplModelClp);
        this._tplModelHintsXml = this._getTplProperty("model_hints_xml", this._tplModelHintsXml);
        this._tplModelImpl = this._getTplProperty("model_impl", this._tplModelImpl);
        this._tplModelSoap = this._getTplProperty("model_soap", this._tplModelSoap);
        this._tplModelWrapper = this._getTplProperty("model_wrapper", this._tplModelWrapper);
        this._tplPersistence = this._getTplProperty("persistence", this._tplPersistence);
        this._tplPersistenceImpl = this._getTplProperty("persistence_impl", this._tplPersistenceImpl);
        this._tplPersistenceUtil = this._getTplProperty("persistence_util", this._tplPersistenceUtil);
        this._tplProps = this._getTplProperty("props", this._tplProps);
        this._tplRemotingXml = this._getTplProperty("remoting_xml", this._tplRemotingXml);
        this._tplService = this._getTplProperty("service", this._tplService);
        this._tplServiceBaseImpl = this._getTplProperty("service_base_impl", this._tplServiceBaseImpl);
        this._tplServiceClp = this._getTplProperty("service_clp", this._tplServiceClp);
        this._tplServiceClpMessageListener = this._getTplProperty("service_clp_message_listener", this._tplServiceClpMessageListener);
        this._tplServiceClpSerializer = this._getTplProperty("service_clp_serializer", this._tplServiceClpSerializer);
        this._tplServiceHttp = this._getTplProperty("service_http", this._tplServiceHttp);
        this._tplServiceImpl = this._getTplProperty("service_impl", this._tplServiceImpl);
        this._tplServiceJsonSerializer = this._getTplProperty("service_json_serializer", this._tplServiceJsonSerializer);
        this._tplServiceSoap = this._getTplProperty("service_soap", this._tplServiceSoap);
        this._tplServiceUtil = this._getTplProperty("service_util", this._tplServiceUtil);
        this._tplServiceWrapper = this._getTplProperty("service_wrapper", this._tplServiceWrapper);
        this._tplSpringBaseXml = this._getTplProperty("spring_base_xml", this._tplSpringBaseXml);
        this._tplSpringDynamicDataSourceXml = this._getTplProperty("spring_dynamic_data_source_xml", this._tplSpringDynamicDataSourceXml);
        this._tplSpringHibernateXml = this._getTplProperty("spring_hibernate_xml", this._tplSpringHibernateXml);
        this._tplSpringInfrastructureXml = this._getTplProperty("spring_infrastructure_xml", this._tplSpringInfrastructureXml);
        this._tplSpringXml = this._getTplProperty("spring_xml", this._tplSpringXml);
        try {
            this._badTableNames = SetUtil.fromString((String)StringUtil.read((ClassLoader)this.getClass().getClassLoader(), (String)this._tplBadTableNames));
            this._badAliasNames = SetUtil.fromString((String)StringUtil.read((ClassLoader)this.getClass().getClassLoader(), (String)this._tplBadAliasNames));
            this._badColumnNames = SetUtil.fromString((String)StringUtil.read((ClassLoader)this.getClass().getClassLoader(), (String)this._tplBadColumnNames));
            this._badJsonTypes = SetUtil.fromString((String)StringUtil.read((ClassLoader)this.getClass().getClassLoader(), (String)this._tplBadJsonTypes));
            this._hbmFileName = hbmFileName;
            this._modelHintsFileName = modelHintsFileName;
            this._springFileName = springFileName;
            this._springBaseFileName = springBaseFileName;
            this._springDynamicDataSourceFileName = springDynamicDataSourceFileName;
            this._springHibernateFileName = springHibernateFileName;
            this._springInfrastructureFileName = springInfrastructureFileName;
            this._apiDir = apiDir;
            this._implDir = implDir;
            this._jsonFileName = jsonFileName;
            this._remotingFileName = remotingFileName;
            this._sqlDir = sqlDir;
            this._sqlFileName = sqlFileName;
            this._sqlIndexesFileName = sqlIndexesFileName;
            this._sqlIndexesPropertiesFileName = sqlIndexesPropertiesFileName;
            this._sqlSequencesFileName = sqlSequencesFileName;
            this._autoNamespaceTables = autoNamespaceTables;
            this._beanLocatorUtil = beanLocatorUtil;
            this._beanLocatorUtilShortName = this._beanLocatorUtil.substring(this._beanLocatorUtil.lastIndexOf(".") + 1);
            this._propsUtil = propsUtil;
            this._pluginName = GetterUtil.getString((String)pluginName);
            this._testDir = testDir;
            Document doc = SAXReaderUtil.read((File)new File(fileName), (boolean)true);
            Element root = doc.getRootElement();
            String packagePath = root.attributeValue("package-path");
            this._outputPath = this._implDir + "/" + StringUtil.replace((String)packagePath, (String)".", (String)"/");
            this._serviceOutputPath = this._apiDir + "/" + StringUtil.replace((String)packagePath, (String)".", (String)"/");
            if (Validator.isNotNull((String)this._testDir)) {
                this._testOutputPath = this._testDir + "/" + StringUtil.replace((String)packagePath, (String)".", (String)"/");
            }
            this._packagePath = packagePath;
            Element author = root.element("author");
            this._author = author != null ? author.getText() : AUTHOR;
            Element portlet = root.element("portlet");
            Element namespace = root.element("namespace");
            if (portlet != null) {
                this._portletName = portlet.attributeValue("name");
                this._portletShortName = portlet.attributeValue("short-name");
                this._portletPackageName = TextFormatter.format((String)this._portletName, (int)1);
                this._outputPath = this._outputPath + "/" + this._portletPackageName;
                this._serviceOutputPath = this._serviceOutputPath + "/" + this._portletPackageName;
                this._testOutputPath = this._testOutputPath + "/" + this._portletPackageName;
                this._packagePath = this._packagePath + "." + this._portletPackageName;
            } else {
                this._portletShortName = namespace.getText();
            }
            this._portletShortName = this._portletShortName.trim();
            if (!Validator.isChar((String)this._portletShortName)) {
                throw new RuntimeException("The namespace element must be a valid keyword");
            }
            this._ejbList = new ArrayList<Entity>();
            this._entityMappings = new HashMap<String, EntityMapping>();
            List entities = root.elements("entity");
            for (Element entityEl : entities) {
                String alias;
                String ejbName = entityEl.attributeValue("name");
                String table = entityEl.attributeValue("table");
                if (Validator.isNull((String)table)) {
                    table = ejbName;
                    if (this._badTableNames.contains(ejbName)) {
                        table = table + "_";
                    }
                    if (this._autoNamespaceTables) {
                        table = this._portletShortName + "_" + ejbName;
                    }
                }
                boolean uuid = GetterUtil.getBoolean((String)entityEl.attributeValue("uuid"), (boolean)false);
                boolean localService = GetterUtil.getBoolean((String)entityEl.attributeValue("local-service"), (boolean)false);
                boolean remoteService = GetterUtil.getBoolean((String)entityEl.attributeValue("remote-service"), (boolean)true);
                String persistenceClass = GetterUtil.getString((String)entityEl.attributeValue("persistence-class"), (String)(this._packagePath + ".service.persistence." + ejbName + "PersistenceImpl"));
                String finderClass = "";
                if (FileUtil.exists((String)(this._outputPath + "/service/persistence/" + ejbName + "FinderImpl.java"))) {
                    finderClass = this._packagePath + ".service.persistence." + ejbName + "FinderImpl";
                }
                String dataSource = entityEl.attributeValue("data-source");
                String sessionFactory = entityEl.attributeValue("session-factory");
                String txManager = entityEl.attributeValue("tx-manager");
                boolean cacheEnabled = GetterUtil.getBoolean((String)entityEl.attributeValue("cache-enabled"), (boolean)true);
                ArrayList<EntityColumn> pkList = new ArrayList<EntityColumn>();
                ArrayList<EntityColumn> regularColList = new ArrayList<EntityColumn>();
                ArrayList<EntityColumn> collectionList = new ArrayList<EntityColumn>();
                ArrayList<EntityColumn> columnList = new ArrayList<EntityColumn>();
                List columns = entityEl.elements("column");
                if (uuid) {
                    Element column = SAXReaderUtil.createElement((String)"column");
                    column.addAttribute("name", "uuid");
                    column.addAttribute("type", "String");
                    columns.add(0, column);
                }
                for (Element column : columns) {
                    int collectionEntityWeight;
                    String columnName = column.attributeValue("name");
                    String columnDBName = column.attributeValue("db-name");
                    if (Validator.isNull((String)columnDBName)) {
                        columnDBName = columnName;
                        if (this._badColumnNames.contains(columnName)) {
                            columnDBName = columnDBName + "_";
                        }
                    }
                    String columnType = column.attributeValue("type");
                    boolean primary = GetterUtil.getBoolean((String)column.attributeValue("primary"), (boolean)false);
                    String collectionEntity = column.attributeValue("entity");
                    String mappingKey = column.attributeValue("mapping-key");
                    String mappingTable = column.attributeValue("mapping-table");
                    if (Validator.isNotNull((String)mappingTable)) {
                        if (this._badTableNames.contains(mappingTable)) {
                            mappingTable = mappingTable + "_";
                        }
                        if (this._autoNamespaceTables) {
                            mappingTable = this._portletShortName + "_" + mappingTable;
                        }
                    }
                    String idType = column.attributeValue("id-type");
                    String idParam = column.attributeValue("id-param");
                    boolean convertNull = GetterUtil.getBoolean((String)column.attributeValue("convert-null"), (boolean)true);
                    boolean localized = GetterUtil.getBoolean((String)column.attributeValue("localized"));
                    EntityColumn col = new EntityColumn(columnName, columnDBName, columnType, primary, collectionEntity, mappingKey, mappingTable, idType, idParam, convertNull, localized);
                    if (primary) {
                        pkList.add(col);
                    }
                    if (columnType.equals("Collection")) {
                        collectionList.add(col);
                    } else {
                        regularColList.add(col);
                    }
                    columnList.add(col);
                    if (!Validator.isNotNull((String)collectionEntity) || !Validator.isNotNull((String)mappingTable)) continue;
                    EntityMapping entityMapping = new EntityMapping(mappingTable, ejbName, collectionEntity);
                    int ejbNameWeight = StringUtil.startsWithWeight((String)mappingTable, (String)ejbName);
                    if (ejbNameWeight <= (collectionEntityWeight = StringUtil.startsWithWeight((String)mappingTable, (String)collectionEntity)) && (ejbNameWeight != collectionEntityWeight || ejbName.compareTo(collectionEntity) <= 0)) continue;
                    this._entityMappings.put(mappingTable, entityMapping);
                }
                EntityOrder order = null;
                Element orderEl = entityEl.element("order");
                if (orderEl != null) {
                    boolean asc = true;
                    if (orderEl.attribute("by") != null && orderEl.attributeValue("by").equals("desc")) {
                        asc = false;
                    }
                    ArrayList<EntityColumn> orderColsList = new ArrayList<EntityColumn>();
                    order = new EntityOrder(asc, orderColsList);
                    List orderCols = orderEl.elements("order-column");
                    for (Element orderColEl : orderCols) {
                        String orderColName = orderColEl.attributeValue("name");
                        boolean orderColCaseSensitive = GetterUtil.getBoolean((String)orderColEl.attributeValue("case-sensitive"), (boolean)true);
                        boolean orderColByAscending = asc;
                        String orderColBy = GetterUtil.getString((String)orderColEl.attributeValue("order-by"));
                        if (orderColBy.equals("asc")) {
                            orderColByAscending = true;
                        } else if (orderColBy.equals("desc")) {
                            orderColByAscending = false;
                        }
                        EntityColumn col = Entity.getColumn(orderColName, columnList);
                        col = (EntityColumn)col.clone();
                        col.setCaseSensitive(orderColCaseSensitive);
                        col.setOrderByAscending(orderColByAscending);
                        orderColsList.add(col);
                    }
                }
                ArrayList<EntityFinder> finderList = new ArrayList<EntityFinder>();
                List finders = entityEl.elements("finder");
                if (uuid) {
                    Element finderEl = SAXReaderUtil.createElement((String)"finder");
                    finderEl.addAttribute("name", "Uuid");
                    finderEl.addAttribute("return-type", "Collection");
                    Element finderColEl = finderEl.addElement("finder-column");
                    finderColEl.addAttribute("name", "uuid");
                    finders.add(0, finderEl);
                    if (columnList.contains(new EntityColumn("groupId"))) {
                        finderEl = SAXReaderUtil.createElement((String)"finder");
                        finderEl.addAttribute("name", "UUID_G");
                        finderEl.addAttribute("return-type", ejbName);
                        finderEl.addAttribute("unique", "true");
                        finderColEl = finderEl.addElement("finder-column");
                        finderColEl.addAttribute("name", "uuid");
                        finderColEl = finderEl.addElement("finder-column");
                        finderColEl.addAttribute("name", "groupId");
                        finders.add(1, finderEl);
                    }
                }
                if (this._badAliasNames.contains((alias = TextFormatter.format((String)ejbName, (int)8)).toLowerCase())) {
                    alias = alias + "_";
                }
                for (Element finderEl : finders) {
                    String finderName = finderEl.attributeValue("name");
                    String finderReturn = finderEl.attributeValue("return-type");
                    boolean finderUnique = GetterUtil.getBoolean((String)finderEl.attributeValue("unique"), (boolean)false);
                    String finderWhere = finderEl.attributeValue("where");
                    if (Validator.isNotNull((String)finderWhere)) {
                        for (EntityColumn column : columnList) {
                            String name = column.getName();
                            if (finderWhere.indexOf(name) == -1) continue;
                            finderWhere = finderWhere.replaceAll(name, alias + "." + name);
                        }
                    }
                    boolean finderDBIndex = GetterUtil.getBoolean((String)finderEl.attributeValue("db-index"), (boolean)true);
                    ArrayList<EntityColumn> finderColsList = new ArrayList<EntityColumn>();
                    List finderCols = finderEl.elements("finder-column");
                    for (Element finderColEl : finderCols) {
                        String finderColName = finderColEl.attributeValue("name");
                        boolean finderColCaseSensitive = GetterUtil.getBoolean((String)finderColEl.attributeValue("case-sensitive"), (boolean)true);
                        String finderColComparator = GetterUtil.getString((String)finderColEl.attributeValue("comparator"), (String)"=");
                        EntityColumn col = Entity.getColumn(finderColName, columnList);
                        if (!col.isFetchFinderPath() && !finderReturn.equals("Collection")) {
                            col.setFetchFinderPath(true);
                        }
                        col = (EntityColumn)col.clone();
                        col.setCaseSensitive(finderColCaseSensitive);
                        col.setComparator(finderColComparator);
                        finderColsList.add(col);
                    }
                    finderList.add(new EntityFinder(finderName, finderReturn, finderUnique, finderWhere, finderDBIndex, finderColsList));
                }
                ArrayList<Entity> referenceList = new ArrayList<Entity>();
                if (build) {
                    List references = entityEl.elements("reference");
                    Iterator itr2 = references.iterator();
                    TreeSet<String> referenceSet = new TreeSet<String>();
                    while (itr2.hasNext()) {
                        Element reference = (Element)itr2.next();
                        String referencePackage = reference.attributeValue("package-path");
                        String referenceEntity = reference.attributeValue("entity");
                        referenceSet.add(referencePackage + "." + referenceEntity);
                    }
                    if (Validator.isNull((String)this._pluginName)) {
                        if (!this._packagePath.equals("com.liferay.counter")) {
                            referenceSet.add("com.liferay.counter.Counter");
                        }
                        if (!this._packagePath.equals("com.liferay.portal")) {
                            referenceSet.add("com.liferay.portal.Resource");
                            referenceSet.add("com.liferay.portal.User");
                        }
                    }
                    for (String referenceName : referenceSet) {
                        referenceList.add(this.getEntity(referenceName));
                    }
                }
                ArrayList<String> txRequiredList = new ArrayList<String>();
                for (Element txRequiredEl : entityEl.elements("tx-required")) {
                    String txRequired = txRequiredEl.getText();
                    txRequiredList.add(txRequired);
                }
                this._ejbList.add(new Entity(this._packagePath, this._portletName, this._portletShortName, ejbName, table, alias, uuid, localService, remoteService, persistenceClass, finderClass, dataSource, sessionFactory, txManager, cacheEnabled, pkList, regularColList, collectionList, columnList, order, finderList, referenceList, txRequiredList));
            }
            ArrayList<String> exceptionList = new ArrayList<String>();
            if (root.element("exceptions") != null) {
                List exceptions = root.element("exceptions").elements("exception");
                for (Element exception : exceptions) {
                    exceptionList.add(exception.getText());
                }
            }
            if (build) {
                for (int x = 0; x < this._ejbList.size(); ++x) {
                    Entity entity = this._ejbList.get(x);
                    System.out.println("Building " + entity.getName());
                    if (entity.hasColumns()) {
                        this._createHbm(entity);
                        this._createHbmUtil(entity);
                        this._createPersistenceImpl(entity);
                        this._createPersistence(entity);
                        this._createPersistenceUtil(entity);
                        if (Validator.isNotNull((String)this._testDir)) {
                            this._createPersistenceTest(entity);
                        }
                        this._createModelImpl(entity);
                        this._createExtendedModelImpl(entity);
                        this._createModel(entity);
                        this._createExtendedModel(entity);
                        this._createModelClp(entity);
                        this._createModelWrapper(entity);
                        this._createModelSoap(entity);
                        this._createPool(entity);
                        if (entity.getPKList().size() > 1) {
                            this._createEJBPK(entity);
                        }
                    }
                    this._createFinder(entity);
                    this._createFinderUtil(entity);
                    if (entity.hasLocalService()) {
                        this._createServiceImpl(entity, 1);
                        this._createServiceBaseImpl(entity, 1);
                        this._createService(entity, 1);
                        this._createServiceFactory(entity, 1);
                        this._createServiceUtil(entity, 1);
                        this._createServiceClp(entity, 1);
                        this._createServiceWrapper(entity, 1);
                    }
                    if (!entity.hasRemoteService()) continue;
                    this._createServiceImpl(entity, 0);
                    this._createServiceBaseImpl(entity, 0);
                    this._createService(entity, 0);
                    this._createServiceFactory(entity, 0);
                    this._createServiceUtil(entity, 0);
                    this._createServiceClp(entity, 0);
                    this._createServiceWrapper(entity, 0);
                    if (!Validator.isNotNull((String)this._jsonFileName)) continue;
                    this._createServiceHttp(entity);
                    this._createServiceJson(entity);
                    if (entity.hasColumns()) {
                        this._createServiceJsonSerializer(entity);
                    }
                    this._createServiceSoap(entity);
                }
                this._createHbmXml();
                this._createModelHintsXml();
                this._createSpringXml();
                this._createServiceClpMessageListener();
                this._createServiceClpSerializer();
                if (Validator.isNotNull((String)this._jsonFileName)) {
                    this._createJsonJs();
                }
                if (Validator.isNotNull((String)this._remotingFileName)) {
                    this._createRemotingXml();
                }
                this._createSQLIndexes();
                this._createSQLTables();
                this._createSQLSequences();
                this._createExceptions(exceptionList);
                this._createProps();
                this._createSpringBaseXml();
                this._createSpringDynamicDataSourceXml();
                this._createSpringHibernateXml();
                this._createSpringInfrastructureXml();
            }
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getClassName(Type type) {
        int dimensions = type.getDimensions();
        String name = type.getValue();
        if (dimensions > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < dimensions; ++i) {
                sb.append("[");
            }
            if (name.equals("boolean")) {
                return sb.toString() + "Z";
            }
            if (name.equals("byte")) {
                return sb.toString() + "B";
            }
            if (name.equals("char")) {
                return sb.toString() + "C";
            }
            if (name.equals("double")) {
                return sb.toString() + "D";
            }
            if (name.equals("float")) {
                return sb.toString() + "F";
            }
            if (name.equals("int")) {
                return sb.toString() + "I";
            }
            if (name.equals("long")) {
                return sb.toString() + "J";
            }
            if (name.equals("short")) {
                return sb.toString() + "S";
            }
            return sb.toString() + "L" + name + ";";
        }
        return name;
    }

    public String getCreateMappingTableSQL(EntityMapping entityMapping) throws IOException {
        String createMappingTableSQL = this._getCreateMappingTableSQL(entityMapping);
        createMappingTableSQL = StringUtil.replace((String)createMappingTableSQL, (String)"\n", (String)"");
        createMappingTableSQL = StringUtil.replace((String)createMappingTableSQL, (String)"\t", (String)"");
        createMappingTableSQL = createMappingTableSQL.substring(0, createMappingTableSQL.length() - 1);
        return createMappingTableSQL;
    }

    public String getCreateTableSQL(Entity entity) {
        String createTableSQL = this._getCreateTableSQL(entity);
        createTableSQL = StringUtil.replace((String)createTableSQL, (String)"\n", (String)"");
        createTableSQL = StringUtil.replace((String)createTableSQL, (String)"\t", (String)"");
        createTableSQL = createTableSQL.substring(0, createTableSQL.length() - 1);
        return createTableSQL;
    }

    public String getDimensions(String dims) {
        return this.getDimensions(Integer.parseInt(dims));
    }

    public String getDimensions(int dims) {
        String dimensions = "";
        for (int i = 0; i < dims; ++i) {
            dimensions = dimensions + "[]";
        }
        return dimensions;
    }

    public Entity getEntity(String name) throws IOException {
        Entity entity = this._entityPool.get(name);
        if (entity != null) {
            return entity;
        }
        int pos = name.lastIndexOf(".");
        if (pos == -1) {
            pos = this._ejbList.indexOf(new Entity(name));
            if (pos == -1) {
                throw new RuntimeException("Cannot find " + name + " in " + ListUtil.toString(this._ejbList, (String)"name"));
            }
            entity = this._ejbList.get(pos);
            this._entityPool.put(name, entity);
            return entity;
        }
        String refPackage = name.substring(0, pos);
        String refPackageDir = StringUtil.replace((String)refPackage, (String)".", (String)"/");
        String refEntity = name.substring(pos + 1, name.length());
        String refFileName = this._implDir + "/" + refPackageDir + "/service.xml";
        File refFile = new File(refFileName);
        boolean useTempFile = false;
        if (!refFile.exists()) {
            refFileName = Time.getTimestamp();
            refFile = new File(refFileName);
            ClassLoader classLoader = this.getClass().getClassLoader();
            FileUtil.write((String)refFileName, (String)StringUtil.read((ClassLoader)classLoader, (String)(refPackageDir + "/service.xml")));
            useTempFile = true;
        }
        ServiceBuilder serviceBuilder = new ServiceBuilder(refFileName, this._hbmFileName, this._modelHintsFileName, this._springFileName, this._springBaseFileName, this._springDynamicDataSourceFileName, this._springHibernateFileName, this._springInfrastructureFileName, this._apiDir, this._implDir, this._jsonFileName, this._remotingFileName, this._sqlDir, this._sqlFileName, this._sqlIndexesFileName, this._sqlIndexesPropertiesFileName, this._sqlSequencesFileName, this._autoNamespaceTables, this._beanLocatorUtil, this._propsUtil, this._pluginName, this._testDir, false);
        entity = serviceBuilder.getEntity(refEntity);
        entity.setPortalReference(useTempFile);
        this._entityPool.put(name, entity);
        if (useTempFile) {
            refFile.deleteOnExit();
        }
        return entity;
    }

    public Entity getEntityByGenericsName(String genericsName) {
        try {
            String name = genericsName.substring(1, genericsName.length() - 1);
            name = StringUtil.replace((String)name, (String)".model.", (String)".");
            return this.getEntity(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Entity getEntityByParameterTypeValue(String parameterTypeValue) {
        try {
            String name = parameterTypeValue;
            name = StringUtil.replace((String)name, (String)".model.", (String)".");
            return this.getEntity(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public EntityMapping getEntityMapping(String mappingTable) {
        return this._entityMappings.get(mappingTable);
    }

    public String getGeneratorClass(String idType) {
        if (Validator.isNull((String)idType)) {
            idType = "assigned";
        }
        return idType;
    }

    public List<EntityColumn> getMappingEntities(String mappingTable) throws IOException {
        ArrayList<EntityColumn> mappingEntitiesPKList = new ArrayList<EntityColumn>();
        EntityMapping entityMapping = this._entityMappings.get(mappingTable);
        for (int i = 0; i < 2; ++i) {
            Entity entity = this.getEntity(entityMapping.getEntity(i));
            if (entity == null) {
                return null;
            }
            mappingEntitiesPKList.addAll(entity.getPKList());
        }
        return mappingEntitiesPKList;
    }

    public String getNoSuchEntityException(Entity entity) {
        String noSuchEntityException = entity.getName();
        if (Validator.isNull((String)entity.getPortletShortName()) || noSuchEntityException.startsWith(entity.getPortletShortName()) && !noSuchEntityException.equals(entity.getPortletShortName())) {
            noSuchEntityException = noSuchEntityException.substring(entity.getPortletShortName().length());
        }
        noSuchEntityException = "NoSuch" + noSuchEntityException;
        return noSuchEntityException;
    }

    public String getParameterType(JavaParameter parameter) {
        StringBuilder sb = new StringBuilder();
        Type returnType = parameter.getType();
        sb.append(returnType.getValue());
        sb.append(parameter.getGenericsName());
        sb.append(this.getDimensions(returnType.getDimensions()));
        return sb.toString();
    }

    public String getPrimitiveObj(String type) {
        if (type.equals("boolean")) {
            return "Boolean";
        }
        if (type.equals("double")) {
            return "Double";
        }
        if (type.equals("float")) {
            return "Float";
        }
        if (type.equals("int")) {
            return "Integer";
        }
        if (type.equals("long")) {
            return "Long";
        }
        if (type.equals("short")) {
            return "Short";
        }
        return type;
    }

    public String getPrimitiveObjValue(String colType) {
        if (colType.equals("Boolean")) {
            return ".booleanValue()";
        }
        if (colType.equals("Double")) {
            return ".doubleValue()";
        }
        if (colType.equals("Float")) {
            return ".floatValue()";
        }
        if (colType.equals("Integer")) {
            return ".intValue()";
        }
        if (colType.equals("Long")) {
            return ".longValue()";
        }
        if (colType.equals("Short")) {
            return ".shortValue()";
        }
        return "";
    }

    public String getReturnType(JavaMethod method) {
        StringBuilder sb = new StringBuilder();
        Type returnType = method.getReturns();
        sb.append(returnType.getValue());
        sb.append(method.getReturnsGenericsName());
        sb.append(this.getDimensions(returnType.getDimensions()));
        return sb.toString();
    }

    public String getServiceBaseThrowsExceptions(List<JavaMethod> methods, String methodName, List<String> args, List<String> exceptions) {
        boolean foundMethod = false;
        for (JavaMethod method : methods) {
            JavaParameter[] parameters = method.getParameters();
            if (method.getName().equals(methodName) && parameters.length == args.size()) {
                for (int i = 0; i < parameters.length; ++i) {
                    Type[] methodExceptions;
                    JavaParameter parameter = parameters[i];
                    String arg = args.get(i);
                    if (!this.getParameterType(parameter).equals(arg)) continue;
                    exceptions = ListUtil.copy(exceptions);
                    for (Type methodException : methodExceptions = method.getExceptions()) {
                        String exception = methodException.getValue();
                        if (exception.equals(PortalException.class.getName())) {
                            exception = "PortalException";
                        }
                        if (exception.equals(SystemException.class.getName())) {
                            exception = "SystemException";
                        }
                        if (exceptions.contains(exception)) continue;
                        exceptions.add(exception);
                    }
                    Collections.sort(exceptions);
                    foundMethod = true;
                    break;
                }
            }
            if (!foundMethod) continue;
            break;
        }
        if (!exceptions.isEmpty()) {
            return "throws " + StringUtil.merge(exceptions);
        }
        return "";
    }

    public String getSqlType(String type) {
        if (type.equals("boolean") || type.equals("Boolean")) {
            return "BOOLEAN";
        }
        if (type.equals("double") || type.equals("Double")) {
            return "DOUBLE";
        }
        if (type.equals("float") || type.equals("Float")) {
            return "FLOAT";
        }
        if (type.equals("int") || type.equals("Integer")) {
            return "INTEGER";
        }
        if (type.equals("long") || type.equals("Long")) {
            return "BIGINT";
        }
        if (type.equals("short") || type.equals("Short")) {
            return "INTEGER";
        }
        if (type.equals("Date")) {
            return "TIMESTAMP";
        }
        return null;
    }

    public String getSqlType(String model, String field, String type) {
        if (type.equals("boolean") || type.equals("Boolean")) {
            return "BOOLEAN";
        }
        if (type.equals("double") || type.equals("Double")) {
            return "DOUBLE";
        }
        if (type.equals("float") || type.equals("Float")) {
            return "FLOAT";
        }
        if (type.equals("int") || type.equals("Integer")) {
            return "INTEGER";
        }
        if (type.equals("long") || type.equals("Long")) {
            return "BIGINT";
        }
        if (type.equals("short") || type.equals("Short")) {
            return "INTEGER";
        }
        if (type.equals("Date")) {
            return "TIMESTAMP";
        }
        if (type.equals("String")) {
            int maxLength;
            Map hints = ModelHintsUtil.getHints((String)model, (String)field);
            if (hints != null && (maxLength = GetterUtil.getInteger((String)((String)hints.get("max-length")))) == 2000000) {
                return "CLOB";
            }
            return "VARCHAR";
        }
        return null;
    }

    public boolean hasEntityByGenericsName(String genericsName) {
        if (Validator.isNull((String)genericsName)) {
            return false;
        }
        if (genericsName.indexOf(".model.") == -1) {
            return false;
        }
        return this.getEntityByGenericsName(genericsName) != null;
    }

    public boolean hasEntityByParameterTypeValue(String parameterTypeValue) {
        if (Validator.isNull((String)parameterTypeValue)) {
            return false;
        }
        if (parameterTypeValue.indexOf(".model.") == -1) {
            return false;
        }
        return this.getEntityByParameterTypeValue(parameterTypeValue) != null;
    }

    public boolean isBasePersistenceMethod(JavaMethod method) {
        String methodName = method.getName();
        if (methodName.equals("clearCache") || methodName.equals("findWithDynamicQuery")) {
            return true;
        }
        if (methodName.equals("findByPrimaryKey") || methodName.equals("fetchByPrimaryKey") || methodName.equals("remove")) {
            JavaParameter[] parameters = method.getParameters();
            if (parameters.length == 1 && parameters[0].getName().equals("primaryKey")) {
                return true;
            }
            if (methodName.equals("remove")) {
                Type[] methodExceptions;
                for (Type methodException : methodExceptions = method.getExceptions()) {
                    String exception = methodException.getValue();
                    if (!exception.contains("NoSuch")) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean isCustomMethod(JavaMethod method) {
        String methodName = method.getName();
        if (methodName.equals("afterPropertiesSet") || methodName.equals("equals") || methodName.equals("getClass") || methodName.equals("hashCode") || methodName.equals("notify") || methodName.equals("notifyAll") || methodName.equals("toString") || methodName.equals("wait")) {
            return false;
        }
        if (methodName.equals("getPermissionChecker")) {
            return false;
        }
        if (methodName.equals("getUser") && method.getParameters().length == 0) {
            return false;
        }
        if (methodName.equals("getUserId") && method.getParameters().length == 0) {
            return false;
        }
        if (methodName.endsWith("Finder") && (methodName.startsWith("get") || methodName.startsWith("set"))) {
            return false;
        }
        if (methodName.endsWith("Persistence") && (methodName.startsWith("get") || methodName.startsWith("set"))) {
            return false;
        }
        return !methodName.endsWith("Service") || !methodName.startsWith("get") && !methodName.startsWith("set");
    }

    public boolean isDuplicateMethod(JavaMethod method, Map<String, Object> tempMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("isDuplicateMethod ");
        sb.append(method.getReturns().getValue());
        sb.append(method.getReturnsGenericsName());
        sb.append(this.getDimensions(method.getReturns().getDimensions()));
        sb.append(" ");
        sb.append(method.getName());
        sb.append("(");
        JavaParameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            JavaParameter javaParameter = parameters[i];
            sb.append(javaParameter.getType().getValue());
            sb.append(javaParameter.getGenericsName());
            sb.append(this.getDimensions(javaParameter.getType().getDimensions()));
            if (i + 1 == parameters.length) continue;
            sb.append(",");
        }
        sb.append(")");
        String key = sb.toString();
        if (tempMap.containsKey(key)) {
            return true;
        }
        tempMap.put(key, key);
        return false;
    }

    public boolean isServiceReadOnlyMethod(JavaMethod method, List<String> txRequiredList) {
        return this.isReadOnlyMethod(method, txRequiredList, PropsValues.SERVICE_BUILDER_SERVICE_READ_ONLY_PREFIXES);
    }

    public boolean isReadOnlyMethod(JavaMethod method, List<String> txRequiredList, String[] prefixes) {
        String methodName = method.getName();
        if (this.isTxRequiredMethod(method, txRequiredList)) {
            return false;
        }
        for (String prefix : prefixes) {
            if (!methodName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public boolean isSoapMethod(JavaMethod method) {
        String returnValueName = method.getReturns().getValue();
        if (returnValueName.equals("com.liferay.portal.model.Lock") || returnValueName.equals("com.liferay.portlet.messageboards.model.MBMessageDisplay") || returnValueName.startsWith("java.io") || returnValueName.equals("java.util.Map") || returnValueName.equals("java.util.Properties") || returnValueName.startsWith("javax")) {
            return false;
        }
        JavaParameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            JavaParameter javaParameter = parameters[i];
            String parameterTypeName = javaParameter.getType().getValue() + this._getDimensions(javaParameter.getType());
            if (!parameterTypeName.equals("com.liferay.portal.kernel.util.UnicodeProperties") && !parameterTypeName.equals("com.liferay.portal.theme.ThemeDisplay") && !parameterTypeName.equals("com.liferay.portlet.PortletPreferencesImpl") && !parameterTypeName.startsWith("java.io") && !parameterTypeName.startsWith("java.util.Map") && !parameterTypeName.startsWith("java.util.Properties") && !parameterTypeName.startsWith("javax")) continue;
            return false;
        }
        return true;
    }

    public boolean isTxRequiredMethod(JavaMethod method, List<String> txRequiredList) {
        if (txRequiredList == null) {
            return false;
        }
        String methodName = method.getName();
        for (String txRequired : txRequiredList) {
            if (!methodName.equals(txRequired)) continue;
            return true;
        }
        return false;
    }

    private static String _getPackagePath(File file) {
        String fileName = StringUtil.replace((String)file.toString(), (String)"\\", (String)"/");
        int x = fileName.indexOf("src/");
        if (x == -1) {
            x = fileName.indexOf("test/");
        }
        int y = fileName.lastIndexOf("/");
        fileName = fileName.substring(x + 4, y);
        return StringUtil.replace((String)fileName, (String)"/", (String)".");
    }

    private void _createEJBPK(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplEjbPk, context);
        File ejbFile = new File(this._serviceOutputPath + "/service/persistence/" + entity.getPKClassName() + ".java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createExceptions(List<String> exceptions) throws Exception {
        for (int i = 0; i < this._ejbList.size(); ++i) {
            Entity entity = this._ejbList.get(i);
            if (!entity.hasColumns()) continue;
            exceptions.add(this.getNoSuchEntityException(entity));
        }
        for (String exception : exceptions) {
            String content;
            File exceptionFile = new File(this._serviceOutputPath + "/" + exception + "Exception.java");
            if (!exceptionFile.exists()) {
                Map<String, Object> context = this._getContext();
                context.put("exception", exception);
                String content2 = this._processTemplate(this._tplException, context);
                if (exception.startsWith("NoSuch")) {
                    content2 = StringUtil.replace((String)content2, (String)"PortalException", (String)"NoSuchModelException");
                }
                content2 = StringUtil.replace((String)content2, (String)"\r\n", (String)"\n");
                FileUtil.write((File)exceptionFile, (String)content2);
            }
            if (exception.startsWith("NoSuch") && !(content = FileUtil.read((File)exceptionFile)).contains("NoSuchModelException")) {
                content = StringUtil.replace((String)content, (String)"PortalException", (String)"NoSuchModelException");
                FileUtil.write((File)exceptionFile, (String)content);
            }
            if (this._serviceOutputPath.equals(this._outputPath) || !(exceptionFile = new File(this._outputPath + "/" + exception + "Exception.java")).exists()) continue;
            System.out.println("Relocating " + exceptionFile);
            exceptionFile.delete();
        }
    }

    private void _createExtendedModel(Entity entity) throws Exception {
        JavaClass javaClass = this._getJavaClass(this._outputPath + "/model/impl/" + entity.getName() + "Impl.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        String content = this._processTemplate(this._tplExtendedModel, context);
        File modelFile = new File(this._serviceOutputPath + "/model/" + entity.getName() + ".java");
        ServiceBuilder.writeFile(modelFile, content, this._author);
        if (!this._serviceOutputPath.equals(this._outputPath) && (modelFile = new File(this._outputPath + "/model/" + entity.getName() + ".java")).exists()) {
            System.out.println("Relocating " + modelFile);
            modelFile.delete();
        }
    }

    private void _createExtendedModelImpl(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplExtendedModelImpl, context);
        File modelFile = new File(this._outputPath + "/model/impl/" + entity.getName() + "Impl.java");
        if (!modelFile.exists()) {
            ServiceBuilder.writeFile(modelFile, content, this._author);
        }
    }

    private void _createFinder(Entity entity) throws Exception {
        if (!entity.hasFinderClass()) {
            return;
        }
        JavaClass javaClass = this._getJavaClass(this._outputPath + "/service/persistence/" + entity.getName() + "FinderImpl.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        String content = this._processTemplate(this._tplFinder, context);
        File ejbFile = new File(this._serviceOutputPath + "/service/persistence/" + entity.getName() + "Finder.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
        if (!this._serviceOutputPath.equals(this._outputPath) && (ejbFile = new File(this._outputPath + "/service/persistence/" + entity.getName() + "Finder.java")).exists()) {
            System.out.println("Relocating " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createFinderUtil(Entity entity) throws Exception {
        if (!entity.hasFinderClass()) {
            return;
        }
        JavaClass javaClass = this._getJavaClass(this._outputPath + "/service/persistence/" + entity.getName() + "FinderImpl.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        String content = this._processTemplate(this._tplFinderUtil, context);
        File ejbFile = new File(this._serviceOutputPath + "/service/persistence/" + entity.getName() + "FinderUtil.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
        if (!this._serviceOutputPath.equals(this._outputPath) && (ejbFile = new File(this._outputPath + "/service/persistence/" + entity.getName() + "FinderUtil.java")).exists()) {
            System.out.println("Relocating " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createHbm(Entity entity) {
        File ejbFile = new File(this._outputPath + "/service/persistence/" + entity.getName() + "HBM.java");
        if (ejbFile.exists()) {
            System.out.println("Removing deprecated " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createHbmUtil(Entity entity) {
        File ejbFile = new File(this._outputPath + "/service/persistence/" + entity.getName() + "HBMUtil.java");
        if (ejbFile.exists()) {
            System.out.println("Removing deprecated " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createHbmXml() throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entities", this._ejbList);
        String content = this._processTemplate(this._tplHbmXml, context);
        int lastImportStart = content.lastIndexOf("<import class=");
        int lastImportEnd = content.indexOf("/>", lastImportStart) + 3;
        String imports = content.substring(0, lastImportEnd);
        content = content.substring(lastImportEnd + 1);
        File xmlFile = new File(this._hbmFileName);
        if (!xmlFile.exists()) {
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE hibernate-mapping PUBLIC \"-//Hibernate/Hibernate Mapping DTD 3.0//EN\" \"http://hibernate.sourceforge.net/hibernate-mapping-3.0.dtd\">\n\n<hibernate-mapping default-lazy=\"false\" auto-import=\"false\">\n</hibernate-mapping>";
            FileUtil.write((File)xmlFile, (String)xml);
        }
        String oldContent = FileUtil.read((File)xmlFile);
        String newContent = this._fixHbmXml(oldContent);
        int firstImport = newContent.indexOf("<import class=\"" + this._packagePath + ".model.");
        int lastImport = newContent.lastIndexOf("<import class=\"" + this._packagePath + ".model.");
        if (firstImport == -1) {
            int x = newContent.indexOf("<class");
            if (x != -1) {
                newContent = newContent.substring(0, x) + imports + newContent.substring(x);
            } else {
                content = imports + content;
            }
        } else {
            firstImport = newContent.indexOf("<import", firstImport) - 1;
            lastImport = newContent.indexOf("/>", lastImport) + 3;
            newContent = newContent.substring(0, firstImport) + imports + newContent.substring(lastImport);
        }
        int firstClass = newContent.indexOf("<class name=\"" + this._packagePath + ".model.impl.");
        int lastClass = newContent.lastIndexOf("<class name=\"" + this._packagePath + ".model.impl.");
        if (firstClass == -1) {
            int x = newContent.indexOf("</hibernate-mapping>");
            if (x != -1) {
                newContent = newContent.substring(0, x) + content + newContent.substring(x, newContent.length());
            }
        } else {
            firstClass = newContent.lastIndexOf("<class", firstClass) - 1;
            lastClass = newContent.indexOf("</class>", lastClass) + 9;
            newContent = newContent.substring(0, firstClass) + content + newContent.substring(lastClass, newContent.length());
        }
        newContent = this._formatXml(newContent);
        if (!oldContent.equals(newContent)) {
            FileUtil.write((File)xmlFile, (String)newContent);
        }
    }

    private void _createJsonJs() throws Exception {
        StringBuilder content = new StringBuilder();
        if (this._ejbList.size() > 0) {
            content.append(this._processTemplate(this._tplJsonJs));
        }
        for (int i = 0; i < this._ejbList.size(); ++i) {
            Entity entity = this._ejbList.get(i);
            if (!entity.hasRemoteService()) continue;
            JavaClass javaClass = this._getJavaClass(this._serviceOutputPath + "/service/" + entity.getName() + "Service.java");
            JavaMethod[] methods = this._getMethods(javaClass);
            LinkedHashSet<String> jsonMethods = new LinkedHashSet<String>();
            for (JavaMethod method : methods) {
                String methodName = method.getName();
                String returnValue = this.getReturnType(method);
                boolean badJsonType = false;
                for (JavaParameter parameter : method.getParameters()) {
                    String parameterType = this.getParameterType(parameter);
                    if (!this._badJsonTypes.contains(parameterType)) continue;
                    badJsonType = true;
                }
                if (!method.isPublic() || this._badJsonTypes.contains(returnValue) || badJsonType) continue;
                jsonMethods.add(methodName);
            }
            if (jsonMethods.size() <= 0) continue;
            Map<String, Object> context = this._getContext();
            context.put("entity", entity);
            context.put("methods", jsonMethods);
            content.append("\n\n");
            content.append(this._processTemplate(this._tplJsonJsMethod, context));
        }
        File jsonFile = new File(this._jsonFileName);
        if (!jsonFile.exists()) {
            FileUtil.write((File)jsonFile, (String)"");
        }
        String oldContent = FileUtil.read((File)jsonFile);
        String newContent = new String(oldContent);
        int oldBegin = oldContent.indexOf("Liferay.Service.register(\"Liferay.Service." + this._portletShortName);
        int oldEnd = oldContent.lastIndexOf("Liferay.Service." + this._portletShortName);
        oldEnd = oldContent.indexOf(");", oldEnd);
        int newBegin = newContent.indexOf("Liferay.Service.register(\"Liferay.Service." + this._portletShortName);
        int newEnd = newContent.lastIndexOf("Liferay.Service." + this._portletShortName);
        newEnd = newContent.indexOf(");", newEnd);
        newContent = newBegin == -1 ? oldContent + "\n\n" + content.toString().trim() : newContent.substring(0, oldBegin) + content.toString().trim() + newContent.substring(oldEnd + 2, newContent.length());
        if (!oldContent.equals(newContent = newContent.trim())) {
            FileUtil.write((File)jsonFile, (String)newContent);
        }
    }

    private void _createModel(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplModel, context);
        File modelFile = new File(this._serviceOutputPath + "/model/" + entity.getName() + "Model.java");
        ServiceBuilder.writeFile(modelFile, content, this._author);
        if (!this._serviceOutputPath.equals(this._outputPath) && (modelFile = new File(this._outputPath + "/model/" + entity.getName() + "Model.java")).exists()) {
            System.out.println("Relocating " + modelFile);
            modelFile.delete();
        }
    }

    private void _createModelClp(Entity entity) throws Exception {
        if (Validator.isNull((String)this._pluginName)) {
            return;
        }
        JavaClass javaClass = this._getJavaClass(this._outputPath + "/model/impl/" + entity.getName() + "Impl.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        String content = this._processTemplate(this._tplModelClp, context);
        File modelFile = new File(this._serviceOutputPath + "/model/" + entity.getName() + "Clp.java");
        ServiceBuilder.writeFile(modelFile, content, this._author);
    }

    private void _createModelHintsXml() throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entities", this._ejbList);
        String content = this._processTemplate(this._tplModelHintsXml, context);
        File xmlFile = new File(this._modelHintsFileName);
        if (!xmlFile.exists()) {
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<model-hints>\n</model-hints>";
            FileUtil.write((File)xmlFile, (String)xml);
        }
        String oldContent = FileUtil.read((File)xmlFile);
        String newContent = new String(oldContent);
        int firstModel = newContent.indexOf("<model name=\"" + this._packagePath + ".model.");
        int lastModel = newContent.lastIndexOf("<model name=\"" + this._packagePath + ".model.");
        if (firstModel == -1) {
            int x = newContent.indexOf("</model-hints>");
            newContent = newContent.substring(0, x) + content + newContent.substring(x, newContent.length());
        } else {
            firstModel = newContent.lastIndexOf("<model", firstModel) - 1;
            lastModel = newContent.indexOf("</model>", lastModel) + 9;
            newContent = newContent.substring(0, firstModel) + content + newContent.substring(lastModel, newContent.length());
        }
        newContent = this._formatXml(newContent);
        if (!oldContent.equals(newContent)) {
            FileUtil.write((File)xmlFile, (String)newContent);
        }
    }

    private void _createModelImpl(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplModelImpl, context);
        File modelFile = new File(this._outputPath + "/model/impl/" + entity.getName() + "ModelImpl.java");
        ServiceBuilder.writeFile(modelFile, content, this._author);
    }

    private void _createModelSoap(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplModelSoap, context);
        File modelFile = new File(this._serviceOutputPath + "/model/" + entity.getName() + "Soap.java");
        ServiceBuilder.writeFile(modelFile, content, this._author);
        if (!this._serviceOutputPath.equals(this._outputPath) && (modelFile = new File(this._outputPath + "/model/" + entity.getName() + "Soap.java")).exists()) {
            System.out.println("Relocating " + modelFile);
            modelFile.delete();
        }
    }

    private void _createModelWrapper(Entity entity) throws Exception {
        JavaClass modelJavaClass = this._getJavaClass(this._serviceOutputPath + "/model/" + entity.getName() + "Model.java");
        JavaClass extendedModelJavaClass = this._getJavaClass(this._serviceOutputPath + "/model/" + entity.getName() + ".java");
        Object[] methods = this._getMethods(modelJavaClass);
        methods = ArrayUtil.append((Object[])methods, (Object[])this._getMethods(extendedModelJavaClass));
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", methods);
        String content = this._processTemplate(this._tplModelWrapper, context);
        File modelFile = new File(this._serviceOutputPath + "/model/" + entity.getName() + "Wrapper.java");
        ServiceBuilder.writeFile(modelFile, content, this._author);
    }

    private void _createPersistence(Entity entity) throws Exception {
        JavaClass javaClass = this._getJavaClass(this._outputPath + "/service/persistence/" + entity.getName() + "PersistenceImpl.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        String content = this._processTemplate(this._tplPersistence, context);
        File ejbFile = new File(this._serviceOutputPath + "/service/persistence/" + entity.getName() + "Persistence.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
        if (!this._serviceOutputPath.equals(this._outputPath) && (ejbFile = new File(this._outputPath + "/service/persistence/" + entity.getName() + "Persistence.java")).exists()) {
            System.out.println("Relocating " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createPersistenceImpl(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("referenceList", this._mergeReferenceList(entity.getReferenceList()));
        Logger.selectLoggerLibrary((int)0);
        String content = this._processTemplate(this._tplPersistenceImpl, context);
        Logger.selectLoggerLibrary((int)-1);
        File ejbFile = new File(this._outputPath + "/service/persistence/" + entity.getName() + "PersistenceImpl.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createPersistenceTest(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplPersistenceTest, context);
        File ejbFile = new File(this._testOutputPath + "/service/persistence/" + entity.getName() + "PersistenceTest.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createPersistenceUtil(Entity entity) throws Exception {
        JavaClass javaClass = this._getJavaClass(this._outputPath + "/service/persistence/" + entity.getName() + "PersistenceImpl.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        String content = this._processTemplate(this._tplPersistenceUtil, context);
        File ejbFile = new File(this._serviceOutputPath + "/service/persistence/" + entity.getName() + "Util.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
        if (!this._serviceOutputPath.equals(this._outputPath) && (ejbFile = new File(this._outputPath + "/service/persistence/" + entity.getName() + "Util.java")).exists()) {
            System.out.println("Relocating " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createPool(Entity entity) {
        File ejbFile = new File(this._outputPath + "/service/persistence/" + entity.getName() + "Pool.java");
        if (ejbFile.exists()) {
            System.out.println("Removing deprecated " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createProps() throws Exception {
        if (Validator.isNull((String)this._pluginName)) {
            return;
        }
        File propsFile = new File(this._implDir + "/service.properties");
        long buildNumber = 1L;
        if (propsFile.exists()) {
            Properties props = PropertiesUtil.load((String)FileUtil.read((File)propsFile));
            buildNumber = GetterUtil.getLong((String)props.getProperty("build.number")) + 1L;
        }
        Map<String, Object> context = this._getContext();
        context.put("buildNumber", new Long(buildNumber));
        context.put("currentTimeMillis", new Long(System.currentTimeMillis()));
        String content = this._processTemplate(this._tplProps, context);
        FileUtil.write((File)propsFile, (String)content, (boolean)true);
    }

    private void _createRemotingXml() throws Exception {
        String content;
        StringBuilder sb = new StringBuilder();
        Document doc = SAXReaderUtil.read((File)new File(this._springFileName));
        for (Element beanEl : doc.getRootElement().elements("bean")) {
            String serviceName;
            String beanId = beanEl.attributeValue("id");
            if (!beanId.endsWith("Service") || beanId.endsWith("LocalService")) continue;
            String entityName = beanId;
            entityName = StringUtil.replace((String)entityName, (String)".service.", (String)".");
            int pos = entityName.indexOf("Service");
            entityName = entityName.substring(0, pos);
            Entity entity = this.getEntity(entityName);
            String serviceMapping = serviceName = beanId;
            serviceMapping = StringUtil.replace((String)serviceMapping, (String)".service.", (String)".service.spring.");
            serviceMapping = StringUtil.replace((String)serviceMapping, (String)".", (String)"_");
            Map<String, Object> context = this._getContext();
            context.put("entity", entity);
            context.put("serviceName", serviceName);
            context.put("serviceMapping", serviceMapping);
            sb.append(this._processTemplate(this._tplRemotingXml, context));
        }
        File outputFile = new File(this._remotingFileName);
        if (!outputFile.exists()) {
            return;
        }
        String newContent = content = FileUtil.read((File)outputFile);
        int x = content.indexOf("<bean ");
        int y = content.lastIndexOf("</bean>") + 8;
        if (x != -1) {
            newContent = content.substring(0, x - 1) + sb.toString() + content.substring(y, content.length());
        } else {
            x = content.indexOf("</beans>");
            if (x != -1) {
                newContent = content.substring(0, x) + sb.toString() + content.substring(x, content.length());
            } else {
                x = content.indexOf("<beans/>");
                y = x + 8;
                newContent = content.substring(0, x) + "<beans>" + sb.toString() + "</beans>" + content.substring(y, content.length());
            }
        }
        newContent = this._formatXml(newContent);
        if (!content.equals(newContent)) {
            FileUtil.write((File)outputFile, (String)newContent);
            System.out.println(outputFile.toString());
        }
    }

    private void _createService(Entity entity, int sessionType) throws Exception {
        String serviceComments = "This is a remote service. Methods of this service are expected to have security checks based on the propagated JAAS credentials because this service can be accessed remotely.";
        JavaClass javaClass = this._getJavaClass(this._outputPath + "/service/impl/" + entity.getName() + (sessionType != 0 ? "Local" : "") + "ServiceImpl.java");
        Object[] methods = this._getMethods(javaClass);
        if (sessionType == 1) {
            if (javaClass.getSuperClass().getValue().endsWith(entity.getName() + "LocalServiceBaseImpl")) {
                JavaClass parentJavaClass = this._getJavaClass(this._outputPath + "/service/base/" + entity.getName() + "LocalServiceBaseImpl.java");
                Object[] parentMethods = parentJavaClass.getMethods();
                Object[] allMethods = new JavaMethod[parentMethods.length + methods.length];
                ArrayUtil.combine((Object[])parentMethods, (Object[])methods, (Object[])allMethods);
                methods = allMethods;
            }
            serviceComments = "This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.";
        }
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", methods);
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        context.put("serviceComments", serviceComments);
        String content = this._processTemplate(this._tplService, context);
        File ejbFile = new File(this._serviceOutputPath + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "Service.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
        if (!this._serviceOutputPath.equals(this._outputPath) && (ejbFile = new File(this._outputPath + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "Service.java")).exists()) {
            System.out.println("Relocating " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createServiceBaseImpl(Entity entity, int sessionType) throws Exception {
        JavaClass javaClass = this._getJavaClass(this._outputPath + "/service/impl/" + entity.getName() + (sessionType != 0 ? "Local" : "") + "ServiceImpl.java");
        JavaMethod[] methods = this._getMethods(javaClass);
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", methods);
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        context.put("referenceList", this._mergeReferenceList(entity.getReferenceList()));
        String content = this._processTemplate(this._tplServiceBaseImpl, context);
        File ejbFile = new File(this._outputPath + "/service/base/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceBaseImpl.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createServiceClp(Entity entity, int sessionType) throws Exception {
        if (Validator.isNull((String)this._pluginName)) {
            return;
        }
        JavaClass javaClass = this._getJavaClass(this._serviceOutputPath + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "Service.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        String content = this._processTemplate(this._tplServiceClp, context);
        File ejbFile = new File(this._serviceOutputPath + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceClp.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createServiceClpMessageListener() throws Exception {
        if (Validator.isNull((String)this._pluginName)) {
            return;
        }
        Map<String, Object> context = this._getContext();
        context.put("entities", this._ejbList);
        String content = this._processTemplate(this._tplServiceClpMessageListener, context);
        File ejbFile = new File(this._serviceOutputPath + "/service/messaging/ClpMessageListener.java");
        ServiceBuilder.writeFile(ejbFile, content);
    }

    private void _createServiceClpSerializer() throws Exception {
        if (Validator.isNull((String)this._pluginName)) {
            return;
        }
        Map<String, Object> context = this._getContext();
        context.put("entities", this._ejbList);
        String content = this._processTemplate(this._tplServiceClpSerializer, context);
        File ejbFile = new File(this._serviceOutputPath + "/service/ClpSerializer.java");
        ServiceBuilder.writeFile(ejbFile, content);
    }

    private void _createServiceFactory(Entity entity, int sessionType) throws Exception {
        File ejbFile = new File(this._serviceOutputPath + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceFactory.java");
        if (ejbFile.exists()) {
            System.out.println("Removing deprecated " + ejbFile);
            ejbFile.delete();
        }
        if ((ejbFile = new File(this._outputPath + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceFactory.java")).exists()) {
            System.out.println("Removing deprecated " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createServiceHttp(Entity entity) throws Exception {
        JavaClass javaClass = this._getJavaClass(this._outputPath + "/service/impl/" + entity.getName() + "ServiceImpl.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        context.put("hasHttpMethods", new Boolean(this._hasHttpMethods(javaClass)));
        String content = this._processTemplate(this._tplServiceHttp, context);
        File ejbFile = new File(this._outputPath + "/service/http/" + entity.getName() + "ServiceHttp.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createServiceImpl(Entity entity, int sessionType) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        String content = this._processTemplate(this._tplServiceImpl, context);
        File ejbFile = new File(this._outputPath + "/service/impl/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceImpl.java");
        if (!ejbFile.exists()) {
            ServiceBuilder.writeFile(ejbFile, content, this._author);
        }
    }

    private void _createServiceJson(Entity entity) throws Exception {
        File ejbFile = new File(this._outputPath + "/service/http/" + entity.getName() + "ServiceJSON.java");
        if (ejbFile.exists()) {
            System.out.println("Removing deprecated " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createServiceJsonSerializer(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplServiceJsonSerializer, context);
        File ejbFile = new File(this._outputPath + "/service/http/" + entity.getName() + "JSONSerializer.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createServiceSoap(Entity entity) throws Exception {
        JavaClass javaClass = this._getJavaClass(this._outputPath + "/service/impl/" + entity.getName() + "ServiceImpl.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        String content = this._processTemplate(this._tplServiceSoap, context);
        File ejbFile = new File(this._outputPath + "/service/http/" + entity.getName() + "ServiceSoap.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createServiceUtil(Entity entity, int sessionType) throws Exception {
        JavaClass javaClass = this._getJavaClass(this._serviceOutputPath + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "Service.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        String content = this._processTemplate(this._tplServiceUtil, context);
        File ejbFile = new File(this._serviceOutputPath + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceUtil.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
        if (!this._serviceOutputPath.equals(this._outputPath) && (ejbFile = new File(this._outputPath + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceUtil.java")).exists()) {
            System.out.println("Relocating " + ejbFile);
            ejbFile.delete();
        }
    }

    private void _createServiceWrapper(Entity entity, int sessionType) throws Exception {
        JavaClass javaClass = this._getJavaClass(this._serviceOutputPath + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "Service.java");
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        String content = this._processTemplate(this._tplServiceWrapper, context);
        File ejbFile = new File(this._serviceOutputPath + "/service/" + entity.getName() + this._getSessionTypeName(sessionType) + "ServiceWrapper.java");
        ServiceBuilder.writeFile(ejbFile, content, this._author);
    }

    private void _createSpringBaseXml() throws Exception {
        if (Validator.isNull((String)this._springBaseFileName)) {
            return;
        }
        String content = this._processTemplate(this._tplSpringBaseXml);
        File ejbFile = new File(this._springBaseFileName);
        FileUtil.write((File)ejbFile, (String)content, (boolean)true);
        if (Validator.isNotNull((String)this._pluginName)) {
            FileUtil.delete((String)"docroot/WEB-INF/src/META-INF/data-source-spring.xml");
            FileUtil.delete((String)"docroot/WEB-INF/src/META-INF/misc-spring.xml");
        }
    }

    private void _createSpringDynamicDataSourceXml() throws Exception {
        if (Validator.isNull((String)this._springDynamicDataSourceFileName)) {
            return;
        }
        String content = this._processTemplate(this._tplSpringDynamicDataSourceXml);
        File ejbFile = new File(this._springDynamicDataSourceFileName);
        FileUtil.write((File)ejbFile, (String)content, (boolean)true);
    }

    private void _createSpringHibernateXml() throws Exception {
        if (Validator.isNull((String)this._springHibernateFileName)) {
            return;
        }
        String content = this._processTemplate(this._tplSpringHibernateXml);
        File ejbFile = new File(this._springHibernateFileName);
        FileUtil.write((File)ejbFile, (String)content, (boolean)true);
    }

    private void _createSpringInfrastructureXml() throws Exception {
        if (Validator.isNull((String)this._springInfrastructureFileName)) {
            return;
        }
        String content = this._processTemplate(this._tplSpringInfrastructureXml);
        File ejbFile = new File(this._springInfrastructureFileName);
        FileUtil.write((File)ejbFile, (String)content, (boolean)true);
    }

    private void _createSpringXml() throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entities", this._ejbList);
        String content = this._processTemplate(this._tplSpringXml, context);
        File xmlFile = new File(this._springFileName);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<beans\n\tdefault-init-method=\"afterPropertiesSet\"\n\txmlns=\"http://www.springframework.org/schema/beans\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.5.xsd\"\n>\n</beans>";
        if (!xmlFile.exists()) {
            FileUtil.write((File)xmlFile, (String)xml);
        }
        String oldContent = FileUtil.read((File)xmlFile);
        if (Validator.isNotNull((String)this._pluginName) && oldContent.contains("DOCTYPE beans PUBLIC")) {
            oldContent = xml;
        }
        String newContent = this._fixSpringXml(oldContent);
        int x = oldContent.indexOf("<beans");
        int y = oldContent.lastIndexOf("</beans>");
        int firstSession = newContent.indexOf("<bean id=\"" + this._packagePath + ".service.", x);
        int lastSession = newContent.lastIndexOf("<bean id=\"" + this._packagePath + ".service.", y);
        if (firstSession == -1 || firstSession > y) {
            x = newContent.indexOf("</beans>");
            newContent = newContent.substring(0, x) + content + newContent.substring(x, newContent.length());
        } else {
            firstSession = newContent.lastIndexOf("<bean", firstSession) - 1;
            int tempLastSession = newContent.indexOf("<bean id=\"", lastSession + 1);
            if (tempLastSession == -1) {
                tempLastSession = newContent.indexOf("</beans>", lastSession);
            }
            lastSession = tempLastSession;
            newContent = newContent.substring(0, firstSession) + content + newContent.substring(lastSession, newContent.length());
        }
        newContent = this._formatXml(newContent);
        if (!oldContent.equals(newContent)) {
            FileUtil.write((File)xmlFile, (String)newContent);
        }
    }

    private void _createSQLIndexes() throws IOException {
        String indexMapping;
        String indexSQL;
        if (!FileUtil.exists((String)this._sqlDir)) {
            return;
        }
        File sqlFile = new File(this._sqlDir + "/" + this._sqlIndexesFileName);
        if (!sqlFile.exists()) {
            FileUtil.write((File)sqlFile, (String)"");
        }
        TreeMap<String, String> indexSQLs = new TreeMap<String, String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new FileReader(sqlFile));
        while ((indexSQL = unsyncBufferedReader.readLine()) != null) {
            if (!Validator.isNotNull((String)indexSQL.trim())) continue;
            int pos = indexSQL.indexOf(" on ");
            String indexSpec = indexSQL.substring(pos + 4);
            indexSQLs.put(indexSpec, indexSQL);
        }
        unsyncBufferedReader.close();
        File propsFile = new File(this._sqlDir + "/" + this._sqlIndexesPropertiesFileName);
        if (!propsFile.exists()) {
            FileUtil.write((File)propsFile, (String)"");
        }
        TreeMap<String, String> indexProps = new TreeMap<String, String>();
        unsyncBufferedReader = new UnsyncBufferedReader((Reader)new FileReader(propsFile));
        while ((indexMapping = unsyncBufferedReader.readLine()) != null) {
            if (!Validator.isNotNull((String)indexMapping.trim())) continue;
            String[] splitIndexMapping = indexMapping.split("\\=");
            indexProps.put(splitIndexMapping[1], splitIndexMapping[0]);
        }
        unsyncBufferedReader.close();
        for (int i = 0; i < this._ejbList.size(); ++i) {
            Entity entity = this._ejbList.get(i);
            if (!entity.isDefaultDataSource()) continue;
            List<EntityFinder> finderList = entity.getFinderList();
            for (int j = 0; j < finderList.size(); ++j) {
                EntityFinder finder = finderList.get(j);
                if (!finder.isDBIndex()) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(entity.getTable() + " (");
                List<EntityColumn> finderColsList = finder.getColumns();
                for (int k = 0; k < finderColsList.size(); ++k) {
                    EntityColumn col = finderColsList.get(k);
                    sb.append(col.getDBName());
                    if (k + 1 == finderColsList.size()) continue;
                    sb.append(", ");
                }
                sb.append(");");
                String indexSpec = sb.toString();
                String indexHash = Integer.toHexString(indexSpec.hashCode()).toUpperCase();
                String indexName = "IX_" + indexHash;
                sb = new StringBuilder();
                sb.append("create ");
                if (finder.isUnique()) {
                    sb.append("unique ");
                }
                sb.append("index " + indexName + " on ");
                sb.append(indexSpec);
                indexSQLs.put(indexSpec, sb.toString());
                String finderName = entity.getTable() + "." + finder.getName();
                indexProps.put(finderName, indexName);
            }
        }
        for (Map.Entry<String, EntityMapping> entry : this._entityMappings.entrySet()) {
            EntityMapping entityMapping = entry.getValue();
            this._getCreateMappingTableIndex(entityMapping, indexSQLs, indexProps);
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Object> itr = indexSQLs.values().iterator();
        String prevEntityName = null;
        while (itr.hasNext()) {
            String indexSQL2 = (String)itr.next();
            int pos = indexSQL2.indexOf(" on ");
            String indexSQLSuffix = indexSQL2.substring(pos + 4);
            String entityName = indexSQLSuffix.split(" ")[0];
            if (prevEntityName != null && !prevEntityName.equals(entityName)) {
                sb.append("\n");
            }
            sb.append(indexSQL2);
            if (itr.hasNext()) {
                sb.append("\n");
            }
            prevEntityName = entityName;
        }
        FileUtil.write((File)sqlFile, (String)sb.toString(), (boolean)true);
        sb = new StringBuilder();
        itr = indexProps.keySet().iterator();
        prevEntityName = null;
        while (itr.hasNext()) {
            String finderName = (String)itr.next();
            String indexName = (String)indexProps.get(finderName);
            String entityName = finderName.split("\\.")[0];
            if (prevEntityName != null && !prevEntityName.equals(entityName)) {
                sb.append("\n");
            }
            sb.append(indexName + "=" + finderName);
            if (itr.hasNext()) {
                sb.append("\n");
            }
            prevEntityName = entityName;
        }
        FileUtil.write((File)propsFile, (String)sb.toString(), (boolean)true);
    }

    private void _createSQLMappingTables(File sqlFile, String newCreateTableString, EntityMapping entityMapping, boolean addMissingTables) throws IOException {
        if (!sqlFile.exists()) {
            FileUtil.write((File)sqlFile, (String)"");
        }
        String content = FileUtil.read((File)sqlFile);
        int x = content.indexOf(_SQL_CREATE_TABLE + entityMapping.getTable() + " (");
        int y = content.indexOf(");", x);
        if (x != -1) {
            String oldCreateTableString = content.substring(x + 1, y);
            if (!oldCreateTableString.equals(newCreateTableString)) {
                content = content.substring(0, x) + newCreateTableString + content.substring(y + 2, content.length());
                FileUtil.write((File)sqlFile, (String)content);
            }
        } else if (addMissingTables) {
            StringBuilder sb = new StringBuilder();
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
            String line = null;
            boolean appendNewTable = true;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String tableName;
                if (appendNewTable && line.startsWith(_SQL_CREATE_TABLE) && (tableName = line.substring(x = _SQL_CREATE_TABLE.length(), y = line.indexOf(" ", x))).compareTo(entityMapping.getTable()) > 0) {
                    sb.append(newCreateTableString + "\n\n");
                    appendNewTable = false;
                }
                sb.append(line);
                sb.append("\n");
            }
            if (appendNewTable) {
                sb.append("\n" + newCreateTableString);
            }
            unsyncBufferedReader.close();
            FileUtil.write((File)sqlFile, (String)sb.toString(), (boolean)true);
        }
    }

    private void _createSQLSequences() throws IOException {
        String sequenceSQL;
        if (!FileUtil.exists((String)this._sqlDir)) {
            return;
        }
        File sqlFile = new File(this._sqlDir + "/" + this._sqlSequencesFileName);
        if (!sqlFile.exists()) {
            FileUtil.write((File)sqlFile, (String)"");
        }
        TreeSet<String> sequenceSQLs = new TreeSet<String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new FileReader(sqlFile));
        while ((sequenceSQL = unsyncBufferedReader.readLine()) != null) {
            if (!Validator.isNotNull((String)sequenceSQL)) continue;
            sequenceSQLs.add(sequenceSQL);
        }
        unsyncBufferedReader.close();
        for (int i = 0; i < this._ejbList.size(); ++i) {
            Entity entity = this._ejbList.get(i);
            if (!entity.isDefaultDataSource()) continue;
            List<EntityColumn> columnList = entity.getColumnList();
            for (int j = 0; j < columnList.size(); ++j) {
                EntityColumn column = columnList.get(j);
                if (!"sequence".equals(column.getIdType())) continue;
                StringBuilder sb = new StringBuilder();
                String sequenceName = column.getIdParam();
                if (sequenceName.length() > 30) {
                    sequenceName = sequenceName.substring(0, 30);
                }
                sb.append("create sequence " + sequenceName + ";");
                String sequenceSQL2 = sb.toString();
                if (sequenceSQLs.contains(sequenceSQL2)) continue;
                sequenceSQLs.add(sequenceSQL2);
            }
        }
        StringBuilder sb = new StringBuilder();
        Iterator itr = sequenceSQLs.iterator();
        while (itr.hasNext()) {
            String sequenceSQL3 = (String)itr.next();
            sb.append(sequenceSQL3);
            if (!itr.hasNext()) continue;
            sb.append("\n");
        }
        FileUtil.write((File)sqlFile, (String)sb.toString(), (boolean)true);
    }

    private void _createSQLTables() throws IOException {
        if (!FileUtil.exists((String)this._sqlDir)) {
            return;
        }
        File sqlFile = new File(this._sqlDir + "/" + this._sqlFileName);
        if (!sqlFile.exists()) {
            FileUtil.write((File)sqlFile, (String)"");
        }
        for (int i = 0; i < this._ejbList.size(); ++i) {
            String createTableSQL;
            Entity entity = this._ejbList.get(i);
            if (!entity.isDefaultDataSource() || !Validator.isNotNull((String)(createTableSQL = this._getCreateTableSQL(entity)))) continue;
            this._createSQLTables(sqlFile, createTableSQL, entity, true);
            File updateSQLFile = new File(this._sqlDir + "/update-5.2.6-5.2.7.sql");
            if (!updateSQLFile.exists()) continue;
            this._createSQLTables(updateSQLFile, createTableSQL, entity, false);
        }
        for (Map.Entry<String, EntityMapping> entry : this._entityMappings.entrySet()) {
            EntityMapping entityMapping = entry.getValue();
            String createMappingTableSQL = this._getCreateMappingTableSQL(entityMapping);
            if (!Validator.isNotNull((String)createMappingTableSQL)) continue;
            this._createSQLMappingTables(sqlFile, createMappingTableSQL, entityMapping, true);
        }
    }

    private void _createSQLTables(File sqlFile, String newCreateTableString, Entity entity, boolean addMissingTables) throws IOException {
        if (!sqlFile.exists()) {
            FileUtil.write((File)sqlFile, (String)"");
        }
        String content = FileUtil.read((File)sqlFile);
        int x = content.indexOf(_SQL_CREATE_TABLE + entity.getTable() + " (");
        int y = content.indexOf(");", x);
        if (x != -1) {
            String oldCreateTableString = content.substring(x + 1, y);
            if (!oldCreateTableString.equals(newCreateTableString)) {
                content = content.substring(0, x) + newCreateTableString + content.substring(y + 2, content.length());
                FileUtil.write((File)sqlFile, (String)content);
            }
        } else if (addMissingTables) {
            StringBuilder sb = new StringBuilder();
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
            String line = null;
            boolean appendNewTable = true;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String tableName;
                if (appendNewTable && line.startsWith(_SQL_CREATE_TABLE) && (tableName = line.substring(x = _SQL_CREATE_TABLE.length(), y = line.indexOf(" ", x))).compareTo(entity.getTable()) > 0) {
                    sb.append(newCreateTableString + "\n\n");
                    appendNewTable = false;
                }
                sb.append(line);
                sb.append("\n");
            }
            if (appendNewTable) {
                sb.append("\n" + newCreateTableString);
            }
            unsyncBufferedReader.close();
            FileUtil.write((File)sqlFile, (String)sb.toString(), (boolean)true);
        }
    }

    private String _fixHbmXml(String content) throws IOException {
        StringBuilder sb = new StringBuilder();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith("\t<class name=\"") && (line = StringUtil.replace((String)line, (String[])new String[]{".service.persistence.", "HBM\" table=\""}, (String[])new String[]{".model.", "\" table=\""})).indexOf(".model.impl.") == -1) {
                line = StringUtil.replace((String)line, (String[])new String[]{".model.", "\" table=\""}, (String[])new String[]{".model.impl.", "Impl\" table=\""});
            }
            sb.append(line);
            sb.append('\n');
        }
        unsyncBufferedReader.close();
        return sb.toString().trim();
    }

    private String _fixSpringXml(String content) {
        return StringUtil.replace((String)content, (String)".service.spring.", (String)".service.");
    }

    private String _formatXml(String xml) throws DocumentException, IOException {
        String doctype = null;
        int x = xml.indexOf("<!DOCTYPE");
        if (x != -1) {
            int y = xml.indexOf(">", x) + 1;
            doctype = xml.substring(x, y);
            xml = xml.substring(0, x) + "\n" + xml.substring(y);
        }
        xml = StringUtil.replace((String)xml, (char)'\r', (String)"");
        xml = XMLFormatter.toString((String)xml);
        xml = StringUtil.replace((String)xml, (String)"\"/>", (String)"\" />");
        if (Validator.isNotNull((String)doctype)) {
            x = xml.indexOf("?>") + 2;
            xml = xml.substring(0, x) + "\n" + doctype + xml.substring(x);
        }
        return xml;
    }

    private Map<String, Object> _getContext() throws TemplateModelException {
        BeansWrapper wrapper = BeansWrapper.getDefaultInstance();
        TemplateHashModel staticModels = wrapper.getStaticModels();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("hbmFileName", this._hbmFileName);
        context.put("modelHintsFileName", this._modelHintsFileName);
        context.put("springFileName", this._springFileName);
        context.put("springBaseFileName", this._springBaseFileName);
        context.put("springHibernateFileName", this._springHibernateFileName);
        context.put("springInfrastructureFileName", this._springInfrastructureFileName);
        context.put("apiDir", this._apiDir);
        context.put("implDir", this._implDir);
        context.put("jsonFileName", this._jsonFileName);
        context.put("sqlDir", this._sqlDir);
        context.put("sqlFileName", this._sqlFileName);
        context.put("beanLocatorUtil", this._beanLocatorUtil);
        context.put("beanLocatorUtilShortName", this._beanLocatorUtilShortName);
        context.put("propsUtil", this._propsUtil);
        context.put("portletName", this._portletName);
        context.put("portletShortName", this._portletShortName);
        context.put("portletPackageName", this._portletPackageName);
        context.put("outputPath", this._outputPath);
        context.put("serviceOutputPath", this._serviceOutputPath);
        context.put("packagePath", this._packagePath);
        context.put("pluginName", this._pluginName);
        context.put("author", this._author);
        context.put("serviceBuilder", this);
        context.put("arrayUtil", ArrayUtil_IW.getInstance());
        context.put("modelHintsUtil", staticModels.get("com.liferay.portal.model.ModelHintsUtil"));
        context.put("stringUtil", StringUtil_IW.getInstance());
        context.put("system", staticModels.get("java.lang.System"));
        context.put("tempMap", wrapper.wrap(new HashMap()));
        context.put("validator", staticModels.get("com.liferay.portal.kernel.util.Validator"));
        return context;
    }

    private void _getCreateMappingTableIndex(EntityMapping entityMapping, Map<String, String> indexSQLs, Map<String, String> indexProps) throws IOException {
        int i;
        Entity[] entities = new Entity[2];
        for (i = 0; i < entities.length; ++i) {
            entities[i] = this.getEntity(entityMapping.getEntity(i));
            if (entities[i] != null) continue;
            return;
        }
        for (i = 0; i < entities.length; ++i) {
            Entity entity = entities[i];
            List<EntityColumn> pkList = entity.getPKList();
            for (int j = 0; j < pkList.size(); ++j) {
                EntityColumn col = pkList.get(j);
                String colName = col.getName();
                String indexSpec = entityMapping.getTable() + " (" + colName + ");";
                String indexHash = Integer.toHexString(indexSpec.hashCode()).toUpperCase();
                String indexName = "IX_" + indexHash;
                StringBuilder sb = new StringBuilder();
                sb.append("create index " + indexName + " on ");
                sb.append(indexSpec);
                indexSQLs.put(indexSpec, sb.toString());
                String finderName = entityMapping.getTable() + "." + colName;
                indexProps.put(finderName, indexName);
            }
        }
    }

    private String _getCreateMappingTableSQL(EntityMapping entityMapping) throws IOException {
        Entity[] entities = new Entity[2];
        for (int i = 0; i < entities.length; ++i) {
            entities[i] = this.getEntity(entityMapping.getEntity(i));
            if (entities[i] != null) continue;
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(_SQL_CREATE_TABLE + entityMapping.getTable() + " (\n");
        for (Entity entity : entities) {
            List<EntityColumn> pkList = entity.getPKList();
            for (int i = 0; i < pkList.size(); ++i) {
                EntityColumn col = pkList.get(i);
                String colName = col.getName();
                String colType = col.getType();
                sb.append("\t" + col.getDBName());
                sb.append(" ");
                if (colType.equalsIgnoreCase("boolean")) {
                    sb.append("BOOLEAN");
                } else if (colType.equalsIgnoreCase("double") || colType.equalsIgnoreCase("float")) {
                    sb.append("DOUBLE");
                } else if (colType.equals("int") || colType.equals("Integer") || colType.equalsIgnoreCase("short")) {
                    sb.append("INTEGER");
                } else if (colType.equalsIgnoreCase("long")) {
                    sb.append("LONG");
                } else if (colType.equals("String")) {
                    Map hints = ModelHintsUtil.getHints((String)(this._packagePath + ".model." + entity.getName()), (String)colName);
                    int maxLength = 75;
                    if (hints != null) {
                        maxLength = GetterUtil.getInteger((String)((String)hints.get("max-length")), (int)maxLength);
                    }
                    if (col.isLocalized()) {
                        maxLength = 4000;
                    }
                    if (maxLength < 4000) {
                        sb.append("VARCHAR(" + maxLength + ")");
                    } else if (maxLength == 4000) {
                        sb.append("STRING");
                    } else if (maxLength > 4000) {
                        sb.append("TEXT");
                    }
                } else if (colType.equals("Date")) {
                    sb.append("DATE null");
                } else {
                    sb.append("invalid");
                }
                if (col.isPrimary()) {
                    sb.append(" not null");
                }
                sb.append(",\n");
            }
        }
        sb.append("\tprimary key (");
        for (int i = 0; i < entities.length; ++i) {
            Entity entity = entities[i];
            List<EntityColumn> pkList = entity.getPKList();
            for (int j = 0; j < pkList.size(); ++j) {
                EntityColumn col = pkList.get(j);
                String colName = col.getName();
                if (i != 0 || j != 0) {
                    sb.append(", ");
                }
                sb.append(colName);
            }
        }
        sb.append(")\n");
        sb.append(");");
        return sb.toString();
    }

    private String _getCreateTableSQL(Entity entity) {
        List<EntityColumn> pkList = entity.getPKList();
        List<EntityColumn> regularColList = entity.getRegularColList();
        if (regularColList.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(_SQL_CREATE_TABLE + entity.getTable() + " (\n");
        for (int i = 0; i < regularColList.size(); ++i) {
            EntityColumn col = regularColList.get(i);
            String colName = col.getName();
            String colType = col.getType();
            String colIdType = col.getIdType();
            sb.append("\t" + col.getDBName());
            sb.append(" ");
            if (colType.equalsIgnoreCase("boolean")) {
                sb.append("BOOLEAN");
            } else if (colType.equalsIgnoreCase("double") || colType.equalsIgnoreCase("float")) {
                sb.append("DOUBLE");
            } else if (colType.equals("int") || colType.equals("Integer") || colType.equalsIgnoreCase("short")) {
                sb.append("INTEGER");
            } else if (colType.equalsIgnoreCase("long")) {
                sb.append("LONG");
            } else if (colType.equals("String")) {
                Map hints = ModelHintsUtil.getHints((String)(this._packagePath + ".model." + entity.getName()), (String)colName);
                int maxLength = 75;
                if (hints != null) {
                    maxLength = GetterUtil.getInteger((String)((String)hints.get("max-length")), (int)maxLength);
                }
                if (col.isLocalized()) {
                    maxLength = 4000;
                }
                if (maxLength < 4000) {
                    sb.append("VARCHAR(" + maxLength + ")");
                } else if (maxLength == 4000) {
                    sb.append("STRING");
                } else if (maxLength > 4000) {
                    sb.append("TEXT");
                }
            } else if (colType.equals("Date")) {
                sb.append("DATE null");
            } else {
                sb.append("invalid");
            }
            if (col.isPrimary()) {
                sb.append(" not null");
                if (!entity.hasCompoundPK()) {
                    sb.append(" primary key");
                }
            } else if (colType.equals("String")) {
                sb.append(" null");
            }
            if (Validator.isNotNull((String)colIdType) && colIdType.equals("identity")) {
                sb.append(" IDENTITY");
            }
            if (i + 1 != regularColList.size() || entity.hasCompoundPK()) {
                sb.append(",");
            }
            sb.append("\n");
        }
        if (entity.hasCompoundPK()) {
            sb.append("\tprimary key (");
            for (int j = 0; j < pkList.size(); ++j) {
                EntityColumn pk = pkList.get(j);
                sb.append(pk.getDBName());
                if (j + 1 == pkList.size()) continue;
                sb.append(", ");
            }
            sb.append(")\n");
        }
        sb.append(");");
        return sb.toString();
    }

    private String _getDimensions(Type type) {
        String dimensions = "";
        for (int i = 0; i < type.getDimensions(); ++i) {
            dimensions = dimensions + "[]";
        }
        return dimensions;
    }

    private JavaClass _getJavaClass(String fileName) throws IOException {
        int pos = fileName.indexOf(this._implDir + "/");
        pos = pos != -1 ? (pos += this._implDir.length()) : fileName.indexOf(this._apiDir + "/") + this._apiDir.length();
        String srcFile = fileName.substring(pos + 1, fileName.length());
        String className = StringUtil.replace((String)srcFile.substring(0, srcFile.length() - 5), (String)"/", (String)".");
        JavaDocBuilder builder = new JavaDocBuilder();
        File file = new File(fileName);
        if (!file.exists()) {
            return null;
        }
        builder.addSource(file);
        return builder.getClassByName(className);
    }

    private JavaMethod[] _getMethods(JavaClass javaClass) {
        return this._getMethods(javaClass, false);
    }

    private JavaMethod[] _getMethods(JavaClass javaClass, boolean superclasses) {
        JavaMethod[] methods;
        for (JavaMethod method : methods = javaClass.getMethods(superclasses)) {
            Arrays.sort(method.getExceptions());
        }
        return methods;
    }

    private String _getSessionTypeName(int sessionType) {
        if (sessionType == 1) {
            return "Local";
        }
        return "";
    }

    private String _getTplProperty(String key, String defaultValue) {
        return System.getProperty("service.tpl." + key, defaultValue);
    }

    private boolean _hasHttpMethods(JavaClass javaClass) {
        JavaMethod[] methods = this._getMethods(javaClass);
        for (int i = 0; i < methods.length; ++i) {
            JavaMethod javaMethod = methods[i];
            if (javaMethod.isConstructor() || !javaMethod.isPublic() || !this.isCustomMethod(javaMethod)) continue;
            return true;
        }
        return false;
    }

    private List<Entity> _mergeReferenceList(List<Entity> referenceList) {
        ArrayList<Entity> list = new ArrayList<Entity>(this._ejbList.size() + referenceList.size());
        list.addAll(this._ejbList);
        list.addAll(referenceList);
        return list;
    }

    private String _processTemplate(String name) throws Exception {
        return this._processTemplate(name, this._getContext());
    }

    private String _processTemplate(String name, Map<String, Object> context) throws Exception {
        return FreeMarkerUtil.process(name, context);
    }
}

