/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

public class UpgradeProcessUtil {
    private static Log _log = LogFactoryUtil.getLog(UpgradeProcessUtil.class);

    public static boolean upgradeProcess(int buildNumber, String[] upgradeProcessClassNames, ClassLoader classLoader) throws UpgradeException {
        boolean ranUpgradeProcess = false;
        for (String upgradeProcessClassName : upgradeProcessClassNames) {
            boolean tempRanUpgradeProcess = UpgradeProcessUtil._upgradeProcess(buildNumber, upgradeProcessClassName, classLoader);
            if (!tempRanUpgradeProcess) continue;
            ranUpgradeProcess = true;
        }
        return ranUpgradeProcess;
    }

    private static boolean _upgradeProcess(int buildNumber, String upgradeProcessClassName, ClassLoader classLoader) throws UpgradeException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Initializing upgrade " + upgradeProcessClassName));
        }
        UpgradeProcess upgradeProcess = null;
        try {
            upgradeProcess = (UpgradeProcess)classLoader.loadClass(upgradeProcessClassName).newInstance();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (upgradeProcess == null) {
            _log.error((Object)(upgradeProcessClassName + " cannot be found"));
            return false;
        }
        if (upgradeProcess.getThreshold() == 0 || upgradeProcess.getThreshold() > buildNumber) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Running upgrade " + upgradeProcessClassName));
            }
            upgradeProcess.upgrade();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Finished upgrade " + upgradeProcessClassName));
            }
            return true;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Upgrade threshold " + upgradeProcess.getThreshold() + " will not trigger upgrade"));
            _log.debug((Object)("Skipping upgrade " + upgradeProcessClassName));
        }
        return false;
    }
}

