/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upgrade.util.Table;

public abstract class BaseUpgradeTableImpl
extends Table {
    static Log _log = LogFactoryUtil.getLog(BaseUpgradeTableImpl.class);
    private boolean _calledUpdateTable;

    public BaseUpgradeTableImpl(String tableName) {
        super(tableName);
    }

    public BaseUpgradeTableImpl(String tableName, Object[][] columns) {
        super(tableName, columns);
    }

    public void setCreateSQL(String createSQL) throws Exception {
        if (this._calledUpdateTable) {
            throw new UpgradeException("setCreateSQL is called after updateTable");
        }
        super.setCreateSQL(createSQL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTable() throws Exception {
        this._calledUpdateTable = true;
        String tempFileName = this.generateTempFile();
        try {
            DB db = DBFactoryUtil.getDB();
            String createSQL = this.getCreateSQL();
            if (Validator.isNotNull((String)createSQL)) {
                db.runSQL("drop table " + this.getTableName());
                db.runSQL(createSQL);
            }
            if (Validator.isNotNull((String)tempFileName)) {
                String deleteSQL = this.getDeleteSQL();
                db.runSQL(deleteSQL);
                this.populateTable(tempFileName);
            }
        }
        finally {
            if (Validator.isNotNull((String)tempFileName)) {
                FileUtil.delete((String)tempFileName);
            }
        }
    }
}

