/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v4_3_5;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradePortletId
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        String[][] portletIdsArray = this.getPortletIdsArray();
        for (int i = 0; i < portletIdsArray.length; ++i) {
            String[] portletIds = portletIdsArray[i];
            String oldRootPortletId = portletIds[0];
            String newRootPortletId = portletIds[1];
            this.updatePortlet(oldRootPortletId, newRootPortletId);
            this.updateResource(oldRootPortletId, newRootPortletId);
            this.updateResourceCode(oldRootPortletId, newRootPortletId);
        }
    }

    protected String[][] getPortletIdsArray() {
        return new String[][]{{"94", "1_WAR_googleadsenseportlet"}, {"95", "1_WAR_googlegadgetportlet"}, {"96", "1_WAR_googlemapsportlet"}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLayout(long plid, String oldPortletId, String newPortletId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select typeSettings from Layout where plid = " + plid);
            rs = ps.executeQuery();
            while (rs.next()) {
                String typeSettings = rs.getString("typeSettings");
                String newTypeSettings = StringUtil.replace((String)typeSettings, (String)oldPortletId, (String)newPortletId);
                this.updateTypeSettings(plid, newTypeSettings);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updatePortlet(String oldRootPortletId, String newRootPortletId) throws Exception {
        this.runSQL("update Portlet set portletId = '" + newRootPortletId + "' where portletId = '" + oldRootPortletId + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateResource(String oldRootPortletId, String newRootPortletId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select primKey from Resource_ where primKey like ?");
            ps.setString(1, "%_LAYOUT_" + oldRootPortletId + "_INSTANCE_" + "%");
            rs = ps.executeQuery();
            while (rs.next()) {
                String oldPrimKey = rs.getString("primKey");
                int pos = oldPrimKey.indexOf("_LAYOUT_");
                long plid = GetterUtil.getLong((String)oldPrimKey.substring(0, pos));
                pos = oldPrimKey.indexOf("_INSTANCE_");
                String instanceId = oldPrimKey.substring(pos + "_INSTANCE_".length());
                String newPrimKey = plid + "_LAYOUT_" + newRootPortletId + "_INSTANCE_" + instanceId;
                this.runSQL("update Resource_ set primKey = '" + newPrimKey + "' where primKey = '" + oldPrimKey + "'");
                String oldPortletId = oldRootPortletId + "_INSTANCE_" + instanceId;
                String newPortletId = newRootPortletId + "_INSTANCE_" + instanceId;
                this.updateLayout(plid, oldPortletId, newPortletId);
                this.runSQL("update PortletPreferences set portletId = '" + newPortletId + "' where portletId = '" + oldPortletId + "'");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateResourceCode(String oldRootPortletId, String newRootPortletId) throws Exception {
        this.runSQL("update ResourceCode set name = '" + newRootPortletId + "' where name = '" + oldRootPortletId + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTypeSettings(long plid, String typeSettings) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("update Layout set typeSettings = ? where plid = " + plid);
            ps.setString(1, typeSettings);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }
}

