/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v4_4_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Location;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.UserGroup;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradePermission
extends UpgradeProcess {
    private static Object[][] _DELETE_PERMISSIONS = new Object[][]{{"ADMINISTRATE", Group.class}, {"ADD_USER", Location.class}, {"ADD_USER", Organization.class}, {"DELETE_USER", Location.class}, {"DELETE_USER", Organization.class}, {"PERMISSIONS_USER", Location.class}, {"PERMISSIONS_USER", Organization.class}, {"UPDATE_USER", Location.class}, {"UPDATE_USER", Organization.class}, {"VIEW_USER", Location.class}, {"VIEW_USER", Organization.class}};
    private static final String _GET_PERMISSION_IDS_1 = "select Permission_.permissionId from Permission_ inner join Resource_ on Resource_.resourceId = Permission_.resourceId inner join ResourceCode on ResourceCode.codeId = Resource_.codeId where Permission_.actionId = ? and ResourceCode.name = ?";
    private static final String _GET_PERMISSION_IDS_2 = "select Users_Permissions.permissionId from Users_Permissions inner join Permission_ on Permission_.permissionId = Users_Permissions.permissionId inner join Resource_ on Resource_.resourceId = Permission_.resourceId inner join ResourceCode on ResourceCode.codeId = Resource_.codeId where ResourceCode.scope = ?";
    private static final String _GET_ROLE_IDS = "select Roles_Permissions.roleId from Roles_Permissions inner join Role_ on Role_.roleId = Roles_Permissions.roleId where Role_.name = ?";
    private static Object[][] _UPDATE_PERMISSIONS = new Object[][]{{"ADD_CATEGORY", "ADD_SUBCATEGORY", MBCategory.class}, {"ADD_CATEGORY", "ADD_SUBCATEGORY", ShoppingCategory.class}, {"ADD_FOLDER", "ADD_SUBFOLDER", DLFolder.class}, {"ADD_FOLDER", "ADD_SUBFOLDER", IGFolder.class}, {"ADD_FOLDER", "ADD_SUBFOLDER", BookmarksFolder.class}, {"ADD_LOCATION", "MANAGE_SUBORGANIZATIONS", Organization.class}, {"ADD_PERMISSIONS", "DEFINE_PERMISSIONS", Role.class}, {"ADD_USER", "MANAGE_USERS", Location.class}, {"ADD_USER", "MANAGE_USERS", Organization.class}, {"ASSIGN_USERS", "ASSIGN_MEMBERS", Group.class}, {"ASSIGN_USERS", "ASSIGN_MEMBERS", Role.class}, {"ASSIGN_USERS", "ASSIGN_MEMBERS", UserGroup.class}};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deletePermissionByActionIdAndResourceName(String actionId, String resourceName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_PERMISSION_IDS_1);
            ps.setString(1, actionId);
            ps.setString(2, resourceName);
            rs = ps.executeQuery();
            while (rs.next()) {
                long permissionId = rs.getLong("permissionId");
                this.deletePermissionByPermissionId(permissionId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void deletePermissionByPermissionId(long permissionId) throws Exception {
        this.runSQL("delete from Permission_ where permissionId = " + permissionId);
        this.runSQL("delete from Groups_Permissions where permissionId = " + permissionId);
        this.runSQL("delete from Roles_Permissions where permissionId = " + permissionId);
        this.runSQL("delete from Users_Permissions where permissionId = " + permissionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deletePermissionByResourceId(long resourceId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select permissionId from Permission_ where resourceId = ?");
            ps.setLong(1, resourceId);
            rs = ps.executeQuery();
            while (rs.next()) {
                long permissionId = rs.getLong("permissionId");
                this.deletePermissionByPermissionId(permissionId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteResource(long codeId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select resourceId from Resource_ where codeId = ?");
            ps.setLong(1, codeId);
            rs = ps.executeQuery();
            while (rs.next()) {
                long resourceId = rs.getLong("resourceId");
                this.deletePermissionByResourceId(resourceId);
                this.runSQL("delete from Resource_ where resourceId = " + resourceId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteResourceCode(String resourceName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select codeId from ResourceCode where name = ?");
            ps.setString(1, resourceName);
            rs = ps.executeQuery();
            while (rs.next()) {
                long codeId = rs.getLong("codeId");
                this.deleteResource(codeId);
                this.runSQL("delete from ResourceCode where name = '" + resourceName + "'");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteRolesPermissions(String roleName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_ROLE_IDS);
            ps.setString(1, roleName);
            rs = ps.executeQuery();
            while (rs.next()) {
                long roleId = rs.getLong("roleId");
                this.runSQL("delete from Roles_Permissions where roleId = " + roleId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteUsersPermissions(int scope) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_PERMISSION_IDS_2);
            ps.setLong(1, scope);
            rs = ps.executeQuery();
            while (rs.next()) {
                long permissionId = rs.getLong("permissionId");
                this.runSQL("delete from Users_Permissions where permissionId = " + permissionId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void doUpgrade() throws Exception {
        Object[] permission;
        int i;
        this.runSQL("delete from OrgGroupPermission");
        for (i = 0; i < _DELETE_PERMISSIONS.length; ++i) {
            permission = _DELETE_PERMISSIONS[i];
            String actionId = (String)permission[0];
            String resourceName = ((Class)permission[1]).getName();
            this.deletePermissionByActionIdAndResourceName(actionId, resourceName);
        }
        for (i = 0; i < _UPDATE_PERMISSIONS.length; ++i) {
            permission = _UPDATE_PERMISSIONS[i];
            String oldActionId = (String)permission[0];
            String newActionId = (String)permission[1];
            String resourceName = ((Class)permission[2]).getName();
            this.updatePermission(oldActionId, newActionId, resourceName);
        }
        this.deleteResourceCode("com.liferay.portlet.blogs.model.BlogsCategory");
        this.deleteRolesPermissions("Community Administrator");
        this.deleteRolesPermissions("Community Owner");
        this.deleteRolesPermissions("Organization Administrator");
        this.deleteUsersPermissions(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePermission(String oldActionId, String newActionId, String resourceName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_PERMISSION_IDS_1);
            ps.setString(1, oldActionId);
            ps.setString(2, resourceName);
            rs = ps.executeQuery();
            while (rs.next()) {
                long permissionId = rs.getLong("permissionId");
                this.runSQL("update Permission_ set actionId = '" + newActionId + "' where permissionId = " + permissionId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

