/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v4_4_0.util;

import com.liferay.portal.kernel.upgrade.util.BaseUpgradeColumnImpl;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFileEntryTitleColumnImpl
extends BaseUpgradeColumnImpl {
    private UpgradeColumn _groupIdColumn;
    private UpgradeColumn _folderIdColumn;
    private UpgradeColumn _nameColumn;
    private int _counter = 0;
    private Set<String> _distinctTitles;

    public DLFileEntryTitleColumnImpl(UpgradeColumn groupIdColumn, UpgradeColumn folderIdColumn, UpgradeColumn nameColumn, Set<String> distinctTitles) {
        super("title", null);
        this._groupIdColumn = groupIdColumn;
        this._folderIdColumn = folderIdColumn;
        this._nameColumn = nameColumn;
        this._distinctTitles = distinctTitles;
    }

    public Object getNewValue(Object oldValue) throws Exception {
        String newTitle = (String)oldValue;
        String name = (String)this._nameColumn.getOldValue();
        String extension = FileUtil.getExtension((String)name);
        newTitle = DLFileEntryImpl.stripExtension(name, newTitle);
        while (this._distinctTitles.contains(this._getKey(newTitle, extension))) {
            ++this._counter;
            StringBuilder sb = new StringBuilder();
            sb.append(newTitle);
            sb.append(" ");
            sb.append(this._counter);
            newTitle = sb.toString();
        }
        this._distinctTitles.add(this._getKey(newTitle, extension));
        return newTitle;
    }

    private String _getKey(String title, String extension) {
        StringBuilder sb = new StringBuilder();
        sb.append(this._groupIdColumn.getOldValue());
        sb.append("_");
        sb.append(this._folderIdColumn.getOldValue());
        sb.append("_");
        sb.append(title);
        if (Validator.isNotNull((String)extension)) {
            sb.append(".");
            sb.append(extension);
        }
        return sb.toString();
    }
}

