/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_1_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletPreferencesSerializer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeSitemap
extends UpgradeProcess {
    private static final String _GET_LAYOUT = "select * from Layout where plid = ?";

    protected void deletePortletPreferences(long portletPreferencesId) throws Exception {
        this.runSQL("delete from PortletPreferences where portletPreferencesId = " + portletPreferencesId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpgrade() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select portletPreferencesId, ownerId, ownerType, plid, portletId, preferences from PortletPreferences where portletId like '85_%'");
            rs = ps.executeQuery();
            while (rs.next()) {
                long portletPreferencesId = rs.getLong("portletPreferencesId");
                long ownerId = rs.getLong("ownerId");
                int ownerType = rs.getInt("ownerType");
                long plid = rs.getLong("plid");
                String portletId = rs.getString("portletId");
                String preferences = rs.getString("preferences");
                Object[] layout = this.getLayout(plid);
                if (layout != null) {
                    long companyId = (Long)layout[0];
                    String newPreferences = this.upgradePreferences(companyId, ownerId, ownerType, plid, portletId, preferences);
                    this.updatePortletPreferences(portletPreferencesId, newPreferences);
                    continue;
                }
                this.deletePortletPreferences(portletPreferencesId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getLayout(long plid) throws Exception {
        Object[] layout = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_LAYOUT);
            ps.setLong(1, plid);
            rs = ps.executeQuery();
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                long layoutId = rs.getLong("layoutId");
                layout = new Object[]{companyId, layoutId};
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePortletPreferences(long portletPreferencesId, String preferences) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("update PortletPreferences set preferences = ? where portletPreferencesId = " + portletPreferencesId);
            ps.setString(1, preferences);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        Object[] layout;
        PortletPreferencesImpl preferences = PortletPreferencesSerializer.fromXML(companyId, ownerId, ownerType, plid, portletId, xml);
        long rootPlid = GetterUtil.getLong((String)preferences.getValue("root-plid", ""));
        if (rootPlid > 0L && (layout = this.getLayout(rootPlid)) != null) {
            long layoutId = (Long)layout[1];
            preferences.setValue("root-layout-id", String.valueOf(layoutId));
        }
        preferences.setValue("root-plid", null);
        return PortletPreferencesSerializer.toXML(preferences);
    }
}

