/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_2_0;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletPreferencesSerializer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    protected void deletePortletPreferences(long portletPreferencesId) throws Exception {
        this.runSQL("delete from PortletPreferences where portletPreferencesId = " + portletPreferencesId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpgrade() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select portletPreferencesId, ownerId, ownerType, plid, portletId, preferences from PortletPreferences where portletId = '20'");
            rs = ps.executeQuery();
            while (rs.next()) {
                long portletPreferencesId = rs.getLong("portletPreferencesId");
                long ownerId = rs.getLong("ownerId");
                int ownerType = rs.getInt("ownerType");
                long plid = rs.getLong("plid");
                String portletId = rs.getString("portletId");
                String preferences = rs.getString("preferences");
                try {
                    String newPreferences = this.upgradePreferences(ownerId, ownerType, plid, portletId, preferences);
                    this.updatePortletPreferences(portletPreferencesId, newPreferences);
                }
                catch (NoSuchLayoutException nsle) {
                    this.deletePortletPreferences(portletPreferencesId);
                }
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePortletPreferences(long portletPreferencesId, String preferences) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("update PortletPreferences set preferences = ? where portletPreferencesId = " + portletPreferencesId);
            ps.setString(1, preferences);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String upgradePreferences(long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        long companyId = 0L;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select companyId from Layout where plid = ?");
            ps.setLong(1, plid);
            rs = ps.executeQuery();
            if (rs.next()) {
                companyId = rs.getLong("companyId");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        if (companyId <= 0L) {
            throw new NoSuchLayoutException();
        }
        PortletPreferencesImpl preferences = PortletPreferencesSerializer.fromXML(companyId, ownerId, ownerType, plid, portletId, xml);
        String fileEntryColumns = preferences.getValue("fileEntryColumns", "");
        if (Validator.isNotNull((String)fileEntryColumns)) {
            fileEntryColumns = StringUtil.replace((String)fileEntryColumns, (String)"document", (String)"name");
            preferences.setValue("fileEntryColumns", fileEntryColumns);
        }
        return PortletPreferencesSerializer.toXML(preferences);
    }
}

