/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_2_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.util.PwdGenerator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeJournal
extends UpgradeProcess {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpgrade() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select id_, content, structureId from JournalArticle");
            rs = ps.executeQuery();
            while (rs.next()) {
                String newContent;
                long id = rs.getLong("id_");
                String content = GetterUtil.getString((String)rs.getString("content"));
                String structureId = rs.getString("structureId");
                if (Validator.isNull((String)structureId) || content.equals(newContent = this.addDynamicElementInstanceId(content))) continue;
                this.updateJournalArticleContent(id, newContent);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        this.deleteJournalArticleImages();
    }

    protected String addDynamicElementInstanceId(String content) throws Exception {
        Document doc = SAXReaderUtil.read((String)content);
        Element root = doc.getRootElement();
        this.addDynamicElementInstanceId(root);
        return JournalUtil.formatXML(doc);
    }

    protected void addDynamicElementInstanceId(Element root) throws Exception {
        for (Element element : root.elements()) {
            if (!element.getName().equals("dynamic-element")) continue;
            String instanceId = element.attributeValue("instance-id");
            String type = element.attributeValue("type");
            if (Validator.isNull((String)instanceId)) {
                instanceId = PwdGenerator.getPassword();
                element.addAttribute("instance-id", instanceId);
                if (type.equals("image")) {
                    this.updateJournalArticleImageInstanceId(element, instanceId);
                }
            }
            this.addDynamicElementInstanceId(element);
        }
    }

    protected void deleteJournalArticleImages() throws Exception {
        this.runSQL("delete from JournalArticleImage where elInstanceId is null or elInstanceId = ''");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateJournalArticleContent(long id, String content) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("update JournalArticle set content = ? where id_ = ?");
            ps.setString(1, content);
            ps.setLong(2, id);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void updateJournalArticleImageInstanceId(Element parentElement, String instanceId) throws Exception {
        for (Element element : parentElement.elements("dynamic-content")) {
            long articleImageId = GetterUtil.getLong((String)element.attributeValue("id"));
            if (articleImageId <= 0L) continue;
            this.runSQL("update JournalArticleImage set elInstanceId = '" + instanceId + "' where articleImageId = " + articleImageId);
        }
    }
}

