/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_2_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.TempUpgradeColumnImpl;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.model.ResourceConstants;
import com.liferay.portal.upgrade.v5_2_0.util.OrganizationTable;
import com.liferay.portal.upgrade.v5_2_0.util.OrganizationTypeUpgradeColumnImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeOrganization
extends UpgradeProcess {
    private static final String _GET_COMPANY_IDS = "select companyId from Company";

    protected void doUpgrade() throws Exception {
        TempUpgradeColumnImpl locationColumn = new TempUpgradeColumnImpl("location", new Integer(16));
        OrganizationTypeUpgradeColumnImpl typeColumn = new OrganizationTypeUpgradeColumnImpl((UpgradeColumn)locationColumn);
        Object[][] organizationColumns1 = new Object[][]{{"location", new Integer(16)}};
        Object[][] organizationColumns2 = (Object[][])OrganizationTable.TABLE_COLUMNS.clone();
        Object[][] organizationColumns = ArrayUtil.append((Object[][])organizationColumns1, (Object[][])organizationColumns2);
        UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"Organization_", (Object[][])organizationColumns, (UpgradeColumn[])new UpgradeColumn[]{locationColumn, typeColumn});
        upgradeTable.updateTable();
        this.updateLocationResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getCodeId(long companyId, String name, int scope) throws Exception {
        long codeId = 0L;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select codeId from ResourceCode where companyId = ? and name = ? and scope = ?");
            ps.setLong(1, companyId);
            ps.setString(2, name);
            ps.setInt(3, scope);
            rs = ps.executeQuery();
            if (rs.next()) {
                codeId = rs.getLong("codeId");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return codeId;
    }

    protected void updateCodeId(long companyId, int scope) throws Exception {
        long oldCodeId = this.getCodeId(companyId, "com.liferay.portal.model.Location", scope);
        long newCodeId = this.getCodeId(companyId, "com.liferay.portal.model.Organization", scope);
        this.runSQL("update Resource_ set codeId = " + newCodeId + " where codeId = " + oldCodeId);
        this.runSQL("delete from ResourceCode where codeId = " + oldCodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLocationResources() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_COMPANY_IDS);
            rs = ps.executeQuery();
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                for (int scope : ResourceConstants.SCOPES) {
                    this.updateCodeId(companyId, scope);
                }
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

