/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_2_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dao.jdbc.SmartResultSet;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.Resource;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradePortletPermissions
extends UpgradeProcess {
    private static final String _GET_LAYOUT = "select * from Layout where plid = ?";
    private static Log _log = LogFactoryUtil.getLog(UpgradePortletPermissions.class);

    protected void doUpgrade() throws Exception {
        this.updatePortletPermissions("33", "com.liferay.portlet.blogs", new String[]{"ADD_ENTRY"});
        this.updatePortletPermissions("28", "com.liferay.portlet.bookmarks", new String[]{"ADD_FOLDER"});
        this.updatePortletPermissions("8", "com.liferay.portlet.calendar", new String[]{"ADD_EVENT", "EXPORT_ALL_EVENTS"});
        this.updatePortletPermissions("20", "com.liferay.portlet.documentlibrary", new String[]{"ADD_FOLDER"});
        this.updatePortletPermissions("31", "com.liferay.portlet.imagegallery", new String[]{"ADD_FOLDER"});
        this.updatePortletPermissions("15", "com.liferay.portlet.journal", new String[]{"ADD_ARTICLE", "ADD_FEED", "ADD_STRUCTURE", "ADD_TEMPLATE", "APPROVE_ARTICLE"});
        this.updatePortletPermissions("19", "com.liferay.portlet.messageboards", new String[]{"ADD_CATEGORY", "BAN_USER"});
        this.updatePortletPermissions("25", "com.liferay.portlet.polls", new String[]{"ADD_QUESTION"});
        this.updatePortletPermissions("34", "com.liferay.portlet.shopping", new String[]{"ADD_CATEGORY", "MANAGE_COUPONS", "MANAGE_ORDERS"});
        this.updatePortletPermissions("98", "com.liferay.portlet.softwarecatalog", new String[]{"ADD_FRAMEWORK_VERSION", "ADD_PRODUCT_ENTRY"});
        this.updatePortletPermissions("99", "com.liferay.portlet.tags", new String[]{"ADD_ENTRY", "ADD_VOCABULARY"});
        this.updatePortletPermissions("36", "com.liferay.portlet.wiki", new String[]{"ADD_NODE"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getLayout(long plid) throws Exception {
        Object[] layout = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_LAYOUT);
            ps.setLong(1, plid);
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                layout = new Object[]{groupId, companyId};
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getPortletPermissionsCount(String actionId, long resourceId, String modelName) throws Exception {
        long l;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("select count(*) from Permission_ ");
            sb.append("inner join Resource_ on Resource_.resourceId = ");
            sb.append("Permission_.resourceId inner join ResourceCode on ");
            sb.append("ResourceCode.codeId = Resource_.codeId where ");
            sb.append("Permission_.actionId = ? and ");
            sb.append("Permission_.resourceId = ? and ResourceCode.name = ? ");
            sb.append("and ResourceCode.scope = ? ");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            ps.setString(1, actionId);
            ps.setLong(2, resourceId);
            ps.setString(3, modelName);
            ps.setInt(4, 4);
            rs = ps.executeQuery();
            rs.next();
            l = rs.getLong(1);
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return l;
    }

    protected void updatePortletPermission(long permissionId, String actionId, String primKey, String modelName, int scope) throws Exception {
        long plid = GetterUtil.getLong((String)primKey.substring(0, primKey.indexOf("_LAYOUT_")));
        Object[] layout = this.getLayout(plid);
        if (layout == null) {
            return;
        }
        long groupId = (Long)layout[0];
        long companyId = (Long)layout[1];
        Resource resource = ResourceLocalServiceUtil.addResource((long)companyId, (String)modelName, (int)scope, (String)String.valueOf(groupId));
        long portletPermissionCount = this.getPortletPermissionsCount(actionId, resource.getResourceId(), modelName);
        if (portletPermissionCount == 0L) {
            this.runSQL("update Permission_ set resourceId = " + resource.getResourceId() + " where permissionId = " + permissionId);
        } else {
            this.runSQL("delete from Permission_ where permissionId = " + permissionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePortletPermissions(String portletName, String modelName, String[] actionIds) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("select Permission_.permissionId, ");
            sb.append("Permission_.actionId, Resource_.primKey, ");
            sb.append("ResourceCode.scope from Permission_ ");
            sb.append("inner join Resource_ on Resource_.resourceId = ");
            sb.append("Permission_.resourceId inner join ResourceCode on ");
            sb.append("ResourceCode.codeId = Resource_.codeId where (");
            for (int i = 0; i < actionIds.length; ++i) {
                String actionId = actionIds[i];
                sb.append("Permission_.actionId = '");
                sb.append(actionId);
                sb.append("'");
                if (i >= actionIds.length - 1) continue;
                sb.append(" or ");
            }
            sb.append(") and ResourceCode.name = ? and ResourceCode.scope = ?");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            ps.setString(1, portletName);
            ps.setInt(2, 4);
            rs = ps.executeQuery();
            SmartResultSet srs = new SmartResultSet(rs);
            while (srs.next()) {
                long permissionId = srs.getLong("Permission_.permissionId");
                String actionId = srs.getString("Permission_.actionId");
                String primKey = srs.getString("Resource_.primKey");
                int scope = srs.getInt("ResourceCode.scope");
                try {
                    this.updatePortletPermission(permissionId, actionId, primKey, modelName, scope);
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to upgrade permission " + permissionId), (Throwable)e);
                }
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

