/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_2_3;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Locale;

public class UpgradeLayout
extends UpgradeProcess {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpgrade() throws Exception {
        String languageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select plid, typeSettings from Layout where typeSettings like '%meta-description=%'");
            rs = ps.executeQuery();
            while (rs.next()) {
                long plid = rs.getLong("plid");
                String typeSettings = rs.getString("typeSettings");
                UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
                typeSettingsProperties.load(typeSettings);
                String oldMetaDescription = typeSettingsProperties.getProperty("meta-description");
                String newMetaDescription = typeSettingsProperties.getProperty("meta-description_" + languageId);
                if (Validator.isNotNull((String)oldMetaDescription) && Validator.isNull((String)newMetaDescription)) {
                    typeSettingsProperties.setProperty("meta-description_" + languageId, oldMetaDescription);
                }
                typeSettingsProperties.remove((Object)"meta-description");
                String oldMetaKeywords = typeSettingsProperties.getProperty("meta-keywords");
                String newMetaKeywords = typeSettingsProperties.getProperty("meta-keywords_" + languageId);
                if (Validator.isNotNull((String)oldMetaKeywords) && Validator.isNull((String)newMetaKeywords)) {
                    typeSettingsProperties.setProperty("meta-keywords_" + languageId, oldMetaKeywords);
                }
                typeSettingsProperties.remove((Object)"meta-keywords");
                String oldMetaRobots = typeSettingsProperties.getProperty("meta-robots");
                String newMetaRobots = typeSettingsProperties.getProperty("meta-robots_" + languageId);
                if (Validator.isNotNull((String)oldMetaRobots) && Validator.isNull((String)newMetaRobots)) {
                    typeSettingsProperties.setProperty("meta-robots_" + languageId, oldMetaRobots);
                }
                typeSettingsProperties.remove((Object)"meta-robots");
                this.updateTypeSettings(plid, typeSettingsProperties.toString());
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTypeSettings(long plid, String typeSettings) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("update Layout set typeSettings = ? where plid = " + plid);
            ps.setString(1, typeSettings);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }
}

