/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_2_3;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.upgrade.v5_2_3.util.TagsAssetTable;
import com.liferay.portal.upgrade.v5_2_3.util.TagsPropertyTable;
import com.liferay.portal.upgrade.v5_2_3.util.TagsPropertyValueUpgradeColumnImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;

public class UpgradeTags
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try {
            this.runSQL("alter_column_type TagsAsset title VARCHAR(255) null");
        }
        catch (Exception e) {
            UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"TagsAsset", (Object[][])TagsAssetTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[0]);
            upgradeTable.setCreateSQL("create table TagsAsset (assetId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,visible BOOLEAN,startDate DATE null,endDate DATE null,publishDate DATE null,expirationDate DATE null,mimeType VARCHAR(75) null,title VARCHAR(255) null,description STRING null,summary STRING null,url STRING null,height INTEGER,width INTEGER,priority DOUBLE,viewCount INTEGER)");
            upgradeTable.updateTable();
        }
        this.updateAssetViewCount();
        UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"TagsProperty", (Object[][])TagsPropertyTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[]{new TagsPropertyValueUpgradeColumnImpl("value")});
        upgradeTable.setCreateSQL("create table TagsProperty (propertyId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,entryId LONG,key_ VARCHAR(75) null,value VARCHAR(255) null)");
        upgradeTable.updateTable();
    }

    protected void updateAssetViewCount() throws Exception {
        this.updateAssetViewCount(BookmarksEntry.class.getName(), "BookmarksEntry", "entryId", "visits");
        this.updateAssetViewCount(DLFileEntry.class.getName(), "DLFileEntry", "fileEntryId", "readCount");
    }

    protected void updateAssetViewCount(String className, String tableName, String columnClassPK, String columnViewCount) throws Exception {
        long classNameId = PortalUtil.getClassNameId((String)className);
        StringBuilder sb = new StringBuilder();
        sb.append("update TagsAsset set viewCount = (select ");
        sb.append(tableName);
        sb.append(".");
        sb.append(columnViewCount);
        sb.append(" from ");
        sb.append(tableName);
        sb.append(" where TagsAsset.classPK = ");
        sb.append(tableName);
        sb.append(".");
        sb.append(columnClassPK);
        sb.append(") where TagsAsset.classNameId = ");
        sb.append(classNameId);
        this.runSQL(sb.toString());
    }
}

