/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upload;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.upload.LiferayFileItem;
import com.liferay.portal.upload.LiferayFileItemFactory;
import com.liferay.portal.upload.LiferayFileUpload;
import com.liferay.portal.upload.LiferayServletRequest;
import com.liferay.portal.util.PropsUtil;
import com.liferay.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadServletRequestImpl
extends HttpServletRequestWrapper
implements UploadServletRequest {
    public static final long DEFAULT_SIZE_MAX = GetterUtil.getLong((String)PropsUtil.get(UploadServletRequestImpl.class.getName() + ".max.size"));
    public static final File DEFAULT_TEMP_DIR = new File(GetterUtil.getString((String)PropsUtil.get(UploadServletRequestImpl.class.getName() + ".temp.dir"), (String)SystemProperties.get((String)"java.io.tmpdir")));
    private static Log _log = LogFactoryUtil.getLog(UploadServletRequestImpl.class);
    private LiferayServletRequest _lsr;
    private Map<String, LiferayFileItem[]> _params = new LinkedHashMap<String, LiferayFileItem[]>();

    public UploadServletRequestImpl(HttpServletRequest request) {
        super(request);
        try {
            LiferayFileUpload servletFileUpload = new LiferayFileUpload((FileItemFactory)new LiferayFileItemFactory(DEFAULT_TEMP_DIR), request);
            servletFileUpload.setSizeMax(DEFAULT_SIZE_MAX);
            this._lsr = new LiferayServletRequest(request);
            List list = servletFileUpload.parseRequest((HttpServletRequest)this._lsr);
            for (LiferayFileItem fileItem : list) {
                LiferayFileItem[] fileItems;
                if (fileItem.isFormField()) {
                    fileItem.setString(request.getCharacterEncoding());
                }
                if ((fileItems = this._params.get(fileItem.getFieldName())) == null) {
                    fileItems = new LiferayFileItem[]{fileItem};
                } else {
                    LiferayFileItem[] newFileItems = new LiferayFileItem[fileItems.length + 1];
                    System.arraycopy(fileItems, 0, newFileItems, 0, fileItems.length);
                    newFileItems[newFileItems.length - 1] = fileItem;
                    fileItems = newFileItems;
                }
                this._params.put(fileItem.getFieldName(), fileItems);
            }
        }
        catch (FileUploadException fue) {
            _log.error((Object)fue, (Throwable)fue);
        }
    }

    public void cleanUp() {
        if (this._params != null && !this._params.isEmpty()) {
            for (LiferayFileItem[] fileItems : this._params.values()) {
                for (int i = 0; i < fileItems.length; ++i) {
                    fileItems[i].delete();
                }
            }
        }
    }

    public String getContentType(String name) {
        LiferayFileItem[] fileItems = this._params.get(name);
        if (fileItems != null && fileItems.length > 0) {
            return fileItems[0].getContentType();
        }
        return null;
    }

    public File getFile(String name) {
        if (this.getFileName(name) == null) {
            return null;
        }
        LiferayFileItem[] fileItems = this._params.get(name);
        if (fileItems != null && fileItems.length > 0) {
            return fileItems[0].getStoreLocation();
        }
        return null;
    }

    public String getFileName(String name) {
        LiferayFileItem[] fileItems = this._params.get(name);
        if (fileItems != null && fileItems.length > 0) {
            return fileItems[0].getFileName();
        }
        return null;
    }

    public String getFullFileName(String name) {
        LiferayFileItem[] fileItems = this._params.get(name);
        if (fileItems != null && fileItems.length > 0) {
            return fileItems[0].getFullFileName();
        }
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this._lsr.getInputStream();
    }

    public Map<String, LiferayFileItem[]> getMultipartParameterMap() {
        return this._params;
    }

    public String getParameter(String name) {
        LiferayFileItem[] fileItems = this._params.get(name);
        if (fileItems != null && fileItems.length > 0) {
            return fileItems[0].getString();
        }
        return super.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration<String> enu = this.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = enu.nextElement();
            map.put(name, this.getParameterValues(name));
        }
        return map;
    }

    public Enumeration<String> getParameterNames() {
        ArrayList<String> parameterNames = new ArrayList<String>();
        Enumeration enu = super.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (this._params.containsKey(name)) continue;
            parameterNames.add(name);
        }
        for (String name : this._params.keySet()) {
            parameterNames.add(name);
        }
        return Collections.enumeration(parameterNames);
    }

    public String[] getParameterValues(String name) {
        String[] parentValues = super.getParameterValues(name);
        LiferayFileItem[] fileItems = this._params.get(name);
        if (fileItems == null || fileItems.length == 0) {
            return parentValues;
        }
        if (parentValues == null || parentValues.length == 0) {
            String[] values = new String[fileItems.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = fileItems[i].getString();
            }
            return values;
        }
        String[] values = new String[parentValues.length + fileItems.length];
        System.arraycopy(parentValues, 0, values, 0, parentValues.length);
        for (int i = parentValues.length; i < values.length; ++i) {
            values[i] = fileItems[i - parentValues.length].getString();
        }
        return values;
    }

    public Boolean isFormField(String name) {
        LiferayFileItem[] fileItems = this._params.get(name);
        if (fileItems != null && fileItems.length > 0) {
            return new Boolean(fileItems[0].isFormField());
        }
        return null;
    }
}

