/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.util.Diff;
import com.liferay.portal.kernel.util.DiffResult;
import com.liferay.portal.kernel.util.FileUtil;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.incava.util.diff.Difference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffImpl
implements Diff {
    public List<DiffResult>[] diff(Reader source, Reader target) {
        int margin = 2;
        return this.diff(source, target, "<ins>", "</ins>", "<del>", "</del>", margin);
    }

    public List<DiffResult>[] diff(Reader source, Reader target, String addedMarkerStart, String addedMarkerEnd, String deletedMarkerStart, String deletedMarkerEnd, int margin) {
        ArrayList<DiffResult> sourceResults = new ArrayList<DiffResult>();
        ArrayList<DiffResult> targetResults = new ArrayList<DiffResult>();
        List[] results = new List[]{sourceResults, targetResults};
        List sourceStringList = FileUtil.toList((Reader)source);
        List targetStringList = FileUtil.toList((Reader)target);
        org.incava.util.diff.Diff diff = new org.incava.util.diff.Diff((Collection)sourceStringList, (Collection)targetStringList);
        List differences = diff.diff();
        for (Difference difference : differences) {
            DiffResult diffResult;
            List<String> changedLines;
            if (difference.getAddedEnd() == -1) {
                DiffImpl._highlightLines(sourceStringList, deletedMarkerStart, deletedMarkerEnd, difference.getDeletedStart(), difference.getDeletedEnd());
                margin = DiffImpl._calculateMargin(sourceResults, targetResults, difference.getDeletedStart(), difference.getAddedStart(), margin);
                changedLines = DiffImpl._addMargins(sourceResults, sourceStringList, difference.getDeletedStart(), margin);
                DiffImpl._addResults(sourceResults, sourceStringList, changedLines, difference.getDeletedStart(), difference.getDeletedEnd());
                changedLines = DiffImpl._addMargins(targetResults, targetStringList, difference.getAddedStart(), margin);
                int deletedLines = difference.getDeletedEnd() + 1 - difference.getDeletedStart();
                for (int i = 0; i < deletedLines; ++i) {
                    changedLines.add("#context#line#");
                }
                diffResult = new DiffResult(difference.getDeletedStart(), changedLines);
                targetResults.add(diffResult);
                continue;
            }
            if (difference.getDeletedEnd() == -1) {
                DiffImpl._highlightLines(targetStringList, addedMarkerStart, addedMarkerEnd, difference.getAddedStart(), difference.getAddedEnd());
                margin = DiffImpl._calculateMargin(sourceResults, targetResults, difference.getDeletedStart(), difference.getAddedStart(), margin);
                changedLines = DiffImpl._addMargins(sourceResults, sourceStringList, difference.getDeletedStart(), margin);
                int addedLines = difference.getAddedEnd() + 1 - difference.getAddedStart();
                for (int i = 0; i < addedLines; ++i) {
                    changedLines.add("#context#line#");
                }
                diffResult = new DiffResult(difference.getAddedStart(), changedLines);
                sourceResults.add(diffResult);
                changedLines = DiffImpl._addMargins(targetResults, targetStringList, difference.getAddedStart(), margin);
                DiffImpl._addResults(targetResults, targetStringList, changedLines, difference.getAddedStart(), difference.getAddedEnd());
                continue;
            }
            DiffImpl._checkCharDiffs(sourceResults, targetResults, sourceStringList, targetStringList, addedMarkerStart, addedMarkerEnd, deletedMarkerStart, deletedMarkerEnd, difference, margin);
        }
        return results;
    }

    private static List<String> _addMargins(List<DiffResult> results, List<String> stringList, int startPos, int margin) {
        int i;
        ArrayList<String> changedLines = new ArrayList<String>();
        if (margin == 0 || startPos == 0) {
            return changedLines;
        }
        for (i = startPos - margin; i < 0; ++i) {
            changedLines.add("#context#line#");
        }
        while (i < startPos) {
            if (i < stringList.size()) {
                changedLines.add(stringList.get(i));
            }
            ++i;
        }
        return changedLines;
    }

    private static void _addResults(List<DiffResult> results, List<String> stringList, List<String> changedLines, int start, int end) {
        changedLines.addAll(stringList.subList(start, end + 1));
        DiffResult diffResult = new DiffResult(start, changedLines);
        results.add(diffResult);
    }

    private static int _calculateMargin(List<DiffResult> sourceResults, List<DiffResult> targetResults, int sourceBeginPos, int targetBeginPos, int margin) {
        int targetMargin;
        int sourceMargin = DiffImpl._checkOverlapping(sourceResults, sourceBeginPos, margin);
        if (sourceMargin < (targetMargin = DiffImpl._checkOverlapping(targetResults, targetBeginPos, margin))) {
            return sourceMargin;
        }
        return targetMargin;
    }

    private static void _checkCharDiffs(List<DiffResult> sourceResults, List<DiffResult> targetResults, List<String> sourceStringList, List<String> targetStringList, String addedMarkerStart, String addedMarkerEnd, String deletedMarkerStart, String deletedMarkerEnd, Difference difference, int margin) {
        DiffResult sourceResult;
        DiffResult targetResult;
        int i;
        boolean aligned = false;
        int j = difference.getAddedStart();
        for (i = difference.getDeletedStart(); i <= difference.getDeletedEnd(); ++i) {
            while (j <= difference.getAddedEnd()) {
                if (DiffImpl._lineDiff(sourceResults, targetResults, sourceStringList, targetStringList, addedMarkerStart, addedMarkerEnd, deletedMarkerStart, deletedMarkerEnd, i, j, false)) {
                    aligned = true;
                    break;
                }
                DiffImpl._highlightLines(targetStringList, addedMarkerStart, addedMarkerEnd, j, j);
                targetResult = new DiffResult(j, targetStringList.subList(j, j + 1));
                targetResults.add(targetResult);
                sourceResults.add(new DiffResult(j, "#context#line#"));
                ++j;
            }
            if (aligned) break;
            DiffImpl._highlightLines(sourceStringList, deletedMarkerStart, deletedMarkerEnd, i, i);
            sourceResult = new DiffResult(i, sourceStringList.subList(i, i + 1));
            sourceResults.add(sourceResult);
            targetResults.add(new DiffResult(i, "#context#line#"));
        }
        ++i;
        ++j;
        while (i <= difference.getDeletedEnd() && j <= difference.getAddedEnd()) {
            DiffImpl._lineDiff(sourceResults, targetResults, sourceStringList, targetStringList, addedMarkerStart, addedMarkerEnd, deletedMarkerStart, deletedMarkerEnd, i, j, true);
            ++i;
            ++j;
        }
        while (i <= difference.getDeletedEnd()) {
            DiffImpl._highlightLines(sourceStringList, deletedMarkerStart, deletedMarkerEnd, i, i);
            sourceResult = new DiffResult(i, sourceStringList.subList(i, i + 1));
            sourceResults.add(sourceResult);
            targetResults.add(new DiffResult(i, "#context#line#"));
            ++i;
        }
        while (j <= difference.getAddedEnd()) {
            DiffImpl._highlightLines(targetStringList, addedMarkerStart, addedMarkerEnd, j, j);
            targetResult = new DiffResult(j, targetStringList.subList(j, j + 1));
            targetResults.add(targetResult);
            sourceResults.add(new DiffResult(j, "#context#line#"));
            ++j;
        }
    }

    private static int _checkOverlapping(List<DiffResult> results, int startPos, int margin) {
        if (results.size() == 0 || startPos - margin < 0) {
            return margin;
        }
        DiffResult lastDiff = results.get(results.size() - 1);
        if (lastDiff.getChangedLines().size() == 0) {
            return margin;
        }
        int lastChangedLine = lastDiff.getLineNumber() - 1 + lastDiff.getChangedLines().size();
        int currentChangedLine = startPos - margin;
        if (lastDiff.getChangedLines().size() == 1 && ((String)lastDiff.getChangedLines().get(0)).equals("#context#line#")) {
            ++currentChangedLine;
        }
        if (currentChangedLine < lastChangedLine) {
            return margin + currentChangedLine - lastChangedLine;
        }
        return margin;
    }

    private static void _highlightChars(List<String> stringList, String markerStart, String markerEnd, int startPos, int endPos) {
        String start = markerStart + stringList.get(startPos);
        stringList.set(startPos, start);
        String end = stringList.get(endPos) + markerEnd;
        stringList.set(endPos, end);
    }

    private static void _highlightLines(List<String> stringList, String markerStart, String markerEnd, int startPos, int endPos) {
        for (int i = startPos; i <= endPos; ++i) {
            stringList.set(i, markerStart + stringList.get(i) + markerEnd);
        }
    }

    private static boolean _lineDiff(List<DiffResult> sourceResults, List<DiffResult> targetResults, List<String> sourceStringList, List<String> targetStringList, String addedMarkerStart, String addedMarkerEnd, String deletedMarkerStart, String deletedMarkerEnd, int sourceChangedLine, int targetChangedLine, boolean aligned) {
        DiffResult sourceResult;
        String source = sourceStringList.get(sourceChangedLine);
        String target = targetStringList.get(targetChangedLine);
        List<String> sourceList = DiffImpl._toList(source);
        List<String> targetList = DiffImpl._toList(target);
        org.incava.util.diff.Diff diff = new org.incava.util.diff.Diff(sourceList, targetList);
        List differences = diff.diff();
        Iterator itr = differences.iterator();
        int deletedChars = 0;
        int addedChars = 0;
        while (itr.hasNext() && !aligned) {
            Difference difference = (Difference)itr.next();
            if (difference.getDeletedEnd() != -1) {
                deletedChars += difference.getDeletedEnd() - difference.getDeletedStart() + 1;
            }
            if (difference.getAddedEnd() == -1) continue;
            addedChars += difference.getAddedEnd() - difference.getAddedStart() + 1;
        }
        if (deletedChars > sourceList.size() / 2 || addedChars > sourceList.size() / 2) {
            return false;
        }
        itr = differences.iterator();
        boolean sourceChanged = false;
        boolean targetChanged = false;
        while (itr.hasNext()) {
            Difference difference = (Difference)itr.next();
            if (difference.getAddedEnd() == -1) {
                DiffImpl._highlightChars(sourceList, deletedMarkerStart, deletedMarkerEnd, difference.getDeletedStart(), difference.getDeletedEnd());
                sourceChanged = true;
                continue;
            }
            if (difference.getDeletedEnd() == -1) {
                DiffImpl._highlightChars(targetList, addedMarkerStart, addedMarkerEnd, difference.getAddedStart(), difference.getAddedEnd());
                targetChanged = true;
                continue;
            }
            DiffImpl._highlightChars(sourceList, deletedMarkerStart, deletedMarkerEnd, difference.getDeletedStart(), difference.getDeletedEnd());
            sourceChanged = true;
            DiffImpl._highlightChars(targetList, addedMarkerStart, addedMarkerEnd, difference.getAddedStart(), difference.getAddedEnd());
            targetChanged = true;
        }
        if (sourceChanged) {
            sourceResult = new DiffResult(sourceChangedLine, DiffImpl._toString(sourceList));
            sourceResults.add(sourceResult);
            if (!targetChanged) {
                DiffResult targetResult = new DiffResult(targetChangedLine, target);
                targetResults.add(targetResult);
            }
        }
        if (targetChanged) {
            if (!sourceChanged) {
                sourceResult = new DiffResult(sourceChangedLine, source);
                sourceResults.add(sourceResult);
            }
            DiffResult targetResult = new DiffResult(targetChangedLine, DiffImpl._toString(targetList));
            targetResults.add(targetResult);
        }
        return true;
    }

    private static List<String> _toList(String line) {
        String[] stringArray = line.split("");
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i < stringArray.length; ++i) {
            result.add(stringArray[i]);
        }
        return result;
    }

    private static String _toString(List<String> line) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> itr = line.iterator();
        while (itr.hasNext()) {
            sb.append(itr.next());
        }
        return sb.toString();
    }
}

