/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.Digester;
import com.liferay.portal.util.PropsValues;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public class DigesterImpl
implements Digester {
    private static final boolean _BASE_64 = PropsValues.PASSWORDS_DIGEST_ENCODING.equals("base64");
    private static Log _log = LogFactoryUtil.getLog(Digester.class);

    public String digest(String text) {
        return this.digest("SHA", text);
    }

    public String digest(String algorithm, String text) {
        MessageDigest digester = null;
        try {
            digester = MessageDigest.getInstance(algorithm);
            digester.update(text.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException nsae) {
            _log.error((Object)nsae, (Throwable)nsae);
        }
        catch (UnsupportedEncodingException uee) {
            _log.error((Object)uee, (Throwable)uee);
        }
        byte[] bytes = digester.digest();
        if (_BASE_64) {
            return Base64.encode((byte[])bytes);
        }
        return new String(Hex.encodeHex((byte[])bytes));
    }
}

