/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileComparator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.PwdGenerator;
import com.liferay.util.SystemProperties;
import com.liferay.util.lucene.JerichoHTMLTextExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.jackrabbit.extractor.MsExcelTextExtractor;
import org.apache.jackrabbit.extractor.MsPowerPointTextExtractor;
import org.apache.jackrabbit.extractor.MsWordTextExtractor;
import org.apache.jackrabbit.extractor.OpenOfficeTextExtractor;
import org.apache.jackrabbit.extractor.PdfTextExtractor;
import org.apache.jackrabbit.extractor.PlainTextExtractor;
import org.apache.jackrabbit.extractor.RTFTextExtractor;
import org.apache.jackrabbit.extractor.XMLTextExtractor;
import org.mozilla.intl.chardet.nsDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileImpl
implements com.liferay.portal.kernel.util.File {
    private static Log _log = LogFactoryUtil.getLog(FileImpl.class);
    private static FileImpl _instance = new FileImpl();

    public static FileImpl getInstance() {
        return _instance;
    }

    public void copyDirectory(String sourceDirName, String destinationDirName) {
        this.copyDirectory(new File(sourceDirName), new File(destinationDirName));
    }

    public void copyDirectory(File source, File destination) {
        if (source.exists() && source.isDirectory()) {
            if (!destination.exists()) {
                destination.mkdirs();
            }
            File[] fileArray = source.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.copyDirectory(fileArray[i], new File(destination.getPath() + File.separator + fileArray[i].getName()));
                    continue;
                }
                this.copyFile(fileArray[i], new File(destination.getPath() + File.separator + fileArray[i].getName()));
            }
        }
    }

    public void copyFile(String source, String destination) {
        this.copyFile(source, destination, false);
    }

    public void copyFile(String source, String destination, boolean lazy) {
        this.copyFile(new File(source), new File(destination), lazy);
    }

    public void copyFile(File source, File destination) {
        this.copyFile(source, destination, false);
    }

    public void copyFile(File source, File destination, boolean lazy) {
        if (!source.exists()) {
            return;
        }
        if (lazy) {
            String oldContent = null;
            try {
                oldContent = this.read(source);
            }
            catch (Exception e) {
                return;
            }
            String newContent = null;
            try {
                newContent = this.read(destination);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (oldContent == null || !oldContent.equals(newContent)) {
                this.copyFile(source, destination, false);
            }
        } else {
            if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
                destination.getParentFile().mkdirs();
            }
            try {
                StreamUtil.transfer((InputStream)new FileInputStream(source), (OutputStream)new FileOutputStream(destination));
            }
            catch (IOException ioe) {
                _log.error((Object)ioe.getMessage());
            }
        }
    }

    public File createTempFile() {
        return this.createTempFile(null);
    }

    public File createTempFile(String extension) {
        return new File(this.createTempFileName(extension));
    }

    public String createTempFileName() {
        return this.createTempFileName(null);
    }

    public String createTempFileName(String extension) {
        StringBuilder sb = new StringBuilder();
        sb.append(SystemProperties.get((String)"java.io.tmpdir"));
        sb.append("/");
        sb.append(Time.getTimestamp());
        sb.append(PwdGenerator.getPassword((String)PwdGenerator.KEY2, (int)8));
        if (Validator.isNotNull((String)extension)) {
            sb.append(".");
            sb.append(extension);
        }
        return sb.toString();
    }

    public boolean delete(String file) {
        return this.delete(new File(file));
    }

    public boolean delete(File file) {
        if (file != null && file.exists()) {
            return file.delete();
        }
        return false;
    }

    public void deltree(String directory) {
        this.deltree(new File(directory));
    }

    public void deltree(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            File[] fileArray = directory.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.deltree(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
            directory.delete();
        }
    }

    public boolean exists(String fileName) {
        return this.exists(new File(fileName));
    }

    public boolean exists(File file) {
        return file.exists();
    }

    public String extractText(InputStream is, String fileExt) {
        String text = null;
        try {
            fileExt = GetterUtil.getString((String)fileExt).toLowerCase();
            MsWordTextExtractor extractor = null;
            String contentType = null;
            String encoding = System.getProperty("encoding");
            if (fileExt.equals(".doc")) {
                extractor = new MsWordTextExtractor();
                contentType = "application/vnd.ms-word";
            } else if (fileExt.equals(".htm") || fileExt.equals(".html")) {
                extractor = new JerichoHTMLTextExtractor();
                contentType = "text/html";
            } else if (fileExt.equals(".odb") || fileExt.equals(".odf") || fileExt.equals(".odg") || fileExt.equals(".odp") || fileExt.equals(".ods") || fileExt.equals(".odt")) {
                extractor = new OpenOfficeTextExtractor();
                contentType = "application/vnd.oasis.opendocument.";
                if (fileExt.equals(".odb")) {
                    contentType = contentType + "database";
                } else if (fileExt.equals(".odf")) {
                    contentType = contentType + "formula";
                } else if (fileExt.equals(".odg")) {
                    contentType = contentType + "graphics";
                } else if (fileExt.equals(".odp")) {
                    contentType = contentType + "presentation";
                } else if (fileExt.equals(".ods")) {
                    contentType = contentType + "spreadsheet";
                } else if (fileExt.equals(".odt")) {
                    contentType = contentType + "text";
                }
            } else if (fileExt.equals(".pdf")) {
                extractor = new PdfTextExtractor();
                contentType = "application/pdf";
            } else if (fileExt.equals(".ppt")) {
                extractor = new MsPowerPointTextExtractor();
                contentType = "application/vnd.ms-powerpoint";
            } else if (fileExt.equals(".rtf")) {
                extractor = new RTFTextExtractor();
                contentType = "application/rtf";
            } else if (fileExt.equals(".txt")) {
                extractor = new PlainTextExtractor();
                contentType = "text/plain";
            } else if (fileExt.equals(".xls")) {
                extractor = new MsExcelTextExtractor();
                contentType = "application/vnd.ms-excel";
            } else if (fileExt.equals(".xml")) {
                extractor = new XMLTextExtractor();
                contentType = "text/xml";
            }
            if (extractor != null) {
                int i;
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Using extractor " + extractor.getClass().getName() + " for extension " + fileExt));
                }
                StringBuilder sb = new StringBuilder();
                UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(extractor.extractText(is, contentType, encoding));
                while ((i = unsyncBufferedReader.read()) != -1) {
                    sb.append((char)i);
                }
                unsyncBufferedReader.close();
                text = sb.toString();
            } else if (_log.isInfoEnabled()) {
                _log.info((Object)("No extractor found for extension " + fileExt));
            }
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Extractor returned text:\n\n" + text));
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    public String getAbsolutePath(File file) {
        return StringUtil.replace((String)file.getAbsolutePath(), (String)"\\", (String)"/");
    }

    public byte[] getBytes(File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream is = new FileInputStream(file);
        byte[] bytes = this.getBytes(is, (int)file.length());
        is.close();
        return bytes;
    }

    public byte[] getBytes(InputStream is) throws IOException {
        return this.getBytes(is, -1);
    }

    public byte[] getBytes(InputStream inputStream, int bufferSize) throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream, (int)bufferSize);
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int pos = fileName.lastIndexOf(".");
        if (pos != -1) {
            return fileName.substring(pos + 1, fileName.length()).toLowerCase();
        }
        return null;
    }

    public String getPath(String fullFileName) {
        String shortFileName;
        int pos = fullFileName.lastIndexOf("/");
        if (pos == -1) {
            pos = fullFileName.lastIndexOf("\\");
        }
        if (Validator.isNull((String)(shortFileName = fullFileName.substring(0, pos)))) {
            return "/";
        }
        return shortFileName;
    }

    public String getShortFileName(String fullFileName) {
        int pos = fullFileName.lastIndexOf("/");
        if (pos == -1) {
            pos = fullFileName.lastIndexOf("\\");
        }
        String shortFileName = fullFileName.substring(pos + 1, fullFileName.length());
        return shortFileName;
    }

    public boolean isAscii(File file) throws IOException {
        boolean ascii = true;
        nsDetector detector = new nsDetector(0);
        FileInputStream inputStream = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = ((InputStream)inputStream).read(buffer, 0, buffer.length)) != -1 && (!ascii || (ascii = detector.isAscii(buffer, len)))) {
        }
        detector.DataEnd();
        ((InputStream)inputStream).close();
        return ascii;
    }

    public String[] listDirs(String fileName) {
        return this.listDirs(new File(fileName));
    }

    public String[] listDirs(File file) {
        ArrayList<String> dirs = new ArrayList<String>();
        File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            dirs.add(fileArray[i].getName());
        }
        return dirs.toArray(new String[dirs.size()]);
    }

    public String[] listFiles(String fileName) {
        if (Validator.isNull((String)fileName)) {
            return new String[0];
        }
        return this.listFiles(new File(fileName));
    }

    public String[] listFiles(File file) {
        ArrayList<String> files = new ArrayList<String>();
        File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (!fileArray[i].isFile()) continue;
            files.add(fileArray[i].getName());
        }
        return files.toArray(new String[files.size()]);
    }

    public void mkdirs(String pathName) {
        File file = new File(pathName);
        file.mkdirs();
    }

    public boolean move(String sourceFileName, String destinationFileName) {
        return this.move(new File(sourceFileName), new File(destinationFileName));
    }

    public boolean move(File source, File destination) {
        if (!source.exists()) {
            return false;
        }
        destination.delete();
        return source.renameTo(destination);
    }

    public String read(String fileName) throws IOException {
        return this.read(new File(fileName));
    }

    public String read(File file) throws IOException {
        return this.read(file, false);
    }

    public String read(File file, boolean raw) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] bytes = new byte[fis.available()];
        fis.read(bytes);
        fis.close();
        String s = new String(bytes, "UTF-8");
        if (raw) {
            return s;
        }
        return StringUtil.replace((String)s, (String)"\r\n", (String)"\n");
    }

    public String replaceSeparator(String fileName) {
        return StringUtil.replace((String)fileName, (String)"\\", (String)"/");
    }

    public File[] sortFiles(File[] files) {
        if (files == null) {
            return null;
        }
        Arrays.sort(files, new FileComparator());
        ArrayList<File> directoryList = new ArrayList<File>();
        ArrayList<File> fileList = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                directoryList.add(files[i]);
                continue;
            }
            fileList.add(files[i]);
        }
        directoryList.addAll(fileList);
        return directoryList.toArray(new File[directoryList.size()]);
    }

    public String stripExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int pos = fileName.lastIndexOf(".");
        if (pos != -1) {
            return fileName.substring(0, pos);
        }
        return fileName;
    }

    public List<String> toList(Reader reader) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(reader);
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                list.add(line);
            }
            unsyncBufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    public List<String> toList(String fileName) {
        try {
            return this.toList(new FileReader(fileName));
        }
        catch (IOException ioe) {
            return new ArrayList<String>();
        }
    }

    public Properties toProperties(FileInputStream fis) {
        Properties props = new Properties();
        try {
            props.load(fis);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    public Properties toProperties(String fileName) {
        try {
            return this.toProperties(new FileInputStream(fileName));
        }
        catch (IOException ioe) {
            return new Properties();
        }
    }

    public void write(String fileName, String s) throws IOException {
        this.write(new File(fileName), s);
    }

    public void write(String fileName, String s, boolean lazy) throws IOException {
        this.write(new File(fileName), s, lazy);
    }

    public void write(String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.write(new File(fileName), s, lazy, append);
    }

    public void write(String pathName, String fileName, String s) throws IOException {
        this.write(new File(pathName, fileName), s);
    }

    public void write(String pathName, String fileName, String s, boolean lazy) throws IOException {
        this.write(new File(pathName, fileName), s, lazy);
    }

    public void write(String pathName, String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.write(new File(pathName, fileName), s, lazy, append);
    }

    public void write(File file, String s) throws IOException {
        this.write(file, s, false);
    }

    public void write(File file, String s, boolean lazy) throws IOException {
        this.write(file, s, lazy, false);
    }

    public void write(File file, String s, boolean lazy, boolean append) throws IOException {
        String content;
        if (file.getParent() != null) {
            this.mkdirs(file.getParent());
        }
        if (lazy && file.exists() && (content = this.read(file)).equals(s)) {
            return;
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), "UTF-8");
        writer.write(s);
        ((Writer)writer).close();
    }

    public void write(String fileName, byte[] bytes) throws IOException {
        this.write(new File(fileName), bytes);
    }

    public void write(File file, byte[] bytes) throws IOException {
        if (file.getParent() != null) {
            this.mkdirs(file.getParent());
        }
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(bytes);
        fos.close();
    }

    public void write(String fileName, InputStream is) throws IOException {
        this.write(new File(fileName), is);
    }

    public void write(File file, InputStream is) throws IOException {
        if (file.getParent() != null) {
            this.mkdirs(file.getParent());
        }
        StreamUtil.transfer((InputStream)is, (OutputStream)new FileOutputStream(file));
    }
}

