/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.util.LayoutView;
import com.liferay.portal.util.SessionTreeJSClicks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class LayoutLister {
    private HttpServletRequest _request;
    private long _groupId;
    private boolean _privateLayout;
    private Locale _locale;
    private int _nodeId;
    private List<String> _list;
    private int _depth;

    public LayoutView getLayoutView(long groupId, boolean privateLayout, String rootNodeName, Locale locale) throws PortalException, SystemException {
        return this.getLayoutView(null, groupId, privateLayout, rootNodeName, locale);
    }

    public LayoutView getLayoutView(HttpServletRequest request, long groupId, boolean privateLayout, String rootNodeName, Locale locale) throws PortalException, SystemException {
        this._request = request;
        this._groupId = groupId;
        this._privateLayout = privateLayout;
        this._locale = locale;
        this._nodeId = 1;
        this._list = new ArrayList<String>();
        this._list.add("1|0|0|0|" + rootNodeName + "|0");
        this._createList(0L, this._nodeId, 0);
        return new LayoutView(this._list, this._depth);
    }

    private void _createList(long parentLayoutId, int parentId, int depth) throws PortalException, SystemException {
        List layouts = LayoutLocalServiceUtil.getLayouts((long)this._groupId, (boolean)this._privateLayout, (long)parentLayoutId);
        for (int i = 0; i < layouts.size(); ++i) {
            Layout layout = (Layout)layouts.get(i);
            if (i == 0 && ++depth > this._depth) {
                this._depth = depth;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(++this._nodeId).append("|");
            sb.append(parentId).append("|");
            if (i + 1 == layouts.size()) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            sb.append("|");
            sb.append(layout.getPlid()).append("|");
            sb.append(layout.getName(this._locale)).append("|");
            sb.append("11");
            sb.append("|");
            sb.append(depth);
            this._list.add(sb.toString());
            long[] openNodes = new long[]{};
            if (this._request != null) {
                String treeId = ParamUtil.getString((HttpServletRequest)this._request, (String)"treeId");
                openNodes = StringUtil.split((String)SessionTreeJSClicks.getOpenNodes(this._request, treeId), (long)0L);
            }
            if (this._request != null && Arrays.binarySearch(openNodes, (long)this._nodeId) < 0) continue;
            this._createList(layout.getLayoutId(), this._nodeId, depth);
        }
    }
}

