/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.mozilla.javascript.ErrorReporter;
import com.liferay.mozilla.javascript.EvaluatorException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.yahoo.platform.yui.compressor.CssCompressor;
import com.liferay.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.Reader;
import java.io.Writer;

public class MinifierUtil {
    private static final int _CSS_LINE_BREAK = -1;
    private static final boolean _JS_DISABLE_OPTIMIZATIONS = false;
    private static final int _JS_LINE_BREAK = -1;
    private static final boolean _JS_MUNGE = true;
    private static final boolean _JS_PRESERVE_ALL_SEMICOLONS = false;
    private static final boolean _JS_VERBOSE = false;
    private static Log _log = LogFactoryUtil.getLog(MinifierUtil.class);
    private static MinifierUtil _instance = new MinifierUtil();

    public static String minifyCss(String content) {
        return _instance._minifyCss(content);
    }

    public static String minifyJavaScript(String content) {
        return _instance._minifyJavaScript(content);
    }

    private MinifierUtil() {
    }

    private String _minifyCss(String content) {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter(true);
        try {
            CssCompressor cssCompressor = new CssCompressor((Reader)new UnsyncStringReader(content));
            cssCompressor.compress((Writer)unsyncStringWriter, -1);
        }
        catch (Exception e) {
            _log.error((Object)("CSS Minifier failed for\n" + content));
            unsyncStringWriter.append((CharSequence)content);
        }
        return unsyncStringWriter.toString();
    }

    private String _minifyJavaScript(String content) {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter(true);
        try {
            JavaScriptCompressor javaScriptCompressor = new JavaScriptCompressor((Reader)new UnsyncStringReader(content), (ErrorReporter)new JavaScriptErrorReporter());
            javaScriptCompressor.compress((Writer)unsyncStringWriter, -1, true, false, false, false);
        }
        catch (Exception e) {
            _log.error((Object)("JavaScript Minifier failed for\n" + content));
            unsyncStringWriter.append((CharSequence)content);
        }
        return unsyncStringWriter.toString();
    }

    private class JavaScriptErrorReporter
    implements ErrorReporter {
        private JavaScriptErrorReporter() {
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                _log.error((Object)message);
            } else {
                _log.error((Object)(line + ": " + lineOffset + ": " + message));
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (!_log.isWarnEnabled()) {
                return;
            }
            if (line < 0) {
                _log.warn((Object)message);
            } else {
                _log.warn((Object)(line + ": " + lineOffset + ": " + message));
            }
        }
    }
}

