/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.NoSuchCompanyException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapperThreadLocal;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.servlet.WebDirDetector;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ClassName;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.GroupConstants;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PublicRenderParameter;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.ResourceCode;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.RoleConstants;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.plugin.PluginPackageUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourceCodeLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.UserServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portal.service.persistence.BasePersistence;
import com.liferay.portal.servlet.filters.i18n.I18nFilter;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.upload.UploadPortletRequestImpl;
import com.liferay.portal.upload.UploadServletRequestImpl;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.portal.util.Portal;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PortletCategoryKeys;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.comparator.PortletControlPanelWeightComparator;
import com.liferay.portlet.ActionRequestImpl;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.ControlPanelEntry;
import com.liferay.portlet.DefaultControlPanelEntryFactory;
import com.liferay.portlet.PortletConfigFactory;
import com.liferay.portlet.PortletConfigImpl;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletPreferencesWrapper;
import com.liferay.portlet.PortletQNameUtil;
import com.liferay.portlet.PortletRequestImpl;
import com.liferay.portlet.PortletResponseImpl;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.RenderRequestImpl;
import com.liferay.portlet.RenderResponseImpl;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.expando.action.EditExpandoAction;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.social.util.FacebookUtil;
import com.liferay.portlet.tags.util.TagsUtil;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.util.Encryptor;
import com.liferay.util.JS;
import com.liferay.util.UniqueList;
import com.liferay.util.servlet.DynamicServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PreferencesValidator;
import javax.portlet.RenderRequest;
import javax.portlet.ValidatorException;
import javax.portlet.WindowState;
import javax.portlet.filter.PortletRequestWrapper;
import javax.portlet.filter.PortletResponseWrapper;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalImpl
implements Portal {
    private static final String _J_SECURITY_CHECK = "j_security_check";
    private static final String _JSESSIONID = ";jsessionid=";
    private static final String _LOCALHOST = "localhost";
    private static final String _PRIVATE_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
    private static final String _PRIVATE_USER_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
    private static final String _PUBLIC_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
    private static final Date _UP_TIME = new Date();
    private static Log _log = LogFactoryUtil.getLog(PortalImpl.class);
    private String[] _allSystemCommunityRoles;
    private String[] _allSystemGroups;
    private String[] _allSystemOrganizationRoles;
    private String[] _allSystemRoles;
    private String _cdnHostHttp;
    private String _cdnHostHttps;
    private String _computerAddress;
    private String _computerName;
    private String[] _customSqlClassNameIds;
    private String[] _customSqlClassNames;
    private String _globalLibDir;
    private String _pathContext;
    private String _pathFriendlyURLPrivateGroup;
    private String _pathFriendlyURLPrivateUser;
    private String _pathFriendlyURLPublic;
    private String _pathImage;
    private String _pathMain;
    private Map<String, Long> _plidToPortletIdCache = new ConcurrentHashMap<String, Long>();
    private String _portalLibDir;
    private Integer _portalPort = new Integer(-1);
    private String _portalWebDir;
    private Set<String> _reservedParams;
    private String[] _sortedSystemCommunityRoles;
    private String[] _sortedSystemGroups;
    private String[] _sortedSystemOrganizationRoles;
    private String[] _sortedSystemRoles;

    public PortalImpl() {
        this._computerName = System.getProperty("env.COMPUTERNAME");
        if (Validator.isNull((String)this._computerName)) {
            this._computerName = System.getProperty("env.HOST");
        }
        if (Validator.isNull((String)this._computerName)) {
            this._computerName = System.getProperty("env.HOSTNAME");
        }
        if (Validator.isNull((String)this._computerName)) {
            try {
                this._computerName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                // empty catch block
            }
        }
        try {
            this._computerAddress = InetAddress.getByName(this._computerName).getHostAddress();
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        if (Validator.isNull((String)this._computerAddress)) {
            try {
                this._computerAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException uhe) {
                // empty catch block
            }
        }
        this._globalLibDir = ClassUtil.getParentPath((ClassLoader)ReleaseInfo.class.getClassLoader(), (String)ReleaseInfo.class.getName());
        int pos = this._globalLibDir.lastIndexOf(".jar!");
        pos = this._globalLibDir.lastIndexOf("/", pos);
        this._globalLibDir = this._globalLibDir.substring(0, pos + 1);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Global lib directory " + this._globalLibDir));
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        this._portalLibDir = WebDirDetector.getLibDir((ClassLoader)classLoader);
        String portalLibDir = System.getProperty("liferay.lib.portal.dir");
        if (portalLibDir != null) {
            if (!portalLibDir.endsWith("/")) {
                portalLibDir = portalLibDir + "/";
            }
            this._portalLibDir = portalLibDir;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Portal lib directory " + this._portalLibDir));
        }
        this._portalWebDir = WebDirDetector.getRootDir((String)this._portalLibDir);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Portal web directory " + this._portalWebDir));
        }
        this._cdnHostHttp = PropsValues.CDN_HOST_HTTP;
        if (this._cdnHostHttp.startsWith("${")) {
            this._cdnHostHttp = "";
        }
        this._cdnHostHttps = PropsValues.CDN_HOST_HTTPS;
        if (this._cdnHostHttps.startsWith("${")) {
            this._cdnHostHttps = "";
        }
        this._pathContext = PropsUtil.get("portal.ctx");
        if (this._pathContext.equals("/")) {
            this._pathContext = "";
        }
        this._pathFriendlyURLPrivateGroup = this._pathContext + _PRIVATE_GROUP_SERVLET_MAPPING;
        this._pathFriendlyURLPrivateUser = this._pathContext + _PRIVATE_USER_SERVLET_MAPPING;
        this._pathFriendlyURLPublic = this._pathContext + _PUBLIC_GROUP_SERVLET_MAPPING;
        this._pathImage = this._pathContext + "/image";
        this._pathMain = this._pathContext + "/c";
        String[] customSystemGroups = PropsUtil.getArray("system.groups");
        this._allSystemGroups = customSystemGroups == null || customSystemGroups.length == 0 ? GroupConstants.SYSTEM_GROUPS : ArrayUtil.append((String[])GroupConstants.SYSTEM_GROUPS, (String[])customSystemGroups);
        this._sortedSystemGroups = new String[this._allSystemGroups.length];
        System.arraycopy(this._allSystemGroups, 0, this._sortedSystemGroups, 0, this._allSystemGroups.length);
        Arrays.sort(this._sortedSystemGroups, new StringComparator());
        String[] customSystemRoles = PropsUtil.getArray("system.roles");
        this._allSystemRoles = customSystemRoles == null || customSystemRoles.length == 0 ? RoleConstants.SYSTEM_ROLES : ArrayUtil.append((String[])RoleConstants.SYSTEM_ROLES, (String[])customSystemRoles);
        this._sortedSystemRoles = new String[this._allSystemRoles.length];
        System.arraycopy(this._allSystemRoles, 0, this._sortedSystemRoles, 0, this._allSystemRoles.length);
        Arrays.sort(this._sortedSystemRoles, new StringComparator());
        String[] customSystemCommunityRoles = PropsUtil.getArray("system.community.roles");
        this._allSystemCommunityRoles = customSystemCommunityRoles == null || customSystemCommunityRoles.length == 0 ? RoleConstants.SYSTEM_COMMUNITY_ROLES : ArrayUtil.append((String[])RoleConstants.SYSTEM_COMMUNITY_ROLES, (String[])customSystemCommunityRoles);
        this._sortedSystemCommunityRoles = new String[this._allSystemCommunityRoles.length];
        System.arraycopy(this._allSystemCommunityRoles, 0, this._sortedSystemCommunityRoles, 0, this._allSystemCommunityRoles.length);
        Arrays.sort(this._sortedSystemCommunityRoles, new StringComparator());
        String[] customSystemOrganizationRoles = PropsUtil.getArray("system.organization.roles");
        this._allSystemOrganizationRoles = customSystemOrganizationRoles == null || customSystemOrganizationRoles.length == 0 ? RoleConstants.SYSTEM_ORGANIZATION_ROLES : ArrayUtil.append((String[])RoleConstants.SYSTEM_ORGANIZATION_ROLES, (String[])customSystemOrganizationRoles);
        this._sortedSystemOrganizationRoles = new String[this._allSystemOrganizationRoles.length];
        System.arraycopy(this._allSystemOrganizationRoles, 0, this._sortedSystemOrganizationRoles, 0, this._allSystemOrganizationRoles.length);
        Arrays.sort(this._sortedSystemOrganizationRoles, new StringComparator());
        this._reservedParams = new HashSet<String>();
        this._reservedParams.add("p_l_id");
        this._reservedParams.add("p_l_reset");
        this._reservedParams.add("p_p_id");
        this._reservedParams.add("p_p_lifecycle");
        this._reservedParams.add("p_p_url_type");
        this._reservedParams.add("p_p_state");
        this._reservedParams.add("p_p_mode");
        this._reservedParams.add("p_p_resource_id");
        this._reservedParams.add("p_p_cacheability");
        this._reservedParams.add("p_p_width");
        this._reservedParams.add("p_p_col_id");
        this._reservedParams.add("p_p_col_pos");
        this._reservedParams.add("p_p_col_count");
        this._reservedParams.add("p_p_static");
        this._reservedParams.add("saveLastPath");
    }

    public void addPageDescription(String description, HttpServletRequest request) {
        String requestDescription = (String)request.getAttribute("LIFERAY_SHARED_PAGE_DESCRIPTION");
        if (requestDescription != null) {
            description = requestDescription + " " + description;
        }
        request.setAttribute("LIFERAY_SHARED_PAGE_DESCRIPTION", (Object)description);
    }

    public void addPageKeywords(String keywords, HttpServletRequest request) {
        String[] keywordsArray;
        List requestKeywords = (List)request.getAttribute("LIFERAY_SHARED_PAGE_KEYWORDS");
        if (requestKeywords == null) {
            requestKeywords = new UniqueList();
        }
        for (String keyword : keywordsArray = StringUtil.split((String)keywords)) {
            if (requestKeywords.contains(keyword.toLowerCase())) continue;
            requestKeywords.add(keyword.toLowerCase());
        }
        request.setAttribute("LIFERAY_SHARED_PAGE_KEYWORDS", (Object)requestKeywords);
    }

    public void addPageSubtitle(String subtitle, HttpServletRequest request) {
        String requestSubtitle = (String)request.getAttribute("LIFERAY_SHARED_PAGE_SUBTITLE");
        if (requestSubtitle != null) {
            subtitle = requestSubtitle + " " + subtitle;
        }
        request.setAttribute("LIFERAY_SHARED_PAGE_SUBTITLE", (Object)subtitle);
    }

    public void addPageTitle(String title, HttpServletRequest request) {
        String requestTitle = (String)request.getAttribute("LIFERAY_SHARED_PAGE_TITLE");
        if (requestTitle != null) {
            title = requestTitle + " " + title;
        }
        request.setAttribute("LIFERAY_SHARED_PAGE_TITLE", (Object)title);
    }

    public void clearRequestParameters(RenderRequest renderRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("THEME_DISPLAY");
        if (themeDisplay.isLifecycleAction()) {
            ((RenderRequestImpl)renderRequest).getRenderParameters().clear();
        }
    }

    public void copyRequestParameters(ActionRequest actionRequest, ActionResponse actionResponse) {
        try {
            ActionResponseImpl actionResponseImpl = (ActionResponseImpl)actionResponse;
            Map<String, String[]> renderParameters = actionResponseImpl.getRenderParameterMap();
            actionResponse.setRenderParameter("p_p_lifecycle", "1");
            Enumeration enu = actionRequest.getParameterNames();
            while (enu.hasMoreElements()) {
                String param = (String)enu.nextElement();
                String[] values = actionRequest.getParameterValues(param);
                if (renderParameters.get(actionResponseImpl.getNamespace() + param) != null) continue;
                actionResponse.setRenderParameter(param, values);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public String escapeRedirect(String url) {
        if (Validator.isNull((String)url) || !HttpUtil.hasDomain((String)url)) {
            return url;
        }
        try {
            String securityMode = PropsValues.REDIRECT_URL_SECURITY_MODE;
            String domain = StringUtil.split((String)HttpUtil.getDomain((String)url), (String)":")[0];
            if (securityMode.equals("domain")) {
                Object[] allowedDomains = PropsValues.REDIRECT_URL_DOMAINS_ALLOWED;
                if (allowedDomains.length > 0 && !ArrayUtil.contains((Object[])allowedDomains, (Object)domain)) {
                    url = null;
                }
            } else if (securityMode.equals("ip")) {
                String serverIp;
                Object[] allowedIps = PropsValues.REDIRECT_URL_IPS_ALLOWED;
                InetAddress inetAddress = InetAddress.getByName(domain);
                if (!(allowedIps.length <= 0 || ArrayUtil.contains((Object[])allowedIps, (Object)inetAddress.getHostAddress()) || (serverIp = this.getComputerAddress()).equals(inetAddress.getHostAddress()) && ArrayUtil.contains((Object[])allowedIps, (Object)"SERVER_IP"))) {
                    url = null;
                }
            }
        }
        catch (UnknownHostException uhe) {
            url = null;
        }
        return url;
    }

    public BaseModel<?> getBaseModel(Resource resource) throws PortalException, SystemException {
        ResourceCode resourceCode = ResourceCodeLocalServiceUtil.getResourceCode((long)resource.getCodeId());
        String modelName = resourceCode.getName();
        String primKey = resource.getPrimKey();
        return this.getBaseModel(modelName, primKey);
    }

    public BaseModel<?> getBaseModel(ResourcePermission resourcePermission) throws PortalException, SystemException {
        String modelName = resourcePermission.getName();
        String primKey = resourcePermission.getPrimKey();
        return this.getBaseModel(modelName, primKey);
    }

    public BaseModel<?> getBaseModel(String modelName, String primKey) throws PortalException, SystemException {
        if (!modelName.contains(".model.")) {
            return null;
        }
        Object[] parts = StringUtil.split((String)modelName, (String)".");
        if (parts.length <= 2 || !parts[parts.length - 2].equals("model")) {
            return null;
        }
        parts[parts.length - 2] = "service";
        String serviceName = StringUtil.merge((Object[])parts, (String)".") + "LocalServiceUtil";
        String methodName = "get" + (String)parts[parts.length - 1];
        Method method = null;
        try {
            Class<?> serviceUtil = Class.forName(serviceName);
            if (Validator.isNumber((String)primKey)) {
                method = serviceUtil.getMethod(methodName, Long.TYPE);
                return (BaseModel)method.invoke(null, new Long(primKey));
            }
            method = serviceUtil.getMethod(methodName, String.class);
            return (BaseModel)method.invoke(null, primKey);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof PortalException) {
                throw (PortalException)cause;
            }
            if (cause instanceof SystemException) {
                throw (SystemException)cause;
            }
            throw new SystemException(cause);
        }
    }

    public BasePersistence<?> getBasePersistence(BaseModel<?> baseModel) {
        String servletContextName = this.getServletContextName(baseModel);
        String className = baseModel.getClass().getName();
        return this.getBasePersistence(servletContextName, className);
    }

    public BasePersistence<?> getBasePersistence(String servletContextName, String className) {
        int pos = className.indexOf(".model.impl.");
        String packagePath = className.substring(0, pos);
        String modelName = className.substring(pos + 12, className.length() - 9);
        StringBuilder sb = new StringBuilder();
        sb.append(packagePath);
        sb.append(".service.persistence.");
        sb.append(modelName);
        sb.append("Persistence");
        String beanName = sb.toString();
        if (Validator.isNull((String)servletContextName)) {
            return (BasePersistence)PortalBeanLocatorUtil.locate((String)beanName);
        }
        return (BasePersistence)PortletBeanLocatorUtil.locate((String)servletContextName, (String)beanName);
    }

    public long getBasicAuthUserId(HttpServletRequest request) throws PortalException, SystemException {
        long companyId = PortalInstances.getCompanyId(request);
        return this.getBasicAuthUserId(request, companyId);
    }

    public long getBasicAuthUserId(HttpServletRequest request, long companyId) throws PortalException, SystemException {
        long userId = 0L;
        String authorizationHeader = request.getHeader("Authorization");
        if (Validator.isNull((String)authorizationHeader)) {
            return userId;
        }
        String[] authorizationArray = authorizationHeader.split("\\s+");
        String authorization = authorizationArray[0];
        String credentials = new String(Base64.decode((String)authorizationArray[1]));
        if (!authorization.equalsIgnoreCase("BASIC")) {
            return userId;
        }
        String[] loginAndPassword = StringUtil.split((String)credentials, (String)":");
        String login = loginAndPassword[0].trim();
        String password = null;
        if (loginAndPassword.length > 1) {
            password = loginAndPassword[1].trim();
        }
        if (login.endsWith("@uid")) {
            int pos = login.indexOf("@uid");
            login = login.substring(0, pos);
        } else if (login.endsWith("@sn")) {
            int pos = login.indexOf("@sn");
            login = login.substring(0, pos);
        }
        userId = UserLocalServiceUtil.authenticateForBasic((long)companyId, (String)"emailAddress", (String)login, (String)password);
        if (userId > 0L) {
            return userId;
        }
        userId = UserLocalServiceUtil.authenticateForBasic((long)companyId, (String)"screenName", (String)login, (String)password);
        if (userId > 0L) {
            return userId;
        }
        userId = UserLocalServiceUtil.authenticateForBasic((long)companyId, (String)"userId", (String)login, (String)password);
        return userId;
    }

    public String getCDNHost() {
        return this.getCDNHostHttp();
    }

    public String getCDNHost(boolean secure) {
        if (secure) {
            return this.getCDNHostHttps();
        }
        return this.getCDNHostHttp();
    }

    public String getCDNHostHttp() {
        return this._cdnHostHttp;
    }

    public String getCDNHostHttps() {
        return this._cdnHostHttps;
    }

    public String getClassName(long classNameId) {
        try {
            ClassName className = ClassNameLocalServiceUtil.getClassName((long)classNameId);
            return className.getValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get class name from id " + classNameId);
        }
    }

    public long getClassNameId(Class<?> classObj) {
        return ClassNameLocalServiceUtil.getClassNameId(classObj);
    }

    public long getClassNameId(String value) {
        return ClassNameLocalServiceUtil.getClassNameId((String)value);
    }

    public String getClassNamePortletId(String className) {
        String portletId = "";
        if (className.startsWith("com.liferay.portlet.blogs")) {
            portletId = "33";
        } else if (className.startsWith("com.liferay.portlet.bookmarks")) {
            portletId = "28";
        } else if (className.startsWith("com.liferay.portlet.documentlibrary")) {
            portletId = "20";
        } else if (className.startsWith("com.liferay.portlet.imagegallery")) {
            portletId = "31";
        } else if (className.startsWith("com.liferay.portlet.journal")) {
            portletId = "15";
        } else if (className.startsWith("com.liferay.portlet.messageboards")) {
            portletId = "19";
        } else if (className.startsWith("com.liferay.portlet.wiki")) {
            portletId = "36";
        }
        return portletId;
    }

    public String getCommunityLoginURL(ThemeDisplay themeDisplay) throws PortalException, SystemException {
        if (Validator.isNull((String)PropsValues.AUTH_LOGIN_COMMUNITY_URL)) {
            return null;
        }
        for (Layout layout : themeDisplay.getLayouts()) {
            if (!layout.getFriendlyURL().equals(PropsValues.AUTH_LOGIN_COMMUNITY_URL)) continue;
            if (themeDisplay.getLayout() == null) break;
            String layoutSetFriendlyURL = this.getLayoutSetFriendlyURL(themeDisplay.getLayout().getLayoutSet(), themeDisplay);
            return layoutSetFriendlyURL + PropsValues.AUTH_LOGIN_COMMUNITY_URL;
        }
        return null;
    }

    public String[] getCommunityPermissions(HttpServletRequest request) {
        return request.getParameterValues("communityPermissions");
    }

    public String[] getCommunityPermissions(PortletRequest portletRequest) {
        return portletRequest.getParameterValues("communityPermissions");
    }

    public Company getCompany(HttpServletRequest request) throws PortalException, SystemException {
        long companyId = this.getCompanyId(request);
        if (companyId <= 0L) {
            return null;
        }
        Company company = (Company)request.getAttribute("COMPANY");
        if (company == null) {
            try {
                company = CompanyLocalServiceUtil.getCompanyById((long)companyId);
            }
            catch (NoSuchCompanyException nsce) {
                company = CompanyLocalServiceUtil.getCompanyById((long)PortalInstances.getDefaultCompanyId());
            }
            request.setAttribute("COMPANY", (Object)company);
        }
        return company;
    }

    public Company getCompany(PortletRequest portletRequest) throws PortalException, SystemException {
        return this.getCompany(this.getHttpServletRequest(portletRequest));
    }

    public long getCompanyId(HttpServletRequest request) {
        return PortalInstances.getCompanyId(request);
    }

    public long getCompanyId(PortletRequest portletRequest) {
        return this.getCompanyId(this.getHttpServletRequest(portletRequest));
    }

    public long[] getCompanyIds() {
        return PortalInstances.getCompanyIds();
    }

    public String getComputerAddress() {
        return this._computerAddress;
    }

    public String getComputerName() {
        return this._computerName;
    }

    public String getControlPanelCategory(String portletId, ThemeDisplay themeDisplay) throws SystemException {
        for (String category : PortletCategoryKeys.ALL) {
            List<Portlet> portlets = this.getControlPanelPortlets(category, themeDisplay);
            for (Portlet portlet : portlets) {
                if (!portlet.getPortletId().equals(portletId)) continue;
                return category;
            }
        }
        return "";
    }

    public List<Portlet> getControlPanelPortlets(String category, ThemeDisplay themeDisplay) throws SystemException {
        TreeSet<Portlet> portletsSet = new TreeSet<Portlet>((Comparator<Portlet>)new PortletControlPanelWeightComparator());
        List portletsList = PortletLocalServiceUtil.getPortlets((long)themeDisplay.getCompanyId());
        for (Portlet portlet : portletsList) {
            if (!category.equals(portlet.getControlPanelEntryCategory())) continue;
            portletsSet.add(portlet);
        }
        return this.filterControlPanelPortlets(portletsSet, category, themeDisplay);
    }

    public String getCurrentCompleteURL(HttpServletRequest request) {
        String currentCompleteURL = (String)request.getAttribute("CURRENT_COMPLETE_URL");
        if (currentCompleteURL == null) {
            currentCompleteURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
            request.setAttribute("CURRENT_COMPLETE_URL", (Object)currentCompleteURL);
        }
        return currentCompleteURL;
    }

    public String getCurrentURL(HttpServletRequest request) {
        String currentURL = (String)request.getAttribute("CURRENT_URL");
        if (currentURL == null) {
            currentURL = ParamUtil.getString((HttpServletRequest)request, (String)"currentURL");
            if (Validator.isNull((String)currentURL)) {
                currentURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
                if (Validator.isNotNull((String)currentURL) && currentURL.indexOf(_J_SECURITY_CHECK) == -1) {
                    currentURL = currentURL.substring(currentURL.indexOf("://") + "://".length());
                    currentURL = currentURL.substring(currentURL.indexOf("/"));
                }
                if (Validator.isNotNull((String)currentURL) && FacebookUtil.isFacebook(currentURL)) {
                    String[] facebookData = FacebookUtil.getFacebookData(request);
                    currentURL = "http://apps.facebook.com/" + facebookData[0] + facebookData[2];
                }
            }
            if (Validator.isNull((String)currentURL)) {
                currentURL = this.getPathMain();
            }
            request.setAttribute("CURRENT_URL", (Object)currentURL);
        }
        return currentURL;
    }

    public String getCurrentURL(PortletRequest portletRequest) {
        return (String)portletRequest.getAttribute("CURRENT_URL");
    }

    public String getCustomSQLFunctionIsNotNull() {
        return PropsValues.CUSTOM_SQL_FUNCTION_ISNOTNULL;
    }

    public String getCustomSQLFunctionIsNull() {
        return PropsValues.CUSTOM_SQL_FUNCTION_ISNULL;
    }

    public Date getDate(int month, int day, int year, int hour, int min, PortalException pe) throws PortalException {
        return this.getDate(month, day, year, hour, min, null, pe);
    }

    public Date getDate(int month, int day, int year, int hour, int min, TimeZone timeZone, PortalException pe) throws PortalException {
        if (!Validator.isGregorianDate((int)month, (int)day, (int)year)) {
            throw pe;
        }
        Calendar cal = null;
        cal = timeZone == null ? CalendarFactoryUtil.getCalendar() : CalendarFactoryUtil.getCalendar((TimeZone)timeZone);
        if (hour == -1 || min == -1) {
            cal.set(year, month, day, 0, 0, 0);
        } else {
            cal.set(year, month, day, hour, min, 0);
        }
        cal.set(14, 0);
        Date date = cal.getTime();
        return date;
    }

    public Date getDate(int month, int day, int year, PortalException pe) throws PortalException {
        return this.getDate(month, day, year, null, pe);
    }

    public Date getDate(int month, int day, int year, TimeZone timeZone, PortalException pe) throws PortalException {
        return this.getDate(month, day, year, -1, -1, timeZone, pe);
    }

    public long getDefaultCompanyId() {
        return PortalInstances.getDefaultCompanyId();
    }

    public Map<String, Serializable> getExpandoBridgeAttributes(ExpandoBridge expandoBridge, PortletRequest portletRequest) throws PortalException, SystemException {
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        ArrayList<String> names = new ArrayList<String>();
        Enumeration enu = portletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            if (param.indexOf("ExpandoAttributeName(") == -1) continue;
            String name = ParamUtil.getString((PortletRequest)portletRequest, (String)param);
            names.add(name);
        }
        for (String name : names) {
            int type = expandoBridge.getAttributeType(name);
            Serializable value = EditExpandoAction.getValue(portletRequest, "ExpandoAttribute(" + name + ")", type);
            attributes.put(name, value);
        }
        return attributes;
    }

    public String getFirstPageLayoutTypes(PageContext pageContext) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < PropsValues.LAYOUT_TYPES.length; ++i) {
            String type = PropsValues.LAYOUT_TYPES[i];
            if (!this.isLayoutFirstPageable(type)) continue;
            sb.append(LanguageUtil.get((PageContext)pageContext, (String)("layout.types." + type)));
            sb.append(",");
            sb.append(" ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    public String getGlobalLibDir() {
        return this._globalLibDir;
    }

    public String getGoogleGadgetURL(Portlet portlet, ThemeDisplay themeDisplay) {
        return this._getServletURL(portlet, PropsValues.GOOGLE_GADGET_SERVLET_MAPPING, themeDisplay);
    }

    public String[] getGuestPermissions(HttpServletRequest request) {
        String[] guestPermissions = request.getParameterValues("guestPermissions");
        if (guestPermissions == null) {
            return null;
        }
        boolean inputPermissionsPublic = ParamUtil.getBoolean((HttpServletRequest)request, (String)"inputPermissionsPublic");
        boolean inputPermissionsShowConfigure = ParamUtil.getBoolean((HttpServletRequest)request, (String)"inputPermissionsShowConfigure");
        if (!inputPermissionsShowConfigure) {
            if (!inputPermissionsPublic) {
                guestPermissions = new String[]{};
            } else if (guestPermissions == null || guestPermissions.length == 0) {
                guestPermissions = new String[]{"VIEW"};
            }
        }
        return guestPermissions;
    }

    public String[] getGuestPermissions(PortletRequest portletRequest) {
        String[] guestPermissions = portletRequest.getParameterValues("guestPermissions");
        if (guestPermissions == null) {
            return null;
        }
        boolean inputPermissionsPublic = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"inputPermissionsPublic");
        boolean inputPermissionsShowConfigure = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"inputPermissionsShowConfigure");
        if (!inputPermissionsShowConfigure) {
            if (!inputPermissionsPublic) {
                guestPermissions = new String[]{};
            } else if (guestPermissions == null || guestPermissions.length == 0) {
                guestPermissions = new String[]{"VIEW"};
            }
        }
        return guestPermissions;
    }

    public String getHomeURL(HttpServletRequest request) throws PortalException, SystemException {
        String portalURL = this.getPortalURL(request);
        Company company = this.getCompany(request);
        String homeURL = company.getHomeURL();
        if (Validator.isNull((String)homeURL)) {
            homeURL = PropsValues.COMPANY_DEFAULT_HOME_URL;
        }
        return portalURL + this._pathContext + homeURL;
    }

    public String getHost(HttpServletRequest request) {
        String host = (request = this.getOriginalServletRequest(request)).getHeader("Host");
        if (host != null) {
            int pos = (host = host.trim().toLowerCase()).indexOf(58);
            if (pos >= 0) {
                host = host.substring(0, pos);
            }
        } else {
            host = null;
        }
        return host;
    }

    public String getHost(PortletRequest portletRequest) {
        return this.getHost(this.getHttpServletRequest(portletRequest));
    }

    public HttpServletRequest getHttpServletRequest(PortletRequest portletRequest) {
        if (portletRequest instanceof PortletRequestImpl) {
            PortletRequestImpl portletRequestImpl = (PortletRequestImpl)portletRequest;
            return portletRequestImpl.getHttpServletRequest();
        }
        if (portletRequest instanceof PortletRequestWrapper) {
            PortletRequestWrapper portletRequestWrapper = (PortletRequestWrapper)portletRequest;
            return this.getHttpServletRequest(portletRequestWrapper.getRequest());
        }
        throw new RuntimeException("Unable to get the HTTP servlet request from " + portletRequest.getClass().getName());
    }

    public HttpServletResponse getHttpServletResponse(PortletResponse portletResponse) {
        if (portletResponse instanceof ActionResponseImpl) {
            ActionResponseImpl actionResponseImpl = (ActionResponseImpl)portletResponse;
            return actionResponseImpl.getHttpServletResponse();
        }
        if (portletResponse instanceof RenderResponseImpl) {
            RenderResponseImpl renderResponseImpl = (RenderResponseImpl)portletResponse;
            return renderResponseImpl.getHttpServletResponse();
        }
        if (portletResponse instanceof PortletResponseWrapper) {
            PortletResponseWrapper portletResponseWrapper = (PortletResponseWrapper)portletResponse;
            return this.getHttpServletResponse(portletResponseWrapper.getResponse());
        }
        PortletResponseImpl portletResponseImpl = PortletResponseImpl.getPortletResponseImpl(portletResponse);
        return portletResponseImpl.getHttpServletResponse();
    }

    public String getJsSafePortletId(String portletId) {
        return JS.getSafeName((String)portletId);
    }

    public String getLayoutActualURL(Layout layout) {
        return this.getLayoutActualURL(layout, this.getPathMain());
    }

    public String getLayoutActualURL(Layout layout, String mainPath) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("liferay:groupId", String.valueOf(layout.getGroupId()));
        variables.put("liferay:mainPath", mainPath);
        variables.put("liferay:plid", String.valueOf(layout.getPlid()));
        UnicodeProperties typeSettingsProperties = layout.getLayoutType().getTypeSettingsProperties();
        for (Map.Entry entry : typeSettingsProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            variables.put(key, value);
        }
        String href = PropsUtil.get("layout.url", new Filter(layout.getType(), variables));
        return href;
    }

    public String getLayoutActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL) throws PortalException, SystemException {
        return this.getLayoutActualURL(groupId, privateLayout, mainPath, friendlyURL, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getLayoutActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params) throws PortalException, SystemException {
        Layout layout = null;
        String queryString = "";
        if (Validator.isNull((String)friendlyURL)) {
            List layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long)0L);
            if (layouts.size() <= 0) throw new NoSuchLayoutException("{groupId=" + groupId + ",privateLayout=" + privateLayout + "} does not have any layouts");
            layout = (Layout)layouts.get(0);
        } else {
            Object[] friendlyURLMapper = this.getPortletFriendlyURLMapper(groupId, privateLayout, friendlyURL, params);
            layout = (Layout)friendlyURLMapper[0];
            queryString = (String)friendlyURLMapper[1];
        }
        String layoutActualURL = this.getLayoutActualURL(layout, mainPath);
        if (Validator.isNotNull((String)queryString)) {
            return layoutActualURL + queryString;
        }
        if (!params.isEmpty()) return layoutActualURL;
        UnicodeProperties typeSettingsProperties = layout.getLayoutType().getTypeSettingsProperties();
        queryString = typeSettingsProperties.getProperty("query-string");
        if (!Validator.isNotNull((String)queryString)) return layoutActualURL;
        if (!layoutActualURL.contains("?")) return layoutActualURL;
        return layoutActualURL + "&" + queryString;
    }

    public String getLayoutEditPage(Layout layout) {
        return PropsUtil.get("layout.edit.page", new Filter(layout.getType()));
    }

    public String getLayoutFriendlyURL(Layout layout, ThemeDisplay themeDisplay) {
        if (!this.isLayoutFriendliable(layout)) {
            return null;
        }
        String layoutFriendlyURL = layout.getFriendlyURL();
        LayoutSet layoutSet = layout.getLayoutSet();
        long curLayoutSetId = themeDisplay.getLayout().getLayoutSet().getLayoutSetId();
        String portalURL = "";
        if (!themeDisplay.getServerName().equals(_LOCALHOST)) {
            String virtualHost = layoutSet.getVirtualHost();
            if (Validator.isNull((String)virtualHost) && Validator.isNotNull((String)PropsValues.VIRTUAL_HOSTS_DEFAULT_COMMUNITY_NAME)) {
                try {
                    Group group = GroupLocalServiceUtil.getGroup((long)themeDisplay.getCompanyId(), (String)PropsValues.VIRTUAL_HOSTS_DEFAULT_COMMUNITY_NAME);
                    if (layoutSet.getGroupId() == group.getGroupId()) {
                        Company company = themeDisplay.getCompany();
                        virtualHost = company.getVirtualHost();
                    }
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
            if (Validator.isNotNull((String)virtualHost)) {
                virtualHost = this.getPortalURL(virtualHost, themeDisplay.getServerPort(), themeDisplay.isSecure());
                String portalDomain = HttpUtil.getDomain((String)themeDisplay.getPortalURL());
                if (layoutSet.getLayoutSetId() != curLayoutSetId || virtualHost.indexOf(portalDomain) != -1) {
                    if (themeDisplay.isWidget()) {
                        layoutFriendlyURL = PropsValues.WIDGET_SERVLET_MAPPING + layoutFriendlyURL;
                    }
                    if (themeDisplay.isI18n()) {
                        layoutFriendlyURL = themeDisplay.getI18nPath() + layoutFriendlyURL;
                    }
                    return virtualHost + this._pathContext + layoutFriendlyURL;
                }
            } else if (layoutSet.getLayoutSetId() != curLayoutSetId && layout.getGroup().getClassPK() != themeDisplay.getUserId() && !(virtualHost = themeDisplay.getCompany().getVirtualHost()).equalsIgnoreCase(_LOCALHOST)) {
                portalURL = this.getPortalURL(virtualHost, themeDisplay.getServerPort(), themeDisplay.isSecure());
            }
        }
        Group group = layout.getGroup();
        String friendlyURL = null;
        friendlyURL = layout.isPrivateLayout() ? (group.isUser() ? _PRIVATE_USER_SERVLET_MAPPING : _PRIVATE_GROUP_SERVLET_MAPPING) : _PUBLIC_GROUP_SERVLET_MAPPING;
        if (themeDisplay.isWidget()) {
            friendlyURL = PropsValues.WIDGET_SERVLET_MAPPING + friendlyURL;
        }
        if (themeDisplay.isI18n()) {
            friendlyURL = themeDisplay.getI18nPath() + friendlyURL;
        }
        return portalURL + this._pathContext + friendlyURL + group.getFriendlyURL() + layoutFriendlyURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLayoutFriendlyURL(Layout layout, ThemeDisplay themeDisplay, Locale locale) {
        String i18nLanguageId = themeDisplay.getI18nLanguageId();
        String i18nPath = themeDisplay.getI18nPath();
        try {
            String tempI18nLanguageId = null;
            if (I18nFilter.getLanguageIds().contains(locale.toString()) && PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 1 && !locale.equals(LocaleUtil.getDefault()) || PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 2) {
                tempI18nLanguageId = locale.toString();
            }
            String tempI18nPath = null;
            if (Validator.isNotNull((String)tempI18nLanguageId)) {
                tempI18nPath = "/" + tempI18nLanguageId;
                if (!LanguageUtil.isDuplicateLanguageCode((String)locale.getLanguage())) {
                    tempI18nPath = "/" + locale.getLanguage();
                } else {
                    Locale priorityLocale = LanguageUtil.getLocale((String)locale.getLanguage());
                    if (locale.equals(priorityLocale)) {
                        tempI18nPath = "/" + locale.getLanguage();
                    }
                }
            }
            themeDisplay.setI18nLanguageId(tempI18nLanguageId);
            themeDisplay.setI18nPath(tempI18nPath);
            String string = this.getLayoutFriendlyURL(layout, themeDisplay);
            return string;
        }
        finally {
            themeDisplay.setI18nLanguageId(i18nLanguageId);
            themeDisplay.setI18nPath(i18nPath);
        }
    }

    public String getLayoutFullURL(Layout layout, ThemeDisplay themeDisplay) {
        return this.getLayoutFullURL(layout, themeDisplay, true);
    }

    public String getLayoutFullURL(Layout layout, ThemeDisplay themeDisplay, boolean doAsUser) {
        String portalURL;
        String layoutURL = this.getLayoutURL(layout, themeDisplay, doAsUser);
        if (StringUtil.startsWith((String)layoutURL, (String)(portalURL = themeDisplay.getPortalURL()))) {
            return layoutURL;
        }
        return portalURL + layoutURL;
    }

    public String getLayoutFullURL(long groupId, String portletId) throws PortalException, SystemException {
        long plid = this.getPlidFromPortletId(groupId, portletId);
        if (plid == 0L) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        Company company = CompanyLocalServiceUtil.getCompany((long)layout.getCompanyId());
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        String portalURL = this.getPortalURL(company.getVirtualHost(), this.getPortalPort(), false);
        sb.append(portalURL);
        if (layout.isPrivateLayout()) {
            if (group.isUser()) {
                sb.append(PortalUtil.getPathFriendlyURLPrivateUser());
            } else {
                sb.append(PortalUtil.getPathFriendlyURLPrivateGroup());
            }
        } else {
            sb.append(PortalUtil.getPathFriendlyURLPublic());
        }
        sb.append(group.getFriendlyURL());
        sb.append(layout.getFriendlyURL());
        return sb.toString();
    }

    public String getLayoutFullURL(ThemeDisplay themeDisplay) {
        return this.getLayoutFullURL(themeDisplay.getLayout(), themeDisplay);
    }

    public String getLayoutSetFriendlyURL(LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        Group group;
        String virtualHost = layoutSet.getVirtualHost();
        if (Validator.isNull((String)virtualHost) && Validator.isNotNull((String)PropsValues.VIRTUAL_HOSTS_DEFAULT_COMMUNITY_NAME)) {
            try {
                group = GroupLocalServiceUtil.getGroup((long)themeDisplay.getCompanyId(), (String)PropsValues.VIRTUAL_HOSTS_DEFAULT_COMMUNITY_NAME);
                if (layoutSet.getGroupId() == group.getGroupId()) {
                    Company company = themeDisplay.getCompany();
                    virtualHost = company.getVirtualHost();
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (Validator.isNotNull((String)virtualHost)) {
            String portalURL = this.getPortalURL(virtualHost, themeDisplay.getServerPort(), themeDisplay.isSecure());
            long curLayoutSetId = themeDisplay.getLayout().getLayoutSet().getLayoutSetId();
            if (layoutSet.getLayoutSetId() != curLayoutSetId || portalURL.startsWith(themeDisplay.getURLPortal())) {
                String layoutSetFriendlyURL = "";
                if (themeDisplay.isI18n()) {
                    layoutSetFriendlyURL = themeDisplay.getI18nPath();
                }
                return portalURL + this._pathContext + layoutSetFriendlyURL;
            }
        }
        group = GroupLocalServiceUtil.getGroup((long)layoutSet.getGroupId());
        String friendlyURL = null;
        friendlyURL = layoutSet.isPrivateLayout() ? (group.isUser() ? _PRIVATE_USER_SERVLET_MAPPING : _PRIVATE_GROUP_SERVLET_MAPPING) : _PUBLIC_GROUP_SERVLET_MAPPING;
        if (themeDisplay.isI18n()) {
            friendlyURL = themeDisplay.getI18nPath() + friendlyURL;
        }
        return this._pathContext + friendlyURL + group.getFriendlyURL();
    }

    public String getLayoutTarget(Layout layout) {
        UnicodeProperties typeSettingsProps = layout.getTypeSettingsProperties();
        String target = typeSettingsProps.getProperty("target");
        target = Validator.isNull((String)target) ? "" : "target=\"" + target + "\"";
        return target;
    }

    public String getLayoutURL(Layout layout, ThemeDisplay themeDisplay) {
        return this.getLayoutURL(layout, themeDisplay, true);
    }

    public String getLayoutURL(Layout layout, ThemeDisplay themeDisplay, boolean doAsUser) {
        String layoutFriendlyURL;
        if (layout == null) {
            return themeDisplay.getPathMain() + "/portal/layout";
        }
        if (!layout.getType().equals("url") && Validator.isNotNull((String)(layoutFriendlyURL = this.getLayoutFriendlyURL(layout, themeDisplay)))) {
            if (doAsUser) {
                if (Validator.isNotNull((String)themeDisplay.getDoAsUserId())) {
                    layoutFriendlyURL = HttpUtil.addParameter((String)layoutFriendlyURL, (String)"doAsUserId", (String)themeDisplay.getDoAsUserId());
                }
                if (Validator.isNotNull((String)themeDisplay.getDoAsUserLanguageId())) {
                    layoutFriendlyURL = HttpUtil.addParameter((String)layoutFriendlyURL, (String)"doAsUserLanguageId", (String)themeDisplay.getDoAsUserLanguageId());
                }
            }
            return layoutFriendlyURL;
        }
        String layoutURL = this.getLayoutActualURL(layout);
        if (doAsUser) {
            if (Validator.isNotNull((String)themeDisplay.getDoAsUserId())) {
                layoutURL = HttpUtil.addParameter((String)layoutURL, (String)"doAsUserId", (String)themeDisplay.getDoAsUserId());
            }
            if (Validator.isNotNull((String)themeDisplay.getDoAsUserLanguageId())) {
                layoutURL = HttpUtil.addParameter((String)layoutURL, (String)"doAsUserLanguageId", (String)themeDisplay.getDoAsUserLanguageId());
            }
        }
        return layoutURL;
    }

    public String getLayoutURL(ThemeDisplay themeDisplay) {
        return this.getLayoutURL(themeDisplay.getLayout(), themeDisplay);
    }

    public String getLayoutViewPage(Layout layout) {
        return PropsUtil.get("layout.view.page", new Filter(layout.getType()));
    }

    public Locale getLocale(HttpServletRequest request) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        if (themeDisplay != null) {
            return themeDisplay.getLocale();
        }
        HttpSession session = request.getSession();
        return (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
    }

    public Locale getLocale(RenderRequest renderRequest) {
        return this.getLocale(this.getHttpServletRequest((PortletRequest)renderRequest));
    }

    public String getNetvibesURL(Portlet portlet, ThemeDisplay themeDisplay) {
        return this._getServletURL(portlet, PropsValues.NETVIBES_SERVLET_MAPPING, themeDisplay);
    }

    public HttpServletRequest getOriginalServletRequest(HttpServletRequest request) {
        HttpServletRequest originalRequest = request;
        while (originalRequest.getClass().getName().startsWith("com.liferay.")) {
            originalRequest = (HttpServletRequest)((HttpServletRequestWrapper)originalRequest).getRequest();
        }
        return originalRequest;
    }

    public String getPathContext() {
        return this._pathContext;
    }

    public String getPathFriendlyURLPrivateGroup() {
        return this._pathFriendlyURLPrivateGroup;
    }

    public String getPathFriendlyURLPrivateUser() {
        return this._pathFriendlyURLPrivateUser;
    }

    public String getPathFriendlyURLPublic() {
        return this._pathFriendlyURLPublic;
    }

    public String getPathImage() {
        return this._pathImage;
    }

    public String getPathMain() {
        return this._pathMain;
    }

    public long getPlidFromFriendlyURL(long companyId, String friendlyURL) {
        if (Validator.isNull((String)friendlyURL)) {
            return 0L;
        }
        String[] urlParts = friendlyURL.split("\\/", 4);
        if (friendlyURL.charAt(0) != '/' && urlParts.length != 4) {
            return 0L;
        }
        boolean privateLayout = true;
        String urlPrefix = "/" + urlParts[1];
        if (_PUBLIC_GROUP_SERVLET_MAPPING.equals(urlPrefix)) {
            privateLayout = false;
        } else if (_PRIVATE_GROUP_SERVLET_MAPPING.equals(urlPrefix) || _PRIVATE_USER_SERVLET_MAPPING.equals(urlPrefix)) {
            privateLayout = true;
        } else {
            return 0L;
        }
        Group group = null;
        try {
            group = GroupLocalServiceUtil.getFriendlyURLGroup((long)companyId, (String)("/" + urlParts[2]));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (group != null) {
            Layout layout = null;
            try {
                String layoutFriendlyURL = null;
                layoutFriendlyURL = urlParts.length == 4 ? "/" + urlParts[3] : "/1";
                layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)group.getGroupId(), (boolean)privateLayout, (String)layoutFriendlyURL);
                return layout.getPlid();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return 0L;
    }

    public long getPlidFromPortletId(long groupId, boolean privateLayout, String portletId) {
        long plid = 0L;
        StringBuilder sb = new StringBuilder();
        sb.append(groupId);
        sb.append(" ");
        sb.append(privateLayout);
        sb.append(" ");
        sb.append(portletId);
        String key = sb.toString();
        Long plidObj = this._plidToPortletIdCache.get(key);
        if (plidObj == null) {
            plid = this._getPlidFromPortletId(groupId, privateLayout, portletId);
            if (plid != 0L) {
                this._plidToPortletIdCache.put(key, plid);
            }
        } else {
            plid = plidObj;
            boolean validPlid = false;
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                if (layoutTypePortlet.hasPortletId(portletId)) {
                    validPlid = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!validPlid) {
                this._plidToPortletIdCache.remove(key);
                plid = this._getPlidFromPortletId(groupId, privateLayout, portletId);
                if (plid != 0L) {
                    this._plidToPortletIdCache.put(key, plid);
                }
            }
        }
        return plid;
    }

    public long getPlidFromPortletId(long groupId, String portletId) {
        long plid = this.getPlidFromPortletId(groupId, false, portletId);
        if (plid == 0L) {
            plid = this.getPlidFromPortletId(groupId, true, portletId);
        }
        if (plid == 0L && _log.isDebugEnabled()) {
            _log.debug((Object)("Portlet " + portletId + " does not exist on a page in group " + groupId));
        }
        return plid;
    }

    public String getPortalLibDir() {
        return this._portalLibDir;
    }

    public int getPortalPort() {
        return this._portalPort;
    }

    public Properties getPortalProperties() {
        return PropsUtil.getProperties();
    }

    public String getPortalURL(HttpServletRequest request) {
        return this.getPortalURL(request, request.isSecure());
    }

    public String getPortalURL(HttpServletRequest request, boolean secure) {
        return this.getPortalURL(request.getServerName(), request.getServerPort(), secure);
    }

    public String getPortalURL(PortletRequest portletRequest) {
        return this.getPortalURL(portletRequest, portletRequest.isSecure());
    }

    public String getPortalURL(PortletRequest portletRequest, boolean secure) {
        return this.getPortalURL(portletRequest.getServerName(), portletRequest.getServerPort(), secure);
    }

    public String getPortalURL(String serverName, int serverPort, boolean secure) {
        StringBuilder sb = new StringBuilder();
        if (secure || "https".equals(PropsValues.WEB_SERVER_PROTOCOL)) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        if (Validator.isNull((String)PropsValues.WEB_SERVER_HOST)) {
            sb.append(serverName);
        } else {
            sb.append(PropsValues.WEB_SERVER_HOST);
        }
        if (!secure) {
            if (PropsValues.WEB_SERVER_HTTP_PORT == -1) {
                if (serverPort != 80 && serverPort != 443) {
                    sb.append(":");
                    sb.append(serverPort);
                }
            } else if (PropsValues.WEB_SERVER_HTTP_PORT != serverPort && PropsValues.WEB_SERVER_HTTP_PORT != 80) {
                sb.append(":");
                sb.append(PropsValues.WEB_SERVER_HTTP_PORT);
            }
        }
        if (secure) {
            if (PropsValues.WEB_SERVER_HTTPS_PORT == -1) {
                if (serverPort != 80 && serverPort != 443) {
                    sb.append(":");
                    sb.append(serverPort);
                }
            } else if (PropsValues.WEB_SERVER_HTTPS_PORT != serverPort && PropsValues.WEB_SERVER_HTTPS_PORT != 443) {
                sb.append(":");
                sb.append(PropsValues.WEB_SERVER_HTTPS_PORT);
            }
        }
        return sb.toString();
    }

    public String getPortalURL(ThemeDisplay themeDisplay) {
        LayoutSet layoutSet;
        String virtualHost;
        String serverName = themeDisplay.getServerName();
        Layout layout = themeDisplay.getLayout();
        if (layout != null && Validator.isNotNull((String)(virtualHost = (layoutSet = layout.getLayoutSet()).getVirtualHost()))) {
            serverName = virtualHost;
        }
        return this.getPortalURL(serverName, themeDisplay.getServerPort(), themeDisplay.isSecure());
    }

    public String getPortalWebDir() {
        return this._portalWebDir;
    }

    public String getPortletDescription(Portlet portlet, ServletContext servletContext, Locale locale) {
        PortletConfig portletConfig = PortletConfigFactory.create(portlet, servletContext);
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        return resourceBundle.getString("javax.portlet.description");
    }

    public String getPortletDescription(Portlet portlet, User user) {
        return this.getPortletDescription(portlet.getPortletId(), user);
    }

    public String getPortletDescription(String portletId, Locale locale) {
        StringBuilder sb = new StringBuilder();
        sb.append("javax.portlet.description");
        sb.append(".");
        sb.append(portletId);
        return LanguageUtil.get((Locale)locale, (String)sb.toString());
    }

    public String getPortletDescription(String portletId, String languageId) {
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        return this.getPortletDescription(portletId, locale);
    }

    public String getPortletDescription(String portletId, User user) {
        StringBuilder sb = new StringBuilder();
        sb.append("javax.portlet.description");
        sb.append(".");
        sb.append(portletId);
        return LanguageUtil.get((Locale)user.getLocale(), (String)sb.toString());
    }

    public Object[] getPortletFriendlyURLMapper(long groupId, boolean privateLayout, String url) throws PortalException, SystemException {
        return this.getPortletFriendlyURLMapper(groupId, privateLayout, url, null);
    }

    public Object[] getPortletFriendlyURLMapper(long groupId, boolean privateLayout, String url, Map<String, String[]> params) throws PortalException, SystemException {
        int x;
        HashMap<Object, Object> actualParams;
        boolean foundFriendlyURLMapper = false;
        String friendlyURL = url;
        String queryString = "";
        List portlets = PortletLocalServiceUtil.getFriendlyURLMapperPortlets();
        for (Portlet portlet : portlets) {
            FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
            if (url.endsWith("/" + friendlyURLMapper.getMapping())) {
                url = url + "/";
            }
            int pos = -1;
            pos = friendlyURLMapper.isCheckMappingWithPrefix() ? url.indexOf("/-/" + friendlyURLMapper.getMapping() + "/") : url.indexOf("/" + friendlyURLMapper.getMapping() + "/");
            if (pos == -1) continue;
            foundFriendlyURLMapper = true;
            friendlyURL = url.substring(0, pos);
            actualParams = new HashMap();
            HashMap<String, String> prpIdentifiers = new HashMap<String, String>();
            Set publicRenderParameters = portlet.getPublicRenderParameters();
            for (PublicRenderParameter publicRenderParameter : publicRenderParameters) {
                QName qName = publicRenderParameter.getQName();
                String publicRenderParameterIdentifier = qName.getLocalPart();
                String publicRenderParameterName = PortletQNameUtil.getPublicRenderParameterName((QName)qName);
                prpIdentifiers.put(publicRenderParameterIdentifier, publicRenderParameterName);
            }
            FriendlyURLMapperThreadLocal.setPRPIdentifiers(prpIdentifiers);
            if (friendlyURLMapper.isCheckMappingWithPrefix()) {
                friendlyURLMapper.populateParams(url.substring(pos + 2), actualParams);
            } else {
                friendlyURLMapper.populateParams(url.substring(pos), actualParams);
            }
            queryString = "&" + HttpUtil.parameterMapToString(actualParams, (boolean)false);
            break;
        }
        if (!foundFriendlyURLMapper && (x = url.indexOf("/-/")) != -1) {
            String ppid;
            int y = url.indexOf("/", x + 3);
            if (y == -1) {
                y = url.length();
            }
            if (Validator.isNotNull((String)(ppid = url.substring(x + 3, y)))) {
                friendlyURL = url.substring(0, x);
                actualParams = null;
                actualParams = params != null ? new HashMap<String, String[]>(params) : new HashMap();
                actualParams.put("p_p_id", new String[]{ppid});
                actualParams.put("p_p_lifecycle", new String[]{"0"});
                actualParams.put("p_p_state", new String[]{WindowState.MAXIMIZED.toString()});
                actualParams.put("p_p_mode", new String[]{PortletMode.VIEW.toString()});
                queryString = "&" + HttpUtil.parameterMapToString(actualParams, (boolean)false);
            }
        }
        if ((friendlyURL = StringUtil.replace((String)friendlyURL, (String)"//", (String)"/")).endsWith("/")) {
            friendlyURL = friendlyURL.substring(0, friendlyURL.length() - 1);
        }
        Layout layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)groupId, (boolean)privateLayout, (String)friendlyURL);
        return new Object[]{layout, queryString};
    }

    public long getPortletGroupId(ActionRequest actionRequest) {
        return this.getScopeGroupId((PortletRequest)actionRequest);
    }

    public long getPortletGroupId(HttpServletRequest request) {
        return this.getScopeGroupId(request);
    }

    public long getPortletGroupId(Layout layout) {
        return this.getScopeGroupId(layout);
    }

    public long getPortletGroupId(long plid) {
        Layout layout = null;
        try {
            layout = LayoutLocalServiceUtil.getLayout((long)plid);
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.getPortletGroupId(layout);
    }

    public long getPortletGroupId(RenderRequest renderRequest) {
        return this.getScopeGroupId((PortletRequest)renderRequest);
    }

    public String getPortletId(HttpServletRequest request) {
        PortletConfigImpl portletConfigImpl = (PortletConfigImpl)request.getAttribute("javax.portlet.config");
        if (portletConfigImpl != null) {
            return portletConfigImpl.getPortletId();
        }
        return null;
    }

    public String getPortletId(PortletRequest portletRequest) {
        PortletConfigImpl portletConfigImpl = (PortletConfigImpl)portletRequest.getAttribute("javax.portlet.config");
        if (portletConfigImpl != null) {
            return portletConfigImpl.getPortletId();
        }
        return null;
    }

    public String getPortletNamespace(String portletId) {
        StringBuilder sb = new StringBuilder();
        sb.append("_");
        sb.append(portletId);
        sb.append("_");
        return sb.toString();
    }

    public String getPortletTitle(Portlet portlet, Locale locale) {
        return this.getPortletTitle(portlet.getPortletId(), locale);
    }

    public String getPortletTitle(Portlet portlet, String languageId) {
        return this.getPortletTitle(portlet.getPortletId(), languageId);
    }

    public String getPortletTitle(Portlet portlet, ServletContext servletContext, Locale locale) {
        PortletConfig portletConfig = PortletConfigFactory.create(portlet, servletContext);
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        return resourceBundle.getString("javax.portlet.title");
    }

    public String getPortletTitle(Portlet portlet, User user) {
        return this.getPortletTitle(portlet.getPortletId(), user);
    }

    public String getPortletTitle(String portletId, Locale locale) {
        StringBuilder sb = new StringBuilder();
        sb.append("javax.portlet.title");
        sb.append(".");
        sb.append(portletId);
        return LanguageUtil.get((Locale)locale, (String)sb.toString());
    }

    public String getPortletTitle(String portletId, String languageId) {
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        return this.getPortletTitle(portletId, locale);
    }

    public String getPortletTitle(String portletId, User user) {
        StringBuilder sb = new StringBuilder();
        sb.append("javax.portlet.title");
        sb.append(".");
        sb.append(portletId);
        return LanguageUtil.get((Locale)user.getLocale(), (String)sb.toString());
    }

    public String getPortletXmlFileName() throws SystemException {
        if (PrefsPropsUtil.getBoolean("auto.deploy.custom.portlet.xml", PropsValues.AUTO_DEPLOY_CUSTOM_PORTLET_XML)) {
            return "portlet-custom.xml";
        }
        return "portlet.xml";
    }

    public PortletPreferences getPreferences(HttpServletRequest request) {
        RenderRequest renderRequest = (RenderRequest)request.getAttribute("javax.portlet.request");
        PortletPreferencesImpl preferences = null;
        if (renderRequest != null) {
            PortletPreferencesWrapper preferencesWrapper = (PortletPreferencesWrapper)renderRequest.getPreferences();
            preferences = preferencesWrapper.getPreferencesImpl();
        }
        return preferences;
    }

    public PreferencesValidator getPreferencesValidator(Portlet portlet) {
        PortletApp portletApp = portlet.getPortletApp();
        if (portletApp.isWARFile()) {
            PortletBag portletBag = PortletBagPool.get((String)portlet.getRootPortletId());
            return portletBag.getPreferencesValidatorInstance();
        }
        PreferencesValidator preferencesValidator = null;
        if (Validator.isNotNull((String)portlet.getPreferencesValidator())) {
            preferencesValidator = (PreferencesValidator)InstancePool.get((String)portlet.getPreferencesValidator());
        }
        return preferencesValidator;
    }

    public long getScopeGroupId(HttpServletRequest request) {
        String portletId = this.getPortletId(request);
        return this.getScopeGroupId(request, portletId);
    }

    public long getScopeGroupId(HttpServletRequest request, String portletId) {
        Group group;
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        long scopeGroupId = 0L;
        if (layout != null && (group = layout.getGroup()).getName().equals("Control Panel")) {
            long doAsGroupId = ParamUtil.getLong((HttpServletRequest)request, (String)"doAsGroupId");
            if (doAsGroupId <= 0L) {
                try {
                    Group guestGroup = GroupLocalServiceUtil.getGroup((long)group.getCompanyId(), (String)"Guest");
                    doAsGroupId = guestGroup.getGroupId();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (doAsGroupId > 0L) {
                scopeGroupId = doAsGroupId;
            }
            try {
                group = GroupLocalServiceUtil.getGroup((long)scopeGroupId);
                if (group.hasStagingGroup()) {
                    Group stagingGroup = group.getStagingGroup();
                    scopeGroupId = stagingGroup.getGroupId();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (scopeGroupId <= 0L) {
            scopeGroupId = this.getScopeGroupId(layout, portletId);
        }
        return scopeGroupId;
    }

    public long getScopeGroupId(Layout layout) {
        if (layout == null) {
            return 0L;
        }
        return layout.getGroupId();
    }

    public long getScopeGroupId(Layout layout, String portletId) {
        if (layout == null) {
            return 0L;
        }
        if (Validator.isNotNull((String)portletId)) {
            try {
                PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
                long scopeLayoutId = GetterUtil.getLong((String)portletSetup.getValue("lfr-scope-layout-id", null));
                if (scopeLayoutId > 0L) {
                    Layout scopeLayout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)scopeLayoutId);
                    return scopeLayout.getScopeGroup().getGroupId();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return layout.getGroupId();
    }

    public long getScopeGroupId(long plid) {
        Layout layout = null;
        try {
            layout = LayoutLocalServiceUtil.getLayout((long)plid);
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.getScopeGroupId(layout);
    }

    public long getScopeGroupId(PortletRequest portletRequest) {
        return this.getScopeGroupId(this.getHttpServletRequest(portletRequest));
    }

    public User getSelectedUser(HttpServletRequest request) throws PortalException, SystemException {
        return this.getSelectedUser(request, true);
    }

    public User getSelectedUser(HttpServletRequest request, boolean checkPermission) throws PortalException, SystemException {
        long userId = ParamUtil.getLong((HttpServletRequest)request, (String)"p_u_i_d");
        User user = null;
        try {
            user = checkPermission ? UserServiceUtil.getUserById((long)userId) : UserLocalServiceUtil.getUserById((long)userId);
        }
        catch (NoSuchUserException nsue) {
            // empty catch block
        }
        return user;
    }

    public User getSelectedUser(PortletRequest portletRequest) throws PortalException, SystemException {
        return this.getSelectedUser(portletRequest, true);
    }

    public User getSelectedUser(PortletRequest portletRequest, boolean checkPermission) throws PortalException, SystemException {
        return this.getSelectedUser(this.getHttpServletRequest(portletRequest), checkPermission);
    }

    public String getServletContextName(BaseModel<?> baseModel) {
        Class<?> baseModelClass = baseModel.getClass();
        String className = baseModelClass.getName();
        int pos = className.indexOf(".model.impl.");
        String packagePath = className.substring(0, pos);
        StringBuilder sb = new StringBuilder();
        sb.append(packagePath);
        sb.append(".service.ClpSerializer");
        try {
            ClassLoader classLoader = baseModelClass.getClassLoader();
            Class<?> clpSerializerClass = classLoader.loadClass(className.toString());
            Field field = clpSerializerClass.getField("SERVLET_CONTEXT_NAME");
            return (String)field.get(null);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot retrieve the servlet context name from ClpSerializer");
        }
    }

    public String getStaticResourceURL(HttpServletRequest request, String uri) {
        return this.getStaticResourceURL(request, uri, null, 0L);
    }

    public String getStaticResourceURL(HttpServletRequest request, String uri, long timestamp) {
        return this.getStaticResourceURL(request, uri, null, timestamp);
    }

    public String getStaticResourceURL(HttpServletRequest request, String uri, String queryString) {
        return this.getStaticResourceURL(request, uri, queryString, 0L);
    }

    public String getStaticResourceURL(HttpServletRequest request, String uri, String queryString, long timestamp) {
        File uriFile;
        ServletContext servletContext;
        String uriRealPath;
        if (uri.contains("?")) {
            return uri;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        Theme theme = themeDisplay.getTheme();
        ColorScheme colorScheme = themeDisplay.getColorScheme();
        Map parameterMap = null;
        if (Validator.isNotNull((String)queryString)) {
            parameterMap = HttpUtil.getParameterMap((String)queryString);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(uri);
        sb.append("?");
        if (parameterMap == null || !parameterMap.containsKey("browserId")) {
            sb.append("&browserId=");
            sb.append(BrowserSnifferUtil.getBrowserId((HttpServletRequest)request));
        }
        if (uri.endsWith(".jsp")) {
            if (parameterMap == null || !parameterMap.containsKey("themeId")) {
                sb.append("&themeId=");
                sb.append(theme.getThemeId());
            }
            if (parameterMap == null || !parameterMap.containsKey("colorSchemeId")) {
                sb.append("&colorSchemeId=");
                sb.append(colorScheme.getColorSchemeId());
            }
        }
        if (parameterMap == null || !parameterMap.containsKey("minifierType")) {
            String minifierType = "";
            if (uri.endsWith(".css") || uri.endsWith("css.jsp")) {
                if (themeDisplay.isThemeCssFastLoad()) {
                    minifierType = "css";
                }
            } else if (themeDisplay.isThemeJsFastLoad()) {
                minifierType = "js";
            }
            if (Validator.isNotNull((String)minifierType)) {
                sb.append("&minifierType=");
                sb.append(minifierType);
            }
        }
        if (Validator.isNotNull((String)queryString)) {
            if (!queryString.startsWith("&")) {
                sb.append("&");
            }
            sb.append(queryString);
        }
        sb.append("&languageId=");
        sb.append(themeDisplay.getLanguageId());
        boolean appendedTimestamp = false;
        if (uri.startsWith("/html") && (uriRealPath = ServletContextUtil.getRealPath((ServletContext)(servletContext = (ServletContext)request.getAttribute("CTX")), (String)uri)) != null && (uriFile = new File(uriRealPath)).exists()) {
            sb.append("&t=");
            sb.append(uriFile.lastModified());
            appendedTimestamp = true;
        }
        if (!(appendedTimestamp || parameterMap != null && parameterMap.containsKey("t"))) {
            sb.append("&t=");
            sb.append(theme.getTimestamp());
        }
        String url = sb.toString();
        url = StringUtil.replace((String)url, (String)"?&", (String)"?");
        return url;
    }

    public String getStrutsAction(HttpServletRequest request) {
        String strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)"struts_action");
        if (Validator.isNotNull((String)strutsAction)) {
            return "";
        }
        return this._getPortletParam(request, "struts_action");
    }

    public String[] getSystemCommunityRoles() {
        return this._allSystemCommunityRoles;
    }

    public String[] getSystemGroups() {
        return this._allSystemGroups;
    }

    public String[] getSystemOrganizationRoles() {
        return this._allSystemOrganizationRoles;
    }

    public String[] getSystemRoles() {
        return this._allSystemRoles;
    }

    public String[] getTagsCategories(PortletRequest portletRequest) {
        return TagsUtil.getTagsCategories(portletRequest);
    }

    public String[] getTagsEntries(PortletRequest portletRequest) {
        return TagsUtil.getTagsEntries(portletRequest);
    }

    public UploadPortletRequest getUploadPortletRequest(ActionRequest actionRequest) {
        ActionRequestImpl actionRequestImpl = (ActionRequestImpl)actionRequest;
        DynamicServletRequest dynamicRequest = (DynamicServletRequest)actionRequestImpl.getHttpServletRequest();
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)dynamicRequest.getRequest();
        UploadServletRequest uploadRequest = this.getUploadServletRequest((HttpServletRequest)requestWrapper);
        return new UploadPortletRequestImpl(uploadRequest, PortalUtil.getPortletNamespace((String)actionRequestImpl.getPortletName()));
    }

    public UploadServletRequest getUploadServletRequest(HttpServletRequest request) {
        HttpServletRequestWrapper requestWrapper = null;
        if (request instanceof HttpServletRequestWrapper) {
            requestWrapper = (HttpServletRequestWrapper)request;
        }
        UploadServletRequest uploadRequest = null;
        while (uploadRequest == null) {
            if (requestWrapper instanceof UploadServletRequest) {
                uploadRequest = (UploadServletRequest)requestWrapper;
                continue;
            }
            HttpServletRequest parentRequest = (HttpServletRequest)requestWrapper.getRequest();
            if (!(parentRequest instanceof HttpServletRequestWrapper)) {
                uploadRequest = new UploadServletRequestImpl(parentRequest);
                break;
            }
            requestWrapper = (HttpServletRequestWrapper)parentRequest;
        }
        return uploadRequest;
    }

    public Date getUptime() {
        return _UP_TIME;
    }

    public String getURLWithSessionId(String url, String sessionId) {
        int y;
        if (!PropsValues.SESSION_ENABLE_URL_WITH_SESSION_ID) {
            return url;
        }
        int x = url.indexOf(";");
        if (x != -1) {
            return url;
        }
        x = url.indexOf("?");
        if (x != -1) {
            StringBuilder sb = new StringBuilder();
            sb.append(url.substring(0, x));
            sb.append(_JSESSIONID);
            sb.append(sessionId);
            sb.append(url.substring(x));
            return sb.toString();
        }
        x = url.indexOf("//");
        StringBuilder sb = new StringBuilder();
        sb.append(url);
        if (x != -1 && x + 1 == (y = url.lastIndexOf("/"))) {
            sb.append("/");
        }
        sb.append(_JSESSIONID);
        sb.append(sessionId);
        return sb.toString();
    }

    public User getUser(HttpServletRequest request) throws PortalException, SystemException {
        User user;
        long userId = this.getUserId(request);
        if (userId <= 0L) {
            String remoteUser = request.getRemoteUser();
            if (remoteUser == null) {
                return null;
            }
            userId = GetterUtil.getLong((String)remoteUser);
        }
        if ((user = (User)request.getAttribute("USER")) == null) {
            user = UserLocalServiceUtil.getUserById((long)userId);
            request.setAttribute("USER", (Object)user);
        }
        return user;
    }

    public User getUser(PortletRequest portletRequest) throws PortalException, SystemException {
        return this.getUser(this.getHttpServletRequest(portletRequest));
    }

    public long getUserId(HttpServletRequest request) {
        HttpSession session;
        Long userIdObj = (Long)request.getAttribute("USER_ID");
        if (userIdObj != null) {
            return userIdObj;
        }
        String path = GetterUtil.getString((String)request.getPathInfo());
        String strutsAction = this.getStrutsAction(request);
        String actionName = this._getPortletParam(request, "actionName");
        boolean alwaysAllowDoAsUser = false;
        if (path.equals("/portal/fckeditor") || strutsAction.equals("/document_library/edit_file_entry") || strutsAction.equals("/image_gallery/edit_image") || strutsAction.equals("/wiki/edit_page_attachment") || actionName.equals("addFile")) {
            alwaysAllowDoAsUser = true;
        }
        if (!PropsValues.PORTAL_JAAS_ENABLE && PropsValues.PORTAL_IMPERSONATION_ENABLE || alwaysAllowDoAsUser) {
            String doAsUserIdString = ParamUtil.getString((HttpServletRequest)request, (String)"doAsUserId");
            try {
                long doAsUserId = this.getDoAsUserId(request, doAsUserIdString, alwaysAllowDoAsUser);
                if (doAsUserId > 0L) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Impersonating user " + doAsUserId));
                    }
                    return doAsUserId;
                }
            }
            catch (Exception e) {
                _log.error((Object)("Unable to impersonate user " + doAsUserIdString), (Throwable)e);
            }
        }
        if ((userIdObj = (Long)(session = request.getSession()).getAttribute("USER_ID")) != null) {
            request.setAttribute("USER_ID", (Object)userIdObj);
            return userIdObj;
        }
        return 0L;
    }

    public long getUserId(PortletRequest portletRequest) {
        return this.getUserId(this.getHttpServletRequest(portletRequest));
    }

    public String getUserName(long userId, String defaultUserName) {
        return this.getUserName(userId, defaultUserName, "user.name.full");
    }

    public String getUserName(long userId, String defaultUserName, HttpServletRequest request) {
        return this.getUserName(userId, defaultUserName, "user.name.full", request);
    }

    public String getUserName(long userId, String defaultUserName, String userAttribute) {
        return this.getUserName(userId, defaultUserName, userAttribute, null);
    }

    public String getUserName(long userId, String defaultUserName, String userAttribute, HttpServletRequest request) {
        String userName = defaultUserName;
        try {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            userName = userAttribute.equals("user.name.full") ? user.getFullName() : user.getScreenName();
            if (request != null) {
                Layout layout = (Layout)request.getAttribute("LAYOUT");
                PortletURLImpl portletURL = new PortletURLImpl(request, "11", layout.getPlid(), "RENDER_PHASE");
                portletURL.setWindowState(WindowState.MAXIMIZED);
                portletURL.setPortletMode(PortletMode.VIEW);
                portletURL.setParameter("struts_action", "/directory/view_user");
                portletURL.setParameter("p_u_i_d", String.valueOf(user.getUserId()));
                userName = "<a href=\"" + ((Object)portletURL).toString() + "\">" + userName + "</a>";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return userName;
    }

    public String getUserPassword(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return this.getUserPassword(session);
    }

    public String getUserPassword(HttpSession session) {
        return (String)session.getAttribute("USER_PASSWORD");
    }

    public String getUserPassword(PortletRequest portletRequest) {
        return this.getUserPassword(this.getHttpServletRequest(portletRequest));
    }

    public String getUserValue(long userId, String param, String defaultValue) throws SystemException {
        if (Validator.isNotNull((String)defaultValue)) {
            return defaultValue;
        }
        try {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            return BeanPropertiesUtil.getString((Object)user, (String)param, (String)defaultValue);
        }
        catch (PortalException pe) {
            return "";
        }
    }

    public String getWidgetURL(Portlet portlet, ThemeDisplay themeDisplay) {
        return this._getServletURL(portlet, PropsValues.WIDGET_SERVLET_MAPPING, themeDisplay);
    }

    public boolean isLayoutFirstPageable(String type) {
        return GetterUtil.getBoolean((String)PropsUtil.get("layout.first.pageable", new Filter(type)), (boolean)false);
    }

    public boolean isLayoutFriendliable(Layout layout) {
        return GetterUtil.getBoolean((String)PropsUtil.get("layout.url.friendliable", new Filter(layout.getType())), (boolean)true);
    }

    public boolean isLayoutParentable(Layout layout) {
        return this.isLayoutParentable(layout.getType());
    }

    public boolean isLayoutParentable(String type) {
        return GetterUtil.getBoolean((String)PropsUtil.get("layout.parentable", new Filter(type)), (boolean)true);
    }

    public boolean isLayoutSitemapable(Layout layout) {
        if (layout.isPrivateLayout()) {
            return false;
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("layout.sitemapable", new Filter(layout.getType())), (boolean)true);
    }

    public boolean isMethodGet(PortletRequest portletRequest) {
        HttpServletRequest request = this.getHttpServletRequest(portletRequest);
        String method = GetterUtil.getString((String)request.getMethod());
        return method.equalsIgnoreCase("GET");
    }

    public boolean isMethodPost(PortletRequest portletRequest) {
        HttpServletRequest request = this.getHttpServletRequest(portletRequest);
        String method = GetterUtil.getString((String)request.getMethod());
        return method.equalsIgnoreCase("POST");
    }

    public boolean isReservedParameter(String name) {
        return this._reservedParams.contains(name);
    }

    public boolean isSystemGroup(String groupName) {
        if (groupName == null) {
            return false;
        }
        int pos = Arrays.binarySearch(this._sortedSystemGroups, groupName = groupName.trim(), new StringComparator());
        return pos >= 0;
    }

    public boolean isSystemRole(String roleName) {
        if (roleName == null) {
            return false;
        }
        int pos = Arrays.binarySearch(this._sortedSystemRoles, roleName = roleName.trim(), new StringComparator());
        if (pos >= 0) {
            return true;
        }
        pos = Arrays.binarySearch(this._sortedSystemCommunityRoles, roleName, new StringComparator());
        if (pos >= 0) {
            return true;
        }
        pos = Arrays.binarySearch(this._sortedSystemOrganizationRoles, roleName, new StringComparator());
        return pos >= 0;
    }

    public boolean isUpdateAvailable() throws SystemException {
        return PluginPackageUtil.isUpdateAvailable();
    }

    public void renderPage(StringBuilder sb, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String path) throws IOException, ServletException {
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
        StringServletResponse stringResponse = new StringServletResponse(response);
        requestDispatcher.include((ServletRequest)request, (ServletResponse)stringResponse);
        sb.append(stringResponse.getString());
    }

    public void renderPortlet(StringBuilder sb, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, Portlet portlet, String queryString) throws IOException, ServletException {
        this.renderPortlet(sb, servletContext, request, response, portlet, queryString, null, null, null);
    }

    public void renderPortlet(StringBuilder sb, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, Portlet portlet, String queryString, String columnId, Integer columnPos, Integer columnCount) throws IOException, ServletException {
        this.renderPortlet(sb, servletContext, request, response, portlet, queryString, columnId, columnPos, columnCount, null);
    }

    public void renderPortlet(StringBuilder sb, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, Portlet portlet, String queryString, String columnId, Integer columnPos, Integer columnCount, String path) throws IOException, ServletException {
        queryString = GetterUtil.getString((String)queryString);
        columnId = GetterUtil.getString((String)columnId);
        if (columnPos == null) {
            columnPos = new Integer(0);
        }
        if (columnCount == null) {
            columnCount = new Integer(0);
        }
        request.setAttribute("RENDER_PORTLET", (Object)portlet);
        request.setAttribute("RENDER_PORTLET_QUERY_STRING", (Object)queryString);
        request.setAttribute("RENDER_PORTLET_COLUMN_ID", (Object)columnId);
        request.setAttribute("RENDER_PORTLET_COLUMN_POS", (Object)columnPos);
        request.setAttribute("RENDER_PORTLET_COLUMN_COUNT", (Object)columnCount);
        if (path == null) {
            path = "/html/portal/render_portlet.jsp";
        }
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
        if (sb != null) {
            StringServletResponse stringResponse = new StringServletResponse(response);
            requestDispatcher.include((ServletRequest)request, (ServletResponse)stringResponse);
            boolean showPortlet = true;
            Boolean portletConfiguratorVisibility = (Boolean)request.getAttribute("PORTLET_CONFIGURATOR_VISIBILITY");
            if (portletConfiguratorVisibility != null) {
                ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
                try {
                    if (!PortletPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getPlid(), (String)portlet.getPortletId(), (String)"CONFIGURATION")) {
                        showPortlet = false;
                    }
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
                request.removeAttribute("PORTLET_CONFIGURATOR_VISIBILITY");
            }
            if (showPortlet) {
                sb.append(stringResponse.getString());
            }
        } else {
            response.setContentType("text/html; charset=UTF-8");
            requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void sendError(Exception e, ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        this.sendError(0, e, actionRequest, actionResponse);
    }

    public void sendError(Exception e, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.sendError(0, e, request, response);
    }

    public void sendError(int status, Exception e, ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(this._pathMain);
        sb.append("/portal/status?status=");
        sb.append(status);
        sb.append("&exception=");
        sb.append(e.getClass().getName());
        sb.append("&previousURL=");
        sb.append(HttpUtil.encodeURL((String)PortalUtil.getCurrentURL((PortletRequest)actionRequest)));
        actionResponse.sendRedirect(sb.toString());
    }

    public void sendError(int status, Exception e, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (_log.isInfoEnabled()) {
            String currentURL = (String)request.getAttribute("CURRENT_URL");
            _log.info((Object)("Current URL " + currentURL + " generates exception: " + e.getMessage()));
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)e, (Throwable)e);
        }
        if (response.isCommitted()) {
            return;
        }
        if (status == 0) {
            if (e instanceof PrincipalException) {
                status = 403;
            } else {
                String name = e.getClass().getName();
                if ((name = name.substring(name.lastIndexOf(".") + 1)).startsWith("NoSuch") && name.endsWith("Exception")) {
                    status = 404;
                }
            }
            if (status == 0) {
                status = PropsValues.TCK_URL ? 500 : 400;
            }
        }
        HttpSession session = request.getSession();
        ServletContext servletContext = session.getServletContext();
        String redirect = "/c/portal/status";
        if (e instanceof NoSuchLayoutException && Validator.isNotNull((String)PropsValues.LAYOUT_FRIENDLY_URL_PAGE_NOT_FOUND)) {
            response.setStatus(status);
            redirect = PropsValues.LAYOUT_FRIENDLY_URL_PAGE_NOT_FOUND;
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(redirect);
            if (requestDispatcher != null) {
                requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
        } else if (PropsValues.LAYOUT_SHOW_HTTP_STATUS) {
            response.setStatus(status);
            SessionErrors.add((HttpServletRequest)request, (String)e.getClass().getName(), (Object)e);
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(redirect);
            if (requestDispatcher != null) {
                requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
        } else if (e != null) {
            response.sendError(status, e.getMessage());
        } else {
            response.sendError(status);
        }
    }

    public void setPageDescription(String description, HttpServletRequest request) {
        request.setAttribute("LIFERAY_SHARED_PAGE_DESCRIPTION", (Object)description);
    }

    public void setPageKeywords(String keywords, HttpServletRequest request) {
        request.removeAttribute("LIFERAY_SHARED_PAGE_KEYWORDS");
        this.addPageKeywords(keywords, request);
    }

    public void setPageSubtitle(String subtitle, HttpServletRequest request) {
        request.setAttribute("LIFERAY_SHARED_PAGE_SUBTITLE", (Object)subtitle);
    }

    public void setPageTitle(String title, HttpServletRequest request) {
        request.setAttribute("LIFERAY_SHARED_PAGE_TITLE", (Object)title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortalPort(HttpServletRequest request) {
        if (this._portalPort == -1) {
            Integer n = this._portalPort;
            synchronized (n) {
                this._portalPort = new Integer(request.getServerPort());
            }
        }
    }

    public void storePreferences(PortletPreferences preferences) throws IOException, ValidatorException {
        PortletPreferencesWrapper preferencesWrapper = (PortletPreferencesWrapper)preferences;
        PortletPreferencesImpl preferencesImpl = preferencesWrapper.getPreferencesImpl();
        preferencesImpl.store();
    }

    public String transformCustomSQL(String sql) {
        if (this._customSqlClassNames == null || this._customSqlClassNameIds == null) {
            this._initCustomSQL();
        }
        return StringUtil.replace((String)sql, (String[])this._customSqlClassNames, (String[])this._customSqlClassNameIds);
    }

    public PortletMode updatePortletMode(String portletId, User user, Layout layout, PortletMode portletMode, HttpServletRequest request) {
        LayoutClone layoutClone;
        LayoutTypePortlet layoutType = (LayoutTypePortlet)layout.getLayoutType();
        if (portletMode == null || Validator.isNull((String)portletMode.toString())) {
            if (layoutType.hasModeAboutPortletId(portletId)) {
                return LiferayPortletMode.ABOUT;
            }
            if (layoutType.hasModeConfigPortletId(portletId)) {
                return LiferayPortletMode.CONFIG;
            }
            if (layoutType.hasModeEditPortletId(portletId)) {
                return PortletMode.EDIT;
            }
            if (layoutType.hasModeEditDefaultsPortletId(portletId)) {
                return LiferayPortletMode.EDIT_DEFAULTS;
            }
            if (layoutType.hasModeEditGuestPortletId(portletId)) {
                return LiferayPortletMode.EDIT_GUEST;
            }
            if (layoutType.hasModeHelpPortletId(portletId)) {
                return PortletMode.HELP;
            }
            if (layoutType.hasModePreviewPortletId(portletId)) {
                return LiferayPortletMode.PREVIEW;
            }
            if (layoutType.hasModePrintPortletId(portletId)) {
                return LiferayPortletMode.PRINT;
            }
            return PortletMode.VIEW;
        }
        boolean updateLayout = false;
        if (portletMode.equals((Object)LiferayPortletMode.ABOUT) && !layoutType.hasModeAboutPortletId(portletId)) {
            layoutType.addModeAboutPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.CONFIG) && !layoutType.hasModeConfigPortletId(portletId)) {
            layoutType.addModeConfigPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)PortletMode.EDIT) && !layoutType.hasModeEditPortletId(portletId)) {
            layoutType.addModeEditPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.EDIT_DEFAULTS) && !layoutType.hasModeEditDefaultsPortletId(portletId)) {
            layoutType.addModeEditDefaultsPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.EDIT_GUEST) && !layoutType.hasModeEditGuestPortletId(portletId)) {
            layoutType.addModeEditGuestPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)PortletMode.HELP) && !layoutType.hasModeHelpPortletId(portletId)) {
            layoutType.addModeHelpPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.PREVIEW) && !layoutType.hasModePreviewPortletId(portletId)) {
            layoutType.addModePreviewPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.PRINT) && !layoutType.hasModePrintPortletId(portletId)) {
            layoutType.addModePrintPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)PortletMode.VIEW) && !layoutType.hasModeViewPortletId(portletId)) {
            layoutType.removeModesPortletId(portletId);
            updateLayout = true;
        }
        if (updateLayout && (layoutClone = LayoutCloneFactory.getInstance()) != null) {
            layoutClone.update(request, layout.getPlid(), layout.getTypeSettings());
        }
        return portletMode;
    }

    public WindowState updateWindowState(String portletId, User user, Layout layout, WindowState windowState, HttpServletRequest request) {
        LayoutClone layoutClone;
        LayoutTypePortlet layoutType = (LayoutTypePortlet)layout.getLayoutType();
        if (windowState == null || Validator.isNull((String)windowState.toString())) {
            if (layoutType.hasStateMaxPortletId(portletId)) {
                return WindowState.MAXIMIZED;
            }
            if (layoutType.hasStateMinPortletId(portletId)) {
                return WindowState.MINIMIZED;
            }
            return WindowState.NORMAL;
        }
        boolean updateLayout = false;
        if (windowState.equals((Object)WindowState.MAXIMIZED) && !layoutType.hasStateMaxPortletId(portletId)) {
            layoutType.addStateMaxPortletId(portletId);
            updateLayout = false;
        } else if (windowState.equals((Object)WindowState.MINIMIZED) && !layoutType.hasStateMinPortletId(portletId)) {
            layoutType.addStateMinPortletId(portletId);
            updateLayout = true;
        } else if (windowState.equals((Object)WindowState.NORMAL) && !layoutType.hasStateNormalPortletId(portletId)) {
            layoutType.removeStatesPortletId(portletId);
            updateLayout = true;
        }
        if (updateLayout && (layoutClone = LayoutCloneFactory.getInstance()) != null) {
            layoutClone.update(request, layout.getPlid(), layout.getTypeSettings());
        }
        return windowState;
    }

    protected List<Portlet> filterControlPanelPortlets(Set<Portlet> portlets, String category, ThemeDisplay themeDisplay) {
        Group group = themeDisplay.getScopeGroup();
        ArrayList<Portlet> filteredPortlets = new ArrayList<Portlet>();
        if (category.equals("content") && group.isLayout()) {
            for (Portlet portlet : portlets) {
                if (!portlet.isScopeable()) continue;
                filteredPortlets.add(portlet);
            }
        } else {
            filteredPortlets.addAll(portlets);
        }
        Iterator itr = filteredPortlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet;
            portlet = (Portlet)itr.next();
            try {
                ControlPanelEntry controlPanelEntry = portlet.getControlPanelEntryInstance();
                if (controlPanelEntry == null) {
                    controlPanelEntry = DefaultControlPanelEntryFactory.getInstance();
                }
                if (controlPanelEntry.isVisible(portlet, category, themeDisplay)) continue;
                itr.remove();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                itr.remove();
            }
        }
        return filteredPortlets;
    }

    protected long getDoAsUserId(HttpServletRequest request, String doAsUserIdString, boolean alwaysAllowDoAsUser) throws Exception {
        if (Validator.isNull((String)doAsUserIdString)) {
            return 0L;
        }
        long doAsUserId = 0L;
        try {
            Company company = this.getCompany(request);
            doAsUserId = GetterUtil.getLong((String)Encryptor.decrypt((Key)company.getKeyObj(), (String)doAsUserIdString));
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to impersonate " + doAsUserIdString + " because the string cannot be decrypted"), (Throwable)e);
            }
            return 0L;
        }
        if (_log.isDebugEnabled()) {
            if (alwaysAllowDoAsUser) {
                _log.debug((Object)"doAsUserId path or Struts action is always allowed");
            } else {
                _log.debug((Object)"doAsUserId path is Struts action not always allowed");
            }
        }
        if (alwaysAllowDoAsUser) {
            request.setAttribute("USER_ID", (Object)new Long(doAsUserId));
            return doAsUserId;
        }
        HttpSession session = request.getSession();
        Long realUserIdObj = (Long)session.getAttribute("USER_ID");
        if (realUserIdObj == null) {
            return 0L;
        }
        User doAsUser = UserLocalServiceUtil.getUserById((long)doAsUserId);
        long[] organizationIds = doAsUser.getOrganizationIds();
        User realUser = UserLocalServiceUtil.getUserById((long)realUserIdObj);
        boolean checkGuest = true;
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)realUser, (boolean)checkGuest);
        if (doAsUser.isDefaultUser() || UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)doAsUserId, (long[])organizationIds, (String)"IMPERSONATE")) {
            request.setAttribute("USER_ID", (Object)new Long(doAsUserId));
            return doAsUserId;
        }
        _log.error((Object)("User " + realUserIdObj + " does not have the permission " + "to impersonate " + doAsUserId));
        return 0L;
    }

    private long _getPlidFromPortletId(long groupId, boolean privateLayout, String portletId) {
        long plid;
        block6: {
            long scopeGroupId = groupId;
            try {
                Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                if (group.isLayout()) {
                    Layout scopeLayout = LayoutLocalServiceUtil.getLayout((long)group.getClassPK());
                    groupId = scopeLayout.getGroupId();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            plid = 0L;
            try {
                List layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (String)"portlet");
                for (Layout layout : layouts) {
                    LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                    if (!layoutTypePortlet.hasPortletId(portletId) || this.getScopeGroupId(layout, portletId) != scopeGroupId) continue;
                    plid = layout.getPlid();
                    break;
                }
            }
            catch (SystemException se) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)se.getMessage(), (Throwable)se);
            }
        }
        return plid;
    }

    private String _getPortletParam(HttpServletRequest request, String name) {
        String value = null;
        int valueCount = 0;
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String portletId2;
            String portletId1;
            String curName = (String)enu.nextElement();
            int pos = curName.indexOf("_" + name);
            if (pos == -1) continue;
            if (++valueCount > 1) {
                return "";
            }
            String curValue = ParamUtil.getString((HttpServletRequest)request, (String)curName);
            if (!Validator.isNotNull((String)curValue) || !(portletId1 = curName.substring(1, pos)).equals(portletId2 = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id"))) continue;
            value = curValue;
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    private String _getServletURL(Portlet portlet, String servletPath, ThemeDisplay themeDisplay) {
        String layoutURL = this.getLayoutURL(themeDisplay);
        Layout layout = themeDisplay.getLayout();
        StringBuilder sb = new StringBuilder();
        if (HttpUtil.hasDomain((String)layoutURL)) {
            String protocol = HttpUtil.getProtocol((String)layoutURL);
            String domain = HttpUtil.getDomain((String)layoutURL);
            HttpUtil.removeDomain((String)layoutURL);
            sb.append(protocol);
            sb.append("://");
            sb.append(domain);
            if (Validator.isNotNull((String)this._pathContext)) {
                sb.append(this._pathContext);
            }
            if (themeDisplay.isI18n()) {
                sb.append(themeDisplay.getI18nPath());
            }
            sb.append(servletPath);
            sb.append(layout.getFriendlyURL());
        } else {
            sb.append(themeDisplay.getPortalURL());
            if (Validator.isNotNull((String)this._pathContext)) {
                sb.append(this._pathContext);
            }
            if (themeDisplay.isI18n()) {
                sb.append(themeDisplay.getI18nPath());
            }
            sb.append(servletPath);
            Group group = layout.getGroup();
            if (layout.isPrivateLayout()) {
                if (group.isUser()) {
                    sb.append(_PRIVATE_USER_SERVLET_MAPPING);
                } else {
                    sb.append(_PRIVATE_GROUP_SERVLET_MAPPING);
                }
            } else {
                sb.append(_PUBLIC_GROUP_SERVLET_MAPPING);
            }
            sb.append(group.getFriendlyURL());
            sb.append(layout.getFriendlyURL());
        }
        sb.append("/-/");
        FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
        if (friendlyURLMapper != null && !portlet.isInstanceable()) {
            sb.append(friendlyURLMapper.getMapping());
        } else {
            sb.append(portlet.getPortletId());
        }
        return sb.toString();
    }

    private void _initCustomSQL() {
        this._customSqlClassNames = new String[]{"[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.GROUP$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.ORGANIZATION$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.ROLE$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.USER$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.USERGROUP$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.BLOGS.MODEL.BLOGSENTRY$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.BOOKMARKS.MODEL.BOOKMARKSENTRY$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.DOCUMENTLIBRARY.MODEL.DLFILEENTRY$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.IMAGEGALLERY.MODEL.IGIMAGE$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.MESSAGEBOARDS.MODEL.MBMESSAGE$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.WIKI.MODEL.WIKIPAGE$]", "[$FALSE$]", "[$TRUE$]"};
        DB db = DBFactoryUtil.getDB();
        this._customSqlClassNameIds = new String[]{String.valueOf(PortalUtil.getClassNameId(Group.class)), String.valueOf(PortalUtil.getClassNameId(Organization.class)), String.valueOf(PortalUtil.getClassNameId(Role.class)), String.valueOf(PortalUtil.getClassNameId(User.class)), String.valueOf(PortalUtil.getClassNameId(UserGroup.class)), String.valueOf(PortalUtil.getClassNameId(BlogsEntry.class)), String.valueOf(PortalUtil.getClassNameId(BookmarksEntry.class)), String.valueOf(PortalUtil.getClassNameId(DLFileEntry.class)), String.valueOf(PortalUtil.getClassNameId(IGImage.class)), String.valueOf(PortalUtil.getClassNameId(MBMessage.class)), String.valueOf(PortalUtil.getClassNameId(WikiPage.class)), db.getTemplateFalse(), db.getTemplateTrue()};
    }
}

