/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.NoSuchCompanyException;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.PortletCategory;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.util.CookieKeys;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class PortalInstances {
    private static Log _log = LogFactoryUtil.getLog(PortalInstances.class);
    private static PortalInstances _instance = new PortalInstances();
    private long[] _companyIds = new long[0];
    private String[] _webIds;
    private Set<String> _autoLoginIgnoreHosts = SetUtil.fromArray((Object[])PropsUtil.getArray("auto.login.ignore.hosts"));
    private Set<String> _autoLoginIgnorePaths = SetUtil.fromArray((Object[])PropsUtil.getArray("auto.login.ignore.paths"));
    private Set<String> _virtualHostsIgnoreHosts = SetUtil.fromArray((Object[])PropsUtil.getArray("virtual.hosts.ignore.hosts"));
    private Set<String> _virtualHostsIgnorePaths = SetUtil.fromArray((Object[])PropsUtil.getArray("virtual.hosts.ignore.paths"));

    public static void addCompanyId(long companyId) {
        _instance._addCompanyId(companyId);
    }

    public static long getCompanyId(HttpServletRequest request) {
        return _instance._getCompanyId(request);
    }

    public static long[] getCompanyIds() {
        return _instance._getCompanyIds();
    }

    public static long getDefaultCompanyId() {
        return _instance._getDefaultCompanyId();
    }

    public static String[] getWebIds() {
        return _instance._getWebIds();
    }

    public static long initCompany(ServletContext servletContext, String webId) {
        return _instance._initCompany(servletContext, webId);
    }

    public static boolean isAutoLoginIgnoreHost(String host) {
        return _instance._isAutoLoginIgnoreHost(host);
    }

    public static boolean isAutoLoginIgnorePath(String path) {
        return _instance._isAutoLoginIgnorePath(path);
    }

    public static boolean isVirtualHostsIgnoreHost(String host) {
        return _instance._isVirtualHostsIgnoreHost(host);
    }

    public static boolean isVirtualHostsIgnorePath(String path) {
        return _instance._isVirtualHostsIgnorePath(path);
    }

    private PortalInstances() {
    }

    private void _addCompanyId(long companyId) {
        if (ArrayUtil.contains((long[])this._companyIds, (long)companyId)) {
            return;
        }
        long[] companyIds = new long[this._companyIds.length + 1];
        System.arraycopy(this._companyIds, 0, companyIds, 0, this._companyIds.length);
        companyIds[this._companyIds.length] = companyId;
        this._companyIds = companyIds;
    }

    private long _getCompanyId(HttpServletRequest request) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Get company id");
        }
        Long companyIdObj = (Long)request.getAttribute("COMPANY_ID");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Company id from request " + companyIdObj));
        }
        if (companyIdObj != null) {
            return companyIdObj;
        }
        String host = PortalUtil.getHost((HttpServletRequest)request);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Host " + host));
        }
        long companyId = this._getCompanyIdByVirtualHosts(host);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Company id from host " + companyId));
        }
        if (companyId <= 0L) {
            LayoutSet layoutSet = this._getLayoutSetByVirtualHosts(host);
            if (layoutSet != null) {
                companyId = layoutSet.getCompanyId();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Company id " + companyId + " is associated with " + "layout set " + layoutSet.getLayoutSetId()));
                }
                request.setAttribute("VIRTUAL_HOST_LAYOUT_SET", (Object)layoutSet);
            }
        } else if (Validator.isNotNull((String)PropsValues.VIRTUAL_HOSTS_DEFAULT_COMMUNITY_NAME)) {
            try {
                Group group = GroupLocalServiceUtil.getGroup((long)companyId, (String)PropsValues.VIRTUAL_HOSTS_DEFAULT_COMMUNITY_NAME);
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)group.getGroupId(), (boolean)false);
                if (Validator.isNull((String)layoutSet.getVirtualHost())) {
                    request.setAttribute("VIRTUAL_HOST_LAYOUT_SET", (Object)layoutSet);
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (companyId <= 0L) {
            companyId = GetterUtil.getLong((String)CookieKeys.getCookie(request, "COMPANY_ID"));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Company id from cookie " + companyId));
            }
        }
        if (companyId <= 0L) {
            companyId = this._getDefaultCompanyId();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Default company id " + companyId));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Set company id " + companyId));
        }
        request.setAttribute("COMPANY_ID", (Object)new Long(companyId));
        CompanyThreadLocal.setCompanyId((long)companyId);
        return companyId;
    }

    private long _getCompanyIdByVirtualHosts(String host) {
        if (Validator.isNull((String)host)) {
            return 0L;
        }
        try {
            Company company = CompanyLocalServiceUtil.getCompanyByVirtualHost((String)host);
            return company.getCompanyId();
        }
        catch (NoSuchCompanyException nsce) {
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return 0L;
    }

    private long[] _getCompanyIds() {
        return this._companyIds;
    }

    private long _getDefaultCompanyId() {
        return this._companyIds[0];
    }

    private LayoutSet _getLayoutSetByVirtualHosts(String host) {
        if (Validator.isNull((String)host)) {
            return null;
        }
        if (this._isVirtualHostsIgnoreHost(host)) {
            return null;
        }
        try {
            return LayoutSetLocalServiceUtil.getLayoutSet((String)host);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String[] _getWebIds() {
        if (this._webIds != null) {
            return this._webIds;
        }
        if (Validator.isNull((String)PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            throw new RuntimeException("Default web id must not be null");
        }
        try {
            List companies = CompanyLocalServiceUtil.getCompanies((boolean)false);
            ArrayList<String> webIdsList = new ArrayList<String>(companies.size());
            for (Company company : companies) {
                webIdsList.add(company.getWebId());
            }
            this._webIds = webIdsList.toArray(new String[webIdsList.size()]);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (this._webIds == null || this._webIds.length == 0) {
            this._webIds = new String[]{PropsValues.COMPANY_DEFAULT_WEB_ID};
        }
        return this._webIds;
    }

    private long _initCompany(ServletContext servletContext, String webId) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Begin initializing company with web id " + webId));
        }
        long companyId = 0L;
        try {
            Company company = CompanyLocalServiceUtil.checkCompany((String)webId);
            companyId = company.getCompanyId();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        CompanyThreadLocal.setCompanyId((long)companyId);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize display");
        }
        try {
            String xml = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-display.xml"));
            PortletCategory portletCategory = (PortletCategory)WebAppPool.get(String.valueOf(companyId), "PORTLET_CATEGORY");
            if (portletCategory == null) {
                portletCategory = new PortletCategory();
            }
            PortletCategory newPortletCategory = PortletLocalServiceUtil.getEARDisplay((String)xml);
            portletCategory.merge(newPortletCategory);
            WebAppPool.put(String.valueOf(companyId), "PORTLET_CATEGORY", portletCategory);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check journal content search");
        }
        if (GetterUtil.getBoolean((String)PropsUtil.get("journal.sync.content.search.on.startup"))) {
            try {
                JournalContentSearchLocalServiceUtil.checkContentSearches((long)companyId);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        try {
            if (PortalLDAPUtil.isImportOnStartup(companyId)) {
                PortalLDAPUtil.importFromLDAP(companyId);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process application startup events");
        }
        try {
            EventsProcessorUtil.process("application.startup.events", PropsValues.APPLICATION_STARTUP_EVENTS, new String[]{String.valueOf(companyId)});
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("End initializing company with web id " + webId + " and company id " + companyId));
        }
        PortalInstances.addCompanyId(companyId);
        return companyId;
    }

    private boolean _isAutoLoginIgnoreHost(String host) {
        return this._autoLoginIgnoreHosts.contains(host);
    }

    private boolean _isAutoLoginIgnorePath(String path) {
        return this._autoLoginIgnorePaths.contains(path);
    }

    private boolean _isVirtualHostsIgnoreHost(String host) {
        return this._virtualHostsIgnoreHosts.contains(host);
    }

    private boolean _isVirtualHostsIgnorePath(String path) {
        return this._virtualHostsIgnorePaths.contains(path);
    }
}

