/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import javax.servlet.http.HttpServletRequest;

public class SessionTreeJSClicks {
    public static final String CLASS_NAME = SessionTreeJSClicks.class.getName();
    private static Log _log = LogFactoryUtil.getLog(SessionTreeJSClicks.class);

    public static void closeNode(HttpServletRequest request, String treeId, String nodeId) {
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
            String openNodesString = preferences.getValue(CLASS_NAME, treeId);
            openNodesString = StringUtil.remove((String)openNodesString, (String)nodeId);
            preferences.setValue(CLASS_NAME, treeId, openNodesString);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static void closeNodes(HttpServletRequest request, String treeId) {
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
            String openNodesString = "";
            preferences.setValue(CLASS_NAME, treeId, openNodesString);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static String getOpenNodes(HttpServletRequest request, String treeId) {
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
            return preferences.getValue(CLASS_NAME, treeId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static void openNode(HttpServletRequest request, String treeId, String nodeId) {
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
            String openNodesString = preferences.getValue(CLASS_NAME, treeId);
            openNodesString = StringUtil.add((String)openNodesString, (String)nodeId);
            preferences.setValue(CLASS_NAME, treeId, openNodesString);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static void openNodes(HttpServletRequest request, String treeId, String[] nodeIds) {
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
            String openNodesString = preferences.getValue(CLASS_NAME, treeId);
            for (int i = 0; i < nodeIds.length; ++i) {
                openNodesString = StringUtil.add((String)openNodesString, (String)nodeIds[i]);
            }
            preferences.setValue(CLASS_NAME, treeId, openNodesString);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }
}

