/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.velocity.VelocityResourceListener;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.JournalTemplateLocalServiceUtil;
import java.io.InputStream;
import org.apache.velocity.exception.ResourceNotFoundException;

public class JournalTemplateVelocityResourceListener
extends VelocityResourceListener {
    private static Log _log = LogFactoryUtil.getLog(JournalTemplateVelocityResourceListener.class);

    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        UnsyncByteArrayInputStream is = null;
        try {
            int pos = source.indexOf("_JOURNAL_CONTEXT_/");
            if (pos != -1) {
                int x = source.indexOf("/", pos);
                int y = source.indexOf("/", x + 1);
                int z = source.indexOf("/", y + 1);
                long companyId = GetterUtil.getLong((String)source.substring(x + 1, y));
                long groupId = GetterUtil.getLong((String)source.substring(y + 1, z));
                String templateId = source.substring(z + 1);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Loading {companyId=" + companyId + ",groupId=" + groupId + ",templateId=" + templateId + "}"));
                }
                JournalTemplate template = JournalTemplateLocalServiceUtil.getTemplate((long)groupId, (String)templateId);
                String buffer = template.getXsl();
                is = new UnsyncByteArrayInputStream(buffer.getBytes());
            }
        }
        catch (PortalException pe) {
            throw new ResourceNotFoundException(source);
        }
        catch (SystemException se) {
            throw new ResourceNotFoundException(source);
        }
        return is;
    }
}

