/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.theme.ThemeLoader;
import com.liferay.portal.theme.ThemeLoaderFactory;
import com.liferay.portal.velocity.VelocityResourceListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.velocity.exception.ResourceNotFoundException;

public class ThemeLoaderVelocityResourceListener
extends VelocityResourceListener {
    private static Log _log = LogFactoryUtil.getLog(ThemeLoaderVelocityResourceListener.class);

    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        FileInputStream is = null;
        try {
            int pos = source.indexOf("_THEME_LOADER_CONTEXT_");
            if (pos != -1) {
                String ctxName = source.substring(0, pos);
                ThemeLoader themeLoader = ThemeLoaderFactory.getThemeLoader(ctxName);
                if (themeLoader != null) {
                    String themesPath;
                    String name = source.substring(pos + "_THEME_LOADER_CONTEXT_".length());
                    if (name.startsWith(themesPath = themeLoader.getThemesPath())) {
                        name = name.substring(themesPath.length(), name.length());
                    }
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)(name + " is associated with the theme loader " + ctxName + " " + themeLoader));
                    }
                    is = new FileInputStream(themeLoader.getFileStorage().getPath() + name);
                } else {
                    _log.error((Object)(source + " is not valid because " + ctxName + " does not map to a theme loader"));
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new ResourceNotFoundException(source);
        }
        return is;
    }
}

