/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class VelocityContextPool {
    private Map<String, ServletContext> _pool = new ConcurrentHashMap<String, ServletContext>();
    private static Log _log = LogFactoryUtil.getLog(VelocityContextPool.class);
    private static VelocityContextPool _instance = new VelocityContextPool();

    public static boolean containsKey(String name) {
        return _instance._containsKey(name);
    }

    public static ServletContext get(String name) {
        return _instance._get(name);
    }

    public static void put(String name, ServletContext servletContext) {
        _instance._put(name, servletContext);
    }

    public static ServletContext remove(String name) {
        return _instance._remove(name);
    }

    private VelocityContextPool() {
    }

    private boolean _containsKey(String name) {
        boolean value = this._pool.containsKey(name);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Contains key " + name + " " + value));
        }
        return value;
    }

    private ServletContext _get(String name) {
        ServletContext servletContext = this._pool.get(name);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get " + name + " " + servletContext));
        }
        return servletContext;
    }

    private void _put(String name, ServletContext servletContext) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Put " + name + " " + servletContext));
        }
        this._pool.put(name, servletContext);
    }

    private ServletContext _remove(String name) {
        ServletContext servletContext = this._pool.remove(name);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Remove " + name + " " + servletContext));
        }
        return servletContext;
    }
}

