/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import java.util.List;

public class VerifyBlogs
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyBlogs.class);

    protected void doVerify() throws Exception {
        List entries = BlogsEntryLocalServiceUtil.getNoAssetEntries();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + entries.size() + " entries with no tags assets"));
        }
        for (BlogsEntry entry : entries) {
            try {
                BlogsEntryLocalServiceUtil.updateTagsAsset((long)entry.getUserId(), (BlogsEntry)entry, (String[])new String[0]);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update tags asset for entry " + entry.getEntryId() + ": " + e.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Tags assets verified for entries");
        }
    }
}

