/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.GroupFriendlyURLException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.verify.VerifyProcess;
import java.util.List;

public class VerifyGroup
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyGroup.class);

    protected void doVerify() throws Exception {
        List groups = GroupLocalServiceUtil.getNullFriendlyURLGroups();
        for (Group group : groups) {
            String friendlyURL = "/" + group.getGroupId();
            User user = null;
            if (group.isUser()) {
                user = UserLocalServiceUtil.getUserById((long)group.getClassPK());
                friendlyURL = "/" + user.getScreenName();
            } else if (group.getClassPK() > 0L) {
                friendlyURL = "/" + group.getClassPK();
            }
            try {
                GroupLocalServiceUtil.updateFriendlyURL((long)group.getGroupId(), (String)friendlyURL);
            }
            catch (GroupFriendlyURLException gfurle) {
                if (user != null) {
                    long userId = user.getUserId();
                    String screenName = user.getScreenName();
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Updating user screen name " + screenName + " to " + userId + " because it is generating an " + "invalid friendly URL"));
                    }
                    UserLocalServiceUtil.updateScreenName((long)userId, (String)String.valueOf(userId));
                    continue;
                }
                _log.error((Object)("Invalid Friendly URL " + friendlyURL));
                throw gfurle;
            }
        }
    }
}

